//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// bswap マクロの OS ごとに違う部分を吸収する
//

// bswapNN() 系は
// - NetBSD, FreeBSD では <sys/endian.h> に bswapNN()。
// - OpenBSD では <sys/endian.h> に swapNN() (bがない)。
// - Linux では <byteswap.h> に bswap_NN() (アンダースコアがある)。
// - OSX では <libkern/OSByteOrder.h> の OSSwap{Const,}IntNN()。

#pragma once

#include "config-nono.h"

#if defined(HAVE_BYTESWAP_H)
#include <byteswap.h>		// bswap_NN() on Linux
#endif
#if defined(HAVE_SYS_ENDIAN_H)
#include <sys/endian.h>		// bswapNN/swapNN on *BSD
#endif

// __builtin_bswap* がないような環境があったらその時考える

#if defined(HAVE_BSWAP16)
#elif defined(HAVE_BSWAP_16)
# define bswap16(x)	bswap_16(x)
#elif defined(HAVE_SWAP16)
# define bswap16(x)	swap16(x)
#elif defined(HAVE___BUILTIN_BSWAP16)
# define bswap16(x)	__builtin_bswap16(x)
#else
#error No bswap16 found
#endif

#if defined(HAVE_BSWAP32)
#elif defined(HAVE_BSWAP_32)
# define bswap32(x)	bswap_32(x)
#elif defined(HAVE_SWAP32)
# define bswap32(x)	swap32(x)
#elif defined(HAVE___BUILTIN_BSWAP32)
# define bswap32(x)	__builtin_bswap32(x)
#else
#error No bswap32 found
#endif

#if defined(HAVE_BSWAP64)
#elif defined(HAVE_BSWAP_64)
# define bswap64(x)	bswap_64(x)
#elif defined(HAVE_SWAP64)
# define bswap64(x)	swap64(x)
#elif defined(HAVE___BUILTIN_BSWAP64)
# define bswap64(x)	__builtin_bswap64(x)
#else
#error No bswap64 found
#endif
