//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ファイルを mmap して提供するクラス
//

#pragma once

#include "nono.h"
#include "autofd.h"

class MappedFile final
{
 public:
	// アクセスモード
	// (enum class は字面が長くなるので手抜きしたい…)
	using Mode = bool;
	static const bool RW = false;
	static const bool RdOnly = true;

 public:
	MappedFile();
	~MappedFile();

	// ファイル名(パス名)を指定する。
	void SetFilename(const std::string& filename);

	// エラーメッセージの表示名を変更する。
	void SetDispname(const std::string& dispname);

	// サイズの確定しているファイルを読み書き両用でオープンして mmap する。
	// ファイルがなければ作成する。SRAM とか用。
	uint8 *OpenCreate(off_t len);

	// クローズする (デストラクタを呼ぶだけでもよい)
	void Close();

	// mmap されている領域の長さを返す。(ファイルサイズと同じとは限らない)
	off_t GetMemSize() const { return memlen; }

 private:
	// ファイルサイズをチェック
	bool CheckFilesize() const;

	// パス名
	std::string filename {};

	// 表示名
	// エラー表示をほぼこちら側で行うため、
	// ただのパス名だけでなくその場に応じたいい感じの表示にしたい。
	std::string dispname {};

	autofd fd {};
	uint8 *mem {};
	off_t memlen {};
};
