/*+ 
** $Header: /home/vikas/netmgt/nocol/src/utility/RCS/display_nocol_datafile.c,v 1.6 1994/06/12 17:21:07 vikas Exp $
**/

/*+ 
** This module displays the NOCOL EVENT structure.
**/

#include "nocol.h"

#include 	<stdio.h>
#include 	<sys/file.h>

int	debug;		/* referenced in libnocol.a */
char	*prognm;	/* referenced in libnocol.a */

main(ac, av)
     char **av ;
     int ac ;
{
    while (--ac)
      display_nocol_datafile(*++av) ;
}


display_nocol_datafile(file)
     char *file;
{
  EVENT v;
  int bufsize, fd;
  
  if ( (fd = open (file, O_RDONLY)) < 0)
  {
      fprintf (stderr, "Error in opening file %s\n", file);
      perror((char *) NULL);
      return (1);
  }
  fprintf (stdout, ":::::  %s  ::::\n\n", file);
  
  while ((bufsize=read (fd, (char *)&v, sizeof(v))) == sizeof(v))
    printf("%s", (char *)event_to_logstr(&v));
  
  if (bufsize != 0)			/* Error		*/
    fprintf (stderr, "Invalid data in %s\n", file);
  
}	/* end: display_nocol_datafile */
