/*+ 
** $Header: /home/vikas/netmgt/nocol/src/netconsole/RCS/setup_display.c,v 1.6 1994/11/29 20:40:34 vikas Exp $
**/

/*+ 
 * FUNCTION
 *	To create all necessary windows.
 *
 * Subwindows within 'wmain' are created and changes made in them.
 * Then only 'wmain' needs to be refreshed. Each window can be treated
 * individually (and with respect (!!)).
 *
 *	Vikas Aggarwal, vikas@navya.com
 */

/*
 * $Log: setup_display.c,v $
 * Revision 1.6  1994/11/29  20:40:34  vikas
 * Updated as netconsole for v4.0
 *
 * Revision 1.5  1994/06/12  18:09:35  vikas
 * Deleted the 'options' variable and set debug/quiet/emode to
 * be simple integers instead.
 *
 *
 * Revision 1.3  1992/06/18  21:09:10  aggarwal
 * Added check for columns also.
 *
 * Revision 1.1  1990/03/09  13:06:33  aggarwal
 * Initial revision
 *
 *
 */
#include	"netconsole.h"

setup_display()
{
    extern int LINES, COLS;			/* defined in curses.h	*/

    initscr ();
    noecho();					/* else messes up curses */
    cbreak();					/* don't buffer input */

    if ( COLS < MNCOLS )
    {
	endwin ();
	fprintf (stderr, 
		 "%s: Terminal ('%s') too small (need %d cols, have %d)\n\n", 
		 prognm, ttytype, MNCOLS, COLS);
	exit (1);
    }

    if (compute_window_sizes() == -1)
    {
	endwin();			/* error printed in compute_.. */
	exit(1);
    }

    bzero(&aw, sizeof(aw));
    aw.wmain = newwin (0,0,0,0);		/* Create main window	*/
    create_sub_windows (aw.wmain) ;		/* create all sub-wins	*/

    scrollok (aw.wmain, TRUE);			/* Allow scrolling	*/
    leaveok (aw.wmain, FALSE);			/* leave cursor at curxy */

}						/* end: setup_display()	*/

/*+ 		compute_window_sizes
** FUNCTION:
** 	Calculates the sizes of the various variable windows like the
** EVENT window and then the corresponding size of the message window.
** The minimum size of the event window is 2 rows and the maximum
** size is LINES - (sum of all fixed sized windows). It returns a -1
** if the size of the screen is too small. Minimum message window size
** is 1 line (this is added to the fixedsz and then added to the msg
** window size. Thus, the minimum window size is fixedsz + min(event sz)
**
**/
compute_window_sizes()
{
    int fixedsz ;				/* total fixed win size	*/

    titlesz = TITLESZ;				/* Fixed window sizes	*/
    hdrsz   = HDRSZ ;				/* Fixed  ..		*/
    promptsz = PROMPTSZ ;			/* Fixed ..		*/
    msgtitlesz = MSGTITLESZ ;			/* Fixed ..		*/

    fixedsz = titlesz + hdrsz + promptsz + msgtitlesz + 1 ;

    if (eventsz <= 0)				/* first time setting	*/
      eventsz = EVENTSZ ;

    if (eventsz > (LINES - fixedsz))		/* Now verify size	*/
      eventsz = LINES - fixedsz ;		/* Maximum size		*/
    else if (eventsz < 2)
      eventsz = 2;				/* minimum size		*/

    msgsz = LINES - fixedsz - eventsz + 1 ;	/* all remaining lines	*/
    
    if (msgsz < 1)				/* msg win atleast 1 	*/
    {
	fprintf(stderr, "window_sizes: Lines lesser than %d\n", 
		fixedsz + eventsz);
	return (-1);				/* screen too small	*/
    }
    return (0);
}					/* end: compute_win_sizes	*/


/*+ 		create_sub_windows
** 
** FUNCTION
**
** This function creates subwindows within the main window. The main
** window is passed as a parameter to the module. The reason behind
** creating sub-windows is that the sub-windows alter the main window
** also and after making all the alterations, we need call only one
** refresh to display all the changes.
** 
** The idea behind creating many windows instead of working with just
** one is that each window represents a header, title, etc. and we can
** manipulate the screen better.
**
** The location and number of the windows are found from the definition of
** the 'allwins' structure and the '..SZ' definitions in the netconsole.h
** header file.
**/

create_sub_windows (wmain)
     WINDOW *wmain ;				/* Main window (parent)	*/
{
    extern int COLS;

    aw.wtitle = subwin (wmain, titlesz, COLS, 0, 0) ;
    aw.whdr   = subwin (wmain, hdrsz, COLS, titlesz, 0) ;
    aw.wevent = subwin (wmain, eventsz, COLS, titlesz + hdrsz, 0);
    aw.wmsgtitle = subwin (wmain, msgtitlesz, COLS, titlesz+hdrsz+eventsz, 0);
    aw.wmsg = subwin (wmain, msgsz, COLS, titlesz+hdrsz+eventsz+msgtitlesz, 0);
    aw.wprompt = subwin(wmain,promptsz,COLS, 
			titlesz+hdrsz+eventsz+msgtitlesz+msgsz, 0);

    scrollok (aw.wmsg, TRUE);		/* Message window can scroll	*/
    return (1);
}					/* end:  create_sub_windows()	*/

