/*+ 
 * $Header: /home/vikas/netmgt/nocol/src/netconsole/RCS/poll_input.c,v 1.7 1994/11/29 20:40:34 vikas Exp $
*/


/*+
 * 
 * FUNCTION:
 *	It polls for the user input asynchronously and returns the
 * user input (integer = character). If there is no user input for as
 * long as PAUSE (defined in the netconsole.h include file), it returns a
 * '0' value.
 *
 * Uses the 'select' function.
 *
 * AUTHOR
 *	Vikas Aggarwal, vikas@navya.com
 *
 */

/*+ 
 * $Log: poll_input.c,v $
 * Revision 1.7  1994/11/29  20:40:34  vikas
 * Updated as netconsole for v4.0
 *
 * Revision 1.6  1994/05/16  01:59:12  vikas
 * Cleanup for new release.
 *
 * Revision 1.5  1993/10/30  03:53:49  aggarwal
 * Added typecasting to avoid compilers complaining.
 *
 * Revision 1.2  1990/03/09  12:14:44  aggarwal
 * Added the 'frozen' option where the poll waits indefinitely for a user
 * input (instead of the default PAUSE seconds).
 *
 * Revision 1.1  89/11/08  12:22:19  aggarwal
 * Initial revision
 * 
 */

#include "netconsole.h"

#ifndef PAUSE
#define PAUSE 15		/* wait for 15 seconds for user input	*/
#endif

poll_input ()
{
    extern bool frozen ;			/* Defined in netconsole.h */
    struct timeval tim_v;
    char   reply;
    int	   read_mask = 1 ;			/* For 'select' routine */

    tim_v.tv_sec = PAUSE;			/* init poll delay	*/
    tim_v.tv_usec = 0;

    if (frozen)
      reply = select (2, (fd_set *)&read_mask, (fd_set *)0, (fd_set *)0, NULL) ;
    else
      reply = select (2, (fd_set *)&read_mask, (fd_set *)0,(fd_set *)0, &tim_v);

    if (!(reply && read_mask))			/* no input, timed out	*/
      return(0); 
    else
      return (getchar()) ;			/* return the input 	*/
}
