/*+ 
** $Header: /home/vikas/netmgt/nocol/src/netconsole/RCS/msg_dpy.c,v 1.9 1994/11/29 20:40:34 vikas Exp $
**/

/*+ FUNCTION
 *
 * This module displays messages on the 'wmsg' window. It displays all
 * the files in the MSGSDIR directory.
 * The window can scroll, so only the latest message is going to be shown
 * anyway. For this very reason, make sure that the newlines when printing
 * out strings are *before* the string starts and not afterwards (else
 * the message can scroll off as soon as printed if the size of the
 * message window is very small).
 *
 *	Vikas Aggarwal, vikas@navya.com
 */

/*+ 
 *   $Log: msg_dpy.c,v $
 * Revision 1.9  1994/11/29  20:40:34  vikas
 * Updated as netconsole for v4.0
 *
 * Revision 1.8  1994/05/16  01:59:12  vikas
 * Cleanup for new release.
 *
 * Revision 1.7  1993/10/30  03:52:42  aggarwal
 * Now uses dirent(). Deleted include dir.h
 *
 * Revision 1.6  1992/06/18  21:05:02  aggarwal
 * Small cleanups for releasing.
 *
 *
 * Revision 1.4  1992/04/22  22:59:58  aggarwal
 * Lot of cleaning up for releasing. Organized things right.
 *
 * Revision 1.3  1990/05/23  17:22:38  aggarwal
 * Added control of the variable 'msg_on' so that it is turned
 * off after displaying all the files in MSGDIR.
 *
 * Revision 1.2  90/05/13  16:24:00  aggarwal
 * Removed the line to skip over "." and ".." since it is done
 * in the fill_window module now.
 * 
 * Revision 1.1  90/03/09  13:06:10  aggarwal
 * Initial revision
 * 
 * 
 */

#include	"netconsole.h"

msg_dpy ()
{
    extern struct allwins aw ;			/* In netconsole.h  */
    extern int msg_on;				/* In netconsole.h  */
    extern char *msgsdir ;			/* dir name, in netconsole.h */
    static DIR *msgdirp ;		     	/* Ptr to 'msgs' dir	*/
    static int msgfd ;				/* Open file desc	*/
    int display_one_msg() ;

    if (msgdirp == NULL)			/* Not opened yet	*/
    {
	if ((msgdirp = opendir(msgsdir)) == NULL)
	{
	    wprintw (aw.wmsg, "\n msg_dpy (opendir '%s'): %s", 
		     msgsdir, sys_errlist[errno]);
	    return(1) ;				/* 'minor' error	*/
	}
    }

    if (fill_window(aw.wmsg, msgdirp, MSGSDIR, &msgfd, display_one_msg))
    {
	closedir(msgdirp);
	msgdirp = NULL ;			/* reset to reopen dir	*/
	msgfd = 0 ;
	msg_on = 0 ;		/* to skip this function next time	*/
    }

    return(0);

}						/* end: msg_dpy()	*/

/*+ 
 * FUNCTION:
 * 	Displays one line from the open file descriptor on the msg
 * window. If reached the end of file, then returns a zero so that the
 * calling program can close the file.
 *
 * Note that the function gets an opened file descriptor and it does
 * not mess with the location of the file pointer since the next line
 * is read from the previous location.
 *
 * The initial newline character should clear the present line to the
 * end else the previous contents remain messed up. Hence used
 * wclrtoeol() to make things safe and sound.
 */
display_one_msg(fd, wmsg)
     int fd;
     WINDOW *wmsg ;
{
    char c ;

    waddch(wmsg, '\n');			/* Insert a newline first	*/
    while (read(fd, &c, 1) > 0)		/* read one character at a time	*/
      if ( c == '\n')			/* reached end of line		*/
      {
	  wclrtoeol(wmsg);		/* Clear prev stuff		*/
	  return(1);			/* return to calling program	*/
      }
      else
	waddch(wmsg, c);	     	/* Put character onto screen	*/

    wclrtoeol(wmsg) ;
    return (0);				/* Here only if end of file	*/
}
