/*
**	$Header: /home/vikas/src/nocol/netconsole/RCS/fill_window.c,v 1.11 1998/08/13 15:33:37 vikas Exp $
*/

/*+ 
 * 	This function fills the window given with files from the
 * specified directory pointer. A pointer to the funtion that is to be
 * called to display one line from the data files is passed. This is
 * done to make this function usable for both the EVENT window as well
 * as the MESSAGES window.
 *
 * LOGIC
 * 	- if no data file open, try opening new file
 *	-    skip over files beginning with '.' or 'core' or dirs
 *	-    if end of data files, clrtobot, return 1
 *	- until window not FULL, call display_function
 *	-    if end of file, close file and open new one
 * 
 * RETURN VALUE
 *	1 if all files in directory are displayed.
 *	0 if all files have not yet been displayed.
 *
 * AUTHOR
 *	Vikas Aggarwal, vikas@navya.com
 */


/*
 *
 *	$Log: fill_window.c,v $
 *	Revision 1.11  1998/08/13 15:33:37  vikas
 *	Rewrote to remove the goto calls.
 *
 * Revision 1.10  1994/11/29  20:40:34  vikas
 * Updated as netconsole for v4.0
 *
 */

#include	"netconsole.h"

#define WFULL(w)  	(w->_cury == (w->_maxy - 1)) ? 1:0

fill_window(win, dirp, dir, pcurfd, dpy_func)
     WINDOW *win;			/* Window to be filled		*/
     char *dir ;			/* Name of the directory	*/
     DIR *dirp;				/* opened directory pointer	*/
     int *pcurfd;			/* Present opened file desc	*/
     int (*dpy_func)();			/* Display function		*/
{
    struct dirent *direntry ;
    char file[MAXLINE];
    struct stat buf ;			/* for fstat */

    wmove(win, 0, 0);				/* reset to start pos	*/
    
    while (!(WFULL(win)))
    {
      if (*pcurfd <= 0)	/* open new file if no file open */
      {
	while (*pcurfd <= 0)
	{
	  direntry = readdir(dirp);
	  if (direntry == NULL)
	  {					/* All files are done	*/
	    wclrtobot(win);			/* Clear win to bottom	*/
	    return (1);				/* All files displayed	*/
	  }

	  /* name begins with a dot or 'core' or is not a file */
	  if (*(direntry->d_name) == '.')
	    continue ;		      	/* ...so skip it */
	  if (strcmp(direntry->d_name, "core") == 0)
	    continue;

	  sprintf (file, "%s/%s", (char *)dir, (char *)direntry->d_name);
	  if ((*pcurfd = open(file, O_RDONLY)) == -1)	/* error */
	  {
	    wprintw (aw.wmsg, "\nERROR fill_win(open): '%s'- %s",
		     direntry->d_name, sys_errlist[errno]);
	    continue ;
	  }

	  fstat (*pcurfd, &buf);		/* Get info about fd */
	  if ((buf.st_mode & S_IFMT) == S_IFDIR)	/* It is a dir	*/
	  {					/* ..so open another	*/
	    close(*pcurfd);
	    *pcurfd = 0;
	    continue;
	  }

	}	/* while(pcurfd <= 0) */
	if (debug)
	  wprintw (aw.wmsg, 
		   "\n(DEBUG) fill_win: Opened file %s... ", direntry->d_name);
      }	/* if (*purfd == 0) */

      if (dpy_func(*pcurfd, win) == 0)		/* end of current data file */
      {
	close (*pcurfd);
	*pcurfd = 0;
      }

    }	/* while(!WFULL() */

    return (0) ;				/* Window full	*/

}	/* end: fill_window() */
