/*
** $Header: /home/vikas/src/nocol/include/RCS/pingmon.h,v 1.15 1998/07/31 18:19:21 vikas Exp $
*/

#ifndef __pingmon_h
# define __pingmon_h

#include "nocol.h"

/*
 * The program needs to know the location of the 'ping' progam that is
 * to be used.
 */

/*
 * If using IP, then you might like to use the 'multiping' program which
 * pings multiple sites synchronously. If defined, it defines the PING
 * value also.
 */
#ifdef IPPING
# define PING	IPPING
/* # define MULTIPING	/* define if you are using support/multiping */
# undef RPCPING
# undef OSIPING
#endif

#ifdef RPCPING
# define PING	RPCPING
# undef OSIPING
#endif

#ifdef OSIPING
# define PING	OSIPING
#endif

#ifndef IPPING
# undef MULTIPING
#endif

#ifdef MULTIPING
#    define BATCHSIZE 32	/* number of sites to ping at a time */
#else
#  define BATCHSIZE 1			/* for standard ping programs */
#endif /* MULTIPING */


/*
 * The progam automatically fills in its own name in the EVENT.sender
 * field. If you want to over-ride this name with your own, then define
 * SENDER
 */
/* #define SENDER	"pingmon"		/* */
/* #define CONFIGFILE	"../../etc/ipnodes"	/* in ETCDIR */



/*************** Rest is standard and need not be touched ***********/

/*
 *		CONSTANTS
 */
#define	DATALEN		100	/* Size of ping packets	(bytes) */
#define	NPACKETS	10	/* Number of ping packets sent */
#define PING_THRES      3	/* If more than this pkts lost, then down */
#define POLLINTERVAL	180	/* secs between starting next poll */
#define RPCTIMEOUT	5	/* timeout for rpcping in secs */

#ifdef IPPING
# define VARNM		"ICMP-ping"	/* for EVENT.var.name field	*/
# define VARUNITS	"Pkts"		/* Units name */
#endif

#ifdef RPCPING
# define VARNM		"Portmapper"
# define VARUNITS	"Status"
#endif

#ifdef OSIPING
# define VARNM		"OSI-ping"
# define VARUNITS	"Pkts"
#endif


/*
 * Global variables
 */
int debug ;
char *prognm ;				/* Program name			*/
char *ping ;				/* which ping to use		*/

#endif	/* ! __pingmon_h */
