/* $Id: list.h,v 1.2 2000/05/23 15:31:55 proff Exp $
 * $Copyright: $
 */
#ifndef LIST_H
#define LIST_H

#ifndef PLIST_ALLOC
#  define PLIST_ALLOC(size) (Smalloc(size))
#endif

/* l = list, e = element, t = type */

struct list
{
    struct list *next;
    struct list *prev;
};

#define PLIST_NEW(t) ((typeof(t)*)PLIST_ALLOC(sizeof (t)))
#define PLIST_INIT(l) ((l)->next = (l)->prev = (l))
#define PLIST_FIRST(l) ((l)->next)
#define PLIST_PREV(e) ((e)->prev)
#define PLIST_NEXT(e) ((e)->next)
#define PLIST_LAST(l) ((l)->prev)
#define PLIST_EMPTY(l) ((l)->prev == (l)->next)
#define PLIST_INSERT_AFTER_UNSAFE(l, e) (e->prev = l, e->next=l->next, l->next->prev=e, l->next=e)
#define PLIST_INSERT_AFTER(ll, ee) do {\
	typeof(ee) e = (ee);\
        typeof(ll) l = (ll);\
	PLIST_INSERT_AFTER_UNSAFE(l, e);\
	} while (0)
#define PLIST_INSERT_BEFORE_UNSAFE(l, e) (e->next = l, e->prev=l->prev, l->prev->next=e, l->prev=e)
#define PLIST_INSERT_BEFORE(ll, ee) do {\
	typeof(ee) e = (ee);\
        typeof(ll) l = (ll);\
	PLIST_INSERT_BEFORE_UNSAFE(l, e);\
	} while (0)
#define PLIST_INSERT_TAIL(l, e) PLIST_INSERT_BEFORE((l), (e))
#define PLIST_INSERT_HEAD(l, e) PLIST_INSERT_AFTER((l), (e))
#define PLIST_DEL_UNSAFE(e) (e->prev->next = e->next, e->next->prev = e->prev)
#define PLIST_DEL(ee) do {\
	typeof(ee) e = (ee);\
	PLIST_DEL_UNSAFE(e);\
	} while (0)
#define PLIST_FOREACH(l, e) for ((e)=(l)->next; (e)!=(l); (e) = (e)->next)
#define PLIST_FOREACH_REV(l, e) for ((e)=(l)->prev; (e)!=(l); (e) = (e)->prev)
#define PLIST_FOREACH_DEL(l, e) for (; (l)->prev != (l) && ((e) = (l)->prev) && PLIST_DEL_UNSAFE(e);)
#define PLIST_FIND(l, e) ((typeof(e))listFind((l), (e)))

#include "list.ext"

#endif /* LIST_H */
