/****************************************************************/
/* Read /etc/nntpcache/newshound.conf file for default settings.*/
/* We just need to edit one file to set ourselves up on a site.	*/
/* Makes newshound alot more portable. ;-)			*/
/* Email :- andre@weblink.solutiuons.net.au			*/
/****************************************************************/

#include "conf.h"

#define CONF	"/etc/nntpcache/newshound.conf" /* Just in case it's moved */

char settings[][16] =
  {";", "SERVER", "PORT", "BAN", "WORD", "CACHEDIR", "CACHEHISTORY",
   "HOUNDLIST", "MINS", "LOWMARK", ""}; /* "" ends list */

char yep[][4]={"on", "ON", "yes", "YES"};
char nope[][4]={"off", "OFF", "no", "NO"};

int answer(char *string)
  {
   int ans=1; /* Default is on */
   int i;

   for(i=0; i<=4; i++) if (strcmp(yep[i], string)==0) ans=1;   
   for(i=0; i<=4; i++) if (strcmp(nope[i], string)==0) ans=0;
   return(ans);   
  }

void getconf()
  {
   FILE *cfp;
   char fs[128];
   char a[16], b[128];
   int word=0;
   int set, hit;

   cfp=fopen(CONF, "r");
   if (cfp==NULL)
     {
      fprintf(stderr, "Configuration file %s missing", CONF);
      exit(1);
     }
   
   if (debug>=1) printf("Reading configuration file.\n");   
   while((fgets(fs, 128, cfp)) != NULL)
     {
      sscanf(fs, "%s %s", a, b);
      set=0; hit=-1;
      while(strcmp(settings[set], "")!=0) 
        {
         if (strcmp(settings[set], a)==0) hit=set;
         set++;
        }
      if (hit==-1)
        {
         fprintf(stderr, "Problem with configuration file %s", CONF);
         exit(1);
        }

      if (debug>=3) printf("%s\n", fs);
      switch(hit)
        {
         case 0: /* Comment */
           break;
         case 1:
           strcpy(server, b);
	   break;
	 case 2:
	   strcpy(port, b);
	   break;
	 case 3:
	   ban=answer(b);
	   break;
         case 4:
           strcpy(banstr[word], b);
           ++word;
           break;
	 case 5:
	   strcpy(cachedir, b);
	   break;
	 case 6:
	   strcpy(history, b);
	   break;
	 case 7:
	   strcpy(hound, b);
	   break;
	 case 8:
	   mins=atoi(b);
	   break;
	 case 9:
	   lowmark=atoi(b);
	   break;
        }
     }
   strcpy(banstr[word], ""); /* "" ends list. */   
  }
