// automatically generated by rust-bindgen 0.39.0

use core::option::Option;
use libc::{c_char, c_int, c_void, iovec, nlmsghdr, FILE};

#[repr(C)]
pub struct nftnl_batch(c_void);

extern "C" {
    pub fn nftnl_batch_alloc(pg_size: u32, pg_overrun_size: u32) -> *mut nftnl_batch;

    pub fn nftnl_batch_update(batch: *mut nftnl_batch) -> c_int;

    pub fn nftnl_batch_free(batch: *mut nftnl_batch);

    pub fn nftnl_batch_buffer(batch: *mut nftnl_batch) -> *mut c_void;

    pub fn nftnl_batch_buffer_len(batch: *mut nftnl_batch) -> u32;

    pub fn nftnl_batch_iovec_len(batch: *mut nftnl_batch) -> c_int;

    pub fn nftnl_batch_iovec(batch: *mut nftnl_batch, iov: *mut iovec, iovlen: u32);
}
pub const NFTNL_PARSE_EBADINPUT: u32 = 0;
pub const NFTNL_PARSE_EMISSINGNODE: u32 = 1;
pub const NFTNL_PARSE_EBADTYPE: u32 = 2;
pub const NFTNL_PARSE_EOPNOTSUPP: u32 = 3;

pub const NFTNL_OUTPUT_DEFAULT: nftnl_output_type = 0;
pub const NFTNL_OUTPUT_XML: nftnl_output_type = 1;
pub const NFTNL_OUTPUT_JSON: nftnl_output_type = 2;
pub type nftnl_output_type = u32;
pub const NFTNL_OF_EVENT_NEW: nftnl_output_flags = 1;
pub const NFTNL_OF_EVENT_DEL: nftnl_output_flags = 2;
pub const NFTNL_OF_EVENT_ANY: nftnl_output_flags = 3;
pub type nftnl_output_flags = u32;
pub const NFTNL_CMD_UNSPEC: nftnl_cmd_type = 0;
pub const NFTNL_CMD_ADD: nftnl_cmd_type = 1;
pub const NFTNL_CMD_INSERT: nftnl_cmd_type = 2;
pub const NFTNL_CMD_DELETE: nftnl_cmd_type = 3;
pub const NFTNL_CMD_REPLACE: nftnl_cmd_type = 4;
pub const NFTNL_CMD_FLUSH: nftnl_cmd_type = 5;
pub const NFTNL_CMD_MAX: nftnl_cmd_type = 6;
pub type nftnl_cmd_type = u32;
pub const NFTNL_PARSE_NONE: nftnl_parse_type = 0;
pub const NFTNL_PARSE_XML: nftnl_parse_type = 1;
pub const NFTNL_PARSE_JSON: nftnl_parse_type = 2;
pub const NFTNL_PARSE_MAX: nftnl_parse_type = 3;
pub type nftnl_parse_type = u32;
#[repr(C)]
pub struct nftnl_parse_err(c_void);

extern "C" {
    pub fn nftnl_nlmsg_build_hdr(
        buf: *mut c_char,
        cmd: u16,
        family: u16,
        type_: u16,
        seq: u32,
    ) -> *mut nlmsghdr;

    pub fn nftnl_parse_err_alloc() -> *mut nftnl_parse_err;

    pub fn nftnl_parse_err_free(arg1: *mut nftnl_parse_err);

    pub fn nftnl_parse_perror(str: *const c_char, err: *mut nftnl_parse_err) -> c_int;

    pub fn nftnl_batch_is_supported() -> c_int;

    pub fn nftnl_batch_begin(buf: *mut c_char, seq: u32);

    pub fn nftnl_batch_end(buf: *mut c_char, seq: u32);
}
#[repr(C)]
pub struct nftnl_chain(c_void);

extern "C" {
    pub fn nftnl_chain_alloc() -> *mut nftnl_chain;

    pub fn nftnl_chain_free(arg1: *const nftnl_chain);
}
pub const NFTNL_CHAIN_NAME: nftnl_chain_attr = 0;
pub const NFTNL_CHAIN_FAMILY: nftnl_chain_attr = 1;
pub const NFTNL_CHAIN_TABLE: nftnl_chain_attr = 2;
pub const NFTNL_CHAIN_HOOKNUM: nftnl_chain_attr = 3;
pub const NFTNL_CHAIN_PRIO: nftnl_chain_attr = 4;
pub const NFTNL_CHAIN_POLICY: nftnl_chain_attr = 5;
pub const NFTNL_CHAIN_USE: nftnl_chain_attr = 6;
pub const NFTNL_CHAIN_BYTES: nftnl_chain_attr = 7;
pub const NFTNL_CHAIN_PACKETS: nftnl_chain_attr = 8;
pub const NFTNL_CHAIN_HANDLE: nftnl_chain_attr = 9;
pub const NFTNL_CHAIN_TYPE: nftnl_chain_attr = 10;
pub const NFTNL_CHAIN_DEV: nftnl_chain_attr = 11;
pub const __NFTNL_CHAIN_MAX: nftnl_chain_attr = 12;
pub type nftnl_chain_attr = u32;
extern "C" {
    pub fn nftnl_chain_is_set(c: *const nftnl_chain, attr: u16) -> bool;

    pub fn nftnl_chain_unset(c: *mut nftnl_chain, attr: u16);

    pub fn nftnl_chain_set(t: *mut nftnl_chain, attr: u16, data: *const c_void);

    pub fn nftnl_chain_set_data(t: *mut nftnl_chain, attr: u16, data: *const c_void, data_len: u32);

    pub fn nftnl_chain_set_u8(t: *mut nftnl_chain, attr: u16, data: u8);

    pub fn nftnl_chain_set_u32(t: *mut nftnl_chain, attr: u16, data: u32);

    pub fn nftnl_chain_set_s32(t: *mut nftnl_chain, attr: u16, data: i32);

    pub fn nftnl_chain_set_u64(t: *mut nftnl_chain, attr: u16, data: u64);

    pub fn nftnl_chain_set_str(t: *mut nftnl_chain, attr: u16, str: *const c_char);

    pub fn nftnl_chain_get(c: *const nftnl_chain, attr: u16) -> *const c_void;

    pub fn nftnl_chain_get_data(
        c: *const nftnl_chain,
        attr: u16,
        data_len: *mut u32,
    ) -> *const c_void;

    pub fn nftnl_chain_get_str(c: *const nftnl_chain, attr: u16) -> *const c_char;

    pub fn nftnl_chain_get_u8(c: *const nftnl_chain, attr: u16) -> u8;

    pub fn nftnl_chain_get_u32(c: *const nftnl_chain, attr: u16) -> u32;

    pub fn nftnl_chain_get_s32(c: *const nftnl_chain, attr: u16) -> i32;

    pub fn nftnl_chain_get_u64(c: *const nftnl_chain, attr: u16) -> u64;

    pub fn nftnl_chain_nlmsg_build_payload(nlh: *mut nlmsghdr, t: *const nftnl_chain);

    pub fn nftnl_chain_parse(
        c: *mut nftnl_chain,
        type_: nftnl_parse_type,
        data: *const c_char,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_chain_parse_file(
        c: *mut nftnl_chain,
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_chain_snprintf(
        buf: *mut c_char,
        size: usize,
        t: *const nftnl_chain,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_chain_fprintf(
        fp: *mut FILE,
        c: *const nftnl_chain,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_chain_nlmsg_parse(nlh: *const nlmsghdr, t: *mut nftnl_chain) -> c_int;
}
#[repr(C)]
pub struct nftnl_chain_list(c_void);

extern "C" {
    pub fn nftnl_chain_list_alloc() -> *mut nftnl_chain_list;

    pub fn nftnl_chain_list_free(list: *mut nftnl_chain_list);

    pub fn nftnl_chain_list_is_empty(list: *const nftnl_chain_list) -> c_int;

    pub fn nftnl_chain_list_foreach(
        chain_list: *mut nftnl_chain_list,
        cb: Option<unsafe extern "C" fn(t: *mut nftnl_chain, data: *mut c_void) -> c_int>,
        data: *mut c_void,
    ) -> c_int;

    pub fn nftnl_chain_list_add(r: *mut nftnl_chain, list: *mut nftnl_chain_list);

    pub fn nftnl_chain_list_add_tail(r: *mut nftnl_chain, list: *mut nftnl_chain_list);

    pub fn nftnl_chain_list_del(c: *mut nftnl_chain);
}
#[repr(C)]
pub struct nftnl_chain_list_iter(c_void);

extern "C" {
    pub fn nftnl_chain_list_iter_create(l: *mut nftnl_chain_list) -> *mut nftnl_chain_list_iter;

    pub fn nftnl_chain_list_iter_next(iter: *mut nftnl_chain_list_iter) -> *mut nftnl_chain;

    pub fn nftnl_chain_list_iter_destroy(iter: *mut nftnl_chain_list_iter);
}
#[repr(C)]
pub struct nftnl_expr(c_void);

pub const NFTNL_EXPR_NAME: u32 = 0;
pub const NFTNL_EXPR_BASE: u32 = 1;

extern "C" {
    pub fn nftnl_expr_alloc(name: *const c_char) -> *mut nftnl_expr;

    pub fn nftnl_expr_free(expr: *const nftnl_expr);

    pub fn nftnl_expr_is_set(expr: *const nftnl_expr, type_: u16) -> bool;

    pub fn nftnl_expr_set(expr: *mut nftnl_expr, type_: u16, data: *const c_void, data_len: u32);

    pub fn nftnl_expr_set_u8(expr: *mut nftnl_expr, type_: u16, data: u8);

    pub fn nftnl_expr_set_u16(expr: *mut nftnl_expr, type_: u16, data: u16);

    pub fn nftnl_expr_set_u32(expr: *mut nftnl_expr, type_: u16, data: u32);

    pub fn nftnl_expr_set_u64(expr: *mut nftnl_expr, type_: u16, data: u64);

    pub fn nftnl_expr_set_str(expr: *mut nftnl_expr, type_: u16, str: *const c_char);

    pub fn nftnl_expr_get(expr: *const nftnl_expr, type_: u16, data_len: *mut u32)
        -> *const c_void;

    pub fn nftnl_expr_get_u8(expr: *const nftnl_expr, type_: u16) -> u8;

    pub fn nftnl_expr_get_u16(expr: *const nftnl_expr, type_: u16) -> u16;

    pub fn nftnl_expr_get_u32(expr: *const nftnl_expr, type_: u16) -> u32;

    pub fn nftnl_expr_get_u64(expr: *const nftnl_expr, type_: u16) -> u64;

    pub fn nftnl_expr_get_str(expr: *const nftnl_expr, type_: u16) -> *const c_char;

    pub fn nftnl_expr_snprintf(
        buf: *mut c_char,
        buflen: usize,
        expr: *const nftnl_expr,
        type_: u32,
        flags: u32,
    ) -> c_int;
}
pub const NFTNL_EXPR_PAYLOAD_DREG: u32 = 1;
pub const NFTNL_EXPR_PAYLOAD_BASE: u32 = 2;
pub const NFTNL_EXPR_PAYLOAD_OFFSET: u32 = 3;
pub const NFTNL_EXPR_PAYLOAD_LEN: u32 = 4;
pub const NFTNL_EXPR_PAYLOAD_SREG: u32 = 5;
pub const NFTNL_EXPR_PAYLOAD_CSUM_TYPE: u32 = 6;
pub const NFTNL_EXPR_PAYLOAD_CSUM_OFFSET: u32 = 7;

pub const NFTNL_EXPR_META_KEY: u32 = 1;
pub const NFTNL_EXPR_META_DREG: u32 = 2;
pub const NFTNL_EXPR_META_SREG: u32 = 3;

pub const NFTNL_EXPR_CMP_SREG: u32 = 1;
pub const NFTNL_EXPR_CMP_OP: u32 = 2;
pub const NFTNL_EXPR_CMP_DATA: u32 = 3;

pub const NFTNL_EXPR_IMM_DREG: u32 = 1;
pub const NFTNL_EXPR_IMM_DATA: u32 = 2;
pub const NFTNL_EXPR_IMM_VERDICT: u32 = 3;
pub const NFTNL_EXPR_IMM_CHAIN: u32 = 4;

pub const NFTNL_EXPR_CTR_PACKETS: u32 = 1;
pub const NFTNL_EXPR_CTR_BYTES: u32 = 2;

pub const NFTNL_EXPR_BITWISE_SREG: u32 = 1;
pub const NFTNL_EXPR_BITWISE_DREG: u32 = 2;
pub const NFTNL_EXPR_BITWISE_LEN: u32 = 3;
pub const NFTNL_EXPR_BITWISE_MASK: u32 = 4;
pub const NFTNL_EXPR_BITWISE_XOR: u32 = 5;

pub const NFTNL_EXPR_TG_NAME: u32 = 1;
pub const NFTNL_EXPR_TG_REV: u32 = 2;
pub const NFTNL_EXPR_TG_INFO: u32 = 3;

pub const NFTNL_EXPR_MT_NAME: u32 = 1;
pub const NFTNL_EXPR_MT_REV: u32 = 2;
pub const NFTNL_EXPR_MT_INFO: u32 = 3;

pub const NFTNL_EXPR_NAT_TYPE: u32 = 1;
pub const NFTNL_EXPR_NAT_FAMILY: u32 = 2;
pub const NFTNL_EXPR_NAT_REG_ADDR_MIN: u32 = 3;
pub const NFTNL_EXPR_NAT_REG_ADDR_MAX: u32 = 4;
pub const NFTNL_EXPR_NAT_REG_PROTO_MIN: u32 = 5;
pub const NFTNL_EXPR_NAT_REG_PROTO_MAX: u32 = 6;
pub const NFTNL_EXPR_NAT_FLAGS: u32 = 7;

pub const NFTNL_EXPR_LOOKUP_SREG: u32 = 1;
pub const NFTNL_EXPR_LOOKUP_DREG: u32 = 2;
pub const NFTNL_EXPR_LOOKUP_SET: u32 = 3;
pub const NFTNL_EXPR_LOOKUP_SET_ID: u32 = 4;

pub const NFTNL_EXPR_DYNSET_SREG_KEY: u32 = 1;
pub const NFTNL_EXPR_DYNSET_SREG_DATA: u32 = 2;
pub const NFTNL_EXPR_DYNSET_OP: u32 = 3;
pub const NFTNL_EXPR_DYNSET_TIMEOUT: u32 = 4;
pub const NFTNL_EXPR_DYNSET_SET_NAME: u32 = 5;
pub const NFTNL_EXPR_DYNSET_SET_ID: u32 = 6;
pub const NFTNL_EXPR_DYNSET_EXPR: u32 = 7;

pub const NFTNL_EXPR_LOG_PREFIX: u32 = 1;
pub const NFTNL_EXPR_LOG_GROUP: u32 = 2;
pub const NFTNL_EXPR_LOG_SNAPLEN: u32 = 3;
pub const NFTNL_EXPR_LOG_QTHRESHOLD: u32 = 4;
pub const NFTNL_EXPR_LOG_LEVEL: u32 = 5;
pub const NFTNL_EXPR_LOG_FLAGS: u32 = 6;

pub const NFTNL_EXPR_EXTHDR_DREG: u32 = 1;
pub const NFTNL_EXPR_EXTHDR_TYPE: u32 = 2;
pub const NFTNL_EXPR_EXTHDR_OFFSET: u32 = 3;
pub const NFTNL_EXPR_EXTHDR_LEN: u32 = 4;

pub const NFTNL_EXPR_CT_DREG: u32 = 1;
pub const NFTNL_EXPR_CT_KEY: u32 = 2;
pub const NFTNL_EXPR_CT_DIR: u32 = 3;
pub const NFTNL_EXPR_CT_SREG: u32 = 4;

pub const NFTNL_EXPR_BYTEORDER_DREG: u32 = 1;
pub const NFTNL_EXPR_BYTEORDER_SREG: u32 = 2;
pub const NFTNL_EXPR_BYTEORDER_OP: u32 = 3;
pub const NFTNL_EXPR_BYTEORDER_LEN: u32 = 4;
pub const NFTNL_EXPR_BYTEORDER_SIZE: u32 = 5;

pub const NFTNL_EXPR_LIMIT_RATE: u32 = 1;
pub const NFTNL_EXPR_LIMIT_UNIT: u32 = 2;
pub const NFTNL_EXPR_LIMIT_BURST: u32 = 3;
pub const NFTNL_EXPR_LIMIT_TYPE: u32 = 4;
pub const NFTNL_EXPR_LIMIT_FLAGS: u32 = 5;

pub const NFTNL_EXPR_REJECT_TYPE: u32 = 1;
pub const NFTNL_EXPR_REJECT_CODE: u32 = 2;

pub const NFTNL_EXPR_QUEUE_NUM: u32 = 1;
pub const NFTNL_EXPR_QUEUE_TOTAL: u32 = 2;
pub const NFTNL_EXPR_QUEUE_FLAGS: u32 = 3;

pub const NFTNL_EXPR_MASQ_FLAGS: u32 = 1;
pub const NFTNL_EXPR_MASQ_REG_PROTO_MIN: u32 = 2;
pub const NFTNL_EXPR_MASQ_REG_PROTO_MAX: u32 = 3;

pub const NFTNL_EXPR_REDIR_REG_PROTO_MIN: u32 = 1;
pub const NFTNL_EXPR_REDIR_REG_PROTO_MAX: u32 = 2;
pub const NFTNL_EXPR_REDIR_FLAGS: u32 = 3;

pub const NFTNL_EXPR_DUP_SREG_ADDR: u32 = 1;
pub const NFTNL_EXPR_DUP_SREG_DEV: u32 = 2;

pub const NFTNL_EXPR_FWD_SREG_DEV: u32 = 1;

#[repr(C)]
pub struct nftnl_gen(c_void);

extern "C" {
    pub fn nftnl_gen_alloc() -> *mut nftnl_gen;

    pub fn nftnl_gen_free(arg1: *const nftnl_gen);
}
pub const NFTNL_GEN_ID: u32 = 0;
pub const __NFTNL_GEN_MAX: u32 = 1;

extern "C" {
    pub fn nftnl_gen_is_set(gen: *const nftnl_gen, attr: u16) -> bool;

    pub fn nftnl_gen_unset(gen: *mut nftnl_gen, attr: u16);

    pub fn nftnl_gen_set(gen: *mut nftnl_gen, attr: u16, data: *const c_void);

    pub fn nftnl_gen_set_data(gen: *mut nftnl_gen, attr: u16, data: *const c_void, data_len: u32);

    pub fn nftnl_gen_get(gen: *const nftnl_gen, attr: u16) -> *const c_void;

    pub fn nftnl_gen_get_data(
        gen: *const nftnl_gen,
        attr: u16,
        data_len: *mut u32,
    ) -> *const c_void;

    pub fn nftnl_gen_set_u32(gen: *mut nftnl_gen, attr: u16, data: u32);

    pub fn nftnl_gen_get_u32(gen: *const nftnl_gen, attr: u16) -> u32;

    pub fn nftnl_gen_nlmsg_parse(nlh: *const nlmsghdr, gen: *mut nftnl_gen) -> c_int;

    pub fn nftnl_gen_snprintf(
        buf: *mut c_char,
        size: usize,
        gen: *const nftnl_gen,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_gen_fprintf(fp: *mut FILE, gen: *const nftnl_gen, type_: u32, flags: u32)
        -> c_int;
}
#[repr(C)]
pub struct nftnl_rule(c_void);

extern "C" {
    pub fn nftnl_rule_alloc() -> *mut nftnl_rule;

    pub fn nftnl_rule_free(arg1: *const nftnl_rule);
}
pub const NFTNL_RULE_FAMILY: nftnl_rule_attr = 0;
pub const NFTNL_RULE_TABLE: nftnl_rule_attr = 1;
pub const NFTNL_RULE_CHAIN: nftnl_rule_attr = 2;
pub const NFTNL_RULE_HANDLE: nftnl_rule_attr = 3;
pub const NFTNL_RULE_COMPAT_PROTO: nftnl_rule_attr = 4;
pub const NFTNL_RULE_COMPAT_FLAGS: nftnl_rule_attr = 5;
pub const NFTNL_RULE_POSITION: nftnl_rule_attr = 6;
pub const NFTNL_RULE_USERDATA: nftnl_rule_attr = 7;
pub const __NFTNL_RULE_MAX: nftnl_rule_attr = 8;
pub type nftnl_rule_attr = u32;
extern "C" {
    pub fn nftnl_rule_unset(r: *mut nftnl_rule, attr: u16);

    pub fn nftnl_rule_is_set(r: *const nftnl_rule, attr: u16) -> bool;

    pub fn nftnl_rule_set(r: *mut nftnl_rule, attr: u16, data: *const c_void);

    pub fn nftnl_rule_set_data(r: *mut nftnl_rule, attr: u16, data: *const c_void, data_len: u32);

    pub fn nftnl_rule_set_u32(r: *mut nftnl_rule, attr: u16, val: u32);

    pub fn nftnl_rule_set_u64(r: *mut nftnl_rule, attr: u16, val: u64);

    pub fn nftnl_rule_set_str(r: *mut nftnl_rule, attr: u16, str: *const c_char);

    pub fn nftnl_rule_get(r: *const nftnl_rule, attr: u16) -> *const c_void;

    pub fn nftnl_rule_get_data(
        r: *const nftnl_rule,
        attr: u16,
        data_len: *mut u32,
    ) -> *const c_void;

    pub fn nftnl_rule_get_str(r: *const nftnl_rule, attr: u16) -> *const c_char;

    pub fn nftnl_rule_get_u8(r: *const nftnl_rule, attr: u16) -> u8;

    pub fn nftnl_rule_get_u32(r: *const nftnl_rule, attr: u16) -> u32;

    pub fn nftnl_rule_get_u64(r: *const nftnl_rule, attr: u16) -> u64;

    pub fn nftnl_rule_add_expr(r: *mut nftnl_rule, expr: *mut nftnl_expr);

    pub fn nftnl_rule_nlmsg_build_payload(nlh: *mut nlmsghdr, t: *mut nftnl_rule);

    pub fn nftnl_rule_parse(
        r: *mut nftnl_rule,
        type_: nftnl_parse_type,
        data: *const c_char,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_rule_parse_file(
        r: *mut nftnl_rule,
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_rule_snprintf(
        buf: *mut c_char,
        size: usize,
        t: *const nftnl_rule,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_rule_fprintf(fp: *mut FILE, r: *const nftnl_rule, type_: u32, flags: u32)
        -> c_int;

    pub fn nftnl_rule_nlmsg_parse(nlh: *const nlmsghdr, t: *mut nftnl_rule) -> c_int;

    pub fn nftnl_expr_foreach(
        r: *mut nftnl_rule,
        cb: Option<unsafe extern "C" fn(e: *mut nftnl_expr, data: *mut c_void) -> c_int>,
        data: *mut c_void,
    ) -> c_int;
}
#[repr(C)]
pub struct nftnl_expr_iter(c_void);

extern "C" {
    pub fn nftnl_expr_iter_create(r: *mut nftnl_rule) -> *mut nftnl_expr_iter;

    pub fn nftnl_expr_iter_next(iter: *mut nftnl_expr_iter) -> *mut nftnl_expr;

    pub fn nftnl_expr_iter_destroy(iter: *mut nftnl_expr_iter);
}
#[repr(C)]
pub struct nftnl_rule_list(c_void);

extern "C" {
    pub fn nftnl_rule_list_alloc() -> *mut nftnl_rule_list;

    pub fn nftnl_rule_list_free(list: *mut nftnl_rule_list);

    pub fn nftnl_rule_list_is_empty(list: *const nftnl_rule_list) -> c_int;

    pub fn nftnl_rule_list_add(r: *mut nftnl_rule, list: *mut nftnl_rule_list);

    pub fn nftnl_rule_list_add_tail(r: *mut nftnl_rule, list: *mut nftnl_rule_list);

    pub fn nftnl_rule_list_del(r: *mut nftnl_rule);

    pub fn nftnl_rule_list_foreach(
        rule_list: *mut nftnl_rule_list,
        cb: Option<unsafe extern "C" fn(t: *mut nftnl_rule, data: *mut c_void) -> c_int>,
        data: *mut c_void,
    ) -> c_int;
}
#[repr(C)]
pub struct nftnl_rule_list_iter(c_void);

extern "C" {
    pub fn nftnl_rule_list_iter_create(l: *mut nftnl_rule_list) -> *mut nftnl_rule_list_iter;

    pub fn nftnl_rule_list_iter_cur(iter: *mut nftnl_rule_list_iter) -> *mut nftnl_rule;

    pub fn nftnl_rule_list_iter_next(iter: *mut nftnl_rule_list_iter) -> *mut nftnl_rule;

    pub fn nftnl_rule_list_iter_destroy(iter: *const nftnl_rule_list_iter);
}
#[repr(C)]
pub struct nftnl_ruleset(c_void);

extern "C" {
    pub fn nftnl_ruleset_alloc() -> *mut nftnl_ruleset;

    pub fn nftnl_ruleset_free(r: *const nftnl_ruleset);
}
pub const NFTNL_RULESET_TABLELIST: u32 = 0;
pub const NFTNL_RULESET_CHAINLIST: u32 = 1;
pub const NFTNL_RULESET_SETLIST: u32 = 2;
pub const NFTNL_RULESET_RULELIST: u32 = 3;

pub const NFTNL_RULESET_UNSPEC: nftnl_ruleset_type = 0;
pub const NFTNL_RULESET_RULESET: nftnl_ruleset_type = 1;
pub const NFTNL_RULESET_TABLE: nftnl_ruleset_type = 2;
pub const NFTNL_RULESET_CHAIN: nftnl_ruleset_type = 3;
pub const NFTNL_RULESET_RULE: nftnl_ruleset_type = 4;
pub const NFTNL_RULESET_SET: nftnl_ruleset_type = 5;
pub const NFTNL_RULESET_SET_ELEMS: nftnl_ruleset_type = 6;
pub type nftnl_ruleset_type = u32;
extern "C" {
    pub fn nftnl_ruleset_is_set(r: *const nftnl_ruleset, attr: u16) -> bool;

    pub fn nftnl_ruleset_unset(r: *mut nftnl_ruleset, attr: u16);

    pub fn nftnl_ruleset_set(r: *mut nftnl_ruleset, attr: u16, data: *mut c_void);

    pub fn nftnl_ruleset_get(r: *const nftnl_ruleset, attr: u16) -> *mut c_void;
}
pub const NFTNL_RULESET_CTX_CMD: u32 = 0;
pub const NFTNL_RULESET_CTX_TYPE: u32 = 1;
pub const NFTNL_RULESET_CTX_TABLE: u32 = 2;
pub const NFTNL_RULESET_CTX_CHAIN: u32 = 3;
pub const NFTNL_RULESET_CTX_RULE: u32 = 4;
pub const NFTNL_RULESET_CTX_SET: u32 = 5;
pub const NFTNL_RULESET_CTX_DATA: u32 = 6;

#[repr(C)]
pub struct nftnl_parse_ctx(c_void);

extern "C" {
    pub fn nftnl_ruleset_ctx_free(ctx: *const nftnl_parse_ctx);

    pub fn nftnl_ruleset_ctx_is_set(ctx: *const nftnl_parse_ctx, attr: u16) -> bool;

    pub fn nftnl_ruleset_ctx_get(ctx: *const nftnl_parse_ctx, attr: u16) -> *mut c_void;

    pub fn nftnl_ruleset_ctx_get_u32(ctx: *const nftnl_parse_ctx, attr: u16) -> u32;

    pub fn nftnl_ruleset_parse_file_cb(
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
        data: *mut c_void,
        cb: Option<unsafe extern "C" fn(ctx: *const nftnl_parse_ctx) -> c_int>,
    ) -> c_int;

    pub fn nftnl_ruleset_parse_buffer_cb(
        type_: nftnl_parse_type,
        buffer: *const c_char,
        err: *mut nftnl_parse_err,
        data: *mut c_void,
        cb: Option<unsafe extern "C" fn(ctx: *const nftnl_parse_ctx) -> c_int>,
    ) -> c_int;

    pub fn nftnl_ruleset_parse(
        rs: *mut nftnl_ruleset,
        type_: nftnl_parse_type,
        data: *const c_char,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_ruleset_parse_file(
        rs: *mut nftnl_ruleset,
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_ruleset_snprintf(
        buf: *mut c_char,
        size: usize,
        rs: *const nftnl_ruleset,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_ruleset_fprintf(
        fp: *mut FILE,
        rs: *const nftnl_ruleset,
        type_: u32,
        flags: u32,
    ) -> c_int;
}
pub const NFTNL_SET_TABLE: nftnl_set_attr = 0;
pub const NFTNL_SET_NAME: nftnl_set_attr = 1;
pub const NFTNL_SET_FLAGS: nftnl_set_attr = 2;
pub const NFTNL_SET_KEY_TYPE: nftnl_set_attr = 3;
pub const NFTNL_SET_KEY_LEN: nftnl_set_attr = 4;
pub const NFTNL_SET_DATA_TYPE: nftnl_set_attr = 5;
pub const NFTNL_SET_DATA_LEN: nftnl_set_attr = 6;
pub const NFTNL_SET_FAMILY: nftnl_set_attr = 7;
pub const NFTNL_SET_ID: nftnl_set_attr = 8;
pub const NFTNL_SET_POLICY: nftnl_set_attr = 9;
pub const NFTNL_SET_DESC_SIZE: nftnl_set_attr = 10;
pub const NFTNL_SET_TIMEOUT: nftnl_set_attr = 11;
pub const NFTNL_SET_GC_INTERVAL: nftnl_set_attr = 12;
pub const __NFTNL_SET_MAX: nftnl_set_attr = 13;
pub type nftnl_set_attr = u32;
#[repr(C)]
pub struct nftnl_set(c_void);

extern "C" {
    pub fn nftnl_set_alloc() -> *mut nftnl_set;

    pub fn nftnl_set_free(s: *const nftnl_set);

    pub fn nftnl_set_clone(set: *const nftnl_set) -> *mut nftnl_set;

    pub fn nftnl_set_is_set(s: *const nftnl_set, attr: u16) -> bool;

    pub fn nftnl_set_unset(s: *mut nftnl_set, attr: u16);

    pub fn nftnl_set_set(s: *mut nftnl_set, attr: u16, data: *const c_void);

    pub fn nftnl_set_set_data(s: *mut nftnl_set, attr: u16, data: *const c_void, data_len: u32);

    pub fn nftnl_set_set_u32(s: *mut nftnl_set, attr: u16, val: u32);

    pub fn nftnl_set_set_u64(s: *mut nftnl_set, attr: u16, val: u64);

    pub fn nftnl_set_set_str(s: *mut nftnl_set, attr: u16, str: *const c_char);

    pub fn nftnl_set_get(s: *const nftnl_set, attr: u16) -> *const c_void;

    pub fn nftnl_set_get_data(s: *const nftnl_set, attr: u16, data_len: *mut u32) -> *const c_void;

    pub fn nftnl_set_get_str(s: *const nftnl_set, attr: u16) -> *const c_char;

    pub fn nftnl_set_get_u32(s: *const nftnl_set, attr: u16) -> u32;

    pub fn nftnl_set_get_u64(s: *const nftnl_set, attr: u16) -> u64;

    pub fn nftnl_set_nlmsg_build_payload(nlh: *mut nlmsghdr, s: *mut nftnl_set);

    pub fn nftnl_set_nlmsg_parse(nlh: *const nlmsghdr, s: *mut nftnl_set) -> c_int;

    pub fn nftnl_set_elems_nlmsg_parse(nlh: *const nlmsghdr, s: *mut nftnl_set) -> c_int;

    pub fn nftnl_set_snprintf(
        buf: *mut c_char,
        size: usize,
        s: *const nftnl_set,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_set_fprintf(fp: *mut FILE, s: *const nftnl_set, type_: u32, flags: u32) -> c_int;
}
#[repr(C)]
pub struct nftnl_set_list(c_void);

extern "C" {
    pub fn nftnl_set_list_alloc() -> *mut nftnl_set_list;

    pub fn nftnl_set_list_free(list: *mut nftnl_set_list);

    pub fn nftnl_set_list_is_empty(list: *const nftnl_set_list) -> c_int;

    pub fn nftnl_set_list_add(s: *mut nftnl_set, list: *mut nftnl_set_list);

    pub fn nftnl_set_list_add_tail(s: *mut nftnl_set, list: *mut nftnl_set_list);

    pub fn nftnl_set_list_del(s: *mut nftnl_set);

    pub fn nftnl_set_list_foreach(
        set_list: *mut nftnl_set_list,
        cb: Option<unsafe extern "C" fn(t: *mut nftnl_set, data: *mut c_void) -> c_int>,
        data: *mut c_void,
    ) -> c_int;
}
#[repr(C)]
pub struct nftnl_set_list_iter(c_void);

extern "C" {
    pub fn nftnl_set_list_iter_create(l: *mut nftnl_set_list) -> *mut nftnl_set_list_iter;

    pub fn nftnl_set_list_iter_cur(iter: *mut nftnl_set_list_iter) -> *mut nftnl_set;

    pub fn nftnl_set_list_iter_next(iter: *mut nftnl_set_list_iter) -> *mut nftnl_set;

    pub fn nftnl_set_list_iter_destroy(iter: *const nftnl_set_list_iter);

    pub fn nftnl_set_parse(
        s: *mut nftnl_set,
        type_: nftnl_parse_type,
        data: *const c_char,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_set_parse_file(
        s: *mut nftnl_set,
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
    ) -> c_int;
}
pub const NFTNL_SET_ELEM_FLAGS: u32 = 0;
pub const NFTNL_SET_ELEM_KEY: u32 = 1;
pub const NFTNL_SET_ELEM_VERDICT: u32 = 2;
pub const NFTNL_SET_ELEM_CHAIN: u32 = 3;
pub const NFTNL_SET_ELEM_DATA: u32 = 4;
pub const NFTNL_SET_ELEM_TIMEOUT: u32 = 5;
pub const NFTNL_SET_ELEM_EXPIRATION: u32 = 6;
pub const NFTNL_SET_ELEM_USERDATA: u32 = 7;
pub const NFTNL_SET_ELEM_EXPR: u32 = 8;

#[repr(C)]
pub struct nftnl_set_elem(c_void);

extern "C" {
    pub fn nftnl_set_elem_alloc() -> *mut nftnl_set_elem;

    pub fn nftnl_set_elem_free(s: *mut nftnl_set_elem);

    pub fn nftnl_set_elem_clone(elem: *mut nftnl_set_elem) -> *mut nftnl_set_elem;

    pub fn nftnl_set_elem_add(s: *mut nftnl_set, elem: *mut nftnl_set_elem);

    pub fn nftnl_set_elem_unset(s: *mut nftnl_set_elem, attr: u16);

    pub fn nftnl_set_elem_set(
        s: *mut nftnl_set_elem,
        attr: u16,
        data: *const c_void,
        data_len: u32,
    );

    pub fn nftnl_set_elem_set_u32(s: *mut nftnl_set_elem, attr: u16, val: u32);

    pub fn nftnl_set_elem_set_u64(s: *mut nftnl_set_elem, attr: u16, val: u64);

    pub fn nftnl_set_elem_set_str(s: *mut nftnl_set_elem, attr: u16, str: *const c_char);

    pub fn nftnl_set_elem_get(
        s: *mut nftnl_set_elem,
        attr: u16,
        data_len: *mut u32,
    ) -> *const c_void;

    pub fn nftnl_set_elem_get_str(s: *mut nftnl_set_elem, attr: u16) -> *const c_char;

    pub fn nftnl_set_elem_get_u32(s: *mut nftnl_set_elem, attr: u16) -> u32;

    pub fn nftnl_set_elem_get_u64(s: *mut nftnl_set_elem, attr: u16) -> u64;

    pub fn nftnl_set_elem_is_set(s: *const nftnl_set_elem, attr: u16) -> bool;

    pub fn nftnl_set_elems_nlmsg_build_payload(nlh: *mut nlmsghdr, s: *mut nftnl_set);

    pub fn nftnl_set_elem_nlmsg_build_payload(nlh: *mut nlmsghdr, e: *mut nftnl_set_elem);

    pub fn nftnl_set_elem_parse(
        e: *mut nftnl_set_elem,
        type_: nftnl_parse_type,
        data: *const c_char,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_set_elem_parse_file(
        e: *mut nftnl_set_elem,
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_set_elem_snprintf(
        buf: *mut c_char,
        size: usize,
        s: *const nftnl_set_elem,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_set_elem_fprintf(
        fp: *mut FILE,
        se: *mut nftnl_set_elem,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_set_elem_foreach(
        s: *mut nftnl_set,
        cb: Option<unsafe extern "C" fn(e: *mut nftnl_set_elem, data: *mut c_void) -> c_int>,
        data: *mut c_void,
    ) -> c_int;
}
#[repr(C)]
pub struct nftnl_set_elems_iter(c_void);

extern "C" {
    pub fn nftnl_set_elems_iter_create(s: *mut nftnl_set) -> *mut nftnl_set_elems_iter;

    pub fn nftnl_set_elems_iter_cur(iter: *mut nftnl_set_elems_iter) -> *mut nftnl_set_elem;

    pub fn nftnl_set_elems_iter_next(iter: *mut nftnl_set_elems_iter) -> *mut nftnl_set_elem;

    pub fn nftnl_set_elems_iter_destroy(iter: *mut nftnl_set_elems_iter);

    pub fn nftnl_set_elems_nlmsg_build_payload_iter(
        nlh: *mut nlmsghdr,
        iter: *mut nftnl_set_elems_iter,
    ) -> c_int;
}
#[repr(C)]
pub struct nftnl_table(c_void);

extern "C" {
    pub fn nftnl_table_alloc() -> *mut nftnl_table;

    pub fn nftnl_table_free(arg1: *const nftnl_table);
}
pub const NFTNL_TABLE_NAME: nftnl_table_attr = 0;
pub const NFTNL_TABLE_FAMILY: nftnl_table_attr = 1;
pub const NFTNL_TABLE_FLAGS: nftnl_table_attr = 2;
pub const NFTNL_TABLE_USE: nftnl_table_attr = 3;
pub const __NFTNL_TABLE_MAX: nftnl_table_attr = 4;
pub type nftnl_table_attr = u32;
extern "C" {
    pub fn nftnl_table_is_set(t: *const nftnl_table, attr: u16) -> bool;

    pub fn nftnl_table_unset(t: *mut nftnl_table, attr: u16);

    pub fn nftnl_table_set(t: *mut nftnl_table, attr: u16, data: *const c_void);

    pub fn nftnl_table_set_data(t: *mut nftnl_table, attr: u16, data: *const c_void, data_len: u32);

    pub fn nftnl_table_get(t: *const nftnl_table, attr: u16) -> *const c_void;

    pub fn nftnl_table_get_data(
        t: *const nftnl_table,
        attr: u16,
        data_len: *mut u32,
    ) -> *const c_void;

    pub fn nftnl_table_set_u8(t: *mut nftnl_table, attr: u16, data: u8);

    pub fn nftnl_table_set_u32(t: *mut nftnl_table, attr: u16, data: u32);

    pub fn nftnl_table_set_str(t: *mut nftnl_table, attr: u16, str: *const c_char);

    pub fn nftnl_table_get_u8(t: *const nftnl_table, attr: u16) -> u8;

    pub fn nftnl_table_get_u32(t: *const nftnl_table, attr: u16) -> u32;

    pub fn nftnl_table_get_str(t: *const nftnl_table, attr: u16) -> *const c_char;

    pub fn nftnl_table_nlmsg_build_payload(nlh: *mut nlmsghdr, t: *const nftnl_table);

    pub fn nftnl_table_parse(
        t: *mut nftnl_table,
        type_: nftnl_parse_type,
        data: *const c_char,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_table_parse_file(
        t: *mut nftnl_table,
        type_: nftnl_parse_type,
        fp: *mut FILE,
        err: *mut nftnl_parse_err,
    ) -> c_int;

    pub fn nftnl_table_snprintf(
        buf: *mut c_char,
        size: usize,
        t: *const nftnl_table,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_table_fprintf(
        fp: *mut FILE,
        t: *const nftnl_table,
        type_: u32,
        flags: u32,
    ) -> c_int;

    pub fn nftnl_table_nlmsg_parse(nlh: *const nlmsghdr, t: *mut nftnl_table) -> c_int;
}
#[repr(C)]
pub struct nftnl_table_list(c_void);

extern "C" {
    pub fn nftnl_table_list_alloc() -> *mut nftnl_table_list;

    pub fn nftnl_table_list_free(list: *mut nftnl_table_list);

    pub fn nftnl_table_list_is_empty(list: *const nftnl_table_list) -> c_int;

    pub fn nftnl_table_list_foreach(
        table_list: *mut nftnl_table_list,
        cb: Option<unsafe extern "C" fn(t: *mut nftnl_table, data: *mut c_void) -> c_int>,
        data: *mut c_void,
    ) -> c_int;

    pub fn nftnl_table_list_add(r: *mut nftnl_table, list: *mut nftnl_table_list);

    pub fn nftnl_table_list_add_tail(r: *mut nftnl_table, list: *mut nftnl_table_list);

    pub fn nftnl_table_list_del(r: *mut nftnl_table);
}
#[repr(C)]
pub struct nftnl_table_list_iter(c_void);

extern "C" {
    pub fn nftnl_table_list_iter_create(l: *mut nftnl_table_list) -> *mut nftnl_table_list_iter;

    pub fn nftnl_table_list_iter_next(iter: *mut nftnl_table_list_iter) -> *mut nftnl_table;

    pub fn nftnl_table_list_iter_destroy(iter: *const nftnl_table_list_iter);
}
pub const NFTNL_TRACE_CHAIN: nftnl_trace_attr = 0;
pub const NFTNL_TRACE_FAMILY: nftnl_trace_attr = 1;
pub const NFTNL_TRACE_ID: nftnl_trace_attr = 2;
pub const NFTNL_TRACE_IIF: nftnl_trace_attr = 3;
pub const NFTNL_TRACE_IIFTYPE: nftnl_trace_attr = 4;
pub const NFTNL_TRACE_JUMP_TARGET: nftnl_trace_attr = 5;
pub const NFTNL_TRACE_OIF: nftnl_trace_attr = 6;
pub const NFTNL_TRACE_OIFTYPE: nftnl_trace_attr = 7;
pub const NFTNL_TRACE_MARK: nftnl_trace_attr = 8;
pub const NFTNL_TRACE_LL_HEADER: nftnl_trace_attr = 9;
pub const NFTNL_TRACE_NETWORK_HEADER: nftnl_trace_attr = 10;
pub const NFTNL_TRACE_TRANSPORT_HEADER: nftnl_trace_attr = 11;
pub const NFTNL_TRACE_TABLE: nftnl_trace_attr = 12;
pub const NFTNL_TRACE_TYPE: nftnl_trace_attr = 13;
pub const NFTNL_TRACE_RULE_HANDLE: nftnl_trace_attr = 14;
pub const NFTNL_TRACE_VERDICT: nftnl_trace_attr = 15;
pub const NFTNL_TRACE_NFPROTO: nftnl_trace_attr = 16;
pub const NFTNL_TRACE_POLICY: nftnl_trace_attr = 17;
pub const __NFTNL_TRACE_MAX: nftnl_trace_attr = 18;
pub type nftnl_trace_attr = u32;
#[repr(C)]
pub struct nftnl_trace(c_void);

extern "C" {
    pub fn nftnl_trace_alloc() -> *mut nftnl_trace;

    pub fn nftnl_trace_free(trace: *const nftnl_trace);

    pub fn nftnl_trace_is_set(trace: *const nftnl_trace, type_: u16) -> bool;

    pub fn nftnl_trace_get_data(
        trace: *const nftnl_trace,
        type_: u16,
        data_len: *mut u32,
    ) -> *const c_void;

    pub fn nftnl_trace_get_u16(trace: *const nftnl_trace, type_: u16) -> u16;

    pub fn nftnl_trace_get_u32(trace: *const nftnl_trace, type_: u16) -> u32;

    pub fn nftnl_trace_get_u64(trace: *const nftnl_trace, type_: u16) -> u64;

    pub fn nftnl_trace_get_str(trace: *const nftnl_trace, type_: u16) -> *const c_char;

    pub fn nftnl_trace_nlmsg_parse(nlh: *const nlmsghdr, t: *mut nftnl_trace) -> c_int;
}
#[repr(C)]
pub struct nftnl_udata(c_void);

#[repr(C)]
pub struct nftnl_udata_buf(c_void);

extern "C" {
    pub fn nftnl_udata_buf_alloc(data_size: u32) -> *mut nftnl_udata_buf;

    pub fn nftnl_udata_buf_free(buf: *const nftnl_udata_buf);

    pub fn nftnl_udata_buf_len(buf: *const nftnl_udata_buf) -> u32;

    pub fn nftnl_udata_buf_data(buf: *const nftnl_udata_buf) -> *mut c_void;

    pub fn nftnl_udata_buf_put(buf: *mut nftnl_udata_buf, data: *const c_void, len: u32);

    pub fn nftnl_udata_start(buf: *const nftnl_udata_buf) -> *mut nftnl_udata;

    pub fn nftnl_udata_end(buf: *const nftnl_udata_buf) -> *mut nftnl_udata;

    pub fn nftnl_udata_put(
        buf: *mut nftnl_udata_buf,
        type_: u8,
        len: u32,
        value: *const c_void,
    ) -> bool;

    pub fn nftnl_udata_put_strz(buf: *mut nftnl_udata_buf, type_: u8, strz: *const c_char) -> bool;

    pub fn nftnl_udata_type(attr: *const nftnl_udata) -> u8;

    pub fn nftnl_udata_len(attr: *const nftnl_udata) -> u8;

    pub fn nftnl_udata_get(attr: *const nftnl_udata) -> *mut c_void;

    pub fn nftnl_udata_next(attr: *const nftnl_udata) -> *mut nftnl_udata;
}
pub type nftnl_udata_cb_t =
    Option<unsafe extern "C" fn(attr: *const nftnl_udata, data: *mut c_void) -> c_int>;
extern "C" {
    pub fn nftnl_udata_parse(
        data: *const c_void,
        data_len: u32,
        cb: nftnl_udata_cb_t,
        cb_data: *mut c_void,
    ) -> c_int;
}
