# nftnl-sys

Low level FFI bindings to [`libnftnl`], a userspace library providing a low-level netlink
programming interface (API) to the in-kernel nf_tables subsystem.

See [`nftnl`] for a higher level safe abstraction.

## Linking to libmnl and libnftnl

By default this crate uses pkg-config to find and link to its C dependencies, [`libmnl`] and
[`libnftnl`]. To manually configure where to look for these libraries, set the environment
variables `LIBMNL_LIB_DIR` and `LIBNFTNL_LIB_DIR` to point to the directories where `libmnl.so`
(or `libmnl.a`) and `libnftnl.so` (or `libnftnl.a`) reside.

## Selecting version of `libnftnl`

This crate has bindings for most versions of [`libnftnl`]. All bindings are generated by
[`bindgen`] via the `generate_bindings.sh` script in this repository.

Only one version of `libnftnl` can be exposed via this crate. By default the crate exports the
bindings for the oldest supported version (`libnftnl-1.0.6`). To get newer versions activate the
corresponding features. See `Cargo.toml` for available features/versions.

So for example, to get bindings to `libnftnl-1.0.9` depend on this crate like this:
```toml
[dependencies]
nftnl-sys = { version = "0.1", features = ["nftnl-1-0-9"] }
```

[`libnftnl`]: https://netfilter.org/projects/libnftnl/
[`libmnl`]: https://netfilter.org/projects/libmnl/
[`nftnl`]: https://crates.io/crates/nftnl
[`bindgen`]: https://crates.io/crates/bindgen

License: MIT/Apache-2.0
