/*
 * Copyright 2017 Aleksey Cheusov <vle@gmx.net>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _IMP_FLAGS_TO_STRING_H_
#define _IMP_FLAGS_TO_STRING_H_

#ifndef _IMP_CHECK_FLAGS_TO_STRING
# error "Missing MKC_FEATURES += flags_to_string"
#endif

#include <unistd.h>
#include <fcntl.h>

#ifdef HAVE_HEADER_UTIL_H
#include <util.h>
#endif

#if !defined(HAVE_FUNC2_FLAGS_TO_STRING_UTIL_H)
char *flags_to_string(unsigned long flags, const char *def);
#endif

#if !defined(HAVE_FUNC3_STRING_TO_FLAGS_UTIL_H)
int string_to_flags(char **stringp, unsigned long *setp, unsigned long *clrp);
#endif

#endif // _IMP_FLAGS_TO_STRING_H_
