/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaProject;

public class IndexSelector {
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexKeys;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    public static boolean canSeeFocus(IJavaElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            int i;
            IPath focusPath;
            JavaProject focusProject;
            IJavaModel model = focus.getJavaModel();
            IJavaProject project = IndexSelector.getJavaProject(projectOrJarPath, model);
            if (project == null) {
                IJavaProject[] allProjects = model.getJavaProjects();
                int i2 = 0;
                int length = allProjects.length;
                while (i2 < length) {
                    IJavaProject otherProject = allProjects[i2];
                    IClasspathEntry[] entries = otherProject.getResolvedClasspath(true);
                    int j = 0;
                    int length2 = entries.length;
                    while (j < length2) {
                        IClasspathEntry entry = entries[j];
                        if (entry.getEntryKind() == 1 && entry.getPath().equals(projectOrJarPath) && IndexSelector.canSeeFocus(focus, isPolymorphicSearch, otherProject.getPath())) {
                            return true;
                        }
                        ++j;
                    }
                    ++i2;
                }
                return false;
            }
            JavaProject javaProject = focusProject = focus instanceof JarPackageFragmentRoot ? (JavaProject)focus.getParent() : (JavaProject)focus;
            if (isPolymorphicSearch) {
                IClasspathEntry[] entries = focusProject.getExpandedClasspath(true);
                int i3 = 0;
                int length = entries.length;
                while (i3 < length) {
                    IClasspathEntry entry = entries[i3];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals(projectOrJarPath)) {
                        return true;
                    }
                    ++i3;
                }
            }
            if (focus instanceof JarPackageFragmentRoot) {
                focusPath = focus.getPath();
                IClasspathEntry[] entries = ((JavaProject)project).getExpandedClasspath(true);
                i = 0;
                int length = entries.length;
                while (i < length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals(focusPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            if (focus.equals(project)) {
                return true;
            }
            focusPath = focusProject.getProject().getFullPath();
            IClasspathEntry[] entries = ((JavaProject)project).getExpandedClasspath(true);
            i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals(focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private void initializeIndexKeys() {
        ArrayList<IPath> requiredIndexKeys = new ArrayList<IPath>();
        IPath[] projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaElement projectOrJarFocus = this.pattern == null || this.pattern.focus == null ? null : IndexSelector.getProjectOrJar(this.pattern.focus);
        boolean isPolymorphicSearch = this.pattern == null ? false : this.pattern.isPolymorphicSearch();
        int i = 0;
        while (i < projectsAndJars.length) {
            IPath location;
            IPath path = projectsAndJars[i];
            if ((root.getProject(path.lastSegment()).exists() || path.segmentCount() <= 1 || (location = root.getFile(path).getLocation()) != null && new File(location.toOSString()).exists() || new File(path.toOSString()).exists()) && (projectOrJarFocus == null || IndexSelector.canSeeFocus(projectOrJarFocus, isPolymorphicSearch, path)) && requiredIndexKeys.indexOf(path) == -1) {
                requiredIndexKeys.add(path);
            }
            ++i;
        }
        this.indexKeys = new IPath[requiredIndexKeys.size()];
        requiredIndexKeys.toArray(this.indexKeys);
    }

    public IPath[] getIndexKeys() {
        if (this.indexKeys == null) {
            this.initializeIndexKeys();
        }
        return this.indexKeys;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project = model.getJavaProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public static IJavaElement getProjectOrJar(IJavaElement element) {
        while (!(element instanceof IJavaProject) && !(element instanceof JarPackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }
}

