/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class OSGiBootLoader {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected String framework = "org.eclipse.osgi";
    protected String installLocation = null;
    protected String dataLocation = null;
    protected String feature;
    protected String configurationLocation;
    protected URL pluginPathLocation;
    protected String devClassPath = null;
    protected boolean inDevelopmentMode = false;
    private String showSplash = null;
    private String endSplash = null;
    private boolean cmdInitialize = false;
    private boolean cmdFirstUse = false;
    private Properties configuration = new Properties();
    private HashMap featureIndex = new HashMap();
    private static final String BOOT = "-boot";
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String DATA = "-data";
    private static final String CONFIGURATION = "-configuration";
    private static final String FEATURE = "-feature";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String ENDSPLASH = "-endsplash";
    private static final String FIRST_USE = "-firstuse";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String CONFIG_FILE = "platform.cfg";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ARG_USER_DIR = "user.dir";
    private static final String CFG_CORE_BOOT = "bootstrap.org.eclipse.core.boot";
    private static final String CFG_FEATURE_ENTRY = "feature";
    private static final String CFG_FEATURE_ENTRY_DEFAULT = "feature.default.id";
    private static final String CFG_FEATURE_ENTRY_ID = "id";
    private static final String CFG_FEATURE_ENTRY_ROOT = "root";
    private static final String CFG_EOF = "eof";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.core.boot";
    protected static File logFile = null;
    protected static BufferedWriter log = null;
    protected static String[] arguments;
    protected static boolean newSession;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        newSession = true;
    }

    private Object basicRun(String[] args, Runnable handler) throws Exception {
        URL[] bootPath = this.getBootPath(this.bootLocation);
        this.handleSplash(bootPath);
        Class clazz = this.getBootLoader(bootPath);
        Class[] classArray = new Class[2];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("[Ljava.lang.Runnable;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            return method.invoke((Object)clazz, args, handler);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
    }

    private String decode(String urlString) {
        try {
            Object result;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Ljava.net.URLDecoder;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("[Ljava.lang.String;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("[Ljava.lang.String;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            Method method = clazz2.getDeclaredMethod("decode", classArray);
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            if ((result = method.invoke(null, urlString, "UTF-8")) != null) {
                return (String)result;
            }
        }
        catch (Exception exception) {}
        boolean replaced = false;
        byte[] encodedBytes = urlString.getBytes();
        int encodedLength = encodedBytes.length;
        byte[] decodedBytes = new byte[encodedLength];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedLength) {
            byte b = encodedBytes[i];
            if (b == 37) {
                byte enc1 = encodedBytes[++i];
                byte enc2 = encodedBytes[++i];
                b = (byte)((this.hexToByte(enc1) << 4) + this.hexToByte(enc2));
                replaced = true;
            }
            decodedBytes[decodedLength++] = b;
            ++i;
        }
        if (!replaced) {
            return urlString;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(decodedBytes, 0, decodedLength);
        }
    }

    private String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    private Class getBootLoader(URL[] path) throws Exception {
        URLClassLoader loader = new URLClassLoader(path, null);
        return loader.loadClass(STARTER);
    }

    private URL[] getDevPath(URL base) throws MalformedURLException {
        String devBase = base.toExternalForm();
        if (devBase.endsWith("/")) {
            devBase = devBase.substring(0, devBase.length() - 1);
        }
        devBase = devBase.substring(0, devBase.lastIndexOf(47) + 1);
        ArrayList result = new ArrayList(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(String.valueOf(devBase) + "org.eclipse.osgi/", result);
            this.addBaseJars(devBase, result);
        }
        this.addBaseJars(base.toExternalForm(), result);
        return result.toArray(new URL[result.size()]);
    }

    private void addBaseJars(String devBase, ArrayList result) throws MalformedURLException {
        this.addEntry(new URL(String.valueOf(devBase) + "core.jar"), result);
        this.addEntry(new URL(String.valueOf(devBase) + "console.jar"), result);
        this.addEntry(new URL(String.valueOf(devBase) + "osgi.jar"), result);
        this.addEntry(new URL(String.valueOf(devBase) + "resolver.jar"), result);
        this.addEntry(new URL(String.valueOf(devBase) + "defaultAdaptor.jar"), result);
        this.addEntry(new URL(String.valueOf(devBase) + "eclipseAdaptor.jar"), result);
    }

    private void addEntry(URL url, List result) {
        if (new File(url.getFile()).exists()) {
            result.add(url);
        }
    }

    private void addDevEntries(String devBase, List result) throws MalformedURLException {
        String[] locations = this.getArrayFromList(this.devClassPath);
        int i = 0;
        while (i < locations.length) {
            String spec = String.valueOf(devBase) + locations[i];
            char lastChar = spec.charAt(spec.length() - 1);
            URL url = spec.endsWith(".jar") || lastChar == '/' || lastChar == '\\' ? new URL(spec) : new URL(String.valueOf(spec) + "/");
            if (new File(url.getFile()).exists()) {
                result.add(url);
            }
            ++i;
        }
    }

    private URL[] getBootPath(String base) throws MalformedURLException {
        URL url = null;
        if (base != null) {
            url = new URL(base);
            if (this.debug) {
                System.out.println("Boot URL: " + url.toExternalForm());
            }
            String path = this.searchFor(this.framework, new File(url.getFile()).getParent());
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
            return this.getDevPath(url);
        }
        URL[] result = null;
        url = new URL(this.installLocation);
        String path = String.valueOf(url.getFile()) + "/plugins";
        path = this.searchFor(this.framework, path);
        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        result = this.getDevPath(url);
        if (this.debug) {
            System.out.println("Boot URL:");
            int i = 0;
            while (i < result.length) {
                System.out.println("    " + result[i].toExternalForm());
                ++i;
            }
        }
        return result;
    }

    private String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.isDirectory() && (candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_"));
            }
        };
        File[] boots = new File(start).listFiles(filter);
        if (boots == null) {
            throw new RuntimeException("Could not find bootstrap code. Check location of boot plug-in or specify -boot.");
        }
        String result = null;
        Object[] maxVersion = null;
        int i = 0;
        while (i < boots.length) {
            String name = boots[i].getName();
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = OSGiBootLoader.getVersionElements(version);
            if (maxVersion == null) {
                result = boots[i].getAbsolutePath();
                maxVersion = currentVersion;
            } else if (OSGiBootLoader.compareVersion(maxVersion, currentVersion) < 0) {
                result = boots[i].getAbsolutePath();
                maxVersion = currentVersion;
            }
            ++i;
        }
        if (result == null) {
            throw new RuntimeException("Could not find bootstrap code. Check location of boot plug-in or specify -boot.");
        }
        return String.valueOf(result.replace(File.separatorChar, '/')) + "/";
    }

    private static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    private String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else if (args[i].equalsIgnoreCase(INITIALIZE)) {
                this.cmdInitialize = true;
            } else if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                this.inDevelopmentMode = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(BOOT)) {
                    this.bootLocation = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(FRAMEWORK)) {
                    this.framework = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(INSTALL)) {
                    this.setInstallLocation(arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEV)) {
                    this.inDevelopmentMode = true;
                    this.devClassPath = arg;
                } else if (args[i - 1].equalsIgnoreCase(DATA)) {
                    this.dataLocation = arg;
                } else if (args[i - 1].equalsIgnoreCase(FEATURE)) {
                    this.feature = arg;
                } else {
                    if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                        this.configurationLocation = arg;
                        found = true;
                    }
                    if (args[i - 1].equalsIgnoreCase(SHOWSPLASH)) {
                        this.showSplash = arg;
                        found = true;
                    }
                    if (args[i - 1].equalsIgnoreCase(ENDSPLASH)) {
                        this.endSplash = arg;
                        found = true;
                    }
                    if (found) {
                        configArgs[configArgIndex++] = i - 1;
                        configArgs[configArgIndex++] = i;
                    }
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        if (applicationName != null) {
            System.setProperty("eclipse.application", applicationName);
        }
        return new OSGiBootLoader().run(args, handler);
    }

    public Object run(String[] args, Runnable handler) throws Exception {
        System.getProperties().setProperty("eclipse.debug.startupTime", Long.toString(System.currentTimeMillis()));
        String[] passThruArgs = this.processCommandLine(args);
        passThruArgs = this.processConfiguration(passThruArgs);
        return this.basicRun(passThruArgs, handler);
    }

    private String[] processConfiguration(String[] passThruArgs) throws MalformedURLException {
        String urlString;
        if (this.installLocation == null) {
            this.setInstallLocation(this.getRootURL().toExternalForm());
        }
        URL configURL = null;
        if (this.configurationLocation != null && !this.configurationLocation.trim().equals("")) {
            this.configurationLocation = this.configurationLocation.replace(File.separatorChar, '/');
            if (this.configurationLocation.equalsIgnoreCase(ARG_USER_DIR)) {
                String tmp = System.getProperty(ARG_USER_DIR);
                if (!tmp.endsWith(File.separator)) {
                    tmp = String.valueOf(tmp) + File.separator;
                }
                configURL = new URL("file:" + tmp.replace(File.separatorChar, '/') + CONFIG_FILE);
            } else {
                configURL = this.configurationLocation.endsWith("/") ? new URL(String.valueOf(this.configurationLocation) + CONFIG_FILE) : new URL(this.configurationLocation);
            }
        }
        this.configuration = this.loadConfiguration(configURL);
        if (this.bootLocation == null && this.configuration != null && (urlString = this.configuration.getProperty(CFG_CORE_BOOT, null)) != null) {
            try {
                this.bootLocation = this.resolve(urlString);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (configURL == null && this.installLocation == null) {
            return passThruArgs;
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(passThruArgs));
        if (configURL != null) {
            args.add(CONFIGURATION);
            args.add(this.decode(configURL.toExternalForm()));
        }
        if (this.cmdFirstUse) {
            args.add(FIRST_USE);
        }
        if (this.installLocation != null) {
            args.add(INSTALL);
            args.add(this.installLocation);
        }
        return args.toArray(new String[0]);
    }

    private URL getRootURL() throws MalformedURLException {
        if (this.installLocation != null) {
            return new URL(this.installLocation);
        }
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String path = this.decode(url.getFile());
        if ((path = new File(path).getAbsolutePath().replace(File.separatorChar, '/')).endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        path = new File(path).getParentFile().getParent();
        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        this.setInstallLocation(path);
        return url;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadConfiguration(URL url) {
        Properties result = null;
        if (url == null) {
            String data = this.dataLocation;
            if (data == null) {
                data = System.getProperty(ARG_USER_DIR);
                if (!data.endsWith(File.separator)) {
                    data = String.valueOf(data) + File.separator;
                }
                data = String.valueOf(data) + "workspace" + File.separator;
            } else {
                data = data.replace('/', File.separatorChar);
            }
            if (!data.endsWith(File.separator)) {
                data = String.valueOf(data) + File.separator;
            }
            File cfg = null;
            try {
                cfg = new File(String.valueOf(data) + ".metadata" + File.separator + ".config" + File.separator + CONFIG_FILE);
                url = new URL("file", null, 0, cfg.getAbsolutePath());
                result = this.loadProperties(url);
                if (!this.debug) return result;
                System.out.println("Startup: using configuration " + url.toString());
                return result;
            }
            catch (IOException iOException) {
                try {
                    String install = this.getRootURL().getFile().replace('/', File.separatorChar);
                    if (!install.endsWith(File.separator)) {
                        install = String.valueOf(install) + File.separator;
                    }
                    cfg = new File(String.valueOf(install) + ".config" + File.separator + CONFIG_FILE);
                    url = new URL("file", null, 0, cfg.getAbsolutePath());
                    result = this.loadProperties(url);
                    if (!this.debug) return result;
                    System.out.println("Startup: using configuration " + url.toString());
                    return result;
                }
                catch (IOException e) {
                    if (!this.debug) return result;
                    System.out.println("Startup: unable to load configuration\n" + e);
                }
                return result;
            }
        }
        try {
            result = this.loadProperties(url);
            if (!this.debug) return result;
            System.out.println("Startup: using configuration " + url.toString());
            return result;
        }
        catch (IOException e) {
            if (!this.debug) return result;
            System.out.println("Startup: unable to load configuration\n" + e);
        }
        return result;
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties result = null;
        IOException originalException = null;
        try {
            result = this.load(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                result = this.load(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException) {
                try {
                    result = this.load(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException2) {
                    throw originalException;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties load(URL url, String suffix) throws IOException {
        Properties props;
        block10: {
            if (suffix != null && !suffix.equals("")) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(url.getFile()) + suffix);
            }
            props = new Properties();
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
                if (!CFG_EOF.equals(props.getProperty(CFG_EOF))) {
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (is == null) break block10;
            }
            try {}
            catch (IOException iOException) {}
            is.close();
        }
        if (props == null) return props;
        String id = props.getProperty("feature.0.id");
        int i = 1;
        while (id != null) {
            this.featureIndex.put(id, Integer.toString(i - 1));
            id = props.getProperty("feature." + i + "." + CFG_FEATURE_ENTRY_ID);
            ++i;
        }
        return props;
    }

    private void handleSplash(URL[] bootPath) {
        if (this.cmdInitialize) {
            this.showSplash = null;
            this.endSplash = null;
            return;
        }
        if (this.endSplash != null) {
            this.showSplash = null;
            return;
        }
        if (this.showSplash == null) {
            return;
        }
        String path = this.getSplashPath(bootPath);
        if (this.debug && path != null) {
            System.out.println("Startup: splash path = " + path);
        }
        String[] cmd = new String[path != null ? 4 : 3];
        int sIndex = 0;
        int eIndex = this.showSplash.indexOf(" -show");
        if (eIndex == -1) {
            return;
        }
        cmd[0] = this.showSplash.substring(sIndex, eIndex);
        sIndex = eIndex + 1;
        if ((eIndex = this.showSplash.indexOf(" ", sIndex)) == -1) {
            return;
        }
        cmd[1] = this.showSplash.substring(sIndex, eIndex);
        cmd[2] = this.showSplash.substring(eIndex + 1);
        if (path != null) {
            cmd[3] = path;
        }
    }

    private String getSplashPath(URL[] bootPath) {
        int pix;
        String[] featurePath = this.getFeatureRoot();
        String path = this.lookupSplash(featurePath);
        if (path != null) {
            return path;
        }
        String temp = bootPath[0].getFile();
        int ix = (temp = temp.replace('/', File.separatorChar)).lastIndexOf("plugins" + File.separator);
        if (ix != -1 && (pix = temp.indexOf(File.separator, ix + 8)) != -1) {
            temp = temp.substring(0, pix);
            path = this.lookupSplash(new String[]{temp});
            return path;
        }
        return null;
    }

    private String lookupSplash(String[] searchPath) {
        if (searchPath == null) {
            return null;
        }
        String localePath = Locale.getDefault().toString().replace('_', File.separatorChar);
        while (localePath != null) {
            int ix;
            String suffix = localePath.equals("") ? SPLASH_IMAGE : "nl" + File.separator + localePath + File.separator + SPLASH_IMAGE;
            int i = 0;
            while (i < searchPath.length) {
                File splash;
                String path = searchPath[i];
                if (!path.endsWith(File.separator)) {
                    path = String.valueOf(path) + File.separator;
                }
                if ((splash = new File(path = String.valueOf(path) + suffix)).exists()) {
                    return splash.getAbsolutePath();
                }
                ++i;
            }
            localePath = localePath.equals("") ? null : ((ix = localePath.lastIndexOf(File.separator)) == -1 ? "" : localePath.substring(0, ix));
        }
        return null;
    }

    private String getFeatureIdentifier() {
        if (this.feature != null) {
            return this.feature;
        }
        String dflt = this.configuration.getProperty(CFG_FEATURE_ENTRY_DEFAULT);
        if (dflt != null) {
            return dflt;
        }
        return null;
    }

    private String[] getFeatureRoot() {
        String ix = this.featureIndex(this.getFeatureIdentifier());
        String urlString = this.configuration.getProperty("feature." + ix + "." + CFG_FEATURE_ENTRY_ROOT + ".0");
        if (urlString == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        URL url = null;
        int i = 1;
        while (urlString != null) {
            block5: {
                try {
                    urlString = this.resolve(urlString);
                    url = new URL(urlString);
                    if (!url.getProtocol().equals("file")) break block5;
                    result.add(url.getFile().replace('/', File.separatorChar));
                }
                catch (MalformedURLException malformedURLException) {}
                urlString = this.configuration.getProperty("feature." + ix + "." + CFG_FEATURE_ENTRY_ROOT + "." + i);
            }
            ++i;
        }
        if (result.size() > 0) {
            return result.toArray(new String[0]);
        }
        return null;
    }

    private String resolve(String urlString) throws MalformedURLException {
        if (urlString.startsWith(PLATFORM_URL)) {
            String root = this.getRootURL().toExternalForm();
            if (!root.endsWith("/")) {
                root = String.valueOf(root) + "/";
            }
            String path = urlString.substring(PLATFORM_URL.length());
            return String.valueOf(root) + path;
        }
        return urlString;
    }

    private String featureIndex(String id) {
        if (id == null) {
            return null;
        }
        return (String)this.featureIndex.get(id);
    }

    private int hexToByte(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    private void setInstallLocation(String location) {
        this.installLocation = location;
        System.getProperties().setProperty("eclipse.installURL", location);
    }
}

