/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Member;

public abstract class CreateTypeMemberOperation
extends CreateElementInCUOperation {
    protected String fSource = null;
    protected String fAlteredName;
    protected IDOMNode fDOMNode;

    public CreateTypeMemberOperation(IJavaElement parentElement, String source, boolean force) {
        super(parentElement);
        this.fSource = source;
        this.force = force;
    }

    protected void generateNewCompilationUnitDOM(ICompilationUnit cu) throws JavaModelException {
        IDOMNode child;
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return;
        }
        char[] prevSource = buffer.getCharacters();
        if (prevSource == null) {
            return;
        }
        this.fCUDOM = new DOMFactory().createCompilationUnit(prevSource, cu.getElementName());
        IDOMNode parent = ((JavaElement)this.getParentElement()).findNode(this.fCUDOM);
        if (parent == null) {
            parent = this.fCUDOM;
        }
        if ((child = this.generateElementDOM()) != null) {
            this.insertDOMNode(parent, child);
        }
        this.worked(1);
    }

    protected IDOMNode generateSyntaxIncorrectDOM() {
        StringBuffer buff = new StringBuffer();
        buff.append(String.valueOf(Util.LINE_SEPARATOR) + " public class A {" + Util.LINE_SEPARATOR);
        buff.append(this.fSource);
        buff.append(Util.LINE_SEPARATOR).append('}');
        IDOMCompilationUnit domCU = new DOMFactory().createCompilationUnit(buff.toString(), "A.java");
        IDOMNode node = (IDOMNode)domCU.getChild("A").getChildren().nextElement();
        if (node != null) {
            node.remove();
        }
        return node;
    }

    protected IType getType() {
        return (IType)this.getParentElement();
    }

    protected void setAlteredName(String newName) {
        this.fAlteredName = newName;
    }

    public IJavaModelStatus verify() {
        Member localContext;
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IJavaElement parent = this.getParentElement();
        if (parent instanceof Member && (localContext = ((Member)parent).getOuterMostLocalContext()) != null && localContext != parent) {
            return new JavaModelStatus(967, parent);
        }
        if (this.fSource == null) {
            return new JavaModelStatus(984);
        }
        if (!this.force) {
            try {
                this.generateElementDOM();
            }
            catch (JavaModelException jme) {
                return jme.getJavaModelStatus();
            }
            return this.verifyNameCollision();
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected IJavaModelStatus verifyNameCollision() {
        return JavaModelStatus.VERIFIED_OK;
    }
}

