/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.internal.plugins.PluginClassLoader;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.QualifiedName;

public class EventStats {
    protected String id;
    protected IProject project;
    protected IPluginDescriptor plugin;
    protected long notificationRunningTime = 0L;
    protected long buildRunningTime = 0L;
    protected int notificationCount = 0;
    protected int buildCount = 0;
    protected Vector exceptions = new Vector();
    public static boolean DEBUG = false;
    private static long currentStart;
    private static EventStats currentStats;
    private static int snapshotCount;
    private static long snapshotTime;
    private static Map notificationStats;
    private static QualifiedName STATS_PROPERTY;

    static {
        snapshotCount = 0;
        snapshotTime = 0L;
        notificationStats = new HashMap(20);
        STATS_PROPERTY = new QualifiedName("org.eclipse.core.resources", "buildstats");
    }

    private EventStats(String id, IProject project) {
        this.id = id;
        this.project = project;
    }

    public static void buildException(Exception e) {
        if (currentStats == null) {
            if (DEBUG) {
                System.out.println(Policy.bind("utils.buildException"));
            }
        } else {
            currentStats.addException(e);
        }
    }

    public static void dumpStats() {
        EventStats.dumpStats(System.out);
    }

    public static void dumpStats(PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        EventStats.dumpStats(writer);
        writer.flush();
        writer.close();
    }

    public static void dumpStats(PrintWriter out) {
        EventStats stats;
        long totalBuildTime = 0L;
        long totalNotifyTime = 0L;
        int totalExceptions = 0;
        int totalBuilds = 0;
        int totalNotifications = 0;
        EventStats[] allStats = EventStats.getAllStats();
        int i = 0;
        while (i < allStats.length) {
            stats = allStats[i];
            totalBuildTime += stats.getBuildRunningTime();
            totalNotifyTime += stats.getNotifyRunningTime();
            totalExceptions += stats.getExceptionCount();
            totalBuilds += stats.getBuildCount();
            totalNotifications += stats.getNotifyCount();
            ++i;
        }
        out.println("---------------------------------------------------------------");
        out.println(Policy.bind("utils.snapshots", Integer.toString(snapshotCount), Long.toString(snapshotTime)));
        i = 0;
        while (i < allStats.length) {
            int exceptions;
            long buildTime;
            int buildCount;
            long notifyTime;
            stats = allStats[i];
            out.println(Policy.bind("utils.stats", stats.getName()));
            int notifyCount = stats.getNotifyCount();
            if (notifyCount > 0) {
                out.println(Policy.bind("utils.notifications", Integer.toString(notifyCount), Integer.toString((int)((double)notifyCount * 100.0 / (double)totalNotifications))));
            }
            if ((notifyTime = stats.getNotifyRunningTime()) > 0L) {
                out.println(Policy.bind("utils.notifyTime", Long.toString(notifyTime), Integer.toString((int)((double)notifyTime * 100.0 / (double)totalNotifyTime))));
            }
            if ((buildCount = stats.getBuildCount()) > 0) {
                out.println(Policy.bind("utils.builds", Integer.toString(buildCount), Integer.toString((int)((double)buildCount * 100.0 / (double)totalBuilds))));
            }
            if ((buildTime = stats.getBuildRunningTime()) > 0L) {
                out.println(Policy.bind("utils.buildTime", Long.toString(buildTime), Integer.toString((int)((double)buildTime * 100.0 / (double)totalBuildTime))));
            }
            if ((exceptions = stats.getExceptionCount()) > 0) {
                out.println(Policy.bind("utils.exceptions", Integer.toString(exceptions), Integer.toString((int)((double)exceptions * 100.0 / (double)totalExceptions))));
            }
            out.println("");
            ++i;
        }
    }

    public static void endBuild() {
        long end = System.currentTimeMillis();
        if (currentStats == null || currentStart == -1L) {
            if (DEBUG) {
                System.err.println(Policy.bind("utils.endBuild"));
            }
            return;
        }
        currentStats.addBuild(end - currentStart);
        currentStats = null;
        currentStart = -1L;
    }

    public static void endNotify() {
        long end = System.currentTimeMillis();
        if (currentStats == null || currentStart == -1L) {
            if (DEBUG) {
                System.err.println(Policy.bind("utils.endNotify"));
            }
            return;
        }
        currentStats.addNotify(end - currentStart);
        currentStart = -1L;
    }

    public static void endSnapshot() {
        snapshotTime += System.currentTimeMillis() - currentStart;
        ++snapshotCount;
        currentStart = -1L;
    }

    public static int getSnapCount() {
        return snapshotCount;
    }

    private static IPluginDescriptor getPluginFor(Object target) {
        ClassLoader loader = target.getClass().getClassLoader();
        if (loader instanceof PluginClassLoader) {
            return ((PluginClassLoader)loader).getPluginDescriptor();
        }
        return null;
    }

    private static EventStats getStats(String id, IProject project, Object origin) {
        EventStats result = null;
        if (project == null) {
            result = (EventStats)notificationStats.get(id);
            if (result == null) {
                result = new EventStats(id, project);
                result.setPlugin(EventStats.getPluginFor(origin));
                notificationStats.put(id, result);
            }
        } else {
            try {
                HashMap<String, EventStats> stats = (HashMap<String, EventStats>)project.getSessionProperty(STATS_PROPERTY);
                if (stats == null) {
                    stats = new HashMap<String, EventStats>(5);
                    project.setSessionProperty(STATS_PROPERTY, stats);
                }
                if ((result = (EventStats)stats.get(id)) == null) {
                    result = new EventStats(id, project);
                    result.setPlugin(EventStats.getPluginFor(origin));
                    stats.put(id, result);
                }
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public static EventStats[] getAllStats() {
        ArrayList result = new ArrayList(notificationStats.values());
        try {
            IResource[] projects = ResourcesPlugin.getWorkspace().getRoot().members();
            int i = 0;
            while (i < projects.length) {
                IProject project = (IProject)projects[i];
                try {
                    Map stats = (Map)project.getSessionProperty(STATS_PROPERTY);
                    if (stats != null) {
                        result.addAll(stats.values());
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new EventStats[result.size()]);
    }

    public static void resetStats() {
        Iterator iter = notificationStats.values().iterator();
        while (iter.hasNext()) {
            ((EventStats)iter.next()).reset();
        }
        try {
            IResource[] projects = ResourcesPlugin.getWorkspace().getRoot().members();
            int i = 0;
            while (i < projects.length) {
                IProject project = (IProject)projects[i];
                try {
                    Map stats = (Map)project.getSessionProperty(STATS_PROPERTY);
                    if (stats != null) {
                        Iterator iter2 = stats.values().iterator();
                        while (iter2.hasNext()) {
                            ((EventStats)iter2.next()).reset();
                        }
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public static void listenerRemoved(IResourceChangeListener listener) {
        if (listener != null) {
            notificationStats.remove(listener.toString());
        }
    }

    public static void listenerAdded(IResourceChangeListener listener) {
        if (listener != null) {
            EventStats.getStats(listener.toString(), null, listener);
        }
    }

    public static void notifyException(Exception e) {
        if (currentStats == null) {
            if (DEBUG) {
                System.out.println(Policy.bind("utils.buildException"));
            }
            return;
        }
        currentStats.addException(e);
    }

    public static void startBuild(IncrementalProjectBuilder builder) {
        String key = builder.getLabel();
        currentStats = EventStats.getStats(key, builder.getProject(), builder);
        currentStart = System.currentTimeMillis();
    }

    public static void startNotify(IResourceChangeListener listener) {
        currentStats = EventStats.getStats(listener.toString(), null, listener);
        currentStart = System.currentTimeMillis();
    }

    public static void startSnapshot() {
        currentStart = System.currentTimeMillis();
    }

    void addBuild(long elapsed) {
        ++this.buildCount;
        this.buildRunningTime += elapsed;
    }

    void addException(Exception e) {
        this.exceptions.addElement(e);
    }

    void addNotify(long elapsed) {
        ++this.notificationCount;
        this.notificationRunningTime += elapsed;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public long getBuildRunningTime() {
        return this.buildRunningTime;
    }

    public Enumeration getCoreExceptions() {
        Vector<Exception> runtime = new Vector<Exception>();
        Enumeration e = this.exceptions.elements();
        while (e.hasMoreElements()) {
            Exception next = (Exception)e.nextElement();
            if (!(next instanceof CoreException)) continue;
            runtime.addElement(next);
        }
        return runtime.elements();
    }

    public int getExceptionCount() {
        return this.exceptions.size();
    }

    public String getName() {
        return this.id;
    }

    public int getNotifyCount() {
        return this.notificationCount;
    }

    public long getNotifyRunningTime() {
        return this.notificationRunningTime;
    }

    public IPluginDescriptor getPlugin() {
        return this.plugin;
    }

    public IProject getProject() {
        return this.project;
    }

    public Enumeration getRuntimeExceptions() {
        Vector<Exception> runtime = new Vector<Exception>();
        Enumeration e = this.exceptions.elements();
        while (e.hasMoreElements()) {
            Exception next = (Exception)e.nextElement();
            if (!(next instanceof RuntimeException)) continue;
            runtime.addElement(next);
        }
        return runtime.elements();
    }

    public long getTotalRunningTime() {
        return this.notificationRunningTime + this.buildRunningTime;
    }

    public void reset() {
        this.notificationRunningTime = 0L;
        this.buildRunningTime = 0L;
        this.notificationCount = 0;
        this.buildCount = 0;
        this.exceptions = new Vector();
    }

    public void setPlugin(IPluginDescriptor value) {
        this.plugin = value;
    }
}

