/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.reflect.Modifier;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.bcel.LazyClassGen;

public class NameMangler {
    public static final String PREFIX = "ajc$";
    public static final String CFLOW_STACK_TYPE = "org.aspectj.runtime.internal.CFlowStack";
    public static final String SOFT_EXCEPTION_TYPE = "org.aspectj.lang.SoftException";
    public static final String PERSINGLETON_FIELD_NAME = "ajc$perSingletonInstance";
    public static final String PERCFLOW_FIELD_NAME = "ajc$perCflowStack";
    public static final String PERCFLOW_PUSH_METHOD = "ajc$perCflowPush";
    public static final String PEROBJECT_BIND_METHOD = "ajc$perObjectBind";
    public static final String AJC_PRE_CLINIT_NAME = "ajc$preClinit";
    public static final String AJC_POST_CLINIT_NAME = "ajc$postClinit";
    public static final String INITFAILURECAUSE_FIELD_NAME = "ajc$initFailureCause";

    private NameMangler() {
        throw new RuntimeException("static");
    }

    public static String perObjectInterfaceGet(TypeX aspectType) {
        return NameMangler.makeName(aspectType.getNameAsIdentifier(), "perObjectGet");
    }

    public static String perObjectInterfaceSet(TypeX aspectType) {
        return NameMangler.makeName(aspectType.getNameAsIdentifier(), "perObjectSet");
    }

    public static String perObjectInterfaceField(TypeX aspectType) {
        return NameMangler.makeName(aspectType.getNameAsIdentifier(), "perObjectField");
    }

    public static String privilegedAccessMethodForMethod(String name, TypeX objectType, TypeX aspectType) {
        return NameMangler.makeName("privMethod", aspectType.getNameAsIdentifier(), objectType.getNameAsIdentifier(), name);
    }

    public static String privilegedAccessMethodForFieldGet(String name, TypeX objectType, TypeX aspectType) {
        return NameMangler.makeName("privFieldGet", aspectType.getNameAsIdentifier(), objectType.getNameAsIdentifier(), name);
    }

    public static String privilegedAccessMethodForFieldSet(String name, TypeX objectType, TypeX aspectType) {
        return NameMangler.makeName("privFieldSet", aspectType.getNameAsIdentifier(), objectType.getNameAsIdentifier(), name);
    }

    public static String inlineAccessMethodForMethod(String name, TypeX objectType, TypeX aspectType) {
        return NameMangler.makeName("inlineAccessMethod", aspectType.getNameAsIdentifier(), objectType.getNameAsIdentifier(), name);
    }

    public static String inlineAccessMethodForFieldGet(String name, TypeX objectType, TypeX aspectType) {
        return NameMangler.makeName("inlineAccessFieldGet", aspectType.getNameAsIdentifier(), objectType.getNameAsIdentifier(), name);
    }

    public static String inlineAccessMethodForFieldSet(String name, TypeX objectType, TypeX aspectType) {
        return NameMangler.makeName("inlineAccessFieldSet", aspectType.getNameAsIdentifier(), objectType.getNameAsIdentifier(), name);
    }

    public static String adviceName(TypeX aspectType, AdviceKind kind, int adviceSeqNumber, int pcdHash) {
        String newname = NameMangler.makeName(kind.getName(), aspectType.getNameAsIdentifier(), Integer.toString(adviceSeqNumber), Integer.toHexString(pcdHash));
        return newname;
    }

    public static String interFieldInterfaceField(TypeX aspectType, TypeX interfaceType, String name) {
        return NameMangler.makeName("interField", aspectType.getNameAsIdentifier(), interfaceType.getNameAsIdentifier(), name);
    }

    public static String interFieldInterfaceSetter(TypeX aspectType, TypeX interfaceType, String name) {
        return NameMangler.makeName("interFieldSet", aspectType.getNameAsIdentifier(), interfaceType.getNameAsIdentifier(), name);
    }

    public static String interFieldInterfaceGetter(TypeX aspectType, TypeX interfaceType, String name) {
        return NameMangler.makeName("interFieldGet", aspectType.getNameAsIdentifier(), interfaceType.getNameAsIdentifier(), name);
    }

    public static String interFieldSetDispatcher(TypeX aspectType, TypeX onType, String name) {
        return NameMangler.makeName("interFieldSetDispatch", aspectType.getNameAsIdentifier(), onType.getNameAsIdentifier(), name);
    }

    public static String interFieldGetDispatcher(TypeX aspectType, TypeX onType, String name) {
        return NameMangler.makeName("interFieldGetDispatch", aspectType.getNameAsIdentifier(), onType.getNameAsIdentifier(), name);
    }

    public static String interFieldClassField(int modifiers, TypeX aspectType, TypeX classType, String name) {
        if (Modifier.isPublic(modifiers)) {
            return name;
        }
        return NameMangler.makeName("interField", NameMangler.makeVisibilityName(modifiers, aspectType), name);
    }

    public static String interFieldInitializer(TypeX aspectType, TypeX classType, String name) {
        return NameMangler.makeName("interFieldInit", aspectType.getNameAsIdentifier(), classType.getNameAsIdentifier(), name);
    }

    public static String interMethod(int modifiers, TypeX aspectType, TypeX classType, String name) {
        if (Modifier.isPublic(modifiers)) {
            return name;
        }
        return NameMangler.makeName("interMethodDispatch2", NameMangler.makeVisibilityName(modifiers, aspectType), name);
    }

    public static String interMethodDispatcher(TypeX aspectType, TypeX classType, String name) {
        return NameMangler.makeName("interMethodDispatch1", aspectType.getNameAsIdentifier(), classType.getNameAsIdentifier(), name);
    }

    public static String interMethodBody(TypeX aspectType, TypeX classType, String name) {
        return NameMangler.makeName("interMethod", aspectType.getNameAsIdentifier(), classType.getNameAsIdentifier(), name);
    }

    public static String preIntroducedConstructor(TypeX aspectType, TypeX targetType) {
        return NameMangler.makeName("preInterConstructor", aspectType.getNameAsIdentifier(), targetType.getNameAsIdentifier());
    }

    public static String postIntroducedConstructor(TypeX aspectType, TypeX targetType) {
        return NameMangler.makeName("postInterConstructor", aspectType.getNameAsIdentifier(), targetType.getNameAsIdentifier());
    }

    public static String superDispatchMethod(TypeX classType, String name) {
        return NameMangler.makeName("superDispatch", classType.getNameAsIdentifier(), name);
    }

    public static String protectedDispatchMethod(TypeX classType, String name) {
        return NameMangler.makeName("protectedDispatch", classType.getNameAsIdentifier(), name);
    }

    private static String makeVisibilityName(int modifiers, TypeX aspectType) {
        if (Modifier.isPrivate(modifiers)) {
            return aspectType.getOutermostType().getNameAsIdentifier();
        }
        if (Modifier.isProtected(modifiers)) {
            throw new RuntimeException("protected inter-types not allowed");
        }
        if (Modifier.isPublic(modifiers)) {
            return "";
        }
        return aspectType.getPackageNameAsIdentifier();
    }

    private static String makeName(String s1, String s2) {
        return PREFIX + s1 + "$" + s2;
    }

    public static String makeName(String s1, String s2, String s3) {
        return PREFIX + s1 + "$" + s2 + "$" + s3;
    }

    public static String makeName(String s1, String s2, String s3, String s4) {
        return PREFIX + s1 + "$" + s2 + "$" + s3 + "$" + s4;
    }

    public static String cflowStack(CrosscuttingMembers xcut) {
        return NameMangler.makeName("cflowStack", Integer.toHexString(xcut.getCflowEntries().size()));
    }

    public static String makeClosureClassName(TypeX enclosingType, int index) {
        return enclosingType.getName() + "$AjcClosure" + index;
    }

    public static String aroundCallbackMethodName(Member shadowSig, LazyClassGen enclosingType) {
        String ret = shadowSig.getExtractableName() + "_aroundBody" + enclosingType.getNewGeneratedNameTag();
        return ret;
    }

    public static String proceedMethodName(String adviceMethodName) {
        return adviceMethodName + "proceed";
    }
}

