/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class ByteArrayBuffer
extends Buffer {
    private int bufLength = 0;
    private byte[] byteBuffer;
    private int position = 0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;

    ByteArrayBuffer(byte[] buf) {
        this.byteBuffer = buf;
        this.setBufLength(buf.length);
    }

    ByteArrayBuffer(int size) {
        this.byteBuffer = new byte[size];
        this.setBufLength(this.byteBuffer.length);
        this.position = 4;
    }

    final void clear() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.position = 4;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void ensureCapacity(int n) throws SQLException {
        void additionalData;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.position + additionalData > this.getBufLength()) {
            if (this.position + additionalData < this.byteBuffer.length) {
                this.setBufLength(this.byteBuffer.length);
            } else {
                int newLength = (int)((double)this.byteBuffer.length * 1.25);
                if (newLength < this.byteBuffer.length + additionalData) {
                    newLength = this.byteBuffer.length + (int)((double)additionalData * 1.25);
                }
                if (newLength < this.byteBuffer.length) {
                    newLength = this.byteBuffer.length + additionalData;
                }
                byte[] newBytes = new byte[newLength];
                System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
                this.byteBuffer = newBytes;
                this.setBufLength(this.byteBuffer.length);
            }
        }
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    public int fastSkipLenString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long len = this.readFieldLength();
        this.position = (int)((long)this.position + len);
        int n = (int)len;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    protected final byte[] getBufferSource() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] byArray = this.byteBuffer;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return this.byteBuffer;
    }

    int getBufLength() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.bufLength;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public byte[] getByteBuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] byArray = this.byteBuffer;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return this.byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    final byte[] getBytes(int n) {
        void len;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b, 0, (int)len);
        this.position += len;
        byte[] byArray = b;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return b;
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytes(int n, int n2) {
        void offset;
        void len;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] dest = new byte[len];
        System.arraycopy(this.byteBuffer, (int)offset, dest, 0, (int)len);
        byte[] byArray = dest;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return dest;
    }

    int getCapacity() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.byteBuffer.length;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public ByteBuffer getNioBuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new IllegalArgumentException(Messages.getString("ByteArrayBuffer.0"));
    }

    public int getPosition() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.position;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final boolean isLastDataPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.getBufLength() < 9 && (this.byteBuffer[0] & 0xFF) == 254;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    final long newReadLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                l = 0L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLongLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final byte readByte() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte by = this.byteBuffer[this.position++];
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.byteObject((byte)by), joinPoint);
        return by;
    }

    /*
     * WARNING - void declaration
     */
    final byte readByte(int n) {
        void readAt;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte by = this.byteBuffer[readAt];
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.byteObject((byte)by), joinPoint);
        return by;
    }

    final long readFieldLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                l = -1L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLongLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final int readInt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        int n = b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final int readIntAsLong() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        int n = b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16 | (b[this.position++] & 0xFF) << 24;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    final byte[] readLenByteArray(int n) {
        byte[] byArray;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long len = this.readFieldLength();
        if (len == -1L) {
            byArray = null;
        } else if (len == 0L) {
            byArray = Constants.EMPTY_BYTE_ARRAY;
        } else {
            void offset;
            this.position += offset;
            byArray = this.getBytes((int)len);
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    final long readLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                l = 0L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final long readLong() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        long l = (long)b[this.position++] & 0xFFL | ((long)b[this.position++] & 0xFFL) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    final int readLongInt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        int n = b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final long readLongLong() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        long l = (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    final int readnBytes() {
        int n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                n = this.byteBuffer[this.position++] & 0xFF;
                break;
            }
            case 2: {
                n = this.readInt();
                break;
            }
            case 3: {
                n = this.readLongInt();
                break;
            }
            case 4: {
                n = (int)this.readLong();
                break;
            }
            default: {
                n = 255;
                break;
            }
        }
        int n2 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    final String readString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int i = this.position;
        int len = 0;
        int maxLen = this.getBufLength();
        while (i < maxLen && this.byteBuffer[i] != 0) {
            ++len;
            ++i;
        }
        String s = new String(this.byteBuffer, this.position, len);
        this.position += len + 1;
        String string = s;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String readString(String string) throws SQLException {
        String string2;
        String string3 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int i = this.position;
        int len = 0;
        int maxLen = this.getBufLength();
        while (i < maxLen && this.byteBuffer[i] != 0) {
            ++len;
            ++i;
        }
        try {
            void encoding;
            try {
                String string4 = new String(this.byteBuffer, this.position, len, (String)encoding);
                Object var5_8 = null;
                this.position += len + 1;
                string2 = string4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(String.valueOf(Messages.getString("ByteArrayBuffer.1")) + (String)encoding + "'", "S1009");
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.position += len + 1;
            throw throwable;
        }
        String string5 = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string5, joinPoint);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    void setBufLength(int n) {
        void bufLengthToSet;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.bufLength = bufLengthToSet;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setByteBuffer(byte[] byArray) {
        void byteBufferToSet;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.byteBuffer = byteBufferToSet;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setPosition(int n) {
        void positionToSet;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.position = positionToSet;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeByte(byte by) throws SQLException {
        void b;
        byte by2 = by;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.byteObject((byte)by2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(1);
        this.byteBuffer[this.position++] = b;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBytesNoNull(byte[] byArray) throws SQLException {
        void bytes;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = ((void)bytes).length;
        this.ensureCapacity(len);
        System.arraycopy(bytes, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBytesNoNull(byte[] byArray, int n, int n2) throws SQLException {
        void offset;
        void bytes;
        void length;
        byte[] byArray2 = byArray;
        int n3 = n;
        int n4 = n2;
        Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity((int)length);
        System.arraycopy(bytes, (int)offset, this.byteBuffer, this.position, (int)length);
        this.position += length;
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeDouble(double d) throws SQLException {
        void d2;
        double d3 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = Double.doubleToLongBits((double)d2);
        this.writeLongLong(l);
        Object var8_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeFieldLength(long l) throws SQLException {
        void length;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (length < 251L) {
            this.writeByte((byte)length);
        } else if (length < 65536L) {
            this.ensureCapacity(3);
            this.writeByte((byte)-4);
            this.writeInt((int)length);
        } else if (length < 0x1000000L) {
            this.ensureCapacity(4);
            this.writeByte((byte)-3);
            this.writeLongInt((int)length);
        } else {
            this.ensureCapacity(9);
            this.writeByte((byte)-2);
            this.writeLongLong((long)length);
        }
        Object var6_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeFloat(float f) throws SQLException {
        void f2;
        float f3 = f;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)Conversions.floatObject((float)f3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(4);
        int i = Float.floatToIntBits((float)f2);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeInt(int n) throws SQLException {
        void i;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(2);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLenBytes(byte[] byArray) throws SQLException {
        void b;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = ((void)b).length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLenString(String string, String string2, String string3, SingleByteCharsetConverter singleByteCharsetConverter, boolean bl) throws UnsupportedEncodingException, SQLException {
        void parserKnowsUnicode;
        void serverEncoding;
        void encoding;
        void s;
        void converter;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        SingleByteCharsetConverter singleByteCharsetConverter2 = singleByteCharsetConverter;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string4, string5, string6, singleByteCharsetConverter2, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = null;
        b = converter != null ? converter.toBytes((String)s) : StringUtils.getBytes((String)s, (String)encoding, (String)serverEncoding, (boolean)parserKnowsUnicode);
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var15_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var15_15, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLong(long l) throws SQLException {
        void i;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(4);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        Object var7_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLongInt(int n) throws SQLException {
        void i;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(3);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLongLong(long l) throws SQLException {
        void i;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(8);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        b[this.position++] = (byte)(i >>> 32);
        b[this.position++] = (byte)(i >>> 40);
        b[this.position++] = (byte)(i >>> 48);
        b[this.position++] = (byte)(i >>> 56);
        Object var7_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeString(String string) throws SQLException {
        void s;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(s.length() * 2 + 1);
        this.writeStringNoNull((String)s);
        this.byteBuffer[this.position++] = 0;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeStringNoNull(String string) throws SQLException {
        void s;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = s.length();
        this.ensureCapacity(len * 2);
        System.arraycopy(s.getBytes(), 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeStringNoNull(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException, SQLException {
        void parserKnowsUnicode;
        void serverEncoding;
        void encoding;
        void s;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string4, string5, string6, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = StringUtils.getBytes((String)s, (String)encoding, (String)serverEncoding, (boolean)parserKnowsUnicode);
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var13_13 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var13_13, joinPoint);
    }

    static {
        Factory factory = new Factory("ByteArrayBuffer.java", Class.forName("com.mysql.jdbc.ByteArrayBuffer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-clear-com.mysql.jdbc.ByteArrayBuffer----void-"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-ensureCapacity-com.mysql.jdbc.ByteArrayBuffer-int:-additionalData:-java.sql.SQLException:-void-"), 63);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPosition-com.mysql.jdbc.ByteArrayBuffer----int-"), 162);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-isLastDataPacket-com.mysql.jdbc.ByteArrayBuffer----boolean-"), 167);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-newReadLength-com.mysql.jdbc.ByteArrayBuffer----long-"), 171);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readByte-com.mysql.jdbc.ByteArrayBuffer----byte-"), 192);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readByte-com.mysql.jdbc.ByteArrayBuffer-int:-readAt:--byte-"), 196);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readFieldLength-com.mysql.jdbc.ByteArrayBuffer----long-"), 200);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readInt-com.mysql.jdbc.ByteArrayBuffer----int-"), 222);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readIntAsLong-com.mysql.jdbc.ByteArrayBuffer----int-"), 228);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLenByteArray-com.mysql.jdbc.ByteArrayBuffer-int:-offset:--[B-"), 236);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLength-com.mysql.jdbc.ByteArrayBuffer----long-"), 252);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-fastSkipLenString-com.mysql.jdbc.ByteArrayBuffer----int-"), 103);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLong-com.mysql.jdbc.ByteArrayBuffer----long-"), 274);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLongInt-com.mysql.jdbc.ByteArrayBuffer----int-"), 283);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLongLong-com.mysql.jdbc.ByteArrayBuffer----long-"), 291);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readnBytes-com.mysql.jdbc.ByteArrayBuffer----int-"), 304);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readString-com.mysql.jdbc.ByteArrayBuffer----java.lang.String-"), 331);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readString-com.mysql.jdbc.ByteArrayBuffer-java.lang.String:-encoding:-java.sql.SQLException:-java.lang.String-"), 347);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-setBufLength-com.mysql.jdbc.ByteArrayBuffer-int:-bufLengthToSet:--void-"), 367);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setByteBuffer-com.mysql.jdbc.ByteArrayBuffer-[B:-byteBufferToSet:--void-"), 377);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPosition-com.mysql.jdbc.ByteArrayBuffer-int:-positionToSet:--void-"), 387);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeByte-com.mysql.jdbc.ByteArrayBuffer-byte:-b:-java.sql.SQLException:-void-"), 391);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14-getBufferSource-com.mysql.jdbc.ByteArrayBuffer----[B-"), 111);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeBytesNoNull-com.mysql.jdbc.ByteArrayBuffer-[B:-bytes:-java.sql.SQLException:-void-"), 398);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeBytesNoNull-com.mysql.jdbc.ByteArrayBuffer-[B:int:int:-bytes:offset:length:-java.sql.SQLException:-void-"), 407);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeDouble-com.mysql.jdbc.ByteArrayBuffer-double:-d:-java.sql.SQLException:-void-"), 413);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeFieldLength-com.mysql.jdbc.ByteArrayBuffer-long:-length:-java.sql.SQLException:-void-"), 418);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeFloat-com.mysql.jdbc.ByteArrayBuffer-float:-f:-java.sql.SQLException:-void-"), 436);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeInt-com.mysql.jdbc.ByteArrayBuffer-int:-i:-java.sql.SQLException:-void-"), 448);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLenBytes-com.mysql.jdbc.ByteArrayBuffer-[B:-b:-java.sql.SQLException:-void-"), 458);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLenString-com.mysql.jdbc.ByteArrayBuffer-java.lang.String:java.lang.String:java.lang.String:com.mysql.jdbc.SingleByteCharsetConverter:boolean:-s:encoding:serverEncoding:converter:parserKnowsUnicode:-java.io.UnsupportedEncodingException:java.sql.SQLException:-void-"), 470);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLong-com.mysql.jdbc.ByteArrayBuffer-long:-i:-java.sql.SQLException:-void-"), 488);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLongInt-com.mysql.jdbc.ByteArrayBuffer-int:-i:-java.sql.SQLException:-void-"), 499);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBufLength-com.mysql.jdbc.ByteArrayBuffer----int-"), 115);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLongLong-com.mysql.jdbc.ByteArrayBuffer-long:-i:-java.sql.SQLException:-void-"), 507);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeString-com.mysql.jdbc.ByteArrayBuffer-java.lang.String:-s:-java.sql.SQLException:-void-"), 521);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeStringNoNull-com.mysql.jdbc.ByteArrayBuffer-java.lang.String:-s:-java.sql.SQLException:-void-"), 528);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeStringNoNull-com.mysql.jdbc.ByteArrayBuffer-java.lang.String:java.lang.String:java.lang.String:boolean:-s:encoding:serverEncoding:parserKnowsUnicode:-java.io.UnsupportedEncodingException:java.sql.SQLException:-void-"), 544);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getByteBuffer-com.mysql.jdbc.ByteArrayBuffer----[B-"), 124);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getBytes-com.mysql.jdbc.ByteArrayBuffer-int:-len:--[B-"), 128);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBytes-com.mysql.jdbc.ByteArrayBuffer-int:int:-offset:len:--[B-"), 141);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getCapacity-com.mysql.jdbc.ByteArrayBuffer----int-"), 148);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getNioBuffer-com.mysql.jdbc.ByteArrayBuffer----java.nio.ByteBuffer-"), 152);
    }
}

