/* compat.c

   Compatibility routines... */

/*
 * Copyright (c) 1996 Vixie Enterprises.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of RadioMail Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY RADIOMAIL CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * RADIOMAIL CORPORATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software was written for Vixie Enterprises by Ted Lemon.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1996 Vixie Enterprises.  All rights reserved.\n";
#endif /* not lint */

#include "osdep.h"
#include "cdefs.h"
#include "global.h"
#include <sys/time.h>
#include <signal.h>
#include <syslog.h>

void really_usleep (delay)
     unsigned long delay;
{
  fd_set r, w, x;
  struct timeval t;
  int status;

  FD_ZERO (&r);
  FD_ZERO (&w);
  FD_ZERO (&x);

  t.tv_sec = delay / 1000000;
  t.tv_usec = delay % 1000000;
  status = select (0, &r, &w, &x, &t);
}
#if 0
#define ITIMER_REAL 0

int timed_out = 0;

void really_usleep (delay)
     unsigned long delay;
{
  struct itimerval itv, junk;
  sigset_t set;
  sigset_t mask_alrm;

  /* Disable processesing of SIGALRM. */
  signal (SIGALRM, SIG_IGN);

  /* Clear the timed-out flag. */
  timed_out = 0;

  /* Trap the alarm. */
  sigemptyset (&mask_alrm);
  sigaddset (&mask_alrm, SIGALRM);
  sigprocmask (SIG_BLOCK, &mask_alrm, (sigset_t *)0);
  signal (SIGALRM, usleep_sig);

  /* Set the interval timer... */
  itv.it_interval.tv_sec = itv.it_interval.tv_usec = 0;
  itv.it_value.tv_sec = delay / 1000000;
  itv.it_value.tv_usec = delay % 1000000;

  setitimer (ITIMER_REAL, &itv, &junk);

  /* Get an empty set of signals... */
  sigemptyset (&set);

  do {
getitimer (ITIMER_REAL, &junk);
syslog (LOG_ERR, "ITIMER_REAL: %d %d",
junk.it_value.tv_sec, junk.it_value.tv_usec);
    sigsuspend (&set);
getitimer (ITIMER_REAL, &junk);
syslog (LOG_ERR, "ITIMER_REAL: %d %d",
junk.it_value.tv_sec, junk.it_value.tv_usec);
  } while (!timed_out);
  sigprocmask (SIG_UNBLOCK, &set, (sigset_t *)0);
}

void usleep_sig (sig)
     int sig;
{
  timed_out = 1;
}
#endif
