/* netbsd.h

   System dependencies for NetBSD... */

/*
 * Copyright (c) 1995 RadioMail Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of RadioMail Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY RADIOMAIL CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * RADIOMAIL CORPORATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software was written for RadioMail Corporation by Ted Lemon
 * under a contract with Vixie Enterprises, and is based on an earlier
 * design by Paul Vixie.
 */

#include <sys/types.h>
#include <string.h>
#include <paths.h>
#include <errno.h>
#include <unistd.h>

#include <sys/wait.h>
#include <signal.h>

#include <sys/param.h>
#include <sys/sysctl.h>

/* Time stuff... */
#include <sys/time.h>
#define TIME struct timeval
#define GET_TIME(x)	gettimeofday ((x), (struct timezone *)0)
#define TIME_DIFF_US(low, high) 					\
  (((high) -> tv_sec - (low) -> tv_sec) * 1000000			\
   + ((high) -> tv_usec - (low) -> tv_usec))
#define SET_TIME(x, y)	(((x) -> tv_sec = ((y) / 1000000)),		\
			 ((x) -> tv_usec = ((y) % 1000000)))
#define MSDELAY(ms)	really_usleep (ms * 1000)
#define DELAY_ONE_SECOND() really_usleep (1000000)

/* Login stuff... */
#include <utmp.h>
#include <sys/syslimits.h>
#define SETLOGIN(x) setlogin (x)
#define SETUID(x)	setuid (x)
#define SETGID(x)	(setgroups (0, &x), setgid (x))
#define USER_MAX	UT_NAMESIZE

/* Varargs stuff... */
#include <stdarg.h>
#define VA_DOTDOTDOT ...
#define va_dcl
#define VA_start(list, last) va_start (list, last)

#define _PATH_MPOOL_PID	"/var/run/mpoold.pid"
#define _PATH_LOGIN	"/usr/bin/login"
