#include "args.h"

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/version.c,v 1.1 2005/05/28 22:27:54 beebe Exp $";
#endif

/*
 * Dump all of the rcs-id's from MM's header files.
 */

#define RCSID
#include "mm.h"
#include "parse.h"
#include "cmds.h"
#include "message.h"
#include "babyl.h"
#include "rd.h"
#include "set.h"
#include "help.h"
#undef RCSID

/*
 * Pull in the version string, major and minor release numbers, the edit
 * number, and the who-compiled-mm string, and make them available in global
 * variables.  This is ugly but it obviates the need to recompile all the
 * modules that might want to reference the edit numbers every time version.h
 * changes.
 */

#include "version.h"

const char *mm_version = MM_VERSION;
const char *mm_compiled = MM_COMPILED;
int mm_major_version = MM_MAJOR;
int mm_minor_version = MM_MINOR;
int mm_patch_level = MM_PATCH;
int mm_edit_number = MM_EDIT;

/*
 * Make a guess at the operating system type, so we can include that
 * info in the headers of bug reports sent with the "bug" command.
 */

#if AIX
const char *OStype = "AIX";
#else
#if hpux
const char *OStype = "hpux";
#else
#ifdef pyr
const char *OStype = "Pyramid";
#else
#if accel
const char *OStype = "Accel";
#else
#if ultrix
const char *OStype = "Ultrix";
#else
#if sun
const char *OStype = "SunOS";
#else
#if BSD
const char *OStype = "BSD";
#else
#if SYSV
#if SVR3
const char *OStype = "SVR3";
#else
#if SVR2
const char *OStype = "SVR2";
#else
const char *OStype = "SYSV";
#endif
#endif
#else
#if MSDOS
const char *OStype = "MS-DOS";
#else
const char *OStype = "unknown";
#endif /* MSDOS */
#endif /* SYSV */
#endif /* BSD */
#endif /* SUN */
#endif /* Ultrix */
#endif /* accel */
#endif /* pyramid */
#endif /* hpux */
#endif /* AIX */
