#include "args.h"

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/rd.c,v 1.1 2005/05/28 22:27:53 beebe Exp $";
#endif

/*
 * rd.c:
 * structure of routines for reading mail files
 */

#include "mm.h"
#include "parse.h"
#define MSGOPS
#include "rd.h"

/*
 * this MUST stay in alphabetical order
 * to line up with the keyword table below
 */
#define C int(*) ARGS((FILE *)) /* NB: don't use variable name here--SGI
				IRIX 4.0.x cc compiler complains */
#define O int(*) ARGS((msgvec *mail, int))
#define R int(*) ARGS((msgvec *mail_, int num_))
#define W int(*) ARGS((msgvec*, message*, int, int))
msg_handler msg_ops[] = {
					/* babyl (RMAIL) file  */
    { "babyl", babyl_open, (C)babyl_close, babyl_rdmsg, babyl_wrmsg,
	  babyl_probe },
					/* unix mailbox */
    { "mbox", mbox_open, (C)mbox_close, mbox_rdmsg, mbox_wrmsg, mbox_probe },
					/* mh type (folders) */
    { "mh", (O)mh_open, (C)mh_close, (O)mh_rdmsg, (W)mh_wrmsg, mh_probe },
					/* MM-20 mail.txt */
    { "mtxt", mtxt_open, (C)mtxt_close, mtxt_rdmsg, mtxt_wrmsg, mtxt_probe },
					/* pop2 client */
    { "pop2", (O)pop2_open, (C)pop2_close, (R)pop2_rdmsg, (W)pop2_wrmsg, pop2_probe },
					/* pop 3 client.   not written yet */
    { "pop3", (O)pop3_open, (C)pop3_close, (R)pop3_rdmsg, (W)pop3_wrmsg, pop3_probe },
};
#undef C
#undef O
#undef R
#undef W
int num_msg_ops = sizeof(msg_ops) / sizeof(msg_handler);

/*
 * make sure to update keywrd formatkeys[], which should be in
 * formattab.c
 */
