#ifndef PATHNAMES_H_
#define PATHNAMES_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *pathnames_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/pathnames.h,v 1.1 2005/05/28 22:27:52 beebe Exp $";
#endif
#endif /* RCSID */

/*
 * Provide default values for any pathnames not defined in config.h.
 *
 * This file is meant primarily as documentation, not something that
 * should be changed to match site-specific needs (use config.h for that).
 */

#ifndef TMPDIR
#ifdef MM_PANIX
#define TMPDIR		"/var/tmp"
#else
#define TMPDIR		"/usr/tmp"
#endif /* MM_PANIX */
#endif /* TMPDIR */

#ifndef SPOOL_DIRECTORY
#ifdef MM_PANIX
#define SPOOL_DIRECTORY	"/var/mail"
#else
#define SPOOL_DIRECTORY	"/usr/spool/mail"
#endif /* MM_PANIX */
#endif

#ifndef EDITOR
#define EDITOR		"emacs"
#endif
#ifndef PAGER
#define PAGER		"more"
#endif
#ifndef SPELLER
#define SPELLER		"ispell"
#endif

#ifndef BUGSTO
#define BUGSTO		"bug-mm"
#endif

#ifndef LIBDIR
#ifdef MM_PANIX
#define LIBDIR		"/pkg/mm-0.91p1/libdata/mm-0.91"
#else
#define LIBDIR		"/usr/local/lib/mm"
#endif /* MM_PANIX */
#endif /* LIBDIR */

#ifndef SYSINIT
#ifdef MM_PANIX
#define SYSINIT		"/pkg/mm-0.91p1/libdata/mm-0.91/mm.conf"
#else
#define SYSINIT		"/usr/local/lib/mm/mm.conf"
#endif /* MM_PANIX */
#endif /* SYSINIT */

#ifndef HELPFILE
#ifdef MM_PANIX
#define HELPFILE	"/pkg/mm-0.91p1/libdata/mm-0.91/mm.help"
#else
#define HELPFILE	"/usr/local/lib/mm/mm.help"
#endif /* MM_PANIX */
#endif /* HELPFILE */

#ifndef HELPDIR
#ifdef MM_PANIX
#define HELPDIR		"/pkg/mm-0.91p1/libdata/mm-0.91/help"
#else
#define HELPDIR		"/usr/local/lib/mm/help"
#endif /* MM_PANIX */
#endif /* HELPDIR */

#ifndef MMAIL_PATH
#ifdef MM_PANIX
#define MMAIL_PATH	"/pkg/mm-0.91p1/libdata/mm-0.91/mmail.el"
#else
#define MMAIL_PATH	"/usr/local/lib/mm/mmail.el"
#endif /* MM_PANIX */
#endif /* MMAIL_PATH */

#ifndef MOVEMAIL
#ifdef MM_PANIX
#define MOVEMAIL	"/usr/local/bin/mdmovemail"
#else
#define MOVEMAIL	"/usr/local/lib/mm/movemail"
#endif /* MM_PANIX */
#endif /* MOVEMAIL */

#ifdef USAGE
#ifndef USAGEFILE
#ifdef MM_PANIX
#define USAGEFILE	"/pkg/mm-0.91p1/libdata/mm-0.91/usage.log"
#else
#define USAGEFILE	"/usr/local/lib/mm/usage.log"
#endif /* MM_PANIX */
#endif /* USAGEFILE */
#endif /* USAGE */

#endif /* PATHNAMES_H_ */
