#include "args.h"
#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/mh.c,v 1.1 2005/05/28 22:27:52 beebe Exp $";
#endif

/* mh.c: routines to handle mh type mail files */

#include "mm.h"

int
#if HAVE_STDC
mh_open (msgvec *mail)
#else /* K&R style */
mh_open (mail)
msgvec *mail;
#endif /* HAVE_STDC */
{
    printf ("mh format not supported yet\n");
    return(false);			/* let them know we failed */
}

int
#if HAVE_STDC
mh_probe (const char *file)
#else /* K&R style */
mh_probe (file)
const char *file;
#endif /* HAVE_STDC */
{
    return (false);
}
/* things to be done */

int
#if HAVE_STDC
mh_close (FILE *fp)
#else /* K&R style */
mh_close (fp)
FILE *fp;
#endif /* HAVE_STDC */
{
    return(false);			/* let them know we failed */
}

int
#if HAVE_STDC
mh_rdmsg (void) {
#else /* K&R style */
mh_rdmsg (VOID) {
#endif /* HAVE_STDC */
    return(false);			/* let them know we failed */
}

int
#if HAVE_STDC
mh_wrmsg (void) {
#else /* K&R style */
mh_wrmsg (VOID) {
#endif /* HAVE_STDC */
    return(false);			/* let them know we failed */
}
