#ifndef MESSAGE_H_
#define MESSAGE_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *msg_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/message.h,v 1.1 2005/05/28 22:27:51 beebe Exp $";
#endif
#endif /* RCSID */

/*
 * Header types
 */

#define TO		1
#define CC		2
#define BCC		3
#define FROM		4
#define DATE		5
#define SUBJECT		6
#define REPLY_TO	7
#define IN_REPLY_TO	8
#define RESENT_TO	9
#define RESENT_DATE	10
#define RESENT_FROM	11
#define SENDER		12
#define REFERENCES	13
#define COMMENTS	14
#define MESSAGE_ID	15
#define KEYWORDS	16
#define ENCRYPTED	17
#define RECEIVED	18
#define USER_HEADERS	19
#define FCC		20
#define MIME_VERSION    21
#define CONTENT_TYPE    22
#define TRANSFER_ENCODING 23

/*
 * header flags
 */
#define HEAD_KNOWN 0x0001
#define HEAD_UNKNOWN 0x0002

typedef struct s_headers {		/* define a message header */
    int type;				/* type of header */
    int flags;				/* info about the header. */
    char *name;				/* name of the header */
    struct s_headers *next;		/* next header */
/* ******* the following should be made a union at some point, but the names
   ******* are too general to make into #defines right now.
*/
    addresslist *address;		/* address if an address field */
    keylist keys;			/* place to hold a bunch of strings */
    char *string;			/* or just a string otherwise */
} headers;

typedef struct mail_msg {
    headers *hdrs;			/* list of unordered headers */
    headers *last;
    char *body;				/* text of the message */
    headers *to;			/* list of known headers for */
    headers *cc;			/* reference and easy lookup */
    headers *bcc;
    headers *fcc;
    headers *from;
    headers *date;
    headers *subject;
    headers *reply_to;
    headers *in_reply_to;
    headers *resent_to;
    headers *resent_date;
    headers *resent_from;
    headers *sender;
    headers *references;
    headers *comments;
    headers *message_id;
    headers *keywords;
    headers *encrypted;
    headers *received;
    headers *content_type;
    headers *mime_version;
    headers *transfer_encoding;
} mail_msg;

extern headers *new_header ARGS((int type_, const char *name_, int flags_,
	 mail_msg *current_));
#define getmsg Getmsg		/* avoid conflict with Sun library routine */
extern int getmsg ARGS((mail_msg *outg_));
extern int sendmail ARGS((mail_msg *m_));
extern mail_msg *get_outgoing ARGS((void));
extern mail_msg *parse_msg ARGS((message *msg_));
extern void display_header ARGS((FILE *pipe__, mail_msg *msg_, int expand_,
	 int smail_));
extern void display_text ARGS((FILE *pipe_, mail_msg *msg_));
extern void files_to_fcc ARGS((addresslist *from_, mail_msg *tomsg_));
extern void free_header ARGS((mail_msg *msg_, int type_));
extern void free_msg ARGS((mail_msg *msg_));
extern void send_mode ARGS((mail_msg *msg_));
extern void set_outgoing ARGS((mail_msg *m_));
extern void set_send_defaults ARGS((mail_msg *msg_));
extern void write_addresses ARGS((FILE *tfp_, headers *h_, int expand_));

#endif /* MESSAGE_H_ */
