#include "config.h"
/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if !defined(HAVE_GNU_LINUX)

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)setenv.c	5.2 (Berkeley) 6/27/88";
#endif /* LIBC_SCCS and not lint */

#include "args.h"
#include <sys/types.h>
#include <stdio.h>

#if HAVE_STDC
#include <stdlib.h>
#include <string.h>
#undef bcopy
/* Using memmove here because memcpy doesn't usually handle overlapping
   memory copies */
/* #define bcopy(a,b,c)	memcpy((b),(a),c) */
#define bcopy(a,b,c)	memmove((b),(a),c)
#else
extern char *malloc ARGS((size_t));
extern char *realloc ARGS((void *, size_t));
#endif

#if defined(__sgi)
#define environ _environ /* environ unavailable in SGI Std C: environ_ is  */
#endif

extern char *_findenv ARGS((const char *name, int *offset));
extern char **environ;

int setenv ARGS((const char *name, const char *value, int rewrite));

#ifndef __NetBSD__
void unsetenv ARGS((const char *name));
#endif /* __NetBSD__ */
/*
 * setenv --
 *	Set the value of the environmental variable "name" to be
 *	"value".  If rewrite is set, replace any current value.
 */
int
#if HAVE_STDC
setenv(register const char *name, register const char *value, int rewrite)
#else /* K&R style */
setenv(name, value, rewrite)
	register const char *name;
	register const char *value;
	int rewrite;
#endif /* HAVE_STDC */
{
	static int alloced;			/* if allocated space before */
	register char *C;
	register const char *CC;
	int l_value, offset;

	if (*value == '=')			/* no `=' in value */
		++value;
	l_value = strlen(value);
	if ((C = _findenv(name, &offset))) {	/* find if already exists */
		if (!rewrite)
			return(0);
		if ((int)strlen(C) >= l_value) { /* old larger; copy over */
			while (*C++ = *value++);
			return(0);
		}
	}
	else {					/* create new slot */
		register int	cnt;
		register char	**P;

		for (P = environ, cnt = 0; *P; ++P, ++cnt);
		if (alloced) {			/* just increase size */
			environ = (char **)realloc((char *)environ,
			    (u_int)(sizeof(char *) * (cnt + 2)));
			if (!environ)
				return(-1);
		}
		else {				/* get new space */
			alloced = 1;		/* copy old entries into it */
			P = (char **)malloc((u_int)(sizeof(char *) *
			    (cnt + 2)));
			if (!P)
				return(-1);
			bcopy(environ, P, cnt * sizeof(char *));
			environ = P;
		}
		environ[cnt + 1] = NULL;
		offset = cnt;
	}
	for (CC = name; *CC && *CC != '='; ++CC); /* no `=' in name */
	if (!(environ[offset] =			/* name + `=' + value */
	    (char*)malloc((u_int)((int)(CC - name) + l_value + 2))))
		return(-1);
	for (C = environ[offset]; ((*C = *name++, *C)) && (*C != '='); ++C);
	for (*C++ = '='; *C++ = *value++;);
	return(0);
}

#ifndef __NetBSD__
/*
 * unsetenv(name) --
 *	Delete environmental variable "name".
 */
void
#if HAVE_STDC
unsetenv(const char *name)
#else /* K&R style */
unsetenv(name)
	const char	*name;
#endif /* HAVE_STDC */
{
	register char	**P;
	int	offset;

	while (_findenv(name, &offset))		/* if set multiple times */
		for (P = &environ[offset];; ++P)
			if (!(*P = *(P + 1)))
				break;
}
#endif /* __NetBSD__ */

#endif /* !defined(HAVE_GNU_LINUX) */
