#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

 Author: Howie Kaye
*/


/*
 * cmchar
 *
 * This module contains a parse for a single character.
 * it is trivial.  May be used when a single character of input is
 * required.
 */

#define	CHARERR				/* char error table allocated here */

#include "ccmdlib.h"			/* get standard symbols */
#include "cmfncs.h"			/* and internal symbols */

/*
 * forward declare parse functions.
 */
PASSEDSTATIC int char_cplt ARGS((char *text, int textlen, fdb *fdbp,
	 int full, const char **cplt, int *cpltlen));
PASSEDSTATIC int char_help ARGS((char *text, int textlen, fdb *fdbp,
	 int cust, int lines));
PASSEDSTATIC int char_parse ARGS((char *text, int textlen, fdb *fdbp,
	 int *parselen, pval *value));

#define charbrk  cmallbk		/* break on everything. */

ftspec ft_char = { char_parse, char_help, char_cplt, 0, &charbrk };

/*
 * char_parse:
 * parse a single character.
 */
PASSEDSTATIC int
#if HAVE_STDC
char_parse(char *text, int textlen, fdb *fdbp, int *parselen, pval *value)
#else /* K&R style */
char_parse(text, textlen, fdbp, parselen, value)
char *text;
int textlen;
fdb *fdbp;
int *parselen;
pval *value;
#endif /* HAVE_STDC */
{
  *parselen = 0;
  if (textlen < 1) return(CMxINC);	/* no data, no parse */
  *parselen = 1;
  value->_pvchr = text[0];
  return(CMxOK);
}

/*
 * give a help message
 */

PASSEDSTATIC int
#if HAVE_STDC
char_help(char *text, int textlen, fdb *fdbp, int cust, int lines)
#else /* K&R style */
char_help(text, textlen, fdbp, cust, lines)
char *text;
int textlen,cust;
fdb *fdbp;
int lines;
#endif /* HAVE_STDC */
{
  if (!cust)
    cmxputs("a character\n");	/* then print the token string */
  return(lines-1);
}

/*
 * character completion.  complete if one character
 */
PASSEDSTATIC int
#if HAVE_STDC
char_cplt(char *text, int textlen, fdb *fdbp, int full, const char **cplt, int *cpltlen)
#else /* K&R style */
char_cplt(text,textlen,fdbp,full,cplt,cpltlen)
char *text;
const char **cplt;
int textlen,full,*cpltlen;
fdb *fdbp;
#endif /* HAVE_STDC */
{
  *cplt = NULL; *cpltlen = 0;
  if (textlen == 1)
    return(CMP_GO | CMP_SPC);
  if (textlen == 0)
    return(CMP_BEL);
  else
    return(CMP_GO);
}
