#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
*/

#include <stdio.h>

#if HAVE_STDC
#include <stdlib.h>
#include <string.h>
#define index strchr
#endif

int
#if HAVE_STDC
main(int argc, char **argv)
#else /* K&R style */
main(argc,argv)
int argc;
char **argv;
#endif /* HAVE_STDC */
{
  unsigned char x[16];
  int i;
  char *bp;

  if (argc != 2)  {
    fprintf(stderr,"expecting 1 arg\n");
    exit(1);
  }
  for (i = 0; i < 16; i++) x[i] = 0xff;
  for (i = 1; i < 128; i++)
    if ((bp = (char *)index(argv[1],i), bp)) {
      printf("%c\n",*bp);
      x[i/8] &= ~(1 << (7-(i%8)));
    }
  x[0] |= 0x80;				/* don't handle nulls */
  for (i = 0; i < 16; i++) {
    if (!(i % 8)) printf("\n\t");	/* split in half */
    printf("0x");
    if (x[i] < 0x10) printf("0");
    printf("%x, ",x[i]);
  }
  printf("\n");
  return (0);
}
