/*
	$Id:$
*/

#ifndef MINAMI_H
#define MINAMI_H

#include <stdio.h>
#include <string.h>
#include "item.h"

#define FLAG_SIZE	16

/*
  YouMinamiϤΤޤޥ֥ǡˤʤ
*/

typedef struct _Inventory{
    unsigned int flag[1];
    unsigned short quan;
    unsigned short count;
} Inventory;
 
typedef struct _You{
    int scene;
    int oscene;
    char name[32];
    char friend[32];
    char nemesis[32];
    int gold;
    int hp;
    int maxhp;
    int cnt;
    int wield;
    int wear;
    int puton;
    int under;
    int shirt;
    int f_female:1;
    int f_ignore_talk:1;
    int f_nowait:1;
    int f_debug:1;
    Inventory items[64];
} You;

#define Status	You
#define status  you

typedef struct _Minami {
    unsigned int flags;	/* ѥե饰 */
    short times;	/* ٤ˬ줿 */
    short cnt;		/* ѥ */
    short cntdown;	/* ȥѥ */
    short tmpcnt;	/* ƥݥꥫ(ư0) */
} Minami;

typedef struct _SceneTab {
    int n;		/* ʥС */
    const char *sym;	/* 󥷥ܥ (for debug)*/
    const char *name;	/* ̾ */
} SceneTab;

/*
typedef struct _Termcap{
    char buf[BUFSIZ];
    char *cl;
    char *me;
    char *mr;
    char *vb;
    char *cr;
} Termcap;
*/

#define I_HAVE	(1)
#define I_DROP	(1<<1)
#define I_WEAR	(1<<2)
#define I_USE	(1<<3)
#define I_UPDATE (1<<4)

typedef struct _ActionTab{
    int scene;
    int (*action)(int, const char *, const char *);
} ActionTab;

typedef struct _VerbTab{
    const char *verb;
    int (*action)(int, const char *, const char *);
} VerbTab;

typedef struct _Monst{
    const char *name;
    int hp;
    int mp;
    unsigned int prop;
} Monst;

typedef struct _ItemTab{
	int n;
	char *name;
	char *ename;
	int flag;
	int price;
} ItemTab;

extern Minami minami[];
/*
extern Termcap termcap;
*/
extern ActionTab actionTab[];
extern VerbTab verbTab[];
extern SceneTab sceneTab[];
extern You you;
extern Monst montab[];

extern void fmtmsg(const char *, ...);
extern void rawmsg(const char *);
extern void msg(const char *);
extern void rotmsg(const char *);

extern int More();
extern int Getc();
extern int Prompt(char *, char *);

extern int NewScene(int);
extern int GetMoney(int);
extern int GetItem(int);
extern int DropItem(int);

extern int UseItem(int, int);
extern int WearItem(int, int);
extern int WearItemS(int, int);
extern int WearItemU(int, int);
extern int PutonItem(int, int);
extern int WieldItem(int, int);
extern int LostAllItem();

extern int UseMap(int, int);
extern int LookCandelabrum();

extern int Select(const char *, int);
extern int Yn(const char *);
extern int Answer(const char *, const char *);
extern int SelectItem(const char *);

extern int Battle(int, int, int, int);
extern int Battle2(int, int, int, int, int);
extern int ItemAction(int, const char *, const char *);

extern int Q_Talk(int);
extern int Q_Town(int);

extern int I_Have(int);
extern int I_Useup(int);
extern int I_Got(int);
extern int I_Wear(int);
extern int I_Use(int);

extern ItemTab *ItemByName(const char *);
extern ItemTab *ItemByNum(int);

extern void BuyItem(int);
extern void ChangeFlag(int, int, int);

#define SetFlag(s, x)	ChangeFlag(s, x, 1)
#define UnsetFlag(s, x)	ChangeFlag(s, x, 0)
#define IsSetFlag(s, x)	(minami[s].flags & (1U << (x)))

#define Item(n)		(&(you.items[n]))
#define ItemFlag(n)	(Item(n)->flag[0])
#define ItemQuan(n)	(Item(n)->quan)
#define ItemName(n)	(ItemByNum(n)->name)

extern int SceneHandler(int, const char *, const char *);
extern int CheckMove(int);

extern int DefaultAction(int, const char *, const char *, int);
extern void InitTerm();


#define MAP_n	1
#define MAP_s	(1<<1)
#define MAP_e	(1<<2)
#define MAP_w	(1<<3)
#define MAP_enter	(1<<4)
#define MAP_exit	(1<<5)
#define MAP_u		(1<<6)
#define MAP_d		(1<<7)
#define MAP_forward	(1<<8)
#define MAP_back	(1<<9)

#define EQ(a,b)		(!strcasecmp(a,b))
#define EQN(a,b,n)	(!strncasecmp(a,b,n))

#define	MIN_NG		0
#define MIN_CONT	0
#define MIN_FALSE	0
#define MIN_OK		1
#define MIN_TRUE	1
#define GAMEOVER	(-1)

#endif
