---
title: "Grafana Mimir Helm chart version 4.4 release notes"
menuTitle: "V4.4 release notes"
description: "Release notes for Grafana Mimir Helm chart version 4.4"
weight: 300
---

# Grafana Mimir Helm chart version 4.4 release notes

Grafana Labs is excited to announce version 4.4 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.8 or Grafana Enterprise Metrics (GEM) v2.8. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To learn about new features and enhancements in Grafana Mimir or GEM, see the release notes for [Grafana Mimir v2.8](/docs/mimir/v2.8.x/release-notes/v2.8/) or [Grafana Enterprise Metrics v2.8](/docs/enterprise-metrics/v2.8.x/release-notes/v2-8/).

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** If you are upgrading from a previous major version, review the changelog entry for all the major releases since then and perform the necessary migrations.

## Important changes

- Store-gateway rollout is sped up by setting unregister_on_shutdown for store-gateway to false by default.

## Features and enhancements

Notable enhancements are as follows:

- **Add support for Vault Agent**
  When enabled, the Pod annotations for TLS configurable components are updated to allow a running Vault Agent to fetch secrets from Vault and to inject them into a Pod. The annotations are updated for the following components: `admin-api`, `alertmanager`, `compactor`, `distributor`, `gateway`, `ingester`, `overrides-exporter`, `querier`, `query-frontend`, `query-scheduler`, `ruler`, `store-gateway`.
- **Default pod security context**
  Set default pod security context under `rbac.podSecurityContext` for easier install on OpenShift.
- **Configure `storageClass` per zone**
  You can now configure `storageClass` per zone for Alertmanager, StoreGateway and Ingester.
- **Allow for deploying mixin dashboards as part of the helm chart**
  If enabled, a ConfigMap will be created for each dashboard which can be used for Grafana.
- **Allow definition of multiple topology spread constraints**
  Backwards compatibility is kept by supporting the old object/dict syntax next to the new array based syntax.

## Bug fixes

- [PR 4728](https://github.com/grafana/mimir/pull/4728): Fix route to service port mapping.
- [PR 4540](https://github.com/grafana/mimir/pull/4540) Include podAnnotations on the tokengen Job.
- [PR 4573](https://github.com/grafana/mimir/pull/4573): Add http port in ingester and store-gateway headless services.
- [PR 4642](https://github.com/grafana/mimir/pull/4642) Set `gateway` and `nginx` HPA MetricTarget type to Utilization to align with usage of averageUtilization.
- [PR 4716](https://github.com/grafana/mimir/pull/4716) Add missing imagePullSecrets configuration to the `graphite-web` deployment template.
