/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "alt-str.h"


/***************************************************************************
 *  Library:
 *      #include <xtend/alt-str.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for count member in a alt_str_t structure.
 *      Use this function to set count in a alt_str_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      count is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      alt_str_ptr     Pointer to the structure to set
 *      new_count       The new value for count
 *
 *  Returns:
 *      XT_DATA_OK if the new value is acceptable and assigned
 *      XT_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      alt_str_t       alt_str;
 *      size_t          new_count;
 *
 *      if ( alt_str_set_count(&alt_str, new_count)
 *              == XT_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-04  gen-get-set Auto-generated from alt-str.h
 ***************************************************************************/

int     alt_str_set_count(alt_str_t *alt_str_ptr, size_t new_count)

{
    if ( false )
	return XT_DATA_OUT_OF_RANGE;
    else
    {
	alt_str_ptr->count = new_count;
	return XT_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/alt-str.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for strings member in a alt_str_t structure.
 *      Use this function to set strings in a alt_str_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      strings is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      alt_str_ptr     Pointer to the structure to set
 *      new_strings     The new value for strings
 *
 *  Returns:
 *      XT_DATA_OK if the new value is acceptable and assigned
 *      XT_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      alt_str_t       alt_str;
 *      char **         new_strings;
 *
 *      if ( alt_str_set_strings(&alt_str, new_strings)
 *              == XT_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-04  gen-get-set Auto-generated from alt-str.h
 ***************************************************************************/

int     alt_str_set_strings(alt_str_t *alt_str_ptr, char ** new_strings)

{
    if ( new_strings == NULL )
	return XT_DATA_OUT_OF_RANGE;
    else
    {
	alt_str_ptr->strings = new_strings;
	return XT_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/alt-str.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for an array element of strings member in a alt_str_t
 *      structure. Use this function to set alt_str_ptr->strings[c]
 *      in a alt_str_t object from non-member functions.
 *
 *  Arguments:
 *      alt_str_ptr     Pointer to the structure to set
 *      c               Subscript to the strings array
 *      new_strings_element The new value for strings[c]
 *
 *  Returns:
 *      XT_DATA_OK if the new value is acceptable and assigned
 *      XT_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      alt_str_t       alt_str;
 *      size_t          c;
 *      char **         new_strings_element;
 *
 *      if ( alt_str_set_strings_ae(&alt_str, c, new_strings_element)
 *              == XT_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      ALT_STR_SET_STRINGS_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-04  gen-get-set Auto-generated from alt-str.h
 ***************************************************************************/

int     alt_str_set_strings_ae(alt_str_t *alt_str_ptr, size_t c, char * new_strings_element)

{
    if ( new_strings_element == NULL )
	return XT_DATA_OUT_OF_RANGE;
    else
    {
	alt_str_ptr->strings[c] = new_strings_element;
	return XT_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/alt-str.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for strings member in a alt_str_t structure.
 *      Use this function to set strings in a alt_str_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_strings to alt_str_ptr->strings.
 *
 *  Arguments:
 *      alt_str_ptr     Pointer to the structure to set
 *      new_strings     The new value for strings
 *      array_size      Size of the strings array.
 *
 *  Returns:
 *      XT_DATA_OK if the new value is acceptable and assigned
 *      XT_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      alt_str_t       alt_str;
 *      char **         new_strings;
 *      size_t          array_size;
 *
 *      if ( alt_str_set_strings_cpy(&alt_str, new_strings, array_size)
 *              == XT_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      ALT_STR_SET_STRINGS(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-04-04  gen-get-set Auto-generated from alt-str.h
 ***************************************************************************/

int     alt_str_set_strings_cpy(alt_str_t *alt_str_ptr, char ** new_strings, size_t array_size)

{
    if ( new_strings == NULL )
	return XT_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    alt_str_ptr->strings[c] = new_strings[c];
	return XT_DATA_OK;
    }
}
