.TH mcwm 1 "Apr 30, 2012" "" ""
.SH NAME
mcwm \- MC's Window Manager for X11.
.SH SYNOPSIS
.B mcwm
[ 
.B \-b 
width ] 
[ 
.B \-i
]
[ 
.B \-t 
.I terminal-program
] [ 
.B \-f 
.I colour
] [ 
.B \-u 
.I colour
] [ 
.B \-x
.I colour
]

.SH DESCRIPTION
.B mcwm\fP is a window manager for the X Window System.

.SH OPTIONS
.PP
\-b width sets border width to this many pixels.
.PP
\-i turns on icons/hidden windows. 
.B Please note
that there is no way from mcwm to get a hidden window back! You have
to use an external program such as a panel or the mcicon or 9icon
scripts (see below) to get the window mapped again.
.PP
\-t urxvt will start urxvt when MODKEY + Return is pressed. Change to
your prefered terminal program or something else entirely.
.PP
\-f colour sets border colour for focused window to a named colour,
such as "red".
.PP
\-u colour sets border colour for unfocused windows.
.PP
\-x colour sets border colour for fixed windows, that is, windows that
are visible on all workspaces.

.SH USE
Nota bene: For mcwm to be at all useful you need to know how what keys
generate the Mod1 and Mod4 modifier masks (default). If you don't
know, use
.B xmodmap(1)
with the \-pm option to list them. If you don't want to use Mod1 and
Mod4, you can change the modifiers in the file config.h and recompile.

With the the default configuration, use mcwm like this.
.PP
Mod1 + mouse buttons:
.RS
.IP \(bu 2
.B 1
move
.IP \(bu 2
.B 2
raise or lower
.IP \(bu 2
.B 3
resize window
.RE
.PP
Note that the mouse cursor needs to be inside the window you want to
move, raise/lower or resize even if it currently has the focus. This
is a feature, not a bug.
.PP
Mod4 + key on focused window:
.RS
.IP \(bu 2
.B r 
raise or lower (toggles).
.IP \(bu 2
.B x 
maximize (toggles).
.IP \(bu 2
.B m 
maximize vertically (toggles).
.IP \(bu 2
.B H 
resize left.
.IP \(bu 2
.B J 
resize down.
.IP \(bu 2
.B K 
resize up.
.IP \(bu 2
.B L
resize right.
.IP \(bu 2
.B h 
move left.
.IP \(bu 2
.B j 
move down.
.IP \(bu 2
.B k 
move up.
.IP \(bu 2
.B l 
move right.
.IP \(bu 2
.B y
move to upper left corner of monitor.
.IP \(bu 2
.B u
move  to upper right corner of monitor.
.IP \(bu 2
.B b
move to lower left corner of monitor.
.IP \(bu 2
.B n
move to lower right corner of monitor.
.IP \(bu 2
.B Return
start terminal or whatever program you have configured with -t or in
the config.h.
.IP \(bu 2
.B Tab
go to next window in the current workspace window ring. If you release
MODKEY or press another command key mcwm will change focus to the new
window. A new press of MODKEY + Tab will bring you back to the window
where you last had focus.
.IP \(bu 2
.B Shift-Tab
go to previous window in the current workspace window ring. This is
most useful while you are tabbing: if you accidentally pressed Tab one
time too many, you can move back by pressing Shift + TAB (all the
while holding down the MODKEY).
.IP \(bu 2
.B f
fix window so it is visible on all workspaces (toggles). Note that
this is also used to move windows between workspaces: First fix the
window, change to the workspace you want, then unfix the window on the
new workspace.
.IP \(bu 2
.B i
iconify (or hide) window from the display. Only usable when mcwm has
been started with -i. Currently there is no way to get a hidden window
back. You have to use an external program such as a panel or the
mcicon or 9icon script in the mcwm distribution.
.IP \(bu 2
.B 0\-9
go to workspace n, 0-9.
.IP \(bu 2
.B c
go to previous workspace.
.IP \(bu 2
.B v
go to next workspace.
.IP \(bu 2
.B End
close window.
.IP \(bu 2
.B ,
move window to previous monitor.
.IP \(bu 2
.B .
move window to next monitor.
.RE
.PP
Note that all functions activated from the keyboard work on the
currently focused window regardless of the position of the mouse
cursor. Of course, changing workspaces has nothing to do with the
focused window.
.PP
If you don't like the default key bindings, border width, et cetera,
look in the config.h file, change and recompile. In the config.h file
you can also define mouse button actions on the root window. By
default button 3 starts the command mcmenu. You can write your own
mcmenu by using, for instance, 9menu, dmenu or ratmenu.
.SH ENVIRONMENT
.B mcwm\fP obeys the $DISPLAY variable.
.SH STARTING
Typically the window manager is started from a script, either run by
.B startx(1) 
or a login manager such as 
.B xdm(1).
.PP
If you start from the console, you need an .xinitrc file. Here's a
complete example:
.sp
.in +4
.nf
\&#! /bin/sh

# Set nice background.
xsetroot -solid grey20

# Set nice pointer cursor.
xsetroot \-cursor_name plus \-fg white \-bg black

# Load resources.
xrdb \-load ~/.Xresources

# Start window manager in the background. If it dies, X still lives.
mcwm &

# If you want to allow windows to be hidden, use this instead:
# mcwm -i &

# Start a terminal in the foreground. If this dies, X dies.
exec urxvt
.fi
.in -4
.sp
.SH SCRIPTS
You may want to define a menu program for use with mcwm (see
config.h). In the source distribution you can find an example as
mcmenu (the default menu program in config.h) in the scripts
directory.
.PP
Christian Neukirchen wrote a little script you can use to get
iconified windows mapped again if you are running mcwm in allow icons
mode (-i). You need awk, xdotool, xprop and xwininfo installed. You
can find the script as scripts/9icon.
.PP
Inspired by Christian's work I wrote a small program, hidden(1), which
is included with mcwm. You can use hidden(1) with the -c option
together with 9menu. See scripts/mcicon for an example.
.PP
You might also be interested in the following shell function that
might come in handy to give your terminal emulators good titles before
hiding them.
.sp
.in +4
.nf
# Set the title and icon name of an xterm or clone.
function title
{
    # icon name
    echo -e '\\033]1;'$1'\\007'
    # title
    echo -e '\\033]2;'$1'\\007'
}
.fi
.in -4
.sp
Use it like this:
.sp
.in +4
.nf
% title 'really descriptive title'
.fi
.in -4
.sp
.SH SEE ALSO
.B hidden(1)
.SH AUTHOR
Michael Cardell Widerkrantz <mc@hack.org>.
