/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef _SARRAY_H_
#define _SARRAY_H_

sarray_t*
sarray_new        (int (*comp)(void*, void*), void (*del)(void*));
int
sarray_size       (sarray_t* array);
void*
sarray_find       (sarray_t* array, void* item);
void
sarray_insert     (sarray_t* array, void* item);
void*
sarray_item       (sarray_t* array, int num);
void
sarray_clear      (sarray_t* array);
void
sarray_remove     (sarray_t* array, int pos);
void
sarray_remove_link(sarray_t* array, void* item);
void
sarray_destroy    (sarray_t* array);

#endif
