/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef _MTYPES_H_
#define _MTYPES_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>

// major media types
#define MEDIA_NONE          0
#define MEDIA_MP3           1
#define MEDIA_AUDIO         2
#define MEDIA_VIDEO         3
#define MEDIA_APPLICATION   4
#define MEDIA_IMAGE         5
#define MEDIA_TEXT          6
#define MEDIA_FOLDER        7
#define MEDIA_SIZE          8

typedef struct _mtype_t mtype_t;
typedef struct _suffix_t suffix_t;

struct _suffix_t {
  GList* app;
  GList* ext;
};

struct _mtype_t {
  GList* app;
  char* download;
  GList* suffix;
  int type;
};

typedef struct {
  char* app;
  char* label;
} app_t;

const char* int2media(int no, int mode);
int media2int(const char* media);

void mtype_load();
void mtype_save();
int mtype_get(char* filename);
int mtype_contains_suffix(int type, char *name);
GList* mtype_get_apps(int type, char* name);
const char* mtype_get_download(int type);

void mtype_set_download(int type, char* download);
void mtype_add_suffix(int type, char* suf, char* app, char* label);
mtype_t* mtype_find(int index);
void mtype_clear_all();
void mtype_create_media(int media, char* suffixes);

#endif
