/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef HANDLER_H_
#define HANDLER_H_

#include "lopster.h"

/** commands being sent */
#define CMD_LOGIN		   1
#define CMD_ADD_FILE		   2 // char* winname, char* md5, long size, int bitrate, int frequency, int duration
#define CMD_REMOVE_FILE		   3 // char* winname
#define CMD_UNSHARE_ALL            4 // 
#define CMD_SEARCH		   5 // char* include, char* exclude=NULL, int results=0, int mediatype=MIME_MP3, int bitrate_lo=0, int bitrate_hi=0, int freq_lo=0, int freq_hi=0, int speed_lo=0, int speed_hi=0, long size_lo=0, long size_hi=0, int duration_lo=0, int duration_hi=0
#define CMD_DOWNLOAD		   6 // char* nick, char* winname
#define CMD_PRIVMSG		   7 // char* nick, char* text
#define CMD_NOTICE		   8 // char* nick, char* text
#define CMD_ADD_HOTLIST		   9 // char* nick
#define CMD_ADD_HOTLIST_SEQ	  10 // char* nick
#define CMD_BROWSE		  11 // char* nick
#define CMD_DOWNLOAD_START	  12 //
#define CMD_DOWNLOAD_END	  13 //
#define CMD_UPLOAD_START	  14 //
#define CMD_UPLOAD_END		  15 //
#define CMD_SERVER_STATS	  16 //
#define CMD_REMOVE_HOTLIST	  17 // char* nick
#define CMD_JOIN		  18 // char* channel
#define CMD_PART		  19 // char* channel, char* reason=NULL
#define CMD_PUBLIC		  20 // char* channel, char* text
#define CMD_GET_TOPIC		  21 // char* channel
#define CMD_SET_TOPIC		  22 // char* channel, char* topic
#define CMD_CHANNEL_BAN_LIST	  23 // char* channel
#define CMD_CHAN_BAN		  24 // char* channel, char* user, char* reason=NULL
#define CMD_CHAN_UNBAN	          25 // char* channel, char* user, char* reason=NULL
#define CMD_DOWNLOAD_FIREWALL	  26 // char* username, char* winname
#define CMD_GET_USERSPEED	  27 // char* nick
#define CMD_CHAN_LIST_MUZZLE      28 // char* channel
#define CMD_WHOIS		  29 // char* nick
#define CMD_SET_USERLEVEL	  30 // char* nick, char* level
#define CMD_UPLOAD_OK		  31 // char* nick, char* winname
#define CMD_KILL		  32 // char* nick, char* reason=NULL
#define CMD_NUKE		  33 // char* nick
#define CMD_BAN			  34 // char* user, char* reason=NULL, unsigned long timeout=0
#define CMD_ALTER_PORT		  35 // char* nick, int port
#define CMD_UNBAN		  36 // char* user, char* reason=NULL
#define CMD_BANLIST		  37 //
#define CMD_UPLOAD_LIMIT          38 // char* nick, char* winname, int limit
#define CMD_MOTD		  39 // char* target
#define CMD_MUZZLE		  40 // char* nick, char* reason=NULL
#define CMD_UNMUZZLE		  41 // char* nick, char* reason=NULL
#define CMD_ALTER_SPEED		  42 // char* nick, char* speed
#define CMD_WALLOP		  43 // char* message
#define CMD_ANNOUNCE		  44 // char* message
#define CMD_BROWSE_DIRECT         45 // char* nick
#define CMD_BROWSE_DIRECT_OK      46 // char* nick
#define CMD_CLOAK		  47 //
#define CMD_CHANGE_SPEED	  48 // char* speed
#define CMD_CHANGE_PASS		  49 // char* password
#define CMD_CHANGE_EMAIL	  50 // char* email
#define CMD_CHANGE_DATA_PORT	  51 // int port
#define CMD_PING_SERVER		  52 // char* server
#define CMD_PING		  53 // char* nick
#define CMD_PONG		  54 // char* nick
#define CMD_ALTER_PASS		  55 // char* nick, char* password
#define CMD_SERVER_VERSION	  56 // char* name
#define CMD_CLEAR_CHANNEL         57 // char* channel, char* reason=NULL
#define CMD_GET_CHAN_LEVEL	  58 // char* channel
#define CMD_SET_CHAN_LEVEL	  59 // char* channel, char* level
#define CMD_UNNUKE		  60 // char* nick
#define CMD_SERVER_REHASH	  61 // char* server=NULL
#define CMD_GET_SERVER_VARS	  62 //
#define CMD_GET_SERVER_VAR	  63 // char* name
#define CMD_SET_SERVER_VAR	  64 // char* name, char* val
#define CMD_REDIRECT		  65 // char* user, char* server, int port
#define CMD_CYCLE		  66 // char* user, char* server
#define CMD_PUBLIC_EMOTE          67 // char* channel, char* text
#define CMD_GET_CHAN_LIMIT	  68 // char* channel
#define CMD_SET_CHAN_LIMIT	  69 // char* channel, int limit
#define CMD_FULL_CHANNEL_LIST	  70 //
#define CMD_KICK		  71 // char* channel, char* nick, char* reason=NULL
#define CMD_NAMES_LIST		  72 // char* channel
#define CMD_GUSER_LIST  	  73 // char* args
#define CMD_SERVER_CONNECT	  74 // char* args
#define CMD_SERVER_DISCONNECT	  75 // char* server, char* reason=NULL
#define CMD_SERVER_REMOVE         76 // char* server, char* reason=NULL
#define CMD_KILL_SERVER		  77 // char* server, char* reason=NULL
#define CMD_LINKS	          78 //
#define CMD_USAGE_STATS		  79 // char* server=NULL
#define CMD_VERSION_STATS         80 //
#define CMD_WHICH_SERVER          81 // char* nick
#define CMD_WHO_WAS               82 // char+ nick
#define CMD_MASS_KILL             83 // char* ip, char* reason=NULL
#define CMD_HISTOGRAM             84 //
#define CMD_SHISTOGRAM            85 //
#define CMD_REGISTER_USER         86 // char* user, char* passwd, char* email, char* level
#define CMD_GET_USER_MODE         87 //
#define CMD_SET_USER_MODE         88 // char* mode
#define CMD_OP                    89 // char* channel, char* nick
#define CMD_DEOP                  90 // char* channel, char* nick
#define CMD_CHAN_WALLOP           91 // char* channel, char* text
#define CMD_GET_CHAN_MODE         92 // char* channel
#define CMD_SET_CHAN_MODE         93 // char* channel, int to_set, int to_clear
#define CMD_CHAN_INVITE           94 // char* channel, char* nick
#define CMD_CHAN_VOICE            95 // char* channel, char* nick
#define CMD_CHAN_UNVOICE          96 // char* channel, char* nick
#define CMD_CHAN_MUZZLE           97 // char* channel, char* nick, char* reason=NULL
#define CMD_CHAN_UNMUZZLE         98 // char* channel, char* nick, char* reason=NULL
#define CMD_CLASS_ADD             99 // char* ip
#define CMD_CLASS_REMOVE         100 // char* ip
#define CMD_CLASS_LIST           101 //
#define CMD_DLINE_ADD            102 // char* ip
#define CMD_DLINE_REMOVE         103 // char* ip
#define CMD_DLINE_LIST           104 //
#define CMD_ILINE_ADD            105 // char* ip
#define CMD_ILINE_REMOVE         106 // char* ip
#define CMD_ILINE_LIST           107 //
#define CMD_ELINE_ADD            108 // char* ip
#define CMD_ELINE_REMOVE         109 // char* ip
#define CMD_ELINE_LIST           110 //
#define CMD_SHARE_FILE           111 // char* winname, long size, char* md5, char* mediatype
#define CMD_SERVER_RECONFIG      112 // char* var
#define CMD_LIST_OP              113 // char* channel
#define CMD_LIST_VOICE           114 // char* channel
#define CMD_CHANGE_NICK          115 // char* nick
#define CMD_RAW                  116 // char* args
#define CMD_PRIVATE_EMOTE        117 // char* nick, char* text
#define COMMAND_SIZE             118 /////////////////////////////

#define HANDLER(f) void f (net_t* net, char *data)

typedef struct {
  int code;
  HANDLER((*handler));
} HANDLER_ENTRY;

void
ext_handle(unsigned int type, const char *user, const char *data);

HANDLER(not_implemented);

#endif
