#!/bin/sh
#
# Detect the current architecture and copy the appropriate binaries in.

demo=EricsSolitaireDemo

# Get to the appropriate run directory
cd `dirname $0`

# Return the appropriate architecture string
function DetectARCH {
    status=1
    case `uname -m` in
        i?86)  echo "x86"
            status=0;;
        *)     echo "`uname -m`"
            status=0;;
    esac
    return $status
}

# Return the appropriate version string
function DetectLIBC {
      status=1
      if [ -f `echo /lib/libc.so.6* | tail -1` ]; then
          if fgrep GLIBC_2.1 /lib/libc.so.6* 2>&1 >/dev/null; then
              echo "glibc-2.1"
              status=0
          else    
              echo "glibc-2.0"
              status=0
          fi        
      elif [ -f /lib/libc.so.5 ]; then
          echo "libc5"
          status=0
      else
          echo "unknown"
      fi
      return $status
}

# Detect the Linux environment
arch=`DetectARCH`
libc=`DetectLIBC`

# See if it is supported by this demo
if [ -f "bin/$arch/$libc/$demo" ]; then

    # Detect whether or not the required libs are present
    if bin/$arch/$libc/$demo.check-dynamic.sh; then
        cp -rp "bin/$arch/$libc"/$demo.dynamic . || exit 1
        mv $demo.dynamic eus
    else
        cp -rp "bin/$arch/$libc"/$demo . || exit 1
        mv $demo eus
    fi

    # Presumeably, the copy overwrote this script,
    # so we can silently start the game
    if [ -f "bin/$arch/$libc/$demo" ]; then
        exec $0
    fi
else
    if [ -d "bin/$arch" ]; then
        echo "This demo does not support $libc on $arch"
    else
        echo "This demo does not support $arch architecture"
    fi
    exit 1
fi
