; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=aarch64-pc-windows-msvc19 -verify-machineinstrs %s -o - | FileCheck %s
; RUN: llc -mtriple=aarch64-pc-windows-msvc19 -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - | FileCheck %s

define double @powi_f64(double %a, i32 %b) {
; CHECK-LABEL: powi_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf d1, w0
; CHECK-NEXT:    b pow
entry:
  %c = call double @llvm.powi.f64.i32(double %a, i32 %b)
  ret double %c
}

define float @powi_f32(float %a, i32 %b) {
; CHECK-LABEL: powi_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf s1, w0
; CHECK-NEXT:    b powf
entry:
  %c = call float @llvm.powi.f32.i32(float %a, i32 %b)
  ret float %c
}

define half @powi_f16(half %a, i32 %b) {
; CHECK-LABEL: powi_f16:
; CHECK:       .seh_proc powi_f16
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg_x x30, 16
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    scvtf s1, w0
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg_x x30, 16
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %c = call half @llvm.powi.f16.i32(half %a, i32 %b)
  ret half %c
}

define <2 x double> @powi_v2f64(<2 x double> %a, i32 %b) {
; CHECK-LABEL: powi_v2f64:
; CHECK:       .seh_proc powi_v2f64
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    .seh_stackalloc 48
; CHECK-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 32
; CHECK-NEXT:    str d8, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_freg d8, 40
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    scvtf d8, w0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    fmov d1, d8
; CHECK-NEXT:    bl pow
; CHECK-NEXT:    fmov d1, d8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl pow
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr d8, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_freg d8, 40
; CHECK-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 32
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    .seh_stackalloc 48
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %c = call <2 x double> @llvm.powi.v2f64.i32(<2 x double> %a, i32 %b)
  ret <2 x double> %c
}

define <2 x float> @powi_v2f32(<2 x float> %a, i32 %b) {
; CHECK-LABEL: powi_v2f32:
; CHECK:       .seh_proc powi_v2f32
; CHECK-NEXT:  // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    .seh_stackalloc 48
; CHECK-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_reg x30, 32
; CHECK-NEXT:    str d8, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    .seh_save_freg d8, 40
; CHECK-NEXT:    .seh_endprologue
; CHECK-NEXT:    scvtf s8, w0
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    fmov s1, s8
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    fmov s1, s8
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    .seh_startepilogue
; CHECK-NEXT:    ldr d8, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_freg d8, 40
; CHECK-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-NEXT:    .seh_save_reg x30, 32
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    .seh_stackalloc 48
; CHECK-NEXT:    .seh_endepilogue
; CHECK-NEXT:    ret
; CHECK-NEXT:    .seh_endfunclet
; CHECK-NEXT:    .seh_endproc
entry:
  %c = call <2 x float> @llvm.powi.v2f32.i32(<2 x float> %a, i32 %b)
  ret <2 x float> %c
}

declare <2 x double> @llvm.powi.v2f64.i32(<2 x double>, i32)
declare <2 x float> @llvm.powi.v2f32.i32(<2 x float>, i32)
declare double @llvm.powi.f64.i32(double, i32)
declare float @llvm.powi.f32.i32(float, i32)
declare half @llvm.powi.f16.i32(half, i32)
