/* glibextra.h -- glib extension for linda
   Copyright (C) 2002 Masatake YAMATO <jet@gyve.org>

   This file is part of linda.

   linda is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   linda is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with linda; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef GLIBEXTRA_H
#define GLIBEXTRA_H 

#include <glib.h>

typedef  gint (* GIntFunc)  (gpointer data, gpointer user_data);

/** 
    g_slist_foreach_with_break
    Almost same as g_slist_foreach except the foreach loop is stopped
    if FUNC returns non zero value.
    g_slist_foreach_with_break itself returns 0 if the foreach loop is
    completed or non zero value that is returned by FUNC. */
gint     g_slist_foreach_with_break        (GSList           *list,
					    GIntFunc          func,
					    gpointer          user_data);

void g_func_func1_to_func0            (gpointer data, gpointer gfunc0);

#endif /* Not def: GLIBEXTRA_H */
