/* glibextra.c -- glib extension for linda
   Copyright (C) 2002 Masatake YAMATO <jet@gyve.org>

   This file is part of linda.

   linda is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   linda is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with linda; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "glibextra.h"

gint
g_slist_foreach_with_break (GSList   *list,
			    GIntFunc     func,
			    gpointer  user_data)
{
  gint result;
  while (list)
    {
      GSList *next = list->next;
      result 	   = (*func) (list->data, user_data);
      if (result)
	break;
      list = next;
    }
  return result;
}

typedef void (*GFunc0)           (gpointer data);
void
g_func_func1_to_func0            (gpointer data, gpointer gfunc0)
{
  ((GFunc0)gfunc0)(data);
}
