/* timeout.c --- linda_*_timed test
   Copyright (C) 2002 Masatake YAMATO

   This file is part of linda.

   linda is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   linda is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with linda; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <linda.h>

#define MAGICK_NUM 94

void func (void);

int
main(int argc, char ** argv)
{
  int i = 27, j, k;
  linda_init(NULL);
  
  linda_spawn(func);
  sleep (5);
  linda_out("%s%d", "a", i);
  linda_in ("%s?d", "b", &j);
  linda_in ("%s?d", "a", &k);
  linda_end();

  if (j == MAGICK_NUM && i == k)
    return 0;
  else
    return 1;
} 

void
func (void)
{
  GTimeVal t;
  gint i, j;
  
  for (j = 0; j < 10; j++)
    {
      g_get_current_time(&t);

      g_time_val_add(&t, 1000000);
      if (linda_rdp_timed(&t, "%s?d", "a", &i))
	{
 	  linda_out("%s%d", "b", MAGICK_NUM); 
 	  return;
 	}
    }
  linda_out("%s%d", "b", MAGICK_NUM + 1);
}
