/* timeout.c --- linda_*_timed test
   Copyright (C) 2002 Masatake YAMATO

   This file is part of linda.

   linda is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   linda is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with linda; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <linda.h>
#define LOOP 3

void func (void);

int
main(int argc, char ** argv)
{
  GTimeVal t;
  int i = 4, j, n, J;
  linda_init(NULL);
  
  for (n = 0; n < LOOP; n++)
    linda_spawn(func);

  sleep(5);
  
  linda_out("%s%d", "a", i);

  J = 0;
  for (n = 0; n < LOOP; n++)
    {
      g_get_current_time(&t);
      g_time_val_add(&t, 3000000);
      if (!linda_inp_timed(&t, "%s?d", "b", &j))
	return 1;
      J += j;
    }
  if (J == LOOP*i)
    return 0;
  else
    return 1;
} 

void
func (void)
{
  int i;
  linda_rd("%s?d", "a", &i);
  linda_out("%s%d", "b", i);
}
