/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include "string.h"         // strlcpy() on Linux
#include "fast-file-private.h"


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for buff member in a xt_ff_t structure.
 *      Use this function to set buff in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      buff is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_buff        The new value for buff
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      unsigned char * new_buff;
 *
 *      if ( xt_ff_set_buff(&xt_ffile, new_buff)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_buff(xt_ff_t *xt_ff_ptr, unsigned char * new_buff)

{
    if ( new_buff == NULL )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->buff = new_buff;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for an array element of buff member in a xt_ff_t
 *      structure. Use this function to set xt_ff_ptr->buff[c]
 *      in a xt_ff_t object from non-member functions.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      c               Subscript to the buff array
 *      new_buff_element The new value for buff[c]
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      size_t          c;
 *      unsigned char * new_buff_element;
 *
 *      if ( xt_ff_set_buff_ae(&xt_ffile, c, new_buff_element)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      XT_FFILE_SET_BUFF_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_buff_ae(xt_ff_t *xt_ff_ptr, size_t c, unsigned char  new_buff_element)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->buff[c] = new_buff_element;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for buff member in a xt_ff_t structure.
 *      Use this function to set buff in a xt_ff_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_buff to xt_ff_ptr->buff.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_buff        The new value for buff
 *      array_size      Size of the buff array.
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      unsigned char * new_buff;
 *      size_t          array_size;
 *
 *      if ( xt_ff_set_buff_cpy(&xt_ffile, new_buff, array_size)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      XT_FFILE_SET_BUFF(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_buff_cpy(xt_ff_t *xt_ff_ptr, unsigned char * new_buff, size_t array_size)

{
    if ( new_buff == NULL )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    xt_ff_ptr->buff[c] = new_buff[c];
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for start_ptr member in a xt_ff_t structure.
 *      Use this function to set start_ptr in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      start_ptr is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_start_ptr   The new value for start_ptr
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      unsigned char * new_start_ptr;
 *
 *      if ( xt_ff_set_start_ptr(&xt_ffile, new_start_ptr)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_start_ptr(xt_ff_t *xt_ff_ptr, unsigned char * new_start_ptr)

{
    if ( new_start_ptr == NULL )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->start_ptr = new_start_ptr;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for an array element of start_ptr member in a xt_ff_t
 *      structure. Use this function to set xt_ff_ptr->start_ptr[c]
 *      in a xt_ff_t object from non-member functions.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      c               Subscript to the start_ptr array
 *      new_start_ptr_element The new value for start_ptr[c]
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      size_t          c;
 *      unsigned char * new_start_ptr_element;
 *
 *      if ( xt_ff_set_start_ptr_ae(&xt_ffile, c, new_start_ptr_element)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      XT_FFILE_SET_START_PTR_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_start_ptr_ae(xt_ff_t *xt_ff_ptr, size_t c, unsigned char  new_start_ptr_element)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->start_ptr[c] = new_start_ptr_element;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for start_ptr member in a xt_ff_t structure.
 *      Use this function to set start_ptr in a xt_ff_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_start_ptr to xt_ff_ptr->start_ptr.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_start_ptr   The new value for start_ptr
 *      array_size      Size of the start_ptr array.
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      unsigned char * new_start_ptr;
 *      size_t          array_size;
 *
 *      if ( xt_ff_set_start_ptr_cpy(&xt_ffile, new_start_ptr, array_size)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      XT_FFILE_SET_START_PTR(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_start_ptr_cpy(xt_ff_t *xt_ff_ptr, unsigned char * new_start_ptr, size_t array_size)

{
    if ( new_start_ptr == NULL )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	size_t  c;
	
	// FIXME: Assuming all elements should be copied
	for (c = 0; c < array_size; ++c)
	    xt_ff_ptr->start_ptr[c] = new_start_ptr[c];
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for bytes_read member in a xt_ff_t structure.
 *      Use this function to set bytes_read in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      bytes_read is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_bytes_read  The new value for bytes_read
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      ssize_t         new_bytes_read;
 *
 *      if ( xt_ff_set_bytes_read(&xt_ffile, new_bytes_read)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_bytes_read(xt_ff_t *xt_ff_ptr, ssize_t new_bytes_read)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->bytes_read = new_bytes_read;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for buff_index member in a xt_ff_t structure.
 *      Use this function to set buff_index in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      buff_index is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_buff_index  The new value for buff_index
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      ssize_t         new_buff_index;
 *
 *      if ( xt_ff_set_buff_index(&xt_ffile, new_buff_index)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_buff_index(xt_ff_t *xt_ff_ptr, ssize_t new_buff_index)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->buff_index = new_buff_index;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for disk_block_size member in a xt_ff_t structure.
 *      Use this function to set disk_block_size in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      disk_block_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_disk_block_size The new value for disk_block_size
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      ssize_t         new_disk_block_size;
 *
 *      if ( xt_ff_set_disk_block_size(&xt_ffile, new_disk_block_size)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_disk_block_size(xt_ff_t *xt_ff_ptr, ssize_t new_disk_block_size)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->disk_block_size = new_disk_block_size;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for buff_size member in a xt_ff_t structure.
 *      Use this function to set buff_size in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      buff_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_buff_size   The new value for buff_size
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      ssize_t         new_buff_size;
 *
 *      if ( xt_ff_set_buff_size(&xt_ffile, new_buff_size)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_buff_size(xt_ff_t *xt_ff_ptr, ssize_t new_buff_size)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->buff_size = new_buff_size;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for fd member in a xt_ff_t structure.
 *      Use this function to set fd in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      fd is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_fd          The new value for fd
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      int             new_fd;
 *
 *      if ( xt_ff_set_fd(&xt_ffile, new_fd)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_fd(xt_ff_t *xt_ff_ptr, int new_fd)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->fd = new_fd;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for flags member in a xt_ff_t structure.
 *      Use this function to set flags in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      flags is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_flags       The new value for flags
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      int             new_flags;
 *
 *      if ( xt_ff_set_flags(&xt_ffile, new_flags)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_flags(xt_ff_t *xt_ff_ptr, int new_flags)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->flags = new_flags;
	return EXTEND_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <xtend/fast-file.h>
 *      -lxtend
 *
 *  Description:
 *      Mutator for child_pid member in a xt_ff_t structure.
 *      Use this function to set child_pid in a xt_ff_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      child_pid is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      xt_ff_ptr    Pointer to the structure to set
 *      new_child_pid   The new value for child_pid
 *
 *  Returns:
 *      EXTEND_DATA_OK if the new value is acceptable and assigned
 *      EXTEND_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      xt_ff_t      xt_ffile;
 *      pid_t           new_child_pid;
 *
 *      if ( xt_ff_set_child_pid(&xt_ffile, new_child_pid)
 *              == EXTEND_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2023-08-29  gen-get-set Auto-generated from fast-file-private.h
 ***************************************************************************/

int     xt_ff_set_child_pid(xt_ff_t *xt_ff_ptr, pid_t new_child_pid)

{
    if ( false )
	return EXTEND_DATA_OUT_OF_RANGE;
    else
    {
	xt_ff_ptr->child_pid = new_child_pid;
	return EXTEND_DATA_OK;
    }
}
