/*
 * Ostatnia aktualizacja:
 *
 * - $Id: testclient.c,v 1.40 2004/01/23 18:04:56 mati Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <signal.h>

/*
 * Doczamy nagwek libtlen.h w ktrym zawarte s wszystkie 
 * informacje o zdarzeniach, funkcjach, strukturach itp. Bez
 * tego ani rusz!
 *
 */

#include "libtlen.h"

/*
 * Zmienna suca do zamknicia klienta - obsugiwana w handlerze
 * dla wcinicia CTRL+C
 *
 */

int terminate=0;

/*
 * Zmienna klienta informujca kiedy by ostatni ping do serwera - 
 * w tym przypadku potrzebna, eby pinga tylko co 60 sekund.
 *
 */

int last_ping_time;

/*
 * Wewntrzny handler klienta ustawiajcy zmienn na 1 - wywoywany
 * podczas CTRL+C
 *
 */

void termhandler(int sig)
{
    terminate=1;
}

/*
 * Gowna funkcja programu - tutaj bdzie michanie z tlenem
 *
 */

int main (int argc, char **argv)
{

	/*
	 * Definiujemy struktur typu tlen_session opisujc wszystko
	 * co z naszym tlenowym poczeniem zwizane. Przechowuje ona
	 * gniazda, zdarzenia i inne potrzebne rzeczy
	 * 
	 */
	
	struct tlen_session *sesja;
	
	/*
	 * Struktura typu tlen_event suy do przechowywania informacji
	 * o zdarzeniach - do niej bd pobierane zdarzenia w gwnej
	 * ptli tlenowej.
	 * 
	 */
	
	struct tlen_event *event;
	
	/*
	 * Struktura nie zwizana z libtlen - potrzebna przy takim a nie
	 * innym rozwizaniu monitorowania gniazda - okrela timeout.
	 *
	 */
	
	struct timeval tv;

        /*
	 * czymy SIGINT (Ctrl+C) z naszym handlerem (termhandler),
	 * pozwoli to na poprawne zamknicie poczenia - tzn. jego
	 * obsuenie, zamiast twardego wyjcia z programu
	 * 
	 */
	
	signal(SIGINT,termhandler);

	/*
	 * Funkcja biblioteki, pozwalajca na sterowanie informacjami
	 * dodatkowymi (debug). Ustawiajc jej parametr 1 wczamy debugowanie,
	 * od tej pory biblioteka bdzie wypluwaa na stderr wszystkie
	 * informacje pomocnicze.
	 * 
	 */
	
	tlen_setdebug(1);
	
	/*
	 * Sprawdzamy, czy liczba parametrw przekazanych do programu
	 * jest rwna 2 - uytkownik i haso (+1, gdy pierwszym z nich
	 * jest sama nazwa programu, ktrej my nie przekazujemy).
	 *
	 */
	
	if (argc>=3) { 

		/*
		 * Inicjujemy sesj przy uyciu funkcji tlen_init()
		 *
		 */

		sesja = tlen_init();

		/*
		 * Przy uyciu funkcji tlen_set_auth() przekazujemy 
		 * do biblioteki nazw uytkownika i haso
		 *
		 */

		tlen_set_auth(sesja,argv[1],argv[2]);
		
		/*
		 * Funkcja tlen_set_hub_blocking() ustawia, czy proces
		 * czenia z HUBem ma by synchroniczny, czy asynchroniczny
		 * (blokowalny/nieblokowalny) - ustawiamy asynchroniczno.
		 * 
		 */
		
		tlen_set_hub_blocking(sesja,0);

		/*
		 * tlen_login() inicjuje poczenie z serwerem Tlenu. Najpierw
		 * czy si z hubem, nastpnie pobiera adres serwera i si
		 * z nim czy. Pobranie ID oraz autoryzacja nastpuj automagicznie.
		 *
		 */
		
		tlen_login(sesja);
	} else {
		printf("Usage: %s login password\n",argv[0]);
		return 1;
        }
	
	/*
	 * Punkt kulminacyjny klienta - gwna ptla obsugi zdarze
	 *
	 */

	while ((!terminate)&&(!sesja->error))
	{
		/*
		 * zmienne potrzebne do poprawnego sterowania obserwacj gniazda
		 *
		 */
		
		fd_set rd, wr;
		int retval;

		/*
		 * Ustawiamy timeout dla serwera na 60 sekund
		 *
		 */
		
		tv.tv_sec = 60;
		tv.tv_usec = 0;

		/*
		 * Zerujemy deskryptory
		 *
		 */
		
		FD_ZERO (&rd);
		FD_ZERO (&wr);

		/*
		 * Wchodzi kawaek obsugi biblioteki - jeeli libtlen
		 * prosi nas o monitorowanie kanau przychodzcego, to
		 * ustawiamy RD, za jeeli kanau wychodzcego to WR.
		 * Kana wychodzcy przede wszystkim sprawdza, czy gniazdo
		 * nadaje si ju do zapisy, czyli czy jestemy ju
		 * poczeni
		 *
		 */
		
		if ((sesja->check & TLEN_CHECK_READ))
			FD_SET (sesja->fd, &rd);
		if ((sesja->check & TLEN_CHECK_WRITE))
			FD_SET (sesja->fd, &wr);

		/*
		 * Funkcja select - systemowa, nie zwizana z bibliotek,
		 * obserwuje deskryptor poczenia z serwerem - gniazdo znajduje
		 * si w strukturze sesji - jako sesja->fd
		 *
		 */
		
		if ((retval = select (sesja->fd + 1, &rd, &wr, NULL, &tv) == -1))
		{
			perror ("select");
			terminate = 1;
		}
		
		/*
		 * Znaleziono co w gniedzie! Obsugujemy zdarzenia.
		 *
		 */

		else if (sesja && (FD_ISSET (sesja->fd, &rd) || FD_ISSET (sesja->fd, &wr)))
		{
			/*
			 * Funkcja biblioteki - tlen_watch_fd() - sprawdza, 
			 * co si zmienio na gniedzie, odczytuje dane, a nastpnie
			 * uzupenia zdarzenia, ktre dalej bdziemy obsugiwa.
			 *
			 */
			
			tlen_watch_fd (sesja);

			/*
			 * W ptli pobieramy zdarzenia poprzez tlen_getevent
			 * do struktury typu tlen_event (ktr zadeklarowalimy
			 * na pocztku programu). Ptla obsugi zdarze wykonuje
			 * si tak dugo, a wszystkie czekajce zdarzenia
			 * zostan obsuone
			 *
			 */
			
			while ((event=tlen_getevent(sesja))!=NULL) {
			
				/*
				 * Przecznikiem switch sprawdzamy typ zdarzenia
				 *
				 */
				
				switch (event->type)
				{
					/*
					 * Dostalimy informacj, e logowanie si powiodo, moemy wic
					 * pobra z serwera ksik adresow - funkcja tlen_getroster()
					 *
					 */
					case TLEN_EVENT_AUTHORIZED:
					{
						tlen_getroster(sesja);
						break;
					}
					/*
					 * Po wywoaniu tlen_getroster bdziemy po kolei dostawa zdarzenia typu
					 * TLEN_EVENT_GOTROSTERITEM informujce o pobraniu danych jednego uytkownika.
					 * W tym programie wypisujemy je jedynie na ekran. Dane uytkownika zawarte
					 * s w strukturze typu tlen_user. Przy kadym zdarzeniu, w ktrym otrzymujemy
					 * jakie dane, do struktury tlen_event dodawana jest struktura danego
					 * zdarzenia - w tym wypadku ksiki adresowej.
					 *
					 */
					case TLEN_EVENT_GOTROSTERITEM:
					{
						printf("Got user: %s\n",event->roster->jid);
						break;
					}
					/*
					 * Otrzymalimy ca ksik adresow - informuje o tym zdarzenie ENDROSTER.
					 * Skoro tak, to powinnismy wysa informacj o swojej dostpnoci. Suy
					 * do tego funkcja tlen_presence pobierajca informacje o stanie - TLEN_STATUS_*
					 * oraz nasz status opisowy - jeeli aden wstawiamy "" lub NULL.
					 *
					 */
					case TLEN_EVENT_ENDROSTER:
					{
						printf("Roster received\n");
						tlen_presence(sesja,TLEN_STATUS_AVAILABLE,"Dostpny");
						break;
					}
					/*
					 * Jednym z najtrudniejszych elementw protokou tlenu/jabbera s
					 * subskrybcje. Jest to system pozwalajcy na kontrol naszej znajomoci.
					 * Generalnie - nikt nie bdzie widzia naszego stanu, jeeli nie
					 * wyrazimy na to zgody, tak samo nikt nie doda nas do ksiki adresowej
					 * jeeli nie wyrazimy na to zgody. Zdarzenie TLEN_EVENT_SUBSCRIBE
					 * mwi nam, e kto prosi o zgod na autoryzacj. Identyfikator
					 * danej osoby znajduje si w polu event->subscribe->jid. Jeeli
					 * zgadzamy si - tutaj zawsze si zgadzamy, nie jest zaimplementowana
					 * obsuga niezgadzania sie ;) - to akceptujemy prob funkcj
					 * tlen_accept_subscribe, no i eby by fair prosimy uytkownika
					 * o subskrybcj, eby te mie go w ksice - tlen_request_subscribe.
					 *
					 */
					case TLEN_EVENT_SUBSCRIBE:
					{
						tlen_accept_subscribe(sesja,event->subscribe->jid);
						tlen_request_subscribe(sesja,event->subscribe->jid);
						break;
					}
					/*
					 * "Kto" zgodzi si abymy go dodali do swojej ksiki - a wic
					 * to robimy, funkcja tlen_addcontact.
					 *
					 */
					case TLEN_EVENT_SUBSCRIBED:
					{
						tlen_addcontact(sesja,"nazwa",event->subscribe->jid,"grupa");
						break;
					}
					/*
					 * BUU - kto chce nas usun ze swojej ksiki - wi prosi abymy
					 * my rwnie go usuli - zgadzamy si na to poprzez tlen_accept_unsubscribe,
					 * i eby dobi wszystkich formalnoci prosimy o to samo - tlen_request_unsubscribe.
					 *
					 */
					case TLEN_EVENT_UNSUBSCRIBE:
					{
						tlen_accept_unsubscribe(sesja,event->subscribe->jid);
						tlen_request_unsubscribe(sesja,event->subscribe->jid);
						break;
					}
					/*
					 * "Kto" nas wanie pomylnie usun, wic my te usuwamy -
					 * tlen_removecontact
					 *
					 */
					case TLEN_EVENT_UNSUBSCRIBED:
					{
						tlen_removecontact(sesja,event->subscribe->jid);
						break;
					}
					/*
					 * Oho - przysza wiadomo! Dane wiadomoci s w strukturze event->message,
					 * podstawowymi s body - tre, oraz from - od kogo, a na szarym kocu
					 * type - typ (TLEN_CHAT albo TLEN_MESSAGE). Nasz prosty klient obsuguje
					 * wiadomoci w sposb bardzo prowizoryczny, np. zmienia stan, odpowiada pingiem,
					 * i inne takie pierdoy. Generalnie nie pojawia si tu na razie nic wanego
					 * - do czasu...
					 *
					 */
					case TLEN_EVENT_MESSAGE:
					{
                                                if (strcmp(event->message->body,"exit")==0) 
						{ 
						    terminate=1;
						    tlen_sendmsg(sesja,event->message->from,"exiting...",TLEN_CHAT);
						}
						else if (strcmp(event->message->body,"available")==0) { tlen_presence(sesja,TLEN_STATUS_AVAILABLE,"available"); tlen_sendmsg(sesja,event->message->from,"status changed to available", TLEN_CHAT); }
						else if (strcmp(event->message->body,"away")==0) { tlen_presence(sesja,TLEN_STATUS_AWAY,"away"); tlen_sendmsg(sesja,event->message->from,"status changed to away", TLEN_CHAT); }
						else if (strcmp(event->message->body,"chatty")==0) { tlen_presence(sesja,TLEN_STATUS_CHATTY,"away"); tlen_sendmsg(sesja,event->message->from,"status changed to chatty", TLEN_CHAT); }
						else if (strcmp(event->message->body,"xa")==0) { tlen_presence(sesja,TLEN_STATUS_EXT_AWAY,"away"); tlen_sendmsg(sesja,event->message->from,"status changed to xa", TLEN_CHAT); }
						else if (strcmp(event->message->body,"dnd")==0) { tlen_presence(sesja,TLEN_STATUS_DND,"away"); tlen_sendmsg(sesja,event->message->from,"status changed to dnd", TLEN_CHAT); }
						else if (strcmp(event->message->body,"invisible")==0) { tlen_presence(sesja,TLEN_STATUS_INVISIBLE,"away"); tlen_sendmsg(sesja,event->message->from,"status changed to invisible", TLEN_CHAT); }
						else if (strcmp(event->message->body,"ping")==0) { tlen_sendmsg(sesja,event->message->from,"pong", TLEN_CHAT); }
						else if (strcmp(event->message->body,"typing")==0) { tlen_sendnotify(sesja,event->message->from, TLEN_NOTIFY_TYPING); }
						else if (strcmp(event->message->body,"nottyping")==0) { tlen_sendnotify(sesja,event->message->from, TLEN_NOTIFY_NOTTYPING); }
						else if (strcmp(event->message->body,"soundalert")==0) { tlen_sendnotify(sesja,event->message->from, TLEN_NOTIFY_SOUNDALERT); }
						else if (argv[3]) { if (strcmp(event->message->from,argv[3])==0) { tlen_socket_write_string(sesja,event->message->body); printf("testclient: Sending raw XML to server: %s\n", event->message->body); } }
						
						/*
						 * Jeeli wylemy klientowi wiadomo pubdir, wyle on prob o swoje
						 * dane z katalogu publicznego - tlen_get_pubdir()
						 *
						 */
						if (strcmp(event->message->body,"pubdir")==0) { tlen_get_pubdir(sesja); }
						if (strcmp(event->message->body,"groupchat")==0) { tlen_groupchat_create(sesja); }

						/*
						 * Jeeli wylemy do testclienta wiadomo o treci search, klient
						 * rozpocznie proces wyszukiwania w katalogu publicznym. W tym celu
						 * inicjowana jest struktura tlen_pubdir, przy uyciu funkcji tlen_new_pubdir(),
						 * a nastpnie wypeniane s jej pola. Tutaj akutat wykonujemy 
						 * odpowiednik windowsowej "wizytwki" - tzn. wyszukujemy po identyfikatorze
						 * tlenu. Gdy wylemy zamwienie poprzez tlen_search, zwalniamy struktur
						 * funkcj tlen_free_pubdir().
						 * 
						 */
						if (strcmp(event->message->body,"search")==0)
						{
						    struct tlen_pubdir *sercz = tlen_new_pubdir();
						    sercz->id = "matijozef"; // tutaj sobie wpiszcie jaki wam sie podoba
						    tlen_search(sesja,sercz);
						    tlen_free_pubdir(sercz);
						}
						/*
						 * Analogicznie - tutaj obsugiwana jest proba o zmian naszych
						 * danych w katalogu. Rwnie inicjujemy struktur tlen_pubdir,
						 * uzupeniamy jej pola, a nastpnie funkcj tlen_change_pubdir
						 * wysyamy do serwera nowe dane. Na koniec zwalniamy struktur
						 * poprzez tlen_free_pubdir()
						 *
						 */
						if (strcmp(event->message->body,"pubdir_change")==0)
						{
						    struct tlen_pubdir *pub = tlen_new_pubdir();
						    pub->firstname = "matijozef"; // tutaj sobie wpiszcie jaki wam sie podoba
						    pub->lastname = "krzysztoffelix"; 
						    tlen_change_pubdir(sesja,pub);
						    tlen_free_pubdir(pub);
						}
																		    
						break;
					}
					/*
					 * Kto zmieni stan - np. na niedostpny, zajty, lub zmieni stan opisowy
					 * Aktualnie nie jest to u nas obsugiwane :) Dane oczywicie zawarte s
					 * w event->presence.
					 *
					 */
					case TLEN_EVENT_PRESENCE:
					{
			
						break;
					}
					/*
					 * Zintegrowany system kont na o2.pl / tlen.pl jest poczony z serwerem tlenu.
					 * Tak wic moemy otrzyma informacj o nowej poczcie - tutaj wanie tak si
					 * dzieje. Informacje o tym s wysyane na ekran - dane za znajdziemy w polu
					 * event->newmail
					 *
					 */
					case TLEN_EVENT_NEWMAIL:
					{
						printf("testclient: Masz now poczt od %s o temacie %s!\n",event->newmail->from, event->newmail->subject);
						break;
					}
					/*
					 * Na razie jeszcze nie mamy w testcliencie obsugi wyszukiwania, wi program
					 * poinformuje nas jedynie o tym, e wyszukiwanie skoczy. Obsuga jednak jest
					 * analogiczna do ksiki adresowej - GOTSEARCHITEM a na kocu ENDSEARCH.
					 *
					 */
					case TLEN_EVENT_ENDSEARCH:
					{
						printf("Wyszukiwanie zakoczone!\n");
						break;
					}
					/*
					 * Serwer tlenu pomylnie zwrci nam swoje dane, znajdziemy je w 
					 * event->pubdir.
					 *
					 */
					case TLEN_EVENT_PUBDIR_GOTDATA:
					{
						printf("Odebralem swoje dane!\n");
						break;
					}
					/*
					 * "Pusty" event. Dostajemy informacje o tym, e nasze dane si
					 * adnie zmieniy.
					 *
					 */
					case TLEN_EVENT_PUBDIR_GOTUPDATEOK:
					{
						printf("Zmienilem swoje dane!\n");
						break;
					}
					/* 
					 * Reklama. Dostajemy informacje o adresie URL, nazwie reklamodawcy,
					 * oraz rozmiarach okienka jakie powinno zostac otworzone.
					 *
					 */
					case TLEN_EVENT_ADVERT:
					{
					    printf("Otrzymaem od %s reklam o adresie %s i wymiarach %d na %d pikseli\n", event->advert->name, event->advert->url, event->advert->width, event->advert->height);
					    break;
					}
					/* 
					 * Powiadomienie. Dostajemy informacje o tym, czy kto pisze, ju nie pisze,
					 * lub alerty dwikowe.
					 *
					 */
					case TLEN_EVENT_NOTIFY:
					{		
						char *notifytype;
						switch (event->notify->type)
						{
						    case TLEN_NOTIFY_TYPING:
						    {
							notifytype = "pisze";
							break;
						    }
						    case TLEN_NOTIFY_NOTTYPING:
						    {
							notifytype = "przesta pisa";
							break;
						    }
						    case TLEN_NOTIFY_SOUNDALERT:
						    {
							notifytype = "alert dwikowy";
							break;
						    }							
						}
						printf("Otrzymaem od %s powiadomienie typu %s\n", event->notify->from, notifytype);
						break;
					}

				}
				tlen_freeevent(event);
			}	/* while(event=tlen_getevent(sesja)) */
		}

		/* 
		 * Co 60 sekund musimy pinga, zapewnia nam to prosty trick z funkcj time.
		 *
		 */
		if (time(NULL)-last_ping_time>60) { tlen_ping (sesja); last_ping_time = time(NULL); }
	}

        /*
         * obsluga m.in bledu autoryzacji
         *
         */
        if(sesja->error)
        {
                printf("Error occured while talking to server!\n");
                exit(1);
        }
        /*
	 * Jeeli dostalimy CTRL+C to wychodzimy i zamykamy poczenie
	 * z serwerem.
	 *
	 */
	if (terminate) printf("SIGINT received, exiting...\n");
	
	/*
	 * Wysyamy zamknicie poczenia poprzez stan TLEN_STATUS_UNAVAILABLE.
	 *
	 */
	tlen_presence(sesja, TLEN_STATUS_UNAVAILABLE, "");
	/*
	 * A na koniec zwalniamy pami po sesji.
	 *
	 */
	tlen_freesession (sesja);
	return 0;
}
