#include <unistd.h>
#include <assert.h>
#include <errno.h>
#include <config.h>
#include <string.h>
#ifdef MULTITHREAD
#include "./Rthreads.h"
#endif

#ifdef XMUTEX_INITIALIZER
static xmutex_rec ttylock = XMUTEX_INITIALIZER;
#endif

/*
   The ttyname_r() function stores the null-terminated
   pathname of the terminal associated with the file 
   descriptor fildes in the character array referenced 
   by name. The array is namesize characters long and 
   should have space for the name and the terminating 
   null character. The maximum length of the terminal 
   name is {TTY_NAME_MAX}. 
*/
int ttyname_r(int fildes, char *name, size_t namesize)
{
    char* theName;
    int retVal = 0;
    /* Must be a terminal. */
    if (isatty(fildes))
    {
#ifdef XMUTEX_INITIALIZER
	xmutex_lock(&ttylock);
#endif
        theName = ttyname(fildes);
        /*
        Upon successful completion, ttyname() returns 
        a pointer to a string. Otherwise, a null 
        pointer is returned and errno is set to 
        indicate the error. 
        */
        if (theName == NULL)
        {
            retVal = errno;
        }
        else
        {
            /* Copy tty name into caller provided buffer */
            if (strlen(theName) > namesize - 1)
            {
                /*
                The value of namesize is smaller than the 
                length of the string to be returned including 
                the terminating null character. 
                */ 
                retVal = ERANGE;
            }
            else
            {
                strcpy(name, theName);
            }
        }
#ifdef XMUTEX_INITIALIZER
        xmutex_unlock(&ttylock);
#endif
        return (retVal);
    }
    else
    {
        /*
        The fildes argument does not refer to a terminal device.
        */
        return (ENOTTY);
    }
}
