/**
 * @file	sdbase.h
 * @brief	TEh foCXNX̐錾уC^[tFCX̒`܂
 */

#pragma once

/**
 * @brief TEh f[^擾C^tFCX
 */
class ISoundData
{
public:
	/**
	 * Xg[ f[^𓾂
	 * @param[out] lpBuffer obt@
	 * @param[in] nBufferCount obt@ JEg
	 * @return Tv
	 */
	virtual UINT Get16(SINT16* lpBuffer, UINT nBufferCount) = 0;
};

/**
 * @brief TEh foCXNX
 */
class CSoundDeviceBase
{
public:
	/**
	 * RXgN^
	 */
	CSoundDeviceBase()
		: m_pSoundData(NULL)
	{
	}

	/**
	 * fXgN^
	 */
	virtual ~CSoundDeviceBase()
	{
	}

	/**
	 * Xg[ f[^̐ݒ
	 * @param[in] pSoundData TEh f[^
	 */
	void SetStreamData(ISoundData* pSoundData)
	{
		m_pSoundData = pSoundData;
	}

	/**
	 * I[v
	 * @param[in] lpDevice foCX
	 * @param[in] hWnd EBhE nh
	 * @retval true 
	 * @retval false s
	 */
	virtual bool Open(LPCTSTR lpDevice = NULL, HWND hWnd = NULL) = 0;

	/**
	 * N[Y
	 */
	virtual void Close() = 0;

	/**
	 * Xg[̍쐬
	 * @param[in] nSamplingRate TvO [g
	 * @param[in] nChannels `l
	 * @param[in] nBufferSize obt@ TCY
	 * @return obt@ TCY
	 */
	virtual UINT CreateStream(UINT nSamplingRate, UINT nChannels, UINT nBufferSize = 0) = 0;

	/**
	 * Xg[j
	 */
	virtual void DestroyStream() = 0;

	/**
	 * Xg[Zbg
	 */
	virtual void ResetStream()
	{
	}

	/**
	 * Xg[̍Đ
	 * @retval true 
	 * @retval false s
	 */
	virtual bool PlayStream() = 0;

	/**
	 * Xg[̒~
	 */
	virtual void StopStream() = 0;
	
	/**
	 * Xg[ H[ݒ
	 * @param[in] nVolume H[(max 100)
	 */
	virtual void SetMasterVolume(int nVolume)
	{
	}

	/**
	 * PCM f[^ǂݍ
	 * @param[in] nNum PCM ԍ
	 * @param[in] lpFilename t@C
	 * @retval true 
	 * @retval false s
	 */
	virtual bool LoadPCM(UINT nNum, LPCTSTR lpFilename)
	{
		return false;
	}

	/**
	 * PCM A[h
	 * @param[in] nNum PCM ԍ
	 */
	virtual void UnloadPCM(UINT nNum)
	{
	}

	/**
	 * PCM H[ݒ
	 * @param[in] nNum PCM ԍ
	 * @param[in] nVolume H[
	 */
	virtual void SetPCMVolume(UINT nNum, int nVolume)
	{
	}

	/**
	 * PCM Đ
	 * @param[in] nNum PCM ԍ
	 * @param[in] bLoop [v tO
	 * @retval true 
	 * @retval false s
	 */
	virtual bool PlayPCM(UINT nNum, BOOL bLoop)
	{
		return false;
	}

	/**
	 * PCM ~
	 * @param[in] nNum PCM ԍ
	 */
	virtual void StopPCM(UINT nNum)
	{
	}

	/**
	 * PCM Xgbv
	 */
	virtual void StopAllPCM()
	{
	}

protected:
	ISoundData* m_pSoundData;		/*!< TEh f[^ CX^X */
};
