/**
 * @file	tstring.cpp
 * @brief	NX̓̒`s܂
 */

#include "compiler.h"
#include "tstring.h"
#include "WndProc.h"

/**
 * \[X當[h
 * @param[in] uID \[Xʎq
 * @return 
 */
std::tstring LoadTString(UINT uID)
{
	std::tstring ret;

	do
	{
		HINSTANCE hInstance = CWndProc::FindResourceHandle(MAKEINTRESOURCE((uID >> 4) + 1), RT_STRING);
		HRSRC hRsrc = ::FindResource(hInstance, MAKEINTRESOURCE((uID >> 4) + 1), RT_STRING);
		if (hRsrc == NULL)
		{
			break;
		}

		DWORD dwResSize = ::SizeofResource(hInstance, hRsrc);
		HGLOBAL hGlobal = ::LoadResource(hInstance, hRsrc);
		if (hGlobal == NULL)
		{
			break;
		}

		LPCWSTR pRes = static_cast<LPCWSTR>(::LockResource(hGlobal));
		DWORD dwPos = 0;
		uID = uID & 15;
		while ((uID) && (dwPos < dwResSize))
		{
			dwPos += pRes[dwPos] + 1;
			uID--;
		}
		if (dwPos >= dwResSize)
		{
			break;
		}

		UINT nLength = pRes[dwPos++];
		nLength = np2min(nLength, (dwResSize - dwPos));

#if defined(_UNICODE)

		ret = std::wstring(pRes + dwPos, nLength);

#else	// defined(_UNICODE)

		UINT nSize = ::WideCharToMultiByte(CP_ACP, 0, pRes + dwPos, nLength, NULL, 0, NULL, NULL);
		if (nSize)
		{
			ret.resize(nSize);
			nSize = ::WideCharToMultiByte(CP_ACP, 0, pRes + dwPos, nLength, &ret.at(0), nSize, NULL, NULL);
			ret.resize(nSize);
		}

#endif	// defined(_UNICODE)

	} while (false /*CONSTCOND*/);

	return ret;
}

/**
 * \[X當[h
 * @param[in] lpString ID
 * @return 
 */
std::tstring LoadTString(LPCTSTR lpString)
{
	if (HIWORD(lpString))
	{
		return std::tstring(lpString);
	}
	else
	{
		return LoadTString(static_cast<UINT>(LOWORD(lpString)));
	}
}
