/**
 * @file	net.c
 * @brief	Virtual LAN Interface
 *
 * @author	$Author: SimK $
 */

#include	"compiler.h"
#if defined(_MSC_VER)
#include	<io.h>
#else
#include	<unistd.h>
#endif


//#define TRACEOUT(a) printf(a);printf("\n");
#define TRACEOUT(a)

#if defined(SUPPORT_NET)

#include	"pccore.h"
#include	"net.h"
#include	"sxsi.h"

#if defined(_WINDOWS)
#include <winioctl.h>
#include <tchar.h>

#if defined(_WINDOWS)
#include	<process.h>
#endif

#pragma warning(disable: 4996)
#pragma comment(lib, "Advapi32.lib")

#define DEVICE_PATH_FMT _T("\\\\.\\Global\\%s.tap")
 
#define TAP_CONTROL_CODE(request,method) \
  CTL_CODE (FILE_DEVICE_UNKNOWN, request, method, FILE_ANY_ACCESS)
 
#define TAP_IOCTL_SET_MEDIA_STATUS \
  TAP_CONTROL_CODE (6, METHOD_BUFFERED)

#else

// for Linux
#include <semaphore.h>
#include <pthread.h>

#include <sched.h>

#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <sys/time.h>

/*
unsigned GetTickCount()
{
        struct timeval tv;
        if(gettimeofday(&tv, NULL) != 0)
                return 0;

        return (tv.tv_sec * 1000) + (tv.tv_usec / 1000);
}
*/

#include <linux/if.h>
#include <linux/if_tun.h>
#include <linux/if_ether.h>	/* struct ethhdr */

#endif // defined(_WINDOWS)
 
#define NET_BUFLEN (10*1024) // obt@1̒iXXX: pPbgTCY̍őlɂȂƖʁBƌΉϒő傫1̃obt@ɓׂHj
#define NET_ARYLEN (128) // obt@̐

	NP2NET	np2net;
	
static OEMCHAR np2net_tapName[MAX_PATH]; // TAPfoCX

static int		np2net_hThreadexit = 0; // XbhItO

#if defined(_WINDOWS)
static TCHAR *GetNetWorkDeviceGuid(CONST TCHAR *, TCHAR *, DWORD); // TAPfoCXGUID擾

static HANDLE	np2net_hTap = NULL; // TAPfoCX̓ǂݏnh
static HANDLE	np2net_hThreadR = NULL; // ReadpXbh
static HANDLE	np2net_hThreadW = NULL; // WritepXbh
#else

// for Linux
static int	np2net_hTap = -1; // TAPfoCX̓ǂݏnh
static int			np2net_hThreadE = 0; // Thread Running Flag
static pthread_t	np2net_hThreadR = NULL; // ReadpXbh
static pthread_t	np2net_hThreadW = NULL; // WritepXbh
#endif // defined(_WINDOWS)

static UINT8	np2net_membuf[NET_ARYLEN][NET_BUFLEN]; // Mpobt@
static int		np2net_membuflen[NET_ARYLEN]; // Mpobt@ɂf[^̒
static int		np2net_membuf_readpos = 0; // obt@ǂݎʒu
static int		np2net_membuf_writepos = 0; // obt@݈ʒu

static int		np2net_pmm = 0; // CPUגጸ[hiʐM͎኱xȂƎvj
static int		np2net_highspeedmode = 0; // M[h
static UINT32		np2net_highspeeddatacount = 0; // Mf[^JE^

#if defined(_WINDOWS)
static HANDLE		np2net_write_hEvent;
static OVERLAPPED	np2net_write_ovl;
#endif // defined(_WINDOWS)

#if defined(_WINDOWS)
// pPbgf[^ TAP ֏o
static int doWriteTap(HANDLE hTap, const UINT8 *pSendBuf, UINT32 len)
{
	#define ETHERDATALEN_MIN 46
	DWORD dwWriteLen;

	if (!WriteFile(hTap, pSendBuf, len, &dwWriteLen, &np2net_write_ovl)) {
		DWORD err = GetLastError();
		if (err == ERROR_IO_PENDING) {
			WaitForSingleObject(np2net_write_hEvent, INFINITE); // ҂
			GetOverlappedResult(hTap, &np2net_write_ovl, &dwWriteLen, FALSE);
		} else {
			TRACEOUT(("LGY-98: WriteFile err=0x%08X\n", err));
			return -1;
		}
	}
	//TRACEOUT(("LGY-98: send %u bytes\n", dwWriteLen));
	return 0;
}
#else

// for Linux
// pPbgf[^ TAP ֏o
static int doWriteTap(int hTap, const UINT8 *pSendBuf, UINT32 len)
{
	#define ETHERDATALEN_MIN 46
	UINT32 dwWriteLen;

	if ((dwWriteLen = write(hTap, pSendBuf, len)) == -1) {
		TRACEOUT(("LGY-98: WriteFile err"));
		return -1;
	}
	//TRACEOUT(("LGY-98: send %u bytes\n", dwWriteLen));
	return 0;
}

#endif // defined(_WINDOWS)

// pPbgf[^obt@ɑiۂ̑Mnp2net_ThreadFuncWōsj
static int sendDataToBuffer(const UINT8 *pSendBuf, UINT32 len){
	if(len > NET_BUFLEN){
		TRACEOUT(("LGY-98: too large packet!! %d bytes", len));
		return 1;
	}
	if(np2net_membuf_readpos==(np2net_membuf_writepos+1)%NET_ARYLEN){
		np2net_highspeedmode = 1;
		TRACEOUT(("LGY-98: buffer full"));
		while(np2net_membuf_readpos==(np2net_membuf_writepos+1)%NET_ARYLEN){
			//Sleep(0); // obt@ςȂ̂ő҂
			return 1; // obt@ςȂ̂Ŏ̂Ă
		}
	}
	memcpy(np2net_membuf[np2net_membuf_writepos], pSendBuf, len);
	np2net_membuflen[np2net_membuf_writepos] = len;
	np2net_membuf_writepos = (np2net_membuf_writepos+1)%NET_ARYLEN;
	np2net_highspeeddatacount += len*50;
	return 0;
}

// pPbgMɌĂ΂iftHgj
static void np2net_default_send_packet(const UINT8 *buf, int size)
{
	sendDataToBuffer(buf, size);
}
// pPbgMɌĂ΂iftHgj
static void np2net_default_recieve_packet(const UINT8 *buf, int size)
{
	// Ȃ
}

static void np2net_updateHighSpeedMode(){
	static UINT32	np2net_highspeedtimer = 0; // Mf[^JEg
	static UINT32	np2net_highspeeddataspeed = 0; // 1b̑Mf[^
	//HDC hdc;
	//RECT r = {0, 0, 100, 100};
	int timediff;
	if(np2net_pmm && np2net_membuf_readpos!=(np2net_membuf_writepos+1)%NET_ARYLEN){
		timediff = GetTickCount() - np2net_highspeedtimer;
		if(timediff<0) timediff = INT_MAX;
		if((!np2net_highspeedmode && timediff>1000)
			|| (np2net_highspeedmode && timediff>8000)){
			np2net_highspeedtimer = GetTickCount();
			np2net_highspeeddataspeed = np2net_highspeeddatacount*1000 / timediff;
			np2net_highspeeddatacount = 0;
			if(np2net_highspeeddataspeed < 3000){
				np2net_highspeedmode = 0;
			}else{
				np2net_highspeedmode = 1;
			}
		}
	}else{
		np2net_highspeedmode = 1;
	}
}

#if defined(_WINDOWS)
//  񓯊ŒʐMĂ݂iWritej
static unsigned int __stdcall np2net_ThreadFuncW(LPVOID vdParam) {
	while (!np2net_hThreadexit) {
		if(np2net.recieve_packet != np2net_default_recieve_packet){
			if(np2net_membuf_readpos!=np2net_membuf_writepos){
				doWriteTap(np2net_hTap, (UCHAR*)(np2net_membuf[np2net_membuf_readpos]), np2net_membuflen[np2net_membuf_readpos]);
				np2net_membuf_readpos = (np2net_membuf_readpos+1)%NET_ARYLEN;
			}else{
				Sleep(0);
			}
		}else{
			Sleep(1000);
		}
		np2net_updateHighSpeedMode();
		if(!np2net_highspeedmode) 
			Sleep(50);
	}
	return 0;
}
//  񓯊ŒʐMĂ݂iReadj
static unsigned int __stdcall np2net_ThreadFuncR(LPVOID vdParam) {
	HANDLE hEvent = NULL;
	DWORD dwLen;
	OVERLAPPED ovl;
	int nodatacount = 0;
	int sleepcount = 0;
	int timediff = 0;
	CHAR np2net_Buf[NET_BUFLEN];

	// OVERLAPPED񓯊ǂݎ菀
	memset(&ovl, 0, sizeof(OVERLAPPED));
	ovl.hEvent = hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	ovl.Offset = 0;
	ovl.OffsetHigh = 0;
 
	while (!np2net_hThreadexit) {
		if (!ReadFile(np2net_hTap, np2net_Buf, sizeof(np2net_Buf), &dwLen, &ovl)) {
			DWORD err = GetLastError();
			if (err == ERROR_IO_PENDING) {
				// ǂݎ҂
				WaitForSingleObject(hEvent, INFINITE); // M҂
				GetOverlappedResult(np2net_hTap, &ovl, &dwLen, FALSE);
				if(dwLen>0){
					//TRACEOUT(("LGY-98: recieve %u bytes\n", dwLen));
					np2net.recieve_packet((UINT8*)np2net_Buf, dwLen); // Mł̂Œʒm
					np2net_highspeeddatacount += dwLen;
				}
			} else {
				// ǂݎG[
				printf("TAP-Win32: ReadFile err=0x%08X\n", err);
				//CloseHandle(hTap);
				//return -1;
				Sleep(1);
			}
		} else {
			// ǂݎ萬
			if(dwLen>0){
				//TRACEOUT(("LGY-98: recieve %u bytes\n", dwLen));
				np2net.recieve_packet((UINT8*)np2net_Buf, dwLen); // Mł̂Œʒm
				np2net_highspeeddatacount += dwLen;
			}else{
				Sleep(1);
			}
		}
		np2net_updateHighSpeedMode();
		if(!np2net_highspeedmode) 
			Sleep(50);
	}
	CloseHandle(hEvent);
	hEvent = NULL;
	return 0;
}
#else

// for Linux
//  񓯊ŒʐMĂ݂iWritej
static void* np2net_ThreadFuncW(void *thdata) {
	while (!np2net_hThreadexit) {
		if(np2net.recieve_packet != np2net_default_recieve_packet){
			if(np2net_membuf_readpos!=np2net_membuf_writepos){
				doWriteTap(np2net_hTap, np2net_membuf[np2net_membuf_readpos], np2net_membuflen[np2net_membuf_readpos]);
				np2net_membuf_readpos = (np2net_membuf_readpos+1)%NET_ARYLEN;
			}else{
				sched_yield();
			}
		}else{
			sleep(1000);
		}
		np2net_updateHighSpeedMode();
		if(!np2net_highspeedmode) 
			sleep(50);
	}
	return (void*) NULL;
}
//  񓯊ŒʐMĂ݂iReadj
static void* np2net_ThreadFuncR(void *thdata) {
	UINT32 dwLen;
	UINT8 np2net_Buf[NET_BUFLEN];

	while (!np2net_hThreadexit) {
		if ((dwLen = read(np2net_hTap, np2net_Buf, sizeof(np2net_Buf))) < 0) {
			// ǂݎG[
			printf("TAP-Win32: ReadFile err");
			sched_yield();
		} else {
			// ǂݎ萬
			if(dwLen>0){
				//TRACEOUT(("LGY-98: recieve %u bytes\n", dwLen));
				np2net.recieve_packet((UINT8*)np2net_Buf, dwLen); // Mł̂Œʒm
				np2net_highspeeddatacount += dwLen;
			}else{
				sched_yield();
			}
		}
		np2net_updateHighSpeedMode();
		if(!np2net_highspeedmode) 
			sleep(50);
	}
	return (void*) NULL;
}

#endif // defined(_WINDOWS)

//  TAPfoCX
static void np2net_closeTAP(){
#if defined(_WINDOWS)
    if (np2net_hTap != NULL) {
		if(np2net_hThreadR){
			np2net_hThreadexit = 1;
			WaitForSingleObject(np2net_hThreadR,  INFINITE);
			WaitForSingleObject(np2net_hThreadW, INFINITE);
			np2net_membuf_readpos = np2net_membuf_writepos;
			np2net_hThreadexit = 0;
			np2net_hThreadR = NULL;
		}
		CloseHandle(np2net_hTap);
		TRACEOUT(("LGY-98: TAP is closed"));
		np2net_hTap = NULL;
    }
#else
    if (np2net_hTap >= 0) {
		if(np2net_hThreadE){
			np2net_hThreadexit = 1;
			pthread_join(np2net_hThreadR , NULL);
			pthread_join(np2net_hThreadW , NULL);
			np2net_membuf_readpos = np2net_membuf_writepos;
			np2net_hThreadexit = 0;
			np2net_hThreadR = NULL;
			np2net_hThreadW = NULL;
			np2net_hThreadE = 0;
		}
        close(np2net_hTap);
		np2net_hTap = -1;
		TRACEOUT(("LGY-98: TAP is closed"));
    }
#endif // defined(_WINDOWS)
}
//  TAPfoCXJ
static int np2net_openTAP(const OEMCHAR* tapname){
#if defined(_WINDOWS)
	DWORD dwID;
	DWORD dwLen;
	ULONG status = TRUE;
	TCHAR Buf[2048];
	TCHAR szDevicePath[256];
	TCHAR szTAPname[MAX_PATH] = _T("TAP1");

	if(*tapname){
		_tcscpy(szTAPname, tapname);
	}

	np2net_closeTAP();

	// w肳ꂽ\ TAP  GUID 𓾂
	if (!GetNetWorkDeviceGuid(szTAPname, Buf, 2048)) {
		TRACEOUT(("LGY-98: [%s] GUID is not found\n", szTAPname));
		return 1;
	}
	TRACEOUT(("LGY-98: [%s] GUID = %s\n", szTAPname, Buf));
	_stprintf(szDevicePath, DEVICE_PATH_FMT, Buf);
 
	// TAP foCXJ
	np2net_hTap = CreateFile (szDevicePath, GENERIC_READ | GENERIC_WRITE,
		0, 0, OPEN_EXISTING,
		FILE_ATTRIBUTE_SYSTEM | FILE_FLAG_OVERLAPPED, 0);
 
	if (np2net_hTap == INVALID_HANDLE_VALUE) {
		TRACEOUT(("LGY-98: Failed to open [%s]", szDevicePath));
		return 2;
	}

	TRACEOUT(("LGY-98: TAP is opened"));
	
	// TAP foCXANeBu
	status = TRUE;
	if (!DeviceIoControl(np2net_hTap,TAP_IOCTL_SET_MEDIA_STATUS,
				&status, sizeof(status), &status, sizeof(status),
				&dwLen, NULL)) {
		TRACEOUT(("LGY-98: TAP_IOCTL_SET_MEDIA_STATUS err"));
		np2net_closeTAP();
		return 3;
	}
 
	np2net_hThreadR = (HANDLE)_beginthreadex(NULL , 0 , np2net_ThreadFuncR  , NULL , 0 , &dwID);
	np2net_hThreadW = (HANDLE)_beginthreadex(NULL , 0 , np2net_ThreadFuncW , NULL , 0 , &dwID);
#else
	struct ifreq ifr;
	np2net_hTap = open("/dev/net/tun", O_RDWR);
	if(np2net_hTap < 0){
		TRACEOUT(("LGY-98: Failed to open [%s]", "/dev/net/tun"));
		return 2;
	}
	memset(&ifr, 0, sizeof(ifr));

	ifr.ifr_flags = IFF_TAP | IFF_NO_PI;
	strcpy(ifr.ifr_name, "tap%d");
	
	if (ioctl(np2net_hTap, TUNSETIFF, (void *)&ifr) < 0) {
		TRACEOUT(("LGY-98: TUNSETIFF err"));
		np2net_closeTAP();
		return 3;
	}

	if(pthread_create(&np2net_hThreadR , NULL , np2net_ThreadFuncR , NULL) != 0){
		TRACEOUT(("LGY-98: thread_create(READ) err"));
		np2net_closeTAP();
		return 3;
	}
	if(pthread_create(&np2net_hThreadW , NULL , np2net_ThreadFuncW , NULL) != 0){
		TRACEOUT(("LGY-98: thread_create(WRITE) err"));
		np2net_closeTAP();
		return 3;
	}

	TRACEOUT(("LGY-98: TAP is opened"));
#endif // defined(_WINDOWS)
	return 0;
}

// NP2N̏
void np2net_init(void)
{
#if defined(_WINDOWS)
	memset(&np2net_write_ovl, 0, sizeof(OVERLAPPED));
	np2net_write_ovl.hEvent = np2net_write_hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	np2net_write_ovl.Offset = 0;
	np2net_write_ovl.OffsetHigh = 0;
#endif // defined(_WINDOWS)

	memset(np2net_tapName, 0, sizeof(np2net_tapName));
	np2net.send_packet = np2net_default_send_packet;
	np2net.recieve_packet = np2net_default_recieve_packet;
}
// ZbgɌĂ΂H
void np2net_reset(const NP2CFG *pConfig){
#if defined(_WINDOWS)
	_tcscpy(np2net_tapName, pConfig->np2nettap);
#else
	strcpy(np2net_tapName, pConfig->np2nettap);
#endif // defined(_WINDOWS)
	np2net_pmm = pConfig->np2netpmm;
	if(pConfig->uselgy98){ // XXX: gĂȂȂTAPfoCX̓I[vȂ
		np2net_openTAP(np2net_tapName);
	}
}
// ZbgɌĂ΂Hinp2net_resetEiocore_attach`gj
void np2net_bind(void){
}
// NP2Ȉ
void np2net_shutdown(void)
{
	np2net_hThreadexit = 1;
	np2net_closeTAP();
}

#if defined(_WINDOWS)
// Ql: http://dsas.blog.klab.org/archives/51012690.html

// lbg[NfoCX\foCX GUID 
static TCHAR *GetNetWorkDeviceGuid(CONST TCHAR *pDisplayName, TCHAR *pszBuf, DWORD cbBuf)
{
  CONST TCHAR *SUBKEY = _T("SYSTEM\\CurrentControlSet\\Control\\Network");
 
#define BUFSZ 256
  // HKLM\SYSTEM\\CurrentControlSet\\Control\\Network\{id1]\{id2}\Connection\Name 
  // lbg[NfoCXij[Nj̊i[ꂽGgłA
  // {id2} ̃foCX GUID ł
 
  HKEY hKey1, hKey2, hKey3;
  LONG nResult;
  DWORD dwIdx1, dwIdx2;
  TCHAR szData[64], *pKeyName1, *pKeyName2, *pKeyName3, *pKeyName4; 
  DWORD dwSize, dwType = REG_SZ;
  BOOL bDone = FALSE;
  FILETIME ft;

  hKey1 = hKey2 = hKey3 = NULL;
  pKeyName1 = pKeyName2 = pKeyName3 = pKeyName4 = NULL;
 
  // L[̃I[v
  nResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE, SUBKEY, 0, KEY_READ, &hKey1);
  if (nResult != ERROR_SUCCESS) {
    return NULL;
  }
  pKeyName1 = (TCHAR*)malloc(sizeof(TCHAR)*BUFSZ);
  pKeyName2 = (TCHAR*)malloc(sizeof(TCHAR)*BUFSZ);
  pKeyName3 = (TCHAR*)malloc(sizeof(TCHAR)*BUFSZ);
  pKeyName4 = (TCHAR*)malloc(sizeof(TCHAR)*BUFSZ);
 
  dwIdx1 = 0;
  while (bDone != TRUE) { // {id1} 񋓂郋[v
 
    dwSize = BUFSZ;
    nResult = RegEnumKeyEx(hKey1, dwIdx1++, pKeyName1,
                          &dwSize, NULL, NULL, NULL, &ft);
    if (nResult == ERROR_NO_MORE_ITEMS) {
      break;
    }
 
    // SUBKEY\{id1} L[I[v
    _stprintf(pKeyName2, _T("%s\\%s"), SUBKEY, pKeyName1);
    nResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE, pKeyName2,
                          0, KEY_READ, &hKey2);
    if (nResult != ERROR_SUCCESS) {
      continue;
    }
    dwIdx2 = 0;
    while (1) { // {id2} 񋓂郋[v
      dwSize = BUFSZ;
      nResult = RegEnumKeyEx(hKey2, dwIdx2++, pKeyName3,
                          &dwSize, NULL, NULL, NULL, &ft);
      if (nResult == ERROR_NO_MORE_ITEMS) {
        break;
      }
 
      if (nResult != ERROR_SUCCESS) {
        continue;
      }
 
      // SUBKEY\{id1}\{id2]\Connection L[I[v
      _stprintf(pKeyName4, _T("%s\\%s\\%s"),
                      pKeyName2, pKeyName3, _T("Connection"));
      nResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,
                      pKeyName4, 0, KEY_READ, &hKey3);
      if (nResult != ERROR_SUCCESS) {
        continue;
      }
 
      // SUBKEY\{id1}\{id2]\Connection\Name l擾
      dwSize = sizeof(szData);
      nResult = RegQueryValueEx(hKey3, _T("Name"),
                      0, &dwType, (LPBYTE)szData, &dwSize);
 
      if (nResult == ERROR_SUCCESS) {
        if (_tcsicmp(szData, pDisplayName) == 0) {
           	_tcscpy(pszBuf, pKeyName3);
          bDone = TRUE;
          break;
        }
      }
      RegCloseKey(hKey3);
      hKey3 = NULL;
    }
    RegCloseKey(hKey2);
    hKey2 = NULL;
  }
 
  if (hKey1) { RegCloseKey(hKey1); }
  if (hKey2) { RegCloseKey(hKey2); }
  if (hKey3) { RegCloseKey(hKey3); }
 
  if (pKeyName1) { free(pKeyName1); }
  if (pKeyName2) { free(pKeyName2); }
  if (pKeyName3) { free(pKeyName3); }
  if (pKeyName4) { free(pKeyName4); }
 
  // GUID 𔭌ł
  if (bDone != TRUE) {
    return NULL;
  }
  return pszBuf;
}
#endif // defined(_WINDOWS)

#endif	/* SUPPORT_NET */
