﻿#ifndef LIBRETRO_CORE_OPTIONS_INTL_H__
#define LIBRETRO_CORE_OPTIONS_INTL_H__

#if defined(_MSC_VER) && (_MSC_VER >= 1500 && _MSC_VER < 1900)
/* https://support.microsoft.com/en-us/kb/980263 */
#pragma execution_character_set("utf-8")
#pragma warning(disable:4566)
#endif

#include <libretro.h>

/*
 ********************************
 * VERSION: 1.3
 ********************************
 *
 * - 1.3: Move translations to libretro_core_options_intl.h
 *        - libretro_core_options_intl.h includes BOM and utf-8
 *          fix for MSVC 2010-2013
 *        - Added HAVE_NO_LANGEXTRA flag to disable translations
 *          on platforms/compilers without BOM support
 * - 1.2: Use core options v1 interface when
 *        RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION is >= 1
 *        (previously required RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION == 1)
 * - 1.1: Support generation of core options v0 retro_core_option_value
 *        arrays containing options with a single value
 * - 1.0: First commit
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 ********************************
 * Core Option Definitions
 ********************************
*/
/* RETRO_LANGUAGE_AR */

#define CATEGORY_SYSTEM_LABEL_AR NULL
#define CATEGORY_SYSTEM_INFO_0_AR NULL
#define CATEGORY_VIDEO_LABEL_AR "نظام تشغيل الفيديو"
#define CATEGORY_VIDEO_INFO_0_AR NULL
#define CATEGORY_AUDIO_LABEL_AR "نظام تشغيل الصوت"
#define CATEGORY_AUDIO_INFO_0_AR NULL
#define CATEGORY_INPUT_LABEL_AR "نظام تشغيل أجهزة الادخال"
#define CATEGORY_INPUT_INFO_0_AR NULL
#define CATEGORY_HACKS_LABEL_AR NULL
#define CATEGORY_HACKS_INFO_0_AR NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_AR NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AR NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AR NULL
#define OPTION_VAL_AUTO_AR "تلقائي"
#define OPTION_VAL_SG_1000_AR NULL
#define OPTION_VAL_SG_1000_II_AR NULL
#define OPTION_VAL_MARK_III_AR NULL
#define OPTION_VAL_MASTER_SYSTEM_AR NULL
#define OPTION_VAL_MASTER_SYSTEM_II_AR NULL
#define OPTION_VAL_GAME_GEAR_AR NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_AR NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_AR NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AR NULL
#define OPTION_VAL_NTSC_U_AR NULL
#define OPTION_VAL_PAL_AR NULL
#define OPTION_VAL_NTSC_J_AR NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_AR NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_AR NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_AR NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_AR NULL
#define OPTION_VAL_PER_BIOS_AR NULL
#define OPTION_VAL_PER_GAME_AR NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_AR NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_AR NULL
#define OPTION_VAL_SEGA_MEGA_CD_AR NULL
#define OPTION_VAL_MEGASD_AR NULL
#define OPTION_VAL_NONE_AR "لاشيء"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_AR NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_AR NULL
#define OPTION_VAL_GAME_GENIE_AR NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_AR NULL
#define OPTION_VAL_SONIC_KNUCKLES_AR NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AR NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AR NULL
#define OPTION_VAL_NTSC_PAR_AR NULL
#define OPTION_VAL_PAL_PAR_AR NULL
#define OPTION_VAL_4_3_AR NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_AR NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_AR NULL
#define OPTION_VAL_TOP_BOTTOM_AR NULL
#define OPTION_VAL_LEFT_RIGHT_AR NULL
#define OPTION_VAL_FULL_AR NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AR NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AR NULL
#define OPTION_VAL_LEFT_BORDER_AR NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_AR NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_AR NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AR NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AR NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AR NULL
#define OPTION_VAL_MONOCHROME_AR "أحادي اللون"
#define OPTION_VAL_COMPOSITE_AR NULL
#define OPTION_VAL_SVIDEO_AR NULL
#define OPTION_VAL_RGB_AR NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_AR NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AR NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_AR NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_AR NULL
#define OPTION_VAL_SINGLE_FIELD_AR NULL
#define OPTION_VAL_DOUBLE_FIELD_AR NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_AR NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AR NULL
#define OPTION_VAL_MANUAL_AR "يدوي"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AR NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AR "عندما يتم تعيين 'Frameskip' إلى 'يدوي'، يحدد عتبة شغل التخزين المؤقت الصوتي (النسبة المئوية) التي سيتم تخطي الأطر أدناه. فارتفاع القيم يقلل من خطر التشويش بالتسبب في انخفاض الأطر بصورة أكثر تواترا."
#define GENESIS_PLUS_GX_YM2413_LABEL_AR NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_AR NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_AR NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AR NULL
#define OPTION_VAL_MAME_AR NULL
#define OPTION_VAL_NUKED_AR NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_AR NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_AR NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_AR NULL
#define OPTION_VAL_MAME_YM2612_AR NULL
#define OPTION_VAL_MAME_ASIC_YM3438_AR NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_AR NULL
#define OPTION_VAL_NUKED_YM2612_AR NULL
#define OPTION_VAL_NUKED_YM3438_AR NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AR NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AR NULL
#define OPTION_VAL_STEREO_AR NULL
#define OPTION_VAL_MONO_AR NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AR "تصفية الصوت"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AR NULL
#define OPTION_VAL_LOW_PASS_AR NULL
#define OPTION_VAL_EQ_AR NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AR NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AR NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_AR NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AR NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AR NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AR NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_AR NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AR NULL
#define OPTION_VAL_LIGHTGUN_AR NULL
#define OPTION_VAL_TOUCHSCREEN_AR NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AR NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AR NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AR NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AR NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AR NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AR NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_AR NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AR NULL
#define OPTION_VAL_100_AR NULL
#define OPTION_VAL_125_AR NULL
#define OPTION_VAL_150_AR NULL
#define OPTION_VAL_175_AR NULL
#define OPTION_VAL_200_AR NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AR NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AR NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AR NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AR NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AR NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AR NULL

struct retro_core_option_v2_category option_cats_ar[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_AR,
      CATEGORY_SYSTEM_INFO_0_AR
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_AR,
      CATEGORY_VIDEO_INFO_0_AR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_AR,
      CATEGORY_AUDIO_INFO_0_AR
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AR,
      CATEGORY_INPUT_INFO_0_AR
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AR,
      CATEGORY_HACKS_INFO_0_AR
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_AR,
      CATEGORY_CHANNEL_VOLUME_INFO_0_AR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ar[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_AR               },
         { "sg-1000",              OPTION_VAL_SG_1000_AR            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_AR         },
         { "mark-III",             OPTION_VAL_MARK_III_AR           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_AR      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_AR   },
         { "game gear",            OPTION_VAL_GAME_GEAR_AR          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_AR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_AR   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_AR },
         { "pal",     OPTION_VAL_PAL_AR    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_AR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_AR,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_AR },
         { "per game", OPTION_VAL_PER_GAME_AR },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_AR,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_AR },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_AR },
         { "megasd",       OPTION_VAL_MEGASD_AR },
         { "none",         OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_AR },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_AR },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AR,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_AR },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_AR },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_AR },
         { "4:3",  OPTION_VAL_4_3_AR },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_AR },
         { "left/right", OPTION_VAL_LEFT_RIGHT_AR },
         { "full",       OPTION_VAL_FULL_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_AR },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_AR },
         { "composite",  OPTION_VAL_COMPOSITE_AR },
         { "svideo",     OPTION_VAL_SVIDEO_AR },
         { "rgb",        OPTION_VAL_RGB_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_AR,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_AR },
         { "double field", OPTION_VAL_DOUBLE_FIELD_AR },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_AR },
         { "manual",   OPTION_VAL_MANUAL_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AR,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_AR,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_AR },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AR,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_AR },
         { "nuked", OPTION_VAL_NUKED_AR },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_AR,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_AR,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_AR,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_AR },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_AR },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_AR },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_AR },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_AR },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AR,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_AR },
         { "mono",   OPTION_VAL_MONO_AR },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AR,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_AR },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_AR },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AR,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AR,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_AR },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_AR },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_AR },
         { "125%", OPTION_VAL_125_AR },
         { "150%", OPTION_VAL_150_AR },
         { "175%", OPTION_VAL_175_AR },
         { "200%", OPTION_VAL_200_AR },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ar = {
   option_cats_ar,
   option_defs_ar
};

/* RETRO_LANGUAGE_AST */

#define CATEGORY_SYSTEM_LABEL_AST "Sistema"
#define CATEGORY_SYSTEM_INFO_0_AST NULL
#define CATEGORY_VIDEO_LABEL_AST "Videu"
#define CATEGORY_VIDEO_INFO_0_AST NULL
#define CATEGORY_AUDIO_LABEL_AST "Audiu"
#define CATEGORY_AUDIO_INFO_0_AST NULL
#define CATEGORY_INPUT_LABEL_AST "Entrada"
#define CATEGORY_INPUT_INFO_0_AST NULL
#define CATEGORY_HACKS_LABEL_AST NULL
#define CATEGORY_HACKS_INFO_0_AST NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_AST "Axustes avanzaos del volume de les canales"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AST "Hardware del sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AST NULL
#define OPTION_VAL_AUTO_AST NULL
#define OPTION_VAL_SG_1000_AST NULL
#define OPTION_VAL_SG_1000_II_AST NULL
#define OPTION_VAL_MARK_III_AST NULL
#define OPTION_VAL_MASTER_SYSTEM_AST NULL
#define OPTION_VAL_MASTER_SYSTEM_II_AST NULL
#define OPTION_VAL_GAME_GEAR_AST NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_AST NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_AST "Rexón del sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AST NULL
#define OPTION_VAL_NTSC_U_AST NULL
#define OPTION_VAL_PAL_AST NULL
#define OPTION_VAL_NTSC_J_AST NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_AST NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_AST NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_AST NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_AST NULL
#define OPTION_VAL_PER_BIOS_AST NULL
#define OPTION_VAL_PER_GAME_AST NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_AST NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_AST NULL
#define OPTION_VAL_SEGA_MEGA_CD_AST NULL
#define OPTION_VAL_MEGASD_AST NULL
#define OPTION_VAL_NONE_AST NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_AST "Lock-On de cartuchos"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_AST "La teunoloxía Lock-On ye una carauterística de Mega Drive que permitía a los xuegos conectase al puertu d'interconexón d'un cartuchu especial p'aumenta o alteriar el so conteníu. Esta opción especifica qué tipu de cartuchu Lock-On especial hai qu'emular. Los ficheros de BIOS correspondientes han tar nel direutoriu «system» de RetroArch."
#define OPTION_VAL_GAME_GENIE_AST NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_AST NULL
#define OPTION_VAL_SONIC_KNUCKLES_AST NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AST "Proporción d'aspeutu fornida pol nucleu"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AST NULL
#define OPTION_VAL_NTSC_PAR_AST NULL
#define OPTION_VAL_PAL_PAR_AST NULL
#define OPTION_VAL_4_3_AST NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_AST "Berbesos"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_AST NULL
#define OPTION_VAL_TOP_BOTTOM_AST NULL
#define OPTION_VAL_LEFT_RIGHT_AST NULL
#define OPTION_VAL_FULL_AST NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AST NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AST NULL
#define OPTION_VAL_LEFT_BORDER_AST NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_AST NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_AST NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AST NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AST NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AST NULL
#define OPTION_VAL_MONOCHROME_AST NULL
#define OPTION_VAL_COMPOSITE_AST NULL
#define OPTION_VAL_SVIDEO_AST NULL
#define OPTION_VAL_RGB_AST NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_AST NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AST NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_AST NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_AST NULL
#define OPTION_VAL_SINGLE_FIELD_AST NULL
#define OPTION_VAL_DOUBLE_FIELD_AST NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_AST NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AST NULL
#define OPTION_VAL_MANUAL_AST NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AST NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AST NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_AST NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_AST NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_AST NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AST NULL
#define OPTION_VAL_MAME_AST NULL
#define OPTION_VAL_NUKED_AST NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_AST NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_AST NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_AST NULL
#define OPTION_VAL_MAME_YM2612_AST NULL
#define OPTION_VAL_MAME_ASIC_YM3438_AST NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_AST NULL
#define OPTION_VAL_NUKED_YM2612_AST NULL
#define OPTION_VAL_NUKED_YM3438_AST NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AST NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AST NULL
#define OPTION_VAL_STEREO_AST "Estéreu"
#define OPTION_VAL_MONO_AST "Monu"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AST NULL
#define OPTION_VAL_LOW_PASS_AST NULL
#define OPTION_VAL_EQ_AST NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AST NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AST NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_AST NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AST NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AST NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AST NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_AST NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AST NULL
#define OPTION_VAL_LIGHTGUN_AST NULL
#define OPTION_VAL_TOUCHSCREEN_AST "Pantalla táctil"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AST NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AST NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AST NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AST NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AST NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AST NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_AST NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AST NULL
#define OPTION_VAL_100_AST NULL
#define OPTION_VAL_125_AST NULL
#define OPTION_VAL_150_AST NULL
#define OPTION_VAL_175_AST NULL
#define OPTION_VAL_200_AST NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AST NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AST NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AST NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AST NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AST NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AST NULL

struct retro_core_option_v2_category option_cats_ast[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_AST,
      CATEGORY_SYSTEM_INFO_0_AST
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_AST,
      CATEGORY_VIDEO_INFO_0_AST
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_AST,
      CATEGORY_AUDIO_INFO_0_AST
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AST,
      CATEGORY_INPUT_INFO_0_AST
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AST,
      CATEGORY_HACKS_INFO_0_AST
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_AST,
      CATEGORY_CHANNEL_VOLUME_INFO_0_AST
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ast[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_AST               },
         { "sg-1000",              OPTION_VAL_SG_1000_AST            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_AST         },
         { "mark-III",             OPTION_VAL_MARK_III_AST           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_AST      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_AST   },
         { "game gear",            OPTION_VAL_GAME_GEAR_AST          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_AST },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_AST   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_AST },
         { "pal",     OPTION_VAL_PAL_AST    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_AST },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_AST,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_AST },
         { "per game", OPTION_VAL_PER_GAME_AST },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_AST,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_AST },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_AST },
         { "megasd",       OPTION_VAL_MEGASD_AST },
         { "none",         OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_AST },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_AST },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_AST,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_AST },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_AST },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_AST },
         { "4:3",  OPTION_VAL_4_3_AST },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_AST },
         { "left/right", OPTION_VAL_LEFT_RIGHT_AST },
         { "full",       OPTION_VAL_FULL_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_AST },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_AST },
         { "composite",  OPTION_VAL_COMPOSITE_AST },
         { "svideo",     OPTION_VAL_SVIDEO_AST },
         { "rgb",        OPTION_VAL_RGB_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_AST,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_AST },
         { "double field", OPTION_VAL_DOUBLE_FIELD_AST },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_AST },
         { "manual",   OPTION_VAL_MANUAL_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_AST,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_AST,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_AST },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_AST,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_AST },
         { "nuked", OPTION_VAL_NUKED_AST },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_AST,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_AST,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_AST,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_AST },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_AST },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_AST },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_AST },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_AST },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_AST,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_AST },
         { "mono",   OPTION_VAL_MONO_AST },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_AST,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_AST },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_AST },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_AST,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_AST,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_AST,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_AST },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_AST },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_AST },
         { "125%", OPTION_VAL_125_AST },
         { "150%", OPTION_VAL_150_AST },
         { "175%", OPTION_VAL_175_AST },
         { "200%", OPTION_VAL_200_AST },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_AST,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_AST,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ast = {
   option_cats_ast,
   option_defs_ast
};

/* RETRO_LANGUAGE_CA */

#define CATEGORY_SYSTEM_LABEL_CA NULL
#define CATEGORY_SYSTEM_INFO_0_CA NULL
#define CATEGORY_VIDEO_LABEL_CA "Vídeo"
#define CATEGORY_VIDEO_INFO_0_CA NULL
#define CATEGORY_AUDIO_LABEL_CA "Àudio"
#define CATEGORY_AUDIO_INFO_0_CA NULL
#define CATEGORY_INPUT_LABEL_CA "Dispositius de joc"
#define CATEGORY_INPUT_INFO_0_CA NULL
#define CATEGORY_HACKS_LABEL_CA NULL
#define CATEGORY_HACKS_INFO_0_CA NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CA NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CA NULL
#define OPTION_VAL_AUTO_CA NULL
#define OPTION_VAL_SG_1000_CA NULL
#define OPTION_VAL_SG_1000_II_CA NULL
#define OPTION_VAL_MARK_III_CA NULL
#define OPTION_VAL_MASTER_SYSTEM_CA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CA NULL
#define OPTION_VAL_GAME_GEAR_CA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CA NULL
#define OPTION_VAL_NTSC_U_CA NULL
#define OPTION_VAL_PAL_CA NULL
#define OPTION_VAL_NTSC_J_CA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CA NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_CA NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_CA NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_CA NULL
#define OPTION_VAL_PER_BIOS_CA NULL
#define OPTION_VAL_PER_GAME_CA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CA NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CA NULL
#define OPTION_VAL_SEGA_MEGA_CD_CA NULL
#define OPTION_VAL_MEGASD_CA NULL
#define OPTION_VAL_NONE_CA NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CA NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CA NULL
#define OPTION_VAL_GAME_GENIE_CA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CA NULL
#define OPTION_VAL_SONIC_KNUCKLES_CA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CA NULL
#define OPTION_VAL_NTSC_PAR_CA NULL
#define OPTION_VAL_PAL_PAR_CA NULL
#define OPTION_VAL_4_3_CA NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CA NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CA NULL
#define OPTION_VAL_TOP_BOTTOM_CA NULL
#define OPTION_VAL_LEFT_RIGHT_CA NULL
#define OPTION_VAL_FULL_CA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CA NULL
#define OPTION_VAL_LEFT_BORDER_CA NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CA NULL
#define OPTION_VAL_MONOCHROME_CA NULL
#define OPTION_VAL_COMPOSITE_CA NULL
#define OPTION_VAL_SVIDEO_CA NULL
#define OPTION_VAL_RGB_CA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CA NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_CA NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_CA NULL
#define OPTION_VAL_SINGLE_FIELD_CA NULL
#define OPTION_VAL_DOUBLE_FIELD_CA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CA NULL
#define OPTION_VAL_MANUAL_CA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CA NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_CA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CA NULL
#define OPTION_VAL_MAME_CA NULL
#define OPTION_VAL_NUKED_CA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_CA NULL
#define OPTION_VAL_MAME_YM2612_CA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CA NULL
#define OPTION_VAL_NUKED_YM2612_CA NULL
#define OPTION_VAL_NUKED_YM3438_CA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CA NULL
#define OPTION_VAL_STEREO_CA NULL
#define OPTION_VAL_MONO_CA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CA NULL
#define OPTION_VAL_LOW_PASS_CA NULL
#define OPTION_VAL_EQ_CA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CA NULL
#define OPTION_VAL_LIGHTGUN_CA NULL
#define OPTION_VAL_TOUCHSCREEN_CA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CA NULL
#define OPTION_VAL_100_CA NULL
#define OPTION_VAL_125_CA NULL
#define OPTION_VAL_150_CA NULL
#define OPTION_VAL_175_CA NULL
#define OPTION_VAL_200_CA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CA NULL

struct retro_core_option_v2_category option_cats_ca[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CA,
      CATEGORY_SYSTEM_INFO_0_CA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CA,
      CATEGORY_VIDEO_INFO_0_CA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CA,
      CATEGORY_AUDIO_INFO_0_CA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CA,
      CATEGORY_INPUT_INFO_0_CA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CA,
      CATEGORY_HACKS_INFO_0_CA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ca[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CA               },
         { "sg-1000",              OPTION_VAL_SG_1000_CA            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CA         },
         { "mark-III",             OPTION_VAL_MARK_III_CA           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CA      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CA   },
         { "game gear",            OPTION_VAL_GAME_GEAR_CA          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CA },
         { "pal",     OPTION_VAL_PAL_CA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_CA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CA },
         { "per game", OPTION_VAL_PER_GAME_CA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CA },
         { "megasd",       OPTION_VAL_MEGASD_CA },
         { "none",         OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CA },
         { "4:3",  OPTION_VAL_4_3_CA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CA },
         { "full",       OPTION_VAL_FULL_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CA },
         { "composite",  OPTION_VAL_COMPOSITE_CA },
         { "svideo",     OPTION_VAL_SVIDEO_CA },
         { "rgb",        OPTION_VAL_RGB_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CA },
         { "manual",   OPTION_VAL_MANUAL_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CA },
         { "nuked", OPTION_VAL_NUKED_CA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CA },
         { "mono",   OPTION_VAL_MONO_CA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CA },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_CA },
         { "125%", OPTION_VAL_125_CA },
         { "150%", OPTION_VAL_150_CA },
         { "175%", OPTION_VAL_175_CA },
         { "200%", OPTION_VAL_200_CA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ca = {
   option_cats_ca,
   option_defs_ca
};

/* RETRO_LANGUAGE_CHS */

#define CATEGORY_SYSTEM_LABEL_CHS "系统"
#define CATEGORY_SYSTEM_INFO_0_CHS "更改基础硬件选择、区域、BIOS 和 Sega CD/Mega-CD 保存文件设置。"
#define CATEGORY_VIDEO_LABEL_CHS "视频"
#define CATEGORY_VIDEO_INFO_0_CHS "更改长宽比、显示裁剪、视频过滤和帧跳过设置。"
#define CATEGORY_AUDIO_LABEL_CHS "音频"
#define CATEGORY_AUDIO_INFO_0_CHS "更改音频设备设置。"
#define CATEGORY_INPUT_LABEL_CHS "输入"
#define CATEGORY_INPUT_INFO_0_CHS "更改光枪/鼠标输入设置。"
#define CATEGORY_HACKS_LABEL_CHS "模拟修改"
#define CATEGORY_HACKS_INFO_0_CHS NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CHS "高级频道音量设置"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CHS "更改单个硬件音频频道的音量。"
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHS "系统硬件"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHS "用特定模拟控制台运行已加载的内容。'自动' 将选择当前游戏最合适的系统。"
#define OPTION_VAL_AUTO_CHS "自动"
#define OPTION_VAL_SG_1000_CHS NULL
#define OPTION_VAL_SG_1000_II_CHS NULL
#define OPTION_VAL_MARK_III_CHS NULL
#define OPTION_VAL_MASTER_SYSTEM_CHS NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CHS NULL
#define OPTION_VAL_GAME_GEAR_CHS NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CHS NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHS "系统区域"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHS "指定系统来自哪个区域。对于游戏手势以外的控制台，'PAL'为50赫兹，而'NTSC'为60赫兹。 如果选中不正确的区域，游戏可能会比正常更快或更慢。"
#define OPTION_VAL_NTSC_U_CHS NULL
#define OPTION_VAL_PAL_CHS NULL
#define OPTION_VAL_NTSC_J_CHS NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CHS "系统启动 ROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_CHS "使用官方的 BIOS/bootloader 模拟硬件，如果存在于RetroArch的系统目录中。显示针对控制台的启动序列/动画，然后运行加载内容。"
#define GENESIS_PLUS_GX_BRAM_LABEL_CHS "CD 系统 BRAM"
#define GENESIS_PLUS_GX_BRAM_INFO_0_CHS "运行 Sega CD/Mega-CD 内容时， 指定是在特定区域的所有游戏之间共享单一保存文件(Per-BIOS)，还是为每个游戏创建单独的保存文件(Per-Game)。 请注意，Sega CD/Mega-CD 有有限的内部存储，仅足以提供少数头衔。 为了避免空间不足，建议设置“Per-Game”。"
#define OPTION_VAL_PER_BIOS_CHS "双精度"
#define OPTION_VAL_PER_GAME_CHS "每个游戏"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CHS "CD 附加组件 (MD 模式) (需要重启)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CHS "指定支持的 Mega 驱动器/Genesis 游戏用于CD音频回放的附加组件。"
#define OPTION_VAL_SEGA_MEGA_CD_CHS NULL
#define OPTION_VAL_MEGASD_CHS NULL
#define OPTION_VAL_NONE_CHS "无"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CHS "卡片锁定"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHS "锁定技术是一个 Mega 驱动器/Genesis 功能，它允许旧游戏连接到特殊盒子的传递端口，用于延长或改变游戏。 此选项指定了要模拟的特殊的 '锁定' 墨盒类型。相应的 bios 文件必须存在于RetroArch的系统目录中。"
#define OPTION_VAL_GAME_GENIE_CHS NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CHS "回放(Pro)"
#define OPTION_VAL_SONIC_KNUCKLES_CHS "音速&节拍"
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHS "核心提供的宽高比"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHS "选择首选内容宽高比。这只适用于RetroArch的宽高比设置为视频设置中的“核心提供”。"
#define OPTION_VAL_NTSC_PAR_CHS NULL
#define OPTION_VAL_PAL_PAR_CHS NULL
#define OPTION_VAL_4_3_CHS NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CHS "边框"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHS "启用此选项以显示屏幕顶部/底部和/或左/右侧的覆盖区域。 这些通常被贝塞尔人隐藏在标准定义电视的边缘。"
#define OPTION_VAL_TOP_BOTTOM_CHS "顶部/底部"
#define OPTION_VAL_LEFT_RIGHT_CHS "左/右"
#define OPTION_VAL_FULL_CHS "全双工"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHS "隐藏主系统侧边框"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHS "从屏幕左侧切断8像素，或者在运行主系统游戏时切断左侧和右侧。"
#define OPTION_VAL_LEFT_BORDER_CHS "仅左边框"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CHS "左和右边边界"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHS "游戏装备扩展屏幕"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHS "强制游戏装备标题在短信模式下运行，分辨率增加256x192。 可能会显示额外内容，但通常会显示损坏/不需要的图像数据。"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHS "Blgg NTSC过滤器"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHS "将视频过滤器应用于模仿的各种NTSC电视信号。"
#define OPTION_VAL_MONOCHROME_CHS "黑白"
#define OPTION_VAL_COMPOSITE_CHS "合成"
#define OPTION_VAL_SVIDEO_CHS "S-视频"
#define OPTION_VAL_RGB_CHS NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHS "LCD重影过滤器"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHS "应用图像“ghosting”过滤器来模拟游戏工具和创意Nomad LCD 面板的显示特性。"
#define GENESIS_PLUS_GX_RENDER_LABEL_CHS "交错模式2输出"
#define GENESIS_PLUS_GX_RENDER_INFO_0_CHS "交错模式2允许Mega Drive/Genesis输出双身高度(高分辨率) 320x448图像，绘制备用扫描线路每个帧(这个图像用于音效2和战斗车多人游戏模式)。 “双字段”模拟原始硬件，产生一幅含有闪烁/交错的图像的尖锐图像。 “单个字段”使用去交错过滤器，稳定图像，但造成轻微模糊。"
#define OPTION_VAL_SINGLE_FIELD_CHS "单字节"
#define OPTION_VAL_DOUBLE_FIELD_CHS "双字节"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHS "跳帧"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHS "跳过帧以避免运行下的音频缓冲区(崩溃)。提高性能以牺牲视觉性能。 “自动”跳板帧在前端建议时。“手动”使用了“Frameskip 阈值(%)”设置。"
#define OPTION_VAL_MANUAL_CHS "手工"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHS "跳帧阈值(%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHS "当“跳帧”功能设置成“手动”，请在下方指定跳帧占音频缓存的比例（百分比）。更高的值可以降低因频繁丢帧而导致的爆音风险。"
#define GENESIS_PLUS_GX_YM2413_LABEL_CHS NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CHS "启用特定的 Sega Mark III/Master 系统游戏使用的 FM 声音单元来增强音频输出。"
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHS "Master System FM (YM2413) 核心。"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHS "选择用于模拟Sega Mark III/Master 系统的 FM 声音单元的方法。 “MAME”选项是快速的，在大多数系统上运行全速。 “Nuked”选项是周期准确的，质量很高，并且有大量的 CPU 要求。"
#define OPTION_VAL_MAME_CHS NULL
#define OPTION_VAL_NUKED_CHS "原型"
#define GENESIS_PLUS_GX_YM2612_LABEL_CHS NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CHS "选择用于模拟Mega Drive/Genesis调频合成器(主声音生成器) 的方法。 “MAME”选项是快速的，并在大多数系统上运行全速。 “Nuked”选项是周期准确的，质量很高，并且有大量的 CPU 要求。 YM2612 芯片被原型1 Mega Drive/Genesis使用。YM3438将用于以后的 Mega Drive/Genesis 版本。"
#define GENESIS_PLUS_GX_YM2612_INFO_1_CHS "选择用于模拟Mega Drive/Genesis调频合成器(主声音生成器) 的方法。 YM2612 芯片被原型1 Mega Drive/Genesis使用。YM3438将用于以后的 Mega Drive/Genesis 版本。"
#define OPTION_VAL_MAME_YM2612_CHS NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CHS NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CHS "MAME (增强的 YM3438)"
#define OPTION_VAL_NUKED_YM2612_CHS "原型 (YM2612)"
#define OPTION_VAL_NUKED_YM3438_CHS "原型(YM3438)"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHS "声音输出"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHS "选择立体声或单声道播放。"
#define OPTION_VAL_STEREO_CHS "立体声"
#define OPTION_VAL_MONO_CHS "单声道"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHS "音频过滤器"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHS "启用低通道音频过滤器以更好地模拟模型1 Mega Drive/Genesis的特征声音。"
#define OPTION_VAL_LOW_PASS_CHS "低通滤波器"
#define OPTION_VAL_EQ_CHS "均衡器"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHS "低通滤波器 %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHS "指定音频低通过过滤器的截断频率。 较高的值提高了该过滤器的“强度”，因为高频谱范围更广。"
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHS "PSG 预置级别"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHS "设置模拟SN764964频道可编程声音生成器在SG-1000中的音频前置放大器级别 Sega Mark III, Master System, Game Gear and Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHS "FM 预置级别"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHS "设置模拟Mega 驱动器/Genesis FM声音合成器或 Sega Mark III/Master System FM 声音设备的音频放大器级别。"
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHS "CD-DA 音量"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHS "调整模拟的 CD 音频回放输出的混合音量。"
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHS "PCM 音量"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHS "调整模拟的Sega CD/Mega-CD RF5C164 PCM 声音生成器输出的混合音量。"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHS "低频均衡"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHS "调整内部音频均衡器的低范围波段。"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHS "中频均衡"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHS "调整内部音频均衡器的中间范围波段。"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHS "高频均衡"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHS "调整内部音频均衡器的高范围波段。"
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHS NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHS NULL
#define OPTION_VAL_LIGHTGUN_CHS NULL
#define OPTION_VAL_TOUCHSCREEN_CHS NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHS NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHS NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHS NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHS NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHS NULL
#define OPTION_VAL_100_CHS NULL
#define OPTION_VAL_125_CHS NULL
#define OPTION_VAL_150_CHS NULL
#define OPTION_VAL_175_CHS NULL
#define OPTION_VAL_200_CHS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHS NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHS NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 0 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHS "降低Master System FM 频道0的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 1 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHS "降低Master System FM 频道1的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 2 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHS "降低Master System FM 频道2的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 3 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHS "降低Master System FM 频道3的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHS "Master System FM (YM2413) 频道4 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHS "降低Master System FM 频道4的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 5 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHS "降低Master System FM 频道5的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHS "Master System FM (YM2413) 通道 6 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHS "降低Master System FM 频道6的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHS "Master System FM (YM2413) 频道 7 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHS "降低 Master System FM 频道7 的音量。"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHS "Master System FM (YM2413) 频道 8 音量 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHS "降低Master System FM 频道8 的音量。"

struct retro_core_option_v2_category option_cats_chs[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CHS,
      CATEGORY_SYSTEM_INFO_0_CHS
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHS,
      CATEGORY_VIDEO_INFO_0_CHS
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CHS,
      CATEGORY_AUDIO_INFO_0_CHS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHS,
      CATEGORY_INPUT_INFO_0_CHS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHS,
      CATEGORY_HACKS_INFO_0_CHS
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CHS,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CHS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_chs[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CHS               },
         { "sg-1000",              OPTION_VAL_SG_1000_CHS            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CHS         },
         { "mark-III",             OPTION_VAL_MARK_III_CHS           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CHS      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CHS   },
         { "game gear",            OPTION_VAL_GAME_GEAR_CHS          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CHS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CHS   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CHS },
         { "pal",     OPTION_VAL_PAL_CHS    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CHS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_CHS,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CHS },
         { "per game", OPTION_VAL_PER_GAME_CHS },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CHS,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CHS },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CHS },
         { "megasd",       OPTION_VAL_MEGASD_CHS },
         { "none",         OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CHS },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CHS },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHS,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CHS },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CHS },
         { "4:3",  OPTION_VAL_4_3_CHS },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CHS },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CHS },
         { "full",       OPTION_VAL_FULL_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CHS },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CHS },
         { "composite",  OPTION_VAL_COMPOSITE_CHS },
         { "svideo",     OPTION_VAL_SVIDEO_CHS },
         { "rgb",        OPTION_VAL_RGB_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CHS },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CHS },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "manual",   OPTION_VAL_MANUAL_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHS,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CHS },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CHS },
         { "nuked", OPTION_VAL_NUKED_CHS },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CHS,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CHS,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CHS,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CHS },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CHS },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CHS },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CHS },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CHS },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CHS },
         { "mono",   OPTION_VAL_MONO_CHS },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CHS },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CHS },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHS,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CHS },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CHS },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_CHS },
         { "125%", OPTION_VAL_125_CHS },
         { "150%", OPTION_VAL_150_CHS },
         { "175%", OPTION_VAL_175_CHS },
         { "200%", OPTION_VAL_200_CHS },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_chs = {
   option_cats_chs,
   option_defs_chs
};

/* RETRO_LANGUAGE_CHT */

#define CATEGORY_SYSTEM_LABEL_CHT "系統"
#define CATEGORY_SYSTEM_INFO_0_CHT NULL
#define CATEGORY_VIDEO_LABEL_CHT "視訊"
#define CATEGORY_VIDEO_INFO_0_CHT "變更長寬比，影像裁切，影像濾鏡以及跳幀設定"
#define CATEGORY_AUDIO_LABEL_CHT "音訊"
#define CATEGORY_AUDIO_INFO_0_CHT NULL
#define CATEGORY_INPUT_LABEL_CHT "輸入"
#define CATEGORY_INPUT_INFO_0_CHT NULL
#define CATEGORY_HACKS_LABEL_CHT NULL
#define CATEGORY_HACKS_INFO_0_CHT NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CHT NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHT "系統硬體"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHT NULL
#define OPTION_VAL_AUTO_CHT "自動"
#define OPTION_VAL_SG_1000_CHT NULL
#define OPTION_VAL_SG_1000_II_CHT NULL
#define OPTION_VAL_MARK_III_CHT NULL
#define OPTION_VAL_MASTER_SYSTEM_CHT NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CHT NULL
#define OPTION_VAL_GAME_GEAR_CHT NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CHT NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHT "系統區域"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHT NULL
#define OPTION_VAL_NTSC_U_CHT NULL
#define OPTION_VAL_PAL_CHT NULL
#define OPTION_VAL_NTSC_J_CHT NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CHT NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_CHT NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_CHT NULL
#define OPTION_VAL_PER_BIOS_CHT NULL
#define OPTION_VAL_PER_GAME_CHT NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CHT NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CHT NULL
#define OPTION_VAL_SEGA_MEGA_CD_CHT NULL
#define OPTION_VAL_MEGASD_CHT NULL
#define OPTION_VAL_NONE_CHT "無"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHT NULL
#define OPTION_VAL_GAME_GENIE_CHT NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CHT NULL
#define OPTION_VAL_SONIC_KNUCKLES_CHT NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHT NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHT NULL
#define OPTION_VAL_NTSC_PAR_CHT NULL
#define OPTION_VAL_PAL_PAR_CHT NULL
#define OPTION_VAL_4_3_CHT NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CHT "邊框"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHT NULL
#define OPTION_VAL_TOP_BOTTOM_CHT "頂/底"
#define OPTION_VAL_LEFT_RIGHT_CHT NULL
#define OPTION_VAL_FULL_CHT NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHT NULL
#define OPTION_VAL_LEFT_BORDER_CHT NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CHT NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHT NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHT NULL
#define OPTION_VAL_MONOCHROME_CHT NULL
#define OPTION_VAL_COMPOSITE_CHT NULL
#define OPTION_VAL_SVIDEO_CHT NULL
#define OPTION_VAL_RGB_CHT NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_CHT NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_CHT NULL
#define OPTION_VAL_SINGLE_FIELD_CHT NULL
#define OPTION_VAL_DOUBLE_FIELD_CHT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHT NULL
#define OPTION_VAL_MANUAL_CHT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_CHT NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHT "Master System FM (YM2413) 核心"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHT NULL
#define OPTION_VAL_MAME_CHT NULL
#define OPTION_VAL_NUKED_CHT NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CHT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_CHT NULL
#define OPTION_VAL_MAME_YM2612_CHT NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CHT NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CHT NULL
#define OPTION_VAL_NUKED_YM2612_CHT NULL
#define OPTION_VAL_NUKED_YM3438_CHT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHT NULL
#define OPTION_VAL_STEREO_CHT "立體聲"
#define OPTION_VAL_MONO_CHT "單聲道"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHT "音訊過濾器"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHT NULL
#define OPTION_VAL_LOW_PASS_CHT NULL
#define OPTION_VAL_EQ_CHT "等化器"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHT NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHT "光線槍輸入"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHT NULL
#define OPTION_VAL_LIGHTGUN_CHT "光線槍"
#define OPTION_VAL_TOUCHSCREEN_CHT "觸控螢幕"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHT NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHT NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHT NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHT NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHT NULL
#define OPTION_VAL_100_CHT NULL
#define OPTION_VAL_125_CHT NULL
#define OPTION_VAL_150_CHT NULL
#define OPTION_VAL_175_CHT NULL
#define OPTION_VAL_200_CHT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHT "68K 位置錯誤"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHT NULL

struct retro_core_option_v2_category option_cats_cht[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CHT,
      CATEGORY_SYSTEM_INFO_0_CHT
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHT,
      CATEGORY_VIDEO_INFO_0_CHT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CHT,
      CATEGORY_AUDIO_INFO_0_CHT
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHT,
      CATEGORY_INPUT_INFO_0_CHT
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHT,
      CATEGORY_HACKS_INFO_0_CHT
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CHT,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CHT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cht[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CHT               },
         { "sg-1000",              OPTION_VAL_SG_1000_CHT            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CHT         },
         { "mark-III",             OPTION_VAL_MARK_III_CHT           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CHT      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CHT   },
         { "game gear",            OPTION_VAL_GAME_GEAR_CHT          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CHT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CHT   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CHT },
         { "pal",     OPTION_VAL_PAL_CHT    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CHT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_CHT,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CHT },
         { "per game", OPTION_VAL_PER_GAME_CHT },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CHT,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CHT },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CHT },
         { "megasd",       OPTION_VAL_MEGASD_CHT },
         { "none",         OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CHT },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CHT },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CHT,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CHT },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CHT },
         { "4:3",  OPTION_VAL_4_3_CHT },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CHT },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CHT },
         { "full",       OPTION_VAL_FULL_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CHT },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CHT },
         { "composite",  OPTION_VAL_COMPOSITE_CHT },
         { "svideo",     OPTION_VAL_SVIDEO_CHT },
         { "rgb",        OPTION_VAL_RGB_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CHT },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CHT },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "manual",   OPTION_VAL_MANUAL_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CHT,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CHT },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CHT },
         { "nuked", OPTION_VAL_NUKED_CHT },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CHT,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CHT,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CHT,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CHT },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CHT },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CHT },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CHT },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CHT },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CHT },
         { "mono",   OPTION_VAL_MONO_CHT },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CHT },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CHT },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CHT,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CHT },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CHT },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_CHT },
         { "125%", OPTION_VAL_125_CHT },
         { "150%", OPTION_VAL_150_CHT },
         { "175%", OPTION_VAL_175_CHT },
         { "200%", OPTION_VAL_200_CHT },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CHT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CHT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cht = {
   option_cats_cht,
   option_defs_cht
};

/* RETRO_LANGUAGE_CS */

#define CATEGORY_SYSTEM_LABEL_CS NULL
#define CATEGORY_SYSTEM_INFO_0_CS NULL
#define CATEGORY_VIDEO_LABEL_CS NULL
#define CATEGORY_VIDEO_INFO_0_CS NULL
#define CATEGORY_AUDIO_LABEL_CS "Zvuk"
#define CATEGORY_AUDIO_INFO_0_CS NULL
#define CATEGORY_INPUT_LABEL_CS "Vstup"
#define CATEGORY_INPUT_INFO_0_CS NULL
#define CATEGORY_HACKS_LABEL_CS NULL
#define CATEGORY_HACKS_INFO_0_CS NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CS NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CS NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CS NULL
#define OPTION_VAL_AUTO_CS NULL
#define OPTION_VAL_SG_1000_CS NULL
#define OPTION_VAL_SG_1000_II_CS NULL
#define OPTION_VAL_MARK_III_CS NULL
#define OPTION_VAL_MASTER_SYSTEM_CS NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CS NULL
#define OPTION_VAL_GAME_GEAR_CS NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CS NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CS NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CS NULL
#define OPTION_VAL_NTSC_U_CS NULL
#define OPTION_VAL_PAL_CS NULL
#define OPTION_VAL_NTSC_J_CS NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CS NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_CS NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_CS NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_CS NULL
#define OPTION_VAL_PER_BIOS_CS NULL
#define OPTION_VAL_PER_GAME_CS NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CS NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CS NULL
#define OPTION_VAL_SEGA_MEGA_CD_CS NULL
#define OPTION_VAL_MEGASD_CS NULL
#define OPTION_VAL_NONE_CS NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CS NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CS NULL
#define OPTION_VAL_GAME_GENIE_CS NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CS NULL
#define OPTION_VAL_SONIC_KNUCKLES_CS NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CS NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CS NULL
#define OPTION_VAL_NTSC_PAR_CS NULL
#define OPTION_VAL_PAL_PAR_CS NULL
#define OPTION_VAL_4_3_CS NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CS NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CS NULL
#define OPTION_VAL_TOP_BOTTOM_CS NULL
#define OPTION_VAL_LEFT_RIGHT_CS NULL
#define OPTION_VAL_FULL_CS NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CS NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CS NULL
#define OPTION_VAL_LEFT_BORDER_CS NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CS NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CS NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CS NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CS NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CS NULL
#define OPTION_VAL_MONOCHROME_CS NULL
#define OPTION_VAL_COMPOSITE_CS NULL
#define OPTION_VAL_SVIDEO_CS NULL
#define OPTION_VAL_RGB_CS NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CS NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CS NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_CS NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_CS NULL
#define OPTION_VAL_SINGLE_FIELD_CS NULL
#define OPTION_VAL_DOUBLE_FIELD_CS NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CS NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CS NULL
#define OPTION_VAL_MANUAL_CS NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CS NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CS NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_CS NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CS NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CS NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CS NULL
#define OPTION_VAL_MAME_CS NULL
#define OPTION_VAL_NUKED_CS NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CS NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CS NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_CS NULL
#define OPTION_VAL_MAME_YM2612_CS NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CS NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CS NULL
#define OPTION_VAL_NUKED_YM2612_CS NULL
#define OPTION_VAL_NUKED_YM3438_CS NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CS NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CS NULL
#define OPTION_VAL_STEREO_CS NULL
#define OPTION_VAL_MONO_CS NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CS NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CS NULL
#define OPTION_VAL_LOW_PASS_CS NULL
#define OPTION_VAL_EQ_CS NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CS NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CS NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CS NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CS NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CS NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CS NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CS NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CS NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CS NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CS NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CS NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CS NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CS NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CS NULL
#define OPTION_VAL_LIGHTGUN_CS NULL
#define OPTION_VAL_TOUCHSCREEN_CS NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CS NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CS NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CS NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CS NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CS NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CS NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CS NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CS NULL
#define OPTION_VAL_100_CS NULL
#define OPTION_VAL_125_CS NULL
#define OPTION_VAL_150_CS NULL
#define OPTION_VAL_175_CS NULL
#define OPTION_VAL_200_CS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CS NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CS NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CS NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CS NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CS NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CS NULL

struct retro_core_option_v2_category option_cats_cs[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CS,
      CATEGORY_SYSTEM_INFO_0_CS
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CS,
      CATEGORY_VIDEO_INFO_0_CS
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CS,
      CATEGORY_AUDIO_INFO_0_CS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CS,
      CATEGORY_INPUT_INFO_0_CS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CS,
      CATEGORY_HACKS_INFO_0_CS
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CS,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cs[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CS               },
         { "sg-1000",              OPTION_VAL_SG_1000_CS            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CS         },
         { "mark-III",             OPTION_VAL_MARK_III_CS           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CS      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CS   },
         { "game gear",            OPTION_VAL_GAME_GEAR_CS          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CS   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CS },
         { "pal",     OPTION_VAL_PAL_CS    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CS },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_CS,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CS },
         { "per game", OPTION_VAL_PER_GAME_CS },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CS,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CS },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CS },
         { "megasd",       OPTION_VAL_MEGASD_CS },
         { "none",         OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CS },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CS },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CS,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CS },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CS },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CS },
         { "4:3",  OPTION_VAL_4_3_CS },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CS },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CS },
         { "full",       OPTION_VAL_FULL_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CS },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CS },
         { "composite",  OPTION_VAL_COMPOSITE_CS },
         { "svideo",     OPTION_VAL_SVIDEO_CS },
         { "rgb",        OPTION_VAL_RGB_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CS,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CS },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CS },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CS },
         { "manual",   OPTION_VAL_MANUAL_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CS,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CS,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CS },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CS,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CS },
         { "nuked", OPTION_VAL_NUKED_CS },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CS,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CS,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CS,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CS },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CS },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CS },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CS },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CS },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CS,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CS },
         { "mono",   OPTION_VAL_MONO_CS },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CS,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CS },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CS },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CS,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CS,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CS,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CS },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CS },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_CS },
         { "125%", OPTION_VAL_125_CS },
         { "150%", OPTION_VAL_150_CS },
         { "175%", OPTION_VAL_175_CS },
         { "200%", OPTION_VAL_200_CS },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CS,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CS,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cs = {
   option_cats_cs,
   option_defs_cs
};

/* RETRO_LANGUAGE_CY */

#define CATEGORY_SYSTEM_LABEL_CY NULL
#define CATEGORY_SYSTEM_INFO_0_CY NULL
#define CATEGORY_VIDEO_LABEL_CY NULL
#define CATEGORY_VIDEO_INFO_0_CY NULL
#define CATEGORY_AUDIO_LABEL_CY NULL
#define CATEGORY_AUDIO_INFO_0_CY NULL
#define CATEGORY_INPUT_LABEL_CY "Mewnbwn"
#define CATEGORY_INPUT_INFO_0_CY NULL
#define CATEGORY_HACKS_LABEL_CY NULL
#define CATEGORY_HACKS_INFO_0_CY NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_CY NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CY NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CY NULL
#define OPTION_VAL_AUTO_CY NULL
#define OPTION_VAL_SG_1000_CY NULL
#define OPTION_VAL_SG_1000_II_CY NULL
#define OPTION_VAL_MARK_III_CY NULL
#define OPTION_VAL_MASTER_SYSTEM_CY NULL
#define OPTION_VAL_MASTER_SYSTEM_II_CY NULL
#define OPTION_VAL_GAME_GEAR_CY NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_CY NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_CY NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CY NULL
#define OPTION_VAL_NTSC_U_CY NULL
#define OPTION_VAL_PAL_CY NULL
#define OPTION_VAL_NTSC_J_CY NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_CY NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_CY NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_CY NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_CY NULL
#define OPTION_VAL_PER_BIOS_CY NULL
#define OPTION_VAL_PER_GAME_CY NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_CY NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_CY NULL
#define OPTION_VAL_SEGA_MEGA_CD_CY NULL
#define OPTION_VAL_MEGASD_CY NULL
#define OPTION_VAL_NONE_CY "Dim"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_CY NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_CY NULL
#define OPTION_VAL_GAME_GENIE_CY NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_CY NULL
#define OPTION_VAL_SONIC_KNUCKLES_CY NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CY NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CY NULL
#define OPTION_VAL_NTSC_PAR_CY NULL
#define OPTION_VAL_PAL_PAR_CY NULL
#define OPTION_VAL_4_3_CY NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_CY NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_CY NULL
#define OPTION_VAL_TOP_BOTTOM_CY NULL
#define OPTION_VAL_LEFT_RIGHT_CY NULL
#define OPTION_VAL_FULL_CY NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CY NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CY NULL
#define OPTION_VAL_LEFT_BORDER_CY NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_CY NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_CY NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CY NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CY NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CY NULL
#define OPTION_VAL_MONOCHROME_CY NULL
#define OPTION_VAL_COMPOSITE_CY NULL
#define OPTION_VAL_SVIDEO_CY NULL
#define OPTION_VAL_RGB_CY NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_CY NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CY NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_CY NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_CY NULL
#define OPTION_VAL_SINGLE_FIELD_CY NULL
#define OPTION_VAL_DOUBLE_FIELD_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CY NULL
#define OPTION_VAL_MANUAL_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CY NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CY "Pan fydd 'Frameskip' yn cael ei osod i 'Manual', yn pennu'r trothwy meddiannaeth byffer sain (canran) islaw y bydd fframiau yn cael eu hepgor. Mae gwerthoedd uwch yn lleihau'r risg o graclo trwy achosi i fframiau ostwng yn amlach."
#define GENESIS_PLUS_GX_YM2413_LABEL_CY NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_CY NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_CY NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CY NULL
#define OPTION_VAL_MAME_CY NULL
#define OPTION_VAL_NUKED_CY NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_CY NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_CY NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_CY NULL
#define OPTION_VAL_MAME_YM2612_CY NULL
#define OPTION_VAL_MAME_ASIC_YM3438_CY NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_CY NULL
#define OPTION_VAL_NUKED_YM2612_CY NULL
#define OPTION_VAL_NUKED_YM3438_CY NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CY NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CY NULL
#define OPTION_VAL_STEREO_CY NULL
#define OPTION_VAL_MONO_CY NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CY NULL
#define OPTION_VAL_LOW_PASS_CY NULL
#define OPTION_VAL_EQ_CY NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CY NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CY NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_CY NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CY NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CY NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CY NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_CY NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CY NULL
#define OPTION_VAL_LIGHTGUN_CY NULL
#define OPTION_VAL_TOUCHSCREEN_CY NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CY NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CY NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CY NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CY NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CY NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CY NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_CY NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CY NULL
#define OPTION_VAL_100_CY NULL
#define OPTION_VAL_125_CY NULL
#define OPTION_VAL_150_CY NULL
#define OPTION_VAL_175_CY NULL
#define OPTION_VAL_200_CY NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CY NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CY NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CY NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CY NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CY NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CY NULL

struct retro_core_option_v2_category option_cats_cy[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CY,
      CATEGORY_SYSTEM_INFO_0_CY
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CY,
      CATEGORY_VIDEO_INFO_0_CY
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CY,
      CATEGORY_AUDIO_INFO_0_CY
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CY,
      CATEGORY_INPUT_INFO_0_CY
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CY,
      CATEGORY_HACKS_INFO_0_CY
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_CY,
      CATEGORY_CHANNEL_VOLUME_INFO_0_CY
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cy[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_CY               },
         { "sg-1000",              OPTION_VAL_SG_1000_CY            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_CY         },
         { "mark-III",             OPTION_VAL_MARK_III_CY           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_CY      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_CY   },
         { "game gear",            OPTION_VAL_GAME_GEAR_CY          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_CY },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_CY   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_CY },
         { "pal",     OPTION_VAL_PAL_CY    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_CY },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_CY,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_CY },
         { "per game", OPTION_VAL_PER_GAME_CY },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_CY,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_CY },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_CY },
         { "megasd",       OPTION_VAL_MEGASD_CY },
         { "none",         OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_CY },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_CY },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_CY,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_CY },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_CY },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_CY },
         { "4:3",  OPTION_VAL_4_3_CY },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_CY },
         { "left/right", OPTION_VAL_LEFT_RIGHT_CY },
         { "full",       OPTION_VAL_FULL_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_CY },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_CY },
         { "composite",  OPTION_VAL_COMPOSITE_CY },
         { "svideo",     OPTION_VAL_SVIDEO_CY },
         { "rgb",        OPTION_VAL_RGB_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_CY,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_CY },
         { "double field", OPTION_VAL_DOUBLE_FIELD_CY },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_CY },
         { "manual",   OPTION_VAL_MANUAL_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_CY,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_CY,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_CY },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_CY,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_CY },
         { "nuked", OPTION_VAL_NUKED_CY },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_CY,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_CY,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_CY,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_CY },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_CY },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_CY },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_CY },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_CY },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_CY,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_CY },
         { "mono",   OPTION_VAL_MONO_CY },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_CY,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_CY },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_CY },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_CY,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_CY,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_CY,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CY },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CY },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_CY },
         { "125%", OPTION_VAL_125_CY },
         { "150%", OPTION_VAL_150_CY },
         { "175%", OPTION_VAL_175_CY },
         { "200%", OPTION_VAL_200_CY },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_CY,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_CY,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cy = {
   option_cats_cy,
   option_defs_cy
};

/* RETRO_LANGUAGE_DA */

#define CATEGORY_SYSTEM_LABEL_DA NULL
#define CATEGORY_SYSTEM_INFO_0_DA NULL
#define CATEGORY_VIDEO_LABEL_DA NULL
#define CATEGORY_VIDEO_INFO_0_DA NULL
#define CATEGORY_AUDIO_LABEL_DA "Lyd"
#define CATEGORY_AUDIO_INFO_0_DA NULL
#define CATEGORY_INPUT_LABEL_DA NULL
#define CATEGORY_INPUT_INFO_0_DA NULL
#define CATEGORY_HACKS_LABEL_DA NULL
#define CATEGORY_HACKS_INFO_0_DA NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_DA NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DA NULL
#define OPTION_VAL_AUTO_DA NULL
#define OPTION_VAL_SG_1000_DA NULL
#define OPTION_VAL_SG_1000_II_DA NULL
#define OPTION_VAL_MARK_III_DA NULL
#define OPTION_VAL_MASTER_SYSTEM_DA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_DA NULL
#define OPTION_VAL_GAME_GEAR_DA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_DA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_DA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DA NULL
#define OPTION_VAL_NTSC_U_DA NULL
#define OPTION_VAL_PAL_DA NULL
#define OPTION_VAL_NTSC_J_DA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_DA NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_DA NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_DA NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_DA NULL
#define OPTION_VAL_PER_BIOS_DA NULL
#define OPTION_VAL_PER_GAME_DA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_DA NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_DA NULL
#define OPTION_VAL_SEGA_MEGA_CD_DA NULL
#define OPTION_VAL_MEGASD_DA NULL
#define OPTION_VAL_NONE_DA NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_DA NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_DA NULL
#define OPTION_VAL_GAME_GENIE_DA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_DA NULL
#define OPTION_VAL_SONIC_KNUCKLES_DA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DA NULL
#define OPTION_VAL_NTSC_PAR_DA NULL
#define OPTION_VAL_PAL_PAR_DA NULL
#define OPTION_VAL_4_3_DA NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_DA NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_DA NULL
#define OPTION_VAL_TOP_BOTTOM_DA NULL
#define OPTION_VAL_LEFT_RIGHT_DA NULL
#define OPTION_VAL_FULL_DA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DA NULL
#define OPTION_VAL_LEFT_BORDER_DA NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_DA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_DA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DA NULL
#define OPTION_VAL_MONOCHROME_DA NULL
#define OPTION_VAL_COMPOSITE_DA NULL
#define OPTION_VAL_SVIDEO_DA NULL
#define OPTION_VAL_RGB_DA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_DA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DA NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_DA NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_DA NULL
#define OPTION_VAL_SINGLE_FIELD_DA NULL
#define OPTION_VAL_DOUBLE_FIELD_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DA NULL
#define OPTION_VAL_MANUAL_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DA "Når 'Frameskip' er sat til 'Manual', angiver den lydbufferbelægningstærsklen (procentdel), under hvilken frames overspringes. Højere værdier reducerer risikoen for crackling ved at foranledige hyppigere drop af frames."
#define GENESIS_PLUS_GX_YM2413_LABEL_DA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_DA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_DA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DA NULL
#define OPTION_VAL_MAME_DA NULL
#define OPTION_VAL_NUKED_DA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_DA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_DA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_DA NULL
#define OPTION_VAL_MAME_YM2612_DA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_DA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_DA NULL
#define OPTION_VAL_NUKED_YM2612_DA NULL
#define OPTION_VAL_NUKED_YM3438_DA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DA NULL
#define OPTION_VAL_STEREO_DA NULL
#define OPTION_VAL_MONO_DA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DA NULL
#define OPTION_VAL_LOW_PASS_DA NULL
#define OPTION_VAL_EQ_DA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_DA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_DA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DA NULL
#define OPTION_VAL_LIGHTGUN_DA NULL
#define OPTION_VAL_TOUCHSCREEN_DA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_DA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DA NULL
#define OPTION_VAL_100_DA NULL
#define OPTION_VAL_125_DA NULL
#define OPTION_VAL_150_DA NULL
#define OPTION_VAL_175_DA NULL
#define OPTION_VAL_200_DA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DA NULL

struct retro_core_option_v2_category option_cats_da[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_DA,
      CATEGORY_SYSTEM_INFO_0_DA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_DA,
      CATEGORY_VIDEO_INFO_0_DA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_DA,
      CATEGORY_AUDIO_INFO_0_DA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DA,
      CATEGORY_INPUT_INFO_0_DA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DA,
      CATEGORY_HACKS_INFO_0_DA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_DA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_DA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_da[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_DA               },
         { "sg-1000",              OPTION_VAL_SG_1000_DA            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_DA         },
         { "mark-III",             OPTION_VAL_MARK_III_DA           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_DA      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_DA   },
         { "game gear",            OPTION_VAL_GAME_GEAR_DA          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_DA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_DA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_DA },
         { "pal",     OPTION_VAL_PAL_DA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_DA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_DA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_DA },
         { "per game", OPTION_VAL_PER_GAME_DA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_DA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_DA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_DA },
         { "megasd",       OPTION_VAL_MEGASD_DA },
         { "none",         OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_DA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_DA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_DA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_DA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_DA },
         { "4:3",  OPTION_VAL_4_3_DA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_DA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_DA },
         { "full",       OPTION_VAL_FULL_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_DA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_DA },
         { "composite",  OPTION_VAL_COMPOSITE_DA },
         { "svideo",     OPTION_VAL_SVIDEO_DA },
         { "rgb",        OPTION_VAL_RGB_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_DA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_DA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_DA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_DA },
         { "manual",   OPTION_VAL_MANUAL_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_DA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_DA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_DA },
         { "nuked", OPTION_VAL_NUKED_DA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_DA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_DA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_DA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_DA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_DA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_DA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_DA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_DA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_DA },
         { "mono",   OPTION_VAL_MONO_DA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_DA },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_DA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_DA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_DA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_DA },
         { "125%", OPTION_VAL_125_DA },
         { "150%", OPTION_VAL_150_DA },
         { "175%", OPTION_VAL_175_DA },
         { "200%", OPTION_VAL_200_DA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_da = {
   option_cats_da,
   option_defs_da
};

/* RETRO_LANGUAGE_DE */

#define CATEGORY_SYSTEM_LABEL_DE NULL
#define CATEGORY_SYSTEM_INFO_0_DE NULL
#define CATEGORY_VIDEO_LABEL_DE NULL
#define CATEGORY_VIDEO_INFO_0_DE NULL
#define CATEGORY_AUDIO_LABEL_DE NULL
#define CATEGORY_AUDIO_INFO_0_DE "Audiogerät-Einstellungen ändern."
#define CATEGORY_INPUT_LABEL_DE "Eingabe"
#define CATEGORY_INPUT_INFO_0_DE NULL
#define CATEGORY_HACKS_LABEL_DE "Emulations-Hacks"
#define CATEGORY_HACKS_INFO_0_DE NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_DE "Erweiterte Lautstärkeeinstellungen"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DE "System-Hardware"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DE NULL
#define OPTION_VAL_AUTO_DE NULL
#define OPTION_VAL_SG_1000_DE NULL
#define OPTION_VAL_SG_1000_II_DE NULL
#define OPTION_VAL_MARK_III_DE NULL
#define OPTION_VAL_MASTER_SYSTEM_DE NULL
#define OPTION_VAL_MASTER_SYSTEM_II_DE NULL
#define OPTION_VAL_GAME_GEAR_DE NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_DE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_DE "Systemregion"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DE NULL
#define OPTION_VAL_NTSC_U_DE NULL
#define OPTION_VAL_PAL_DE NULL
#define OPTION_VAL_NTSC_J_DE NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_DE NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_DE NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_DE NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_DE NULL
#define OPTION_VAL_PER_BIOS_DE "Pro BIOS"
#define OPTION_VAL_PER_GAME_DE "Pro Spiel"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_DE NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_DE NULL
#define OPTION_VAL_SEGA_MEGA_CD_DE NULL
#define OPTION_VAL_MEGASD_DE NULL
#define OPTION_VAL_NONE_DE "Keins"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_DE NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_DE NULL
#define OPTION_VAL_GAME_GENIE_DE NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_DE NULL
#define OPTION_VAL_SONIC_KNUCKLES_DE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DE "Core-Bereitgestelltes Seitenverhältnis"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DE "Das bevorzugte Seitenverhältnis des Inhalts auswählen. Dies wird nur angewendet, wenn das Seitenverhältnis von RetroArch in den Videoeinstellungen auf \"Core-bestimmtes Seitenverhältnis\" eingestellt ist."
#define OPTION_VAL_NTSC_PAR_DE NULL
#define OPTION_VAL_PAL_PAR_DE NULL
#define OPTION_VAL_4_3_DE NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_DE NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_DE NULL
#define OPTION_VAL_TOP_BOTTOM_DE "Oben/Unten"
#define OPTION_VAL_LEFT_RIGHT_DE "Links/Rechts"
#define OPTION_VAL_FULL_DE NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DE NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DE NULL
#define OPTION_VAL_LEFT_BORDER_DE NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_DE NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_DE NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DE NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DE NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DE NULL
#define OPTION_VAL_MONOCHROME_DE "Monochrom"
#define OPTION_VAL_COMPOSITE_DE NULL
#define OPTION_VAL_SVIDEO_DE NULL
#define OPTION_VAL_RGB_DE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_DE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DE NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_DE NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_DE NULL
#define OPTION_VAL_SINGLE_FIELD_DE NULL
#define OPTION_VAL_DOUBLE_FIELD_DE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_DE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DE "Überspringen Sie Frames um zu vermeiden, dass Audio-Puffer unterlaufen (Knistern). Verbessert die Leistung auf Kosten der visuellen Glätte. 'Auto' überspringt Frames wenn vom Frontend empfohlen wird. 'Manuell' verwendet die Einstellung 'Frameskip Grenzwert (%)'."
#define OPTION_VAL_MANUAL_DE "Manuell"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DE "Frameskip Grenzwert (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DE "Gibt den Audiopuffer-Belegungsschwellenwert (Prozent) an, unter dem Frames übersprungen werden, wenn 'Frameskip' auf 'Manual' eingestellt ist. Höhere Werte verringern das Risiko von Knistern, da Frames häufiger weggelassen werden."
#define GENESIS_PLUS_GX_YM2413_LABEL_DE NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_DE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_DE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DE NULL
#define OPTION_VAL_MAME_DE NULL
#define OPTION_VAL_NUKED_DE NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_DE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_DE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_DE NULL
#define OPTION_VAL_MAME_YM2612_DE NULL
#define OPTION_VAL_MAME_ASIC_YM3438_DE NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_DE NULL
#define OPTION_VAL_NUKED_YM2612_DE NULL
#define OPTION_VAL_NUKED_YM3438_DE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DE "Tonausgabe"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DE NULL
#define OPTION_VAL_STEREO_DE NULL
#define OPTION_VAL_MONO_DE NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DE "Audiofilter"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DE NULL
#define OPTION_VAL_LOW_PASS_DE "Tiefpass"
#define OPTION_VAL_EQ_DE NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DE "Tiefpassfilter %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DE NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DE NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DE NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_DE NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DE NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DE NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_DE NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DE NULL
#define OPTION_VAL_LIGHTGUN_DE NULL
#define OPTION_VAL_TOUCHSCREEN_DE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DE NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DE NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DE NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DE NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DE NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_DE "CPU-Geschwindigkeit"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DE NULL
#define OPTION_VAL_100_DE "100 %"
#define OPTION_VAL_125_DE "125 %"
#define OPTION_VAL_150_DE "150 %"
#define OPTION_VAL_175_DE "175 %"
#define OPTION_VAL_200_DE "200 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DE NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DE NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DE NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DE NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DE NULL

struct retro_core_option_v2_category option_cats_de[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_DE,
      CATEGORY_SYSTEM_INFO_0_DE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_DE,
      CATEGORY_VIDEO_INFO_0_DE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_DE,
      CATEGORY_AUDIO_INFO_0_DE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DE,
      CATEGORY_INPUT_INFO_0_DE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DE,
      CATEGORY_HACKS_INFO_0_DE
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_DE,
      CATEGORY_CHANNEL_VOLUME_INFO_0_DE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_de[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_DE               },
         { "sg-1000",              OPTION_VAL_SG_1000_DE            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_DE         },
         { "mark-III",             OPTION_VAL_MARK_III_DE           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_DE      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_DE   },
         { "game gear",            OPTION_VAL_GAME_GEAR_DE          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_DE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_DE   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_DE },
         { "pal",     OPTION_VAL_PAL_DE    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_DE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_DE,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_DE },
         { "per game", OPTION_VAL_PER_GAME_DE },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_DE,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_DE },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_DE },
         { "megasd",       OPTION_VAL_MEGASD_DE },
         { "none",         OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_DE },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_DE },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_DE,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_DE },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_DE },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_DE },
         { "4:3",  OPTION_VAL_4_3_DE },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_DE },
         { "left/right", OPTION_VAL_LEFT_RIGHT_DE },
         { "full",       OPTION_VAL_FULL_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_DE },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_DE },
         { "composite",  OPTION_VAL_COMPOSITE_DE },
         { "svideo",     OPTION_VAL_SVIDEO_DE },
         { "rgb",        OPTION_VAL_RGB_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_DE,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_DE },
         { "double field", OPTION_VAL_DOUBLE_FIELD_DE },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_DE },
         { "manual",   OPTION_VAL_MANUAL_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_DE,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_DE,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_DE },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_DE,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_DE },
         { "nuked", OPTION_VAL_NUKED_DE },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_DE,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_DE,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_DE,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_DE },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_DE },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_DE },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_DE },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_DE },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_DE,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_DE },
         { "mono",   OPTION_VAL_MONO_DE },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_DE,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_DE },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_DE },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_DE,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_DE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_DE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_DE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_DE },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_DE },
         { "125%", OPTION_VAL_125_DE },
         { "150%", OPTION_VAL_150_DE },
         { "175%", OPTION_VAL_175_DE },
         { "200%", OPTION_VAL_200_DE },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_DE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_DE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_de = {
   option_cats_de,
   option_defs_de
};

/* RETRO_LANGUAGE_EL */

#define CATEGORY_SYSTEM_LABEL_EL "Σύστημα"
#define CATEGORY_SYSTEM_INFO_0_EL NULL
#define CATEGORY_VIDEO_LABEL_EL "Οδηγός Βίντεο"
#define CATEGORY_VIDEO_INFO_0_EL NULL
#define CATEGORY_AUDIO_LABEL_EL "Οδηγός Ήχου"
#define CATEGORY_AUDIO_INFO_0_EL NULL
#define CATEGORY_INPUT_LABEL_EL "Οδηγός Εισαγωγής"
#define CATEGORY_INPUT_INFO_0_EL NULL
#define CATEGORY_HACKS_LABEL_EL NULL
#define CATEGORY_HACKS_INFO_0_EL NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_EL NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EL NULL
#define OPTION_VAL_AUTO_EL "Αυτόματο"
#define OPTION_VAL_SG_1000_EL NULL
#define OPTION_VAL_SG_1000_II_EL NULL
#define OPTION_VAL_MARK_III_EL NULL
#define OPTION_VAL_MASTER_SYSTEM_EL NULL
#define OPTION_VAL_MASTER_SYSTEM_II_EL NULL
#define OPTION_VAL_GAME_GEAR_EL NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_EL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_EL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EL NULL
#define OPTION_VAL_NTSC_U_EL NULL
#define OPTION_VAL_PAL_EL NULL
#define OPTION_VAL_NTSC_J_EL NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_EL NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_EL NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_EL NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_EL NULL
#define OPTION_VAL_PER_BIOS_EL NULL
#define OPTION_VAL_PER_GAME_EL NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_EL NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_EL NULL
#define OPTION_VAL_SEGA_MEGA_CD_EL NULL
#define OPTION_VAL_MEGASD_EL NULL
#define OPTION_VAL_NONE_EL "Κανείς"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_EL NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_EL NULL
#define OPTION_VAL_GAME_GENIE_EL NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_EL NULL
#define OPTION_VAL_SONIC_KNUCKLES_EL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EL NULL
#define OPTION_VAL_NTSC_PAR_EL NULL
#define OPTION_VAL_PAL_PAR_EL NULL
#define OPTION_VAL_4_3_EL NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_EL NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_EL NULL
#define OPTION_VAL_TOP_BOTTOM_EL NULL
#define OPTION_VAL_LEFT_RIGHT_EL NULL
#define OPTION_VAL_FULL_EL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EL NULL
#define OPTION_VAL_LEFT_BORDER_EL NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_EL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_EL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EL NULL
#define OPTION_VAL_MONOCHROME_EL "Μονόχρωμο"
#define OPTION_VAL_COMPOSITE_EL NULL
#define OPTION_VAL_SVIDEO_EL NULL
#define OPTION_VAL_RGB_EL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_EL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EL NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_EL NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_EL NULL
#define OPTION_VAL_SINGLE_FIELD_EL NULL
#define OPTION_VAL_DOUBLE_FIELD_EL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_EL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EL NULL
#define OPTION_VAL_MANUAL_EL "Χειροκίνητο"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EL NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_EL NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_EL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_EL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EL NULL
#define OPTION_VAL_MAME_EL NULL
#define OPTION_VAL_NUKED_EL NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_EL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_EL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_EL NULL
#define OPTION_VAL_MAME_YM2612_EL NULL
#define OPTION_VAL_MAME_ASIC_YM3438_EL NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_EL NULL
#define OPTION_VAL_NUKED_YM2612_EL NULL
#define OPTION_VAL_NUKED_YM3438_EL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EL NULL
#define OPTION_VAL_STEREO_EL NULL
#define OPTION_VAL_MONO_EL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EL "Φίλτρα Ήχου"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EL NULL
#define OPTION_VAL_LOW_PASS_EL NULL
#define OPTION_VAL_EQ_EL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_EL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_EL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EL NULL
#define OPTION_VAL_LIGHTGUN_EL NULL
#define OPTION_VAL_TOUCHSCREEN_EL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_EL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EL NULL
#define OPTION_VAL_100_EL NULL
#define OPTION_VAL_125_EL NULL
#define OPTION_VAL_150_EL NULL
#define OPTION_VAL_175_EL NULL
#define OPTION_VAL_200_EL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EL NULL

struct retro_core_option_v2_category option_cats_el[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EL,
      CATEGORY_SYSTEM_INFO_0_EL
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EL,
      CATEGORY_VIDEO_INFO_0_EL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EL,
      CATEGORY_AUDIO_INFO_0_EL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EL,
      CATEGORY_INPUT_INFO_0_EL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EL,
      CATEGORY_HACKS_INFO_0_EL
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_EL,
      CATEGORY_CHANNEL_VOLUME_INFO_0_EL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_el[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_EL               },
         { "sg-1000",              OPTION_VAL_SG_1000_EL            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_EL         },
         { "mark-III",             OPTION_VAL_MARK_III_EL           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_EL      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_EL   },
         { "game gear",            OPTION_VAL_GAME_GEAR_EL          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_EL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_EL   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_EL },
         { "pal",     OPTION_VAL_PAL_EL    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_EL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_EL,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_EL },
         { "per game", OPTION_VAL_PER_GAME_EL },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_EL,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_EL },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_EL },
         { "megasd",       OPTION_VAL_MEGASD_EL },
         { "none",         OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_EL },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_EL },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EL,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_EL },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_EL },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_EL },
         { "4:3",  OPTION_VAL_4_3_EL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_EL },
         { "left/right", OPTION_VAL_LEFT_RIGHT_EL },
         { "full",       OPTION_VAL_FULL_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_EL },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_EL },
         { "composite",  OPTION_VAL_COMPOSITE_EL },
         { "svideo",     OPTION_VAL_SVIDEO_EL },
         { "rgb",        OPTION_VAL_RGB_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_EL,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_EL },
         { "double field", OPTION_VAL_DOUBLE_FIELD_EL },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_EL },
         { "manual",   OPTION_VAL_MANUAL_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EL,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_EL,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_EL },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EL,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_EL },
         { "nuked", OPTION_VAL_NUKED_EL },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_EL,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_EL,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_EL,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_EL },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_EL },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_EL },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_EL },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_EL },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EL,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_EL },
         { "mono",   OPTION_VAL_MONO_EL },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EL,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_EL },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_EL },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EL,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EL,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EL },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EL },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_EL },
         { "125%", OPTION_VAL_125_EL },
         { "150%", OPTION_VAL_150_EL },
         { "175%", OPTION_VAL_175_EL },
         { "200%", OPTION_VAL_200_EL },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_el = {
   option_cats_el,
   option_defs_el
};

/* RETRO_LANGUAGE_EO */

#define CATEGORY_SYSTEM_LABEL_EO NULL
#define CATEGORY_SYSTEM_INFO_0_EO NULL
#define CATEGORY_VIDEO_LABEL_EO "Video Driver"
#define CATEGORY_VIDEO_INFO_0_EO NULL
#define CATEGORY_AUDIO_LABEL_EO "Audio Driver"
#define CATEGORY_AUDIO_INFO_0_EO NULL
#define CATEGORY_INPUT_LABEL_EO "Input Driver"
#define CATEGORY_INPUT_INFO_0_EO NULL
#define CATEGORY_HACKS_LABEL_EO NULL
#define CATEGORY_HACKS_INFO_0_EO NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_EO NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EO NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EO NULL
#define OPTION_VAL_AUTO_EO NULL
#define OPTION_VAL_SG_1000_EO NULL
#define OPTION_VAL_SG_1000_II_EO NULL
#define OPTION_VAL_MARK_III_EO NULL
#define OPTION_VAL_MASTER_SYSTEM_EO NULL
#define OPTION_VAL_MASTER_SYSTEM_II_EO NULL
#define OPTION_VAL_GAME_GEAR_EO NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_EO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_EO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EO NULL
#define OPTION_VAL_NTSC_U_EO NULL
#define OPTION_VAL_PAL_EO NULL
#define OPTION_VAL_NTSC_J_EO NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_EO NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_EO NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_EO NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_EO NULL
#define OPTION_VAL_PER_BIOS_EO NULL
#define OPTION_VAL_PER_GAME_EO NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_EO NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_EO NULL
#define OPTION_VAL_SEGA_MEGA_CD_EO NULL
#define OPTION_VAL_MEGASD_EO NULL
#define OPTION_VAL_NONE_EO NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_EO NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_EO NULL
#define OPTION_VAL_GAME_GENIE_EO NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_EO NULL
#define OPTION_VAL_SONIC_KNUCKLES_EO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EO NULL
#define OPTION_VAL_NTSC_PAR_EO NULL
#define OPTION_VAL_PAL_PAR_EO NULL
#define OPTION_VAL_4_3_EO NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_EO NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_EO NULL
#define OPTION_VAL_TOP_BOTTOM_EO NULL
#define OPTION_VAL_LEFT_RIGHT_EO NULL
#define OPTION_VAL_FULL_EO NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EO NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EO NULL
#define OPTION_VAL_LEFT_BORDER_EO NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_EO NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_EO NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EO NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EO NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EO NULL
#define OPTION_VAL_MONOCHROME_EO NULL
#define OPTION_VAL_COMPOSITE_EO NULL
#define OPTION_VAL_SVIDEO_EO NULL
#define OPTION_VAL_RGB_EO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_EO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EO NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_EO NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_EO NULL
#define OPTION_VAL_SINGLE_FIELD_EO NULL
#define OPTION_VAL_DOUBLE_FIELD_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EO NULL
#define OPTION_VAL_MANUAL_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EO NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_EO NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_EO NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_EO NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EO NULL
#define OPTION_VAL_MAME_EO NULL
#define OPTION_VAL_NUKED_EO NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_EO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_EO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_EO NULL
#define OPTION_VAL_MAME_YM2612_EO NULL
#define OPTION_VAL_MAME_ASIC_YM3438_EO NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_EO NULL
#define OPTION_VAL_NUKED_YM2612_EO NULL
#define OPTION_VAL_NUKED_YM3438_EO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EO NULL
#define OPTION_VAL_STEREO_EO NULL
#define OPTION_VAL_MONO_EO NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EO NULL
#define OPTION_VAL_LOW_PASS_EO NULL
#define OPTION_VAL_EQ_EO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EO NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_EO NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EO NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EO NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_EO NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EO NULL
#define OPTION_VAL_LIGHTGUN_EO NULL
#define OPTION_VAL_TOUCHSCREEN_EO NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EO NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EO NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EO NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EO NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EO NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EO NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_EO NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EO NULL
#define OPTION_VAL_100_EO NULL
#define OPTION_VAL_125_EO NULL
#define OPTION_VAL_150_EO NULL
#define OPTION_VAL_175_EO NULL
#define OPTION_VAL_200_EO NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EO NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EO NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EO NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EO NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EO NULL

struct retro_core_option_v2_category option_cats_eo[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EO,
      CATEGORY_SYSTEM_INFO_0_EO
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EO,
      CATEGORY_VIDEO_INFO_0_EO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EO,
      CATEGORY_AUDIO_INFO_0_EO
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EO,
      CATEGORY_INPUT_INFO_0_EO
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EO,
      CATEGORY_HACKS_INFO_0_EO
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_EO,
      CATEGORY_CHANNEL_VOLUME_INFO_0_EO
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_eo[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_EO               },
         { "sg-1000",              OPTION_VAL_SG_1000_EO            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_EO         },
         { "mark-III",             OPTION_VAL_MARK_III_EO           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_EO      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_EO   },
         { "game gear",            OPTION_VAL_GAME_GEAR_EO          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_EO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_EO   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_EO },
         { "pal",     OPTION_VAL_PAL_EO    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_EO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_EO,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_EO },
         { "per game", OPTION_VAL_PER_GAME_EO },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_EO,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_EO },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_EO },
         { "megasd",       OPTION_VAL_MEGASD_EO },
         { "none",         OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_EO },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_EO },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_EO,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_EO },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_EO },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_EO },
         { "4:3",  OPTION_VAL_4_3_EO },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_EO },
         { "left/right", OPTION_VAL_LEFT_RIGHT_EO },
         { "full",       OPTION_VAL_FULL_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_EO },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_EO },
         { "composite",  OPTION_VAL_COMPOSITE_EO },
         { "svideo",     OPTION_VAL_SVIDEO_EO },
         { "rgb",        OPTION_VAL_RGB_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_EO,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_EO },
         { "double field", OPTION_VAL_DOUBLE_FIELD_EO },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_EO },
         { "manual",   OPTION_VAL_MANUAL_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_EO,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_EO,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_EO },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_EO,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_EO },
         { "nuked", OPTION_VAL_NUKED_EO },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_EO,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_EO,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_EO,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_EO },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_EO },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_EO },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_EO },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_EO },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_EO,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_EO },
         { "mono",   OPTION_VAL_MONO_EO },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_EO,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_EO },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_EO },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_EO,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_EO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_EO,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EO },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EO },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_EO },
         { "125%", OPTION_VAL_125_EO },
         { "150%", OPTION_VAL_150_EO },
         { "175%", OPTION_VAL_175_EO },
         { "200%", OPTION_VAL_200_EO },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_EO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_EO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_eo = {
   option_cats_eo,
   option_defs_eo
};

/* RETRO_LANGUAGE_ES */

#define CATEGORY_SYSTEM_LABEL_ES "Sistema"
#define CATEGORY_SYSTEM_INFO_0_ES "Cambia las opciones del hardware base, la región, su BIOS y el archivo de guardado de Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_ES "Vídeo"
#define CATEGORY_VIDEO_INFO_0_ES "Cambia las opciones de relación de aspecto, recorte de imagen, filtros de vídeo y omisión de fotogramas."
#define CATEGORY_AUDIO_LABEL_ES NULL
#define CATEGORY_AUDIO_INFO_0_ES "Cambia los ajustes de los dispositivos de audio."
#define CATEGORY_INPUT_LABEL_ES "Entrada"
#define CATEGORY_INPUT_INFO_0_ES "Cambia las opciones de las pistolas de luz o la entrada del ratón."
#define CATEGORY_HACKS_LABEL_ES "Arreglos de emulación"
#define CATEGORY_HACKS_INFO_0_ES "Cambia las opciones de velocidad del procesador y de precisión de la emulación que afectan al rendimiento a bajo nivel y a la compatibilidad."
#define CATEGORY_CHANNEL_VOLUME_LABEL_ES "Ajustes avanzados del volumen de los canales"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_ES "Cambia el volumen de los canales individuales de audio del hardware."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_ES "Hardware del sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_ES "Ejecuta el contenido cargado utilizando una consola emulada concreta. «Selección automática» seleccionará el sistema más adecuado para cada juego."
#define OPTION_VAL_AUTO_ES "Selección automática"
#define OPTION_VAL_SG_1000_ES NULL
#define OPTION_VAL_SG_1000_II_ES NULL
#define OPTION_VAL_MARK_III_ES NULL
#define OPTION_VAL_MASTER_SYSTEM_ES NULL
#define OPTION_VAL_MASTER_SYSTEM_II_ES NULL
#define OPTION_VAL_GAME_GEAR_ES NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_ES NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_ES "Región del sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_ES "Especifica la región para la que se ha fabricado el sistema. A excepción de la Game Gear, la opción PAL hará que las consolas muestren una imagen a 50 Hz, mientras que las opciones NTSC la mostrarán a 60 Hz. Si seleccionas una región incorrecta, los juegos podrían ejecutarse más rápidos o lentos de lo normal."
#define OPTION_VAL_NTSC_U_ES NULL
#define OPTION_VAL_PAL_ES NULL
#define OPTION_VAL_NTSC_J_ES NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_ES "ROM de arranque del sistema"
#define GENESIS_PLUS_GX_BIOS_INFO_0_ES "Utiliza un cargador de arranque o BIOS oficiales para la emulación si se encuentran en el directorio del sistema de RetroArch. Se mostrará la secuencia específica de inicio de la consola y luego se ejecutará el contenido cargado."
#define GENESIS_PLUS_GX_BRAM_LABEL_ES "BRAM para el sistema de CD"
#define GENESIS_PLUS_GX_BRAM_INFO_0_ES "Al ejecutar contenidos para Mega-CD/Sega CD, especifica si se debe compartir un archivo de guardado entre todos los juegos de la misma región («Una por BIOS») o si se debe crear un archivo de guardado individual para cada juego («Una por cada juego»). Nota: la Mega-CD/Sega CD tiene un almacenamiento interno limitado, suficiente para unos pocos títulos. Se recomienda seleccionar «Una por cada juego» para que no te quedes sin espacio libre."
#define OPTION_VAL_PER_BIOS_ES "Uno por BIOS"
#define OPTION_VAL_PER_GAME_ES "Uno por cada juego"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_ES "Módulo de CD (modo MD, es necesario reiniciar)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_ES "Especifica el módulo que se ha de utilizar para la reproducción de audio de CD en los juegos compatibles de Mega Drive/Genesis."
#define OPTION_VAL_SEGA_MEGA_CD_ES "Sega CD/Mega-CD"
#define OPTION_VAL_MEGASD_ES NULL
#define OPTION_VAL_NONE_ES "Ninguno"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_ES "Lock-On/Ensamblaje entre cartuchos"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_ES "La tecnología Lock-On/de ensamblaje es una característica de Mega Drive/Genesis que permitía a un juego antiguo conectarse a la ranura de un cartucho especial para alterar o ampliar su contenido. Esta opción especifica el tipo concreto de ensamblaje o «Lock-On» emulado. Es necesario incluir el archivo de la BIOS correspondiente en el directorio del sistema de RetroArch."
#define OPTION_VAL_GAME_GENIE_ES NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_ES NULL
#define OPTION_VAL_SONIC_KNUCKLES_ES NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_ES "Relación de aspecto indicada por el núcleo"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_ES "Selecciona la relación de aspecto del contenido. Esta opción solo surtirá efecto cuando la opción general de RetroArch, en el apartado de Vídeo de los ajustes, esté configurada como «Asignada por el núcleo»."
#define OPTION_VAL_NTSC_PAR_ES "Relación de aspecto de píxeles NTSC"
#define OPTION_VAL_PAL_PAR_ES "Relación de aspecto de píxeles PAL"
#define OPTION_VAL_4_3_ES NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_ES "Bordes"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_ES "Activa esta opción para mostrar las regiones de sobrebarrido en las partes superior e inferior o izquierda y derecha de la pantalla. Una televisión de definición estándar suele ocultarlas con el borde de la pantalla."
#define OPTION_VAL_TOP_BOTTOM_ES "Superior/inferior"
#define OPTION_VAL_LEFT_RIGHT_ES "Izquierda/derecha"
#define OPTION_VAL_FULL_ES "Todo"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_ES "Ocultar los bordes laterales de Master System"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_ES "Corta 8 píxeles del lateral izquierdo de la pantalla o de ambos laterales al ejecutar juegos para Master System."
#define OPTION_VAL_LEFT_BORDER_ES "Solo el borde izquierdo"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_ES "Bordes izquierdo y derecho"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_ES "Extender imagen de Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_ES "Fuerza a los juegos para Game Gear a ejecutarse en el modo SMS con una resolución incrementada de 256x192. Tal vez se muestren más contenidos, pero lo normal es que se muestre un borde de datos de imagen dañados o indeseables."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_ES "Filtro NTSC de Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_ES "Aplica un filtro de vídeo para imitar varios tipos de señales de imagen NTSC."
#define OPTION_VAL_MONOCHROME_ES "Monocromo"
#define OPTION_VAL_COMPOSITE_ES "Vídeo compuesto"
#define OPTION_VAL_SVIDEO_ES NULL
#define OPTION_VAL_RGB_ES NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_ES "Filtro de efecto fantasma («ghosting») de LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_ES "Aplica un filtro de efecto fantasma («ghosting») a la imagen para simular las características de los paneles LCD de Game Gear y Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_ES "Modo de entrelazado de vídeo 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_ES "El modo de entrelazado de vídeo 2 permite a la Mega Drive/Genesis generar una imagen que duplica su altura original a 320x448 (alta resolución) dibujando líneas de barrido alternativas en cada fotograma (usado por los modos multijugador de Sonic the Hedgehog 2 y de Combat Cars). «Dos campos» imita el hardware original: produce una imagen nítida con artefactos de parpadeos o de entrelazado. «Un campo» aplica un filtro de desentrelazado para estabilizar la imagen, pero la hará algo borrosa."
#define OPTION_VAL_SINGLE_FIELD_ES "Un campo"
#define OPTION_VAL_DOUBLE_FIELD_ES "Dos campos"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_ES "Omisión de fotogramas"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_ES "Omite fotogramas para no saturar el búfer de audio (chasquidos en el sonido). Mejora el rendimiento a costa de perder fluidez visual. Selección automática omite fotogramas según lo aconseje el front-end. El valor Manual utiliza el ajuste Umbral de omisión de fotogramas (%)."
#define OPTION_VAL_MANUAL_ES NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_ES "Umbral de omisión de fotogramas (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_ES "Cuando la omisión de fotogramas esté configurada como Manual, este ajuste especifica el umbral de ocupación del búfer de audio (en porcentaje) por debajo del cual se omitirán fotogramas si el valor. Un valor más elevado reduce el riesgo de chasquidos omitiendo fotogramas con una mayor frecuencia."
#define GENESIS_PLUS_GX_YM2413_LABEL_ES "Sonido por síntesis FM de Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_INFO_0_ES "Activa la emulación de la unidad de sonido FM que usan algunos juegos concretos de Sega Mark III/Master System para mejorar su salida de audio."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_ES "Núcleo del sonido FM de Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_ES "Selecciona el método con el que emular la unidad de sonido FM de la Sega Mark III/Master System. «MAME» es rápido y se ejecuta a la máxima velocidad en la mayoría de sistemas. «Nuked» ofrece una emulación precisa, con una calidad y requisitos de CPU elevados."
#define OPTION_VAL_MAME_ES NULL
#define OPTION_VAL_NUKED_ES NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_ES "Sonido por síntesis FM de Mega Drive/Genesis"
#define GENESIS_PLUS_GX_YM2612_INFO_0_ES "Selecciona el método con el que emular el sintetizador FM (el generador principal de sonido) de la Mega Drive/Genesis. Las opciones de MAME son rápidas y se ejecutan a la máxima velocidad en la mayoría de sistemas. Las opciones Nuked ofrecen una emulación precisa en cuanto a ciclos, con una calidad y requisitos de CPU elevados. El chip YM26132 es el que llevan los Model 1 originales de Mega Drive/Genesis. El chip YM3438 es el que se utilizó en las revisiones posteriores de Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_ES "Selecciona el método con el que emular el sintetizador FM (el generador principal de sonido) de la Mega Drive/Genesis. El chip YM26132 es el que llevan los Model 1 originales de Mega Drive/Genesis. El chip YM3438 es el que se utilizó en las revisiones posteriores de Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_ES NULL
#define OPTION_VAL_MAME_ASIC_YM3438_ES NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_ES "MAME (YM3438 mejorado)"
#define OPTION_VAL_NUKED_YM2612_ES NULL
#define OPTION_VAL_NUKED_YM3438_ES NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_ES "Salida de sonido"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_ES "Selecciona la reproducción de sonido monoaural o estéreo."
#define OPTION_VAL_STEREO_ES "Estéreo"
#define OPTION_VAL_MONO_ES "Monoaural"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_ES "Filtro de audio"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_ES "Aplica un filtro de paso bajo de audio para simular mejor el sonido característico de una Mega Drive/Genesis Model 1."
#define OPTION_VAL_LOW_PASS_ES "Paso bajo"
#define OPTION_VAL_EQ_ES "Ecualizador"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_ES "Porcentaje del filtro de paso bajo"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_ES "Especifica el umbral de frecuencias del filtro de paso bajo de audio. Un valor más elevado aumentará la «fuerza» percibida del filtro, atenuando un mayor rango de frecuencias altas."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_ES "Nivel de preamplificación del PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_ES "Ajusta el nivel de preamplificación de audio del PSG (generador programable de sonidos) SN76496 de cuatro canales que utilizan las SG-1000, Sega Mark III, Master System, Game Gear y Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_ES "Nivel de preamplificación de FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_ES "Ajusta el nivel de preamplificado de audio del sintetizador de sonido FM de Mega Drive/Genesis o de la unidad de sonido FM de las Sega Mark III/Master System."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_ES "Volumen de CD audio (CD-DA)"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_ES "Ajusta el volumen de mezcla de la salida de audio CD emulada."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_ES "Volumen de onda PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_ES "Ajusta el volumen de mezcla de la salida de audio del generador PCM RF5C164 emulado de la Sega CD/Mega-CD."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_ES "Ecualización de graves"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_ES "Ajusta la banda de tonos graves del ecualizador interno de audio."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_ES "Ecualización de medios"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_ES "Ajusta la banda de tonos medios del ecualizador interno de audio."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_ES "Ecualización de agudos"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_ES "Ajusta la banda de tonos agudos del ecualizador interno de audio."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_ES "Entrada de pistola de luz"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_ES "Utiliza un ratón o una pantalla táctil para controlar una pistola de luz."
#define OPTION_VAL_LIGHTGUN_ES "Pistola de luz"
#define OPTION_VAL_TOUCHSCREEN_ES "Pantalla táctil"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_ES "Mostrar punto de mira de las pistolas de luz"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_ES "Muestra los puntos de mira de las pistolas de luz al utilizar los dispositivos de entrada MD Menacer, MD Justifier y MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_ES "Invertir eje Y del ratón"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_ES "Invierte el eje vertical del dispositivo de entrada MD Mouse."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_ES "Eliminar límite de sprites por línea"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_ES "Elimina el límite de sprites por líneas de barrido que tenía el hardware original. Reduce los parpadeos, pero puede provocar fallos gráficos, ya que algunos juegos aprovechan esta limitación para generar efectos especiales."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_ES "Velocidad de la CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_ES "Aumenta la velocidad de la CPU emulada. Puede reducir las ralentizaciones, pero también podría provocar fallos gráficos."
#define OPTION_VAL_100_ES "100 %"
#define OPTION_VAL_125_ES "125 %"
#define OPTION_VAL_150_ES "150 %"
#define OPTION_VAL_175_ES "175 %"
#define OPTION_VAL_200_ES "200 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_ES "Bloqueos del sistema"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_ES "Emula los bloqueos del sistema que se producirían en el hardware real al realizar accesos ilegales a memoria. Solo se debe desactivar esta opción para jugar con demos y aplicaciones homebrew que necesiten este comportamiento ilegal para funcionar correctamente."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_ES "Error de dirección del 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_ES "La CPU principal de la Mega Drive/Genesis (el Motorola 68000) genera una excepción (cuelgue) de error de memoria al intentar acceder a una memoria no alineada. Activa esta opción para simular este comportamiento. Solo debe desactivarse para jugar a modificaciones de juegos, ya que estas suelen desarrollarse con emuladores menos precisos y pueden depender de accesos a RAM no válidos para funcionar correctamente."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_ES "Mostrar Ajustes avanzados de volumen de audio (es necesario reabrir el menú)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_ES "Permite configurar los parámetros de los canales de audio a un bajo nivel. NOTA: es necesario salir y volver a entrar del menú rápido para que el cambio surta efecto."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_ES "Volumen del canal tonal 0 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_ES "Reduce el volumen del canal tonal 0 del PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_ES "Volumen del canal tonal 1 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_ES "Reduce el volumen del canal tonal 1 del PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_ES "Volumen del canal tonal 2 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_ES "Reduce el volumen del canal tonal 2 del PSG."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_ES "Volumen del canal de ruido 3 del PSG (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_ES "Reduce el volumen del canal de ruido 3 del PSG."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_ES "Volumen del canal FM 0 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_ES "Reduce el volumen del canal 0 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_ES "Volumen del canal FM 1 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_ES "Reduce el volumen del canal 1 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_ES "Volumen del canal FM 2 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_ES "Reduce el volumen del canal 2 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_ES "Volumen del canal FM 3 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_ES "Reduce el volumen del canal 3 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_ES "Volumen del canal FM 4 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_ES "Reduce el volumen del canal 4 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_ES "Volumen del canal FM 5 de Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_ES "Reduce el volumen del canal 5 de FM de Mega Drive/Genesis. Solo surtirá efecto con los emuladores MAME de FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_ES "Volumen del canal 0 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_ES "Reduce el volumen del canal 0 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_ES "Volumen del canal 1 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_ES "Reduce el volumen del canal 1 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_ES "Volumen del canal 2 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_ES "Reduce el volumen del canal 2 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_ES "Volumen del canal 3 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_ES "Reduce el volumen del canal 3 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_ES "Volumen del canal 4 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_ES "Reduce el volumen del canal 4 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_ES "Volumen del canal 5 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_ES "Reduce el volumen del canal 5 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_ES "Volumen del canal 6 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_ES "Reduce el volumen del canal 6 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_ES "Volumen del canal 7 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_ES "Reduce el volumen del canal 7 de FM de Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_ES "Volumen del canal 8 FM de Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_ES "Reduce el volumen del canal 8 de FM de Master System."

struct retro_core_option_v2_category option_cats_es[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_ES,
      CATEGORY_SYSTEM_INFO_0_ES
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_ES,
      CATEGORY_VIDEO_INFO_0_ES
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_ES,
      CATEGORY_AUDIO_INFO_0_ES
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_ES,
      CATEGORY_INPUT_INFO_0_ES
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_ES,
      CATEGORY_HACKS_INFO_0_ES
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_ES,
      CATEGORY_CHANNEL_VOLUME_INFO_0_ES
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_es[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_ES               },
         { "sg-1000",              OPTION_VAL_SG_1000_ES            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_ES         },
         { "mark-III",             OPTION_VAL_MARK_III_ES           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_ES      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_ES   },
         { "game gear",            OPTION_VAL_GAME_GEAR_ES          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_ES },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_ES   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_ES },
         { "pal",     OPTION_VAL_PAL_ES    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_ES },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_ES,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_ES },
         { "per game", OPTION_VAL_PER_GAME_ES },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_ES,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_ES },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_ES },
         { "megasd",       OPTION_VAL_MEGASD_ES },
         { "none",         OPTION_VAL_NONE_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_ES },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_ES },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_ES,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_ES },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_ES },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_ES },
         { "4:3",  OPTION_VAL_4_3_ES },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_ES },
         { "left/right", OPTION_VAL_LEFT_RIGHT_ES },
         { "full",       OPTION_VAL_FULL_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_ES },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_ES },
         { "composite",  OPTION_VAL_COMPOSITE_ES },
         { "svideo",     OPTION_VAL_SVIDEO_ES },
         { "rgb",        OPTION_VAL_RGB_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_ES,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_ES },
         { "double field", OPTION_VAL_DOUBLE_FIELD_ES },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_ES },
         { "manual",   OPTION_VAL_MANUAL_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_ES,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_ES,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_ES },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_ES,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_ES },
         { "nuked", OPTION_VAL_NUKED_ES },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_ES,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_ES,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_ES,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_ES },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_ES },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_ES },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_ES },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_ES },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_ES,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_ES },
         { "mono",   OPTION_VAL_MONO_ES },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_ES,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_ES },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_ES },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_ES,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_ES,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_ES,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_ES },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_ES },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_ES },
         { "125%", OPTION_VAL_125_ES },
         { "150%", OPTION_VAL_150_ES },
         { "175%", OPTION_VAL_175_ES },
         { "200%", OPTION_VAL_200_ES },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_ES,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_ES,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_es = {
   option_cats_es,
   option_defs_es
};

/* RETRO_LANGUAGE_FA */

#define CATEGORY_SYSTEM_LABEL_FA NULL
#define CATEGORY_SYSTEM_INFO_0_FA NULL
#define CATEGORY_VIDEO_LABEL_FA "ویدیو"
#define CATEGORY_VIDEO_INFO_0_FA NULL
#define CATEGORY_AUDIO_LABEL_FA "صدا"
#define CATEGORY_AUDIO_INFO_0_FA NULL
#define CATEGORY_INPUT_LABEL_FA "داده"
#define CATEGORY_INPUT_INFO_0_FA NULL
#define CATEGORY_HACKS_LABEL_FA NULL
#define CATEGORY_HACKS_INFO_0_FA NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_FA NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FA NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FA NULL
#define OPTION_VAL_AUTO_FA NULL
#define OPTION_VAL_SG_1000_FA NULL
#define OPTION_VAL_SG_1000_II_FA NULL
#define OPTION_VAL_MARK_III_FA NULL
#define OPTION_VAL_MASTER_SYSTEM_FA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_FA NULL
#define OPTION_VAL_GAME_GEAR_FA NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_FA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_FA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FA NULL
#define OPTION_VAL_NTSC_U_FA NULL
#define OPTION_VAL_PAL_FA NULL
#define OPTION_VAL_NTSC_J_FA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_FA NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_FA NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_FA NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_FA NULL
#define OPTION_VAL_PER_BIOS_FA NULL
#define OPTION_VAL_PER_GAME_FA NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_FA NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_FA NULL
#define OPTION_VAL_SEGA_MEGA_CD_FA NULL
#define OPTION_VAL_MEGASD_FA NULL
#define OPTION_VAL_NONE_FA NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_FA NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_FA NULL
#define OPTION_VAL_GAME_GENIE_FA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_FA NULL
#define OPTION_VAL_SONIC_KNUCKLES_FA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FA NULL
#define OPTION_VAL_NTSC_PAR_FA NULL
#define OPTION_VAL_PAL_PAR_FA NULL
#define OPTION_VAL_4_3_FA NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_FA NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_FA NULL
#define OPTION_VAL_TOP_BOTTOM_FA NULL
#define OPTION_VAL_LEFT_RIGHT_FA NULL
#define OPTION_VAL_FULL_FA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FA NULL
#define OPTION_VAL_LEFT_BORDER_FA NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_FA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_FA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FA NULL
#define OPTION_VAL_MONOCHROME_FA NULL
#define OPTION_VAL_COMPOSITE_FA NULL
#define OPTION_VAL_SVIDEO_FA NULL
#define OPTION_VAL_RGB_FA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_FA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FA NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_FA NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_FA NULL
#define OPTION_VAL_SINGLE_FIELD_FA NULL
#define OPTION_VAL_DOUBLE_FIELD_FA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_FA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FA NULL
#define OPTION_VAL_MANUAL_FA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FA NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_FA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_FA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_FA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FA NULL
#define OPTION_VAL_MAME_FA NULL
#define OPTION_VAL_NUKED_FA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_FA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_FA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_FA NULL
#define OPTION_VAL_MAME_YM2612_FA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_FA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_FA NULL
#define OPTION_VAL_NUKED_YM2612_FA NULL
#define OPTION_VAL_NUKED_YM3438_FA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FA NULL
#define OPTION_VAL_STEREO_FA NULL
#define OPTION_VAL_MONO_FA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FA NULL
#define OPTION_VAL_LOW_PASS_FA NULL
#define OPTION_VAL_EQ_FA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_FA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_FA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FA NULL
#define OPTION_VAL_LIGHTGUN_FA NULL
#define OPTION_VAL_TOUCHSCREEN_FA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_FA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FA NULL
#define OPTION_VAL_100_FA NULL
#define OPTION_VAL_125_FA NULL
#define OPTION_VAL_150_FA NULL
#define OPTION_VAL_175_FA NULL
#define OPTION_VAL_200_FA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FA NULL

struct retro_core_option_v2_category option_cats_fa[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_FA,
      CATEGORY_SYSTEM_INFO_0_FA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_FA,
      CATEGORY_VIDEO_INFO_0_FA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FA,
      CATEGORY_AUDIO_INFO_0_FA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FA,
      CATEGORY_INPUT_INFO_0_FA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FA,
      CATEGORY_HACKS_INFO_0_FA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_FA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_FA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fa[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_FA               },
         { "sg-1000",              OPTION_VAL_SG_1000_FA            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_FA         },
         { "mark-III",             OPTION_VAL_MARK_III_FA           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_FA      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_FA   },
         { "game gear",            OPTION_VAL_GAME_GEAR_FA          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_FA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_FA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_FA },
         { "pal",     OPTION_VAL_PAL_FA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_FA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_FA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_FA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_FA },
         { "per game", OPTION_VAL_PER_GAME_FA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_FA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_FA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_FA },
         { "megasd",       OPTION_VAL_MEGASD_FA },
         { "none",         OPTION_VAL_NONE_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_FA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_FA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_FA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_FA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_FA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_FA },
         { "4:3",  OPTION_VAL_4_3_FA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_FA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_FA },
         { "full",       OPTION_VAL_FULL_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_FA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_FA },
         { "composite",  OPTION_VAL_COMPOSITE_FA },
         { "svideo",     OPTION_VAL_SVIDEO_FA },
         { "rgb",        OPTION_VAL_RGB_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_FA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_FA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_FA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_FA },
         { "manual",   OPTION_VAL_MANUAL_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_FA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_FA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_FA },
         { "nuked", OPTION_VAL_NUKED_FA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_FA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_FA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_FA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_FA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_FA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_FA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_FA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_FA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_FA },
         { "mono",   OPTION_VAL_MONO_FA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_FA },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_FA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_FA },
         { "125%", OPTION_VAL_125_FA },
         { "150%", OPTION_VAL_150_FA },
         { "175%", OPTION_VAL_175_FA },
         { "200%", OPTION_VAL_200_FA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fa = {
   option_cats_fa,
   option_defs_fa
};

/* RETRO_LANGUAGE_FI */

#define CATEGORY_SYSTEM_LABEL_FI "Järjestelmä"
#define CATEGORY_SYSTEM_INFO_0_FI "Vaihda peruslaitteiston valintaa, aluetta, BIOS ja Sega-CD/Mega-CD tallennustiedoston asetuksia."
#define CATEGORY_VIDEO_LABEL_FI NULL
#define CATEGORY_VIDEO_INFO_0_FI "Muuta kuvasuhdetta, näytön rajausta, videosuodatusta ja kuvanohitusasetuksia."
#define CATEGORY_AUDIO_LABEL_FI "Ääni"
#define CATEGORY_AUDIO_INFO_0_FI "Muuta äänilaitteen asetuksia."
#define CATEGORY_INPUT_LABEL_FI "Syöte"
#define CATEGORY_INPUT_INFO_0_FI "Muuta \"Light gun\" ja/tai hiiren syötön asetuksia"
#define CATEGORY_HACKS_LABEL_FI "Emulointikikat"
#define CATEGORY_HACKS_INFO_0_FI "Muuta prosessorin ylikellotus- ja emulointitarkkuusasetuksia, jotka vaikuttavat matalan tason suorituskykyyn ja yhteensopivuuteen."
#define CATEGORY_CHANNEL_VOLUME_LABEL_FI "Kanavan äänenvoimakkuuden lisäasetukset"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_FI "Muuta yksittäisten laitteistoäänikanavien äänenvoimakkuutta."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FI "Järjestelmä laitteisto"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FI "Suorittaa ladattua sisältöä tietyllä emuloidulla konsolilla. \"Autotomaattinen\" valitsee sopivimman järjestelmän nykyiselle pelille."
#define OPTION_VAL_AUTO_FI "Automaattinen"
#define OPTION_VAL_SG_1000_FI NULL
#define OPTION_VAL_SG_1000_II_FI NULL
#define OPTION_VAL_MARK_III_FI NULL
#define OPTION_VAL_MASTER_SYSTEM_FI NULL
#define OPTION_VAL_MASTER_SYSTEM_II_FI NULL
#define OPTION_VAL_GAME_GEAR_FI NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_FI NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_FI "Järjestelmän alue"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FI "Määritä, miltä alueelta järjestelmä on. Muille konsoleille kuin Game Gear, \"PAL\" on 50 Hz, kun taas \"NTSC\" 60 Hz. Pelit saattavat pyöriä nopeammin tai hitaammin jos väärä alue on valittu."
#define OPTION_VAL_NTSC_U_FI NULL
#define OPTION_VAL_PAL_FI NULL
#define OPTION_VAL_NTSC_J_FI NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_FI "Järjestelmän käynnistys ROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_FI NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_FI NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_FI NULL
#define OPTION_VAL_PER_BIOS_FI NULL
#define OPTION_VAL_PER_GAME_FI NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_FI NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_FI NULL
#define OPTION_VAL_SEGA_MEGA_CD_FI NULL
#define OPTION_VAL_MEGASD_FI NULL
#define OPTION_VAL_NONE_FI "Ei mitään"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_FI NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_FI NULL
#define OPTION_VAL_GAME_GENIE_FI NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_FI NULL
#define OPTION_VAL_SONIC_KNUCKLES_FI NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FI "Ytimen määrittämä kuvasuhde"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FI NULL
#define OPTION_VAL_NTSC_PAR_FI NULL
#define OPTION_VAL_PAL_PAR_FI NULL
#define OPTION_VAL_4_3_FI NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_FI "Reunukset"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_FI NULL
#define OPTION_VAL_TOP_BOTTOM_FI NULL
#define OPTION_VAL_LEFT_RIGHT_FI "Vasen/Oikea"
#define OPTION_VAL_FULL_FI NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FI "Piilota Master Systemin sivurajat"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FI NULL
#define OPTION_VAL_LEFT_BORDER_FI "Vain vasen reuna"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_FI "Vasen ja oikea reuna"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_FI NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FI NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FI "Blargg NTSC suodatin"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FI NULL
#define OPTION_VAL_MONOCHROME_FI "Yksivärinen"
#define OPTION_VAL_COMPOSITE_FI "Komposiitti"
#define OPTION_VAL_SVIDEO_FI NULL
#define OPTION_VAL_RGB_FI NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_FI NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FI NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_FI NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_FI NULL
#define OPTION_VAL_SINGLE_FIELD_FI NULL
#define OPTION_VAL_DOUBLE_FIELD_FI NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_FI "Kuvanohitus"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FI "Ohita kuvia välttääksesi äänipuskurin ali ajon (säröily). Parantaa suorituskykyä visuaalisen tasaisuuden kustannuksella. \"Automaatti\" ohittaa kehykset käyttöliittymän asetusten mukaan. \"Manuaalinen\" käyttää \"Kuvienohituksen arvo (%)\" -asetusta."
#define OPTION_VAL_MANUAL_FI "Manuaalinen"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FI "Kuvienohituksen arvo (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FI "Kun \"kehyksen ohitus\" on asetettu \"manuaaliksi\", määrittää äänipuskuri käyttökynnyksen (prosentteina), jonka alapuolella kehykset ohitetaan. Korkeammat arvot vähentävät särkymisen riskiä siten, että kehykset putoavat useammin."
#define GENESIS_PLUS_GX_YM2413_LABEL_FI NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_FI NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_FI "Master System FM (YM2413) ydin"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FI NULL
#define OPTION_VAL_MAME_FI NULL
#define OPTION_VAL_NUKED_FI NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_FI NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_FI NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_FI NULL
#define OPTION_VAL_MAME_YM2612_FI NULL
#define OPTION_VAL_MAME_ASIC_YM3438_FI NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_FI "MAME (Paranneltu YM3438)"
#define OPTION_VAL_NUKED_YM2612_FI NULL
#define OPTION_VAL_NUKED_YM3438_FI NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FI "Äänen ulostulo"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FI NULL
#define OPTION_VAL_STEREO_FI NULL
#define OPTION_VAL_MONO_FI NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FI "Äänisuodatin"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FI "Ota käyttöön alipäästösuodatin simuloidaksesi paremmin Mega Drive/Genesis mallin 1 ääniominaisuuksia."
#define OPTION_VAL_LOW_PASS_FI "Alipäästö"
#define OPTION_VAL_EQ_FI "Taajuuskorjain"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FI "Alipäästösuodatin %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FI NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_FI NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FI NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FI "PCM-äänenvoimakkuus"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FI NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FI NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_FI "Valoaseen syöte"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FI NULL
#define OPTION_VAL_LIGHTGUN_FI "Valoase"
#define OPTION_VAL_TOUCHSCREEN_FI "Kosketusnäyttö"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FI "Näytä valoaseen tähtäin"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FI NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FI NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FI NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FI NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FI NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_FI "Suorittimen nopeus"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FI "Ylikellotta emuloitua prosessoria. Voi vähentää hidastumista, mutta saattaa aiheuttaa virheitä."
#define OPTION_VAL_100_FI "100 %"
#define OPTION_VAL_125_FI "125 %"
#define OPTION_VAL_150_FI "150 %"
#define OPTION_VAL_175_FI "175 %"
#define OPTION_VAL_200_FI "200 %"
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FI NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FI NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FI "68K-osoitevirhe"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FI NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FI "Ota käyttöön alhaisen tason äänikanavan parametrien asetukset. HUOM.: Pikavalikko pitää ottaa käyttöön tämän asetuksen käyttöönottamiseksi."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FI NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FI NULL

struct retro_core_option_v2_category option_cats_fi[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_FI,
      CATEGORY_SYSTEM_INFO_0_FI
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_FI,
      CATEGORY_VIDEO_INFO_0_FI
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FI,
      CATEGORY_AUDIO_INFO_0_FI
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FI,
      CATEGORY_INPUT_INFO_0_FI
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FI,
      CATEGORY_HACKS_INFO_0_FI
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_FI,
      CATEGORY_CHANNEL_VOLUME_INFO_0_FI
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fi[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_FI               },
         { "sg-1000",              OPTION_VAL_SG_1000_FI            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_FI         },
         { "mark-III",             OPTION_VAL_MARK_III_FI           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_FI      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_FI   },
         { "game gear",            OPTION_VAL_GAME_GEAR_FI          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_FI },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_FI   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_FI },
         { "pal",     OPTION_VAL_PAL_FI    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_FI },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_FI,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_FI,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_FI },
         { "per game", OPTION_VAL_PER_GAME_FI },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_FI,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_FI },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_FI },
         { "megasd",       OPTION_VAL_MEGASD_FI },
         { "none",         OPTION_VAL_NONE_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_FI,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_FI },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_FI },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FI,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_FI },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_FI },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_FI },
         { "4:3",  OPTION_VAL_4_3_FI },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_FI },
         { "left/right", OPTION_VAL_LEFT_RIGHT_FI },
         { "full",       OPTION_VAL_FULL_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_FI },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_FI },
         { "composite",  OPTION_VAL_COMPOSITE_FI },
         { "svideo",     OPTION_VAL_SVIDEO_FI },
         { "rgb",        OPTION_VAL_RGB_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_FI,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_FI },
         { "double field", OPTION_VAL_DOUBLE_FIELD_FI },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FI,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_FI },
         { "manual",   OPTION_VAL_MANUAL_FI },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FI,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_FI,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_FI },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FI,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_FI },
         { "nuked", OPTION_VAL_NUKED_FI },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_FI,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_FI,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_FI,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_FI },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_FI },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_FI },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_FI },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_FI },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FI,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_FI },
         { "mono",   OPTION_VAL_MONO_FI },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FI,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_FI },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_FI },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FI,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FI,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FI,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FI },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FI },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FI,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FI,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_FI },
         { "125%", OPTION_VAL_125_FI },
         { "150%", OPTION_VAL_150_FI },
         { "175%", OPTION_VAL_175_FI },
         { "200%", OPTION_VAL_200_FI },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FI,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FI,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FI,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fi = {
   option_cats_fi,
   option_defs_fi
};

/* RETRO_LANGUAGE_FR */

#define CATEGORY_SYSTEM_LABEL_FR "Système"
#define CATEGORY_SYSTEM_INFO_0_FR "Modifier les réglages de la sélection du matériel de base, la région, du BIOS et des fichiers de sauvegarde Sega CD/Mega-CD."
#define CATEGORY_VIDEO_LABEL_FR "Vidéo"
#define CATEGORY_VIDEO_INFO_0_FR "Modifier les réglages du rapport d'aspect, recadrage de l'affichage, filtre vidéo et du saut d'images."
#define CATEGORY_AUDIO_LABEL_FR NULL
#define CATEGORY_AUDIO_INFO_0_FR "Modifier les réglages du périphérique audio."
#define CATEGORY_INPUT_LABEL_FR "Entrées"
#define CATEGORY_INPUT_INFO_0_FR "Modifier les réglages des entrées pistolet et/ou souris."
#define CATEGORY_HACKS_LABEL_FR "Hacks d'émulation"
#define CATEGORY_HACKS_INFO_0_FR "Modifier les réglages d'overclocking du processeur et de la précision d'émulation qui affectent les performances de bas niveau et la compatibilité."
#define CATEGORY_CHANNEL_VOLUME_LABEL_FR "Réglages avancés du volume des canaux"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_FR "Modifier le volume des canaux audio matériels individuels."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FR "Matériel système"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FR "Exécute du contenu chargé avec une console émulée spécifique. 'Auto' sélectionnera le système le plus approprié pour le jeu en cours."
#define OPTION_VAL_AUTO_FR NULL
#define OPTION_VAL_SG_1000_FR NULL
#define OPTION_VAL_SG_1000_II_FR NULL
#define OPTION_VAL_MARK_III_FR NULL
#define OPTION_VAL_MASTER_SYSTEM_FR NULL
#define OPTION_VAL_MASTER_SYSTEM_II_FR NULL
#define OPTION_VAL_GAME_GEAR_FR NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_FR NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_FR "Région du système"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FR "Spécifie de quelle région le système provient. Pour les consoles autres que la Game Gear, 'PAL' est à 50 Hz alors que 'NTSC' est à 60 Hz. Les jeux peuvent tourner plus vite ou plus lentement que la normale si la région incorrecte est sélectionnée."
#define OPTION_VAL_NTSC_U_FR NULL
#define OPTION_VAL_PAL_FR NULL
#define OPTION_VAL_NTSC_J_FR NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_FR "ROM de démarrage du système"
#define GENESIS_PLUS_GX_BIOS_INFO_0_FR "Utiliser le BIOS/bootloader officiel pour le matériel émulé, s'il est présent dans le répertoire système de RetroArch. Affiche une séquence de démarrage/animation spécifique à la console, puis lance le contenu chargé."
#define GENESIS_PLUS_GX_BRAM_LABEL_FR "BRAM du système CD"
#define GENESIS_PLUS_GX_BRAM_INFO_0_FR "Lors de l'exécution de contenu Sega CD/Mega-CD, spécifie s'il faut partager un seul fichier de sauvegarde entre tous les jeux d'une région spécifique (Par BIOS) ou créer un fichier de sauvegarde séparé pour chaque jeu (Par jeu). Notez que le Sega CD/Mega-CD a un stockage interne limité, suffisant seulement pour une poignée de titres. Pour éviter de manquer d'espace, le paramètre 'Par jeu' est recommandé."
#define OPTION_VAL_PER_BIOS_FR "Par BIOS"
#define OPTION_VAL_PER_GAME_FR "Par jeu"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_FR "Module CD complémentaire (mode MD) (Redémarrage requis)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_FR "Spécifie quel module complémentaire utiliser pour la lecture audio de CD avec les jeux Mega Drive/Genesis pris en charge."
#define OPTION_VAL_SEGA_MEGA_CD_FR NULL
#define OPTION_VAL_MEGASD_FR NULL
#define OPTION_VAL_NONE_FR "Aucun"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_FR "Cartouche lock-on"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_FR "La technologie lock-on est une fonctionnalité de la Mega Drive/Genesis qui permettait à un jeu plus ancien de se connecter au port de transit d'une cartouche spéciale pour un jeu prolongé ou modifié. Cette option spécifie quel type de cartouche 'lock-on' spéciale émuler. Un fichier BIOS correspondant doit être présent dans le dossier système de RetroArch."
#define OPTION_VAL_GAME_GENIE_FR NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_FR NULL
#define OPTION_VAL_SONIC_KNUCKLES_FR NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FR "Rapport d'aspect fourni par le cœur"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FR "Choisir le rapport d'aspect préféré pour le contenu. Cela ne s'applique que lorsque le rapport d'aspect de RetroArch est réglé sur 'Fourni par le cœur' (Core provided) dans les paramètres vidéo."
#define OPTION_VAL_NTSC_PAR_FR "Rapport d'aspect préféré NTSC"
#define OPTION_VAL_PAL_PAR_FR "Rapport d'aspect préféré PAL"
#define OPTION_VAL_4_3_FR NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_FR "Bordures"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_FR "Activer cette option pour afficher les régions de surbalayage en haut/bas et/ou à gauche/droite de l'écran. Celles-ci seraient normalement cachées par le biseau autour du bord d'une télévision définition standard."
#define OPTION_VAL_TOP_BOTTOM_FR "Haut/bas"
#define OPTION_VAL_LEFT_RIGHT_FR "Gauche/droite"
#define OPTION_VAL_FULL_FR "Toutes"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FR "Masquer les bordures latérales de la Master System"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FR "Coupe 8 pixels soit du côté gauche de l'écran, soit des côtés gauche et droit lors du lancement de jeux Master System."
#define OPTION_VAL_LEFT_BORDER_FR "Bordure de gauche uniquement"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_FR "Bordures gauche et droite"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_FR "Ecran étendu pour la Game Gear"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FR "Force les jeux Game Gear à fonctionner en mode SMS, avec une résolution accrue de 256x192. Peut afficher du contenu supplémentaire, mais affiche généralement une bordure de données d'image corrompues ou indésirables."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FR "Filtre NTSC Blargg"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FR "Applique un filtre vidéo pour imiter différents signaux TV NTSC."
#define OPTION_VAL_MONOCHROME_FR NULL
#define OPTION_VAL_COMPOSITE_FR NULL
#define OPTION_VAL_SVIDEO_FR NULL
#define OPTION_VAL_RGB_FR "RVB"
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_FR "Filtre de rémanence LCD"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FR "Applique un filtre de 'rémanence' d'image pour imiter les caractéristiques d'écran de la Game Gear et des panneaux LCD de la Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_FR "Sortie Mode 2 entrelacée"
#define GENESIS_PLUS_GX_RENDER_INFO_0_FR "Le Mode 2 entrelacé permet à la Mega Drive/Genesis de produire une image de hauteur doublée (haute résolution) à 320x448 en dessinant des lignes de balayage alternatives à chaque image (utilisé par les modes multi-joueurs de Sonic the Hedgehog 2 et Combat Cars). 'Double champ' imite le matériel original, produisant une image nette avec des artefacts de scintillement/entrelacement. 'Un seul champ' applique un filtre de désentrelacement, qui stabilise l'image mais provoque un flou léger."
#define OPTION_VAL_SINGLE_FIELD_FR "Un seul champ"
#define OPTION_VAL_DOUBLE_FIELD_FR "Double champ"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_FR "Saut d'images"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FR "Sauter des images pour éviter que le tampon audio ne soit sous-exécuté (crépitements). Améliore les performances au détriment de la fluidité visuelle. 'Auto' saute des images lorsque l'interface le conseille. 'Manuel' utilise le paramètre 'Seuil de saut d'images (%)'."
#define OPTION_VAL_MANUAL_FR "Manuel"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FR "Seuil de saut d'images (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FR "Lorsque 'Saut d'images' est réglé sur 'Manuel', spécifie le seuil d'occupation du tampon audio (pourcentage) en dessous duquel des images seront sautées. Des valeurs plus élevées réduisent le risque de crépitements en faisant sauter des images plus fréquemment."
#define GENESIS_PLUS_GX_YM2413_LABEL_FR "FM Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_INFO_0_FR "Activer l'émulation du FM Sound Unit utilisé par certains jeux Sega Mark III/Master System pour une sortie audio améliorée."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_FR "Cœur FM Master System (YM2413)"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FR "Sélectionner la méthode utilisée pour émuler le FM Sound Unit de la Sega Mark III/Master System. L'option 'MAME' est rapide, et fonctionne à pleine vitesse sur la plupart des systèmes. L'option 'Nuked' est précise au cycle près, de très haute qualité, et a des exigences substantielles en matière de processeur."
#define OPTION_VAL_MAME_FR NULL
#define OPTION_VAL_NUKED_FR NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_FR "FM Mega Drive/Genesis"
#define GENESIS_PLUS_GX_YM2612_INFO_0_FR "Sélectionner la méthode utilisée pour émuler le synthétiseur FM (générateur principal de son) de la Mega Drive/Genesis. Les options 'MAME' sont rapides, et fonctionnent à pleine vitesse sur la plupart des systèmes. Les options 'Nuked' sont précises au cycle près, de très haute qualité, et ont plus d'exigences en matière de processeur. La puce YM2612 est utilisée par la version originale du modèle 1 de Mega Drive/Genesis. La YM3438 est utilisée par les révisions suivantes de Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_FR "Sélectionner la méthode utilisée pour émuler le synthétiseur FM (générateur principal de son) de la Mega Drive/Genesis. La puce YM2612 est utilisée par la version originale du modèle 1 de Mega Drive/Genesis. La YM3438 est utilisée par les révisions suivantes de Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_FR NULL
#define OPTION_VAL_MAME_ASIC_YM3438_FR NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_FR "MAME (YM3438 amélioré)"
#define OPTION_VAL_NUKED_YM2612_FR NULL
#define OPTION_VAL_NUKED_YM3438_FR NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FR "Sortie audio"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FR "Sélectionner la lecture du son stéréo ou mono."
#define OPTION_VAL_STEREO_FR "Stéréo"
#define OPTION_VAL_MONO_FR NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FR "Filtre audio"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FR "Active un filtre audio passe-bas pour mieux simuler le son caractéristique d'une Mega Drive/Genesis."
#define OPTION_VAL_LOW_PASS_FR "Passe-bas"
#define OPTION_VAL_EQ_FR "Égaliseur"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FR "Filtre passe-bas (%)"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FR "Spécifie la fréquence de coupure du filtre passe-bas audio. Une valeur plus élevée accroît la 'force' perçue du filtre, car une gamme plus large du spectre des hautes fréquences est atténuée."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FR "Niveau du préampli PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FR "Règle le niveau du préampli audio du générateur de son programmable 4 canaux SN76496 émulé trouvé dans la SG-1000, Sega Mark III, Master System, Game Gear et Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_FR "Niveau du préampli FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FR "Règle le niveau du préampli audio du synthétiseur FM de la Mega Drive/Genesis ou du FM Sound Unit de la Sega Mark III/Master System émulés."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FR "Volume CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FR "Ajuste le volume de mixage de la sortie de lecture audio CD émulée."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FR "Volume PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FR "Ajuste le volume de mixage de la sortie du générateur de son PCM RF5C164 émulé du Sega CD/Mega-CD."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FR "Égaliseur - graves"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FR "Ajuste la bande des basses fréquences de l'égaliseur audio interne."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FR "Égaliseur - médium"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FR "Ajuste la bande des moyennes fréquences de l'égaliseur audio interne."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FR "Égaliseur - aigus"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FR "Ajuste la bande des hautes fréquences de l'égaliseur audio interne."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_FR "Entrée du pistolet"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FR "Utiliser une entrée 'Pistolet' contrôlée par la souris ou 'Écran tactile'."
#define OPTION_VAL_LIGHTGUN_FR "Pistolet"
#define OPTION_VAL_TOUCHSCREEN_FR "Écran tactile"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FR "Afficher le réticule du pistolet"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FR "Affiche les réticules de visée du pistolet lorsque vous utilisez les types de périphériques d'entrée MD Menacer, MD Justifiers et MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FR "Inverser l'axe Y de la souris"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FR "Inverse l'axe Y du type de périphérique d'entrée Souris MD."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FR "Supprimer la limite de sprites par ligne"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FR "Supprime la limite matérielle originale de sprites par ligne de balayage. Cela réduit le scintillement mais peut causer des bugs visuels, car certains jeux exploitent la limite matérielle pour générer des effets spéciaux."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_FR "Vitesse du processeur"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FR "Overclocker le processeur émulé. Peut réduire le ralentissement, mais peut causer des bugs."
#define OPTION_VAL_100_FR NULL
#define OPTION_VAL_125_FR NULL
#define OPTION_VAL_150_FR NULL
#define OPTION_VAL_175_FR NULL
#define OPTION_VAL_200_FR NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FR "Blocages du système"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FR "Émuler les blocages du système qui se produisent sur du vrai matériel lors d'un accès illégal aux adresses. Cela ne devrait être désactivé que lorsque vous jouez à certaines démos et homebrews qui dépendent d'un comportement illégal pour un fonctionnement correct."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FR "Erreur d'adresse 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FR "Le processeur principal de la Mega Drive/Genesis (Motorola 68000) génère une exception d'erreur d'adresse (plantage) lors d'une tentative d'accès à la mémoire non alignée. Activer cette option simule ce comportement. Cela ne devrait être désactivé que lorsque vous jouez à des hacks de ROM, car ils sont généralement développés en utilisant des émulateurs moins précis et peuvent dépendre d'un accès non valide à la mémoire vive pour une opération correcte."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FR "Afficher les paramètres avancés du volume audio (Réouvrir le menu)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FR "Active la configuration des paramètres de bas niveau des canaux audio. REMARQUE : le menu rapide doit être réouvert pour que cette option prenne effet."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FR "Volume du canal de tonalité PSG 0 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FR "Réduit le volume du canal de tonalité PSG 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FR "Volume du canal de tonalité PSG 1 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FR "Réduit le volume du canal de tonalité PSG 1."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FR "Volume du canal de tonalité PSG 2 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FR "Réduit le volume du canal de tonalité PSG 2."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FR "Volume du canal de bruit PSG 3 (%)"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FR "Réduit le volume du canal de bruit PSG 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FR "Volume du canal FM 0 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FR "Réduit le volume du canal FM 0 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FR "Volume du canal FM 1 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FR "Réduit le volume du canal FM 1 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FR "Volume du canal FM 2 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FR "Réduit le volume du canal FM 2 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FR "Volume du canal FM 3 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FR "Réduit le volume du canal FM 3 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FR "Volume du canal FM 4 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FR "Réduit le volume du canal FM 4 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FR "Volume du canal FM 5 de la Mega Drive/Genesis (%)"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FR "Réduit le volume du canal FM 5 de la Mega Drive/Genesis. Ne fonctionne qu'avec les émulateurs FM MAME."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 0 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FR "Réduit le volume du canal FM 0 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 1 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FR "Réduit le volume du canal FM 1 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 2 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FR "Réduit le volume du canal FM 2 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 3 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FR "Réduit le volume du canal FM 3 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 4 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FR "Réduit le volume du canal FM 4 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 5 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FR "Réduit le volume du canal FM 5 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 6 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FR "Réduit le volume du canal FM 6 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 7 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FR "Réduit le volume du canal FM 7 de la Master System."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FR "Volume du canal FM (YM2413) 8 de la Master System (%)"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FR "Réduit le volume du canal FM 8 de la Master System."

struct retro_core_option_v2_category option_cats_fr[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_FR,
      CATEGORY_SYSTEM_INFO_0_FR
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_FR,
      CATEGORY_VIDEO_INFO_0_FR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FR,
      CATEGORY_AUDIO_INFO_0_FR
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FR,
      CATEGORY_INPUT_INFO_0_FR
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FR,
      CATEGORY_HACKS_INFO_0_FR
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_FR,
      CATEGORY_CHANNEL_VOLUME_INFO_0_FR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fr[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_FR               },
         { "sg-1000",              OPTION_VAL_SG_1000_FR            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_FR         },
         { "mark-III",             OPTION_VAL_MARK_III_FR           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_FR      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_FR   },
         { "game gear",            OPTION_VAL_GAME_GEAR_FR          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_FR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_FR   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_FR },
         { "pal",     OPTION_VAL_PAL_FR    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_FR },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_FR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_FR,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_FR },
         { "per game", OPTION_VAL_PER_GAME_FR },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_FR,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_FR },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_FR },
         { "megasd",       OPTION_VAL_MEGASD_FR },
         { "none",         OPTION_VAL_NONE_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_FR,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_FR },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_FR },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_FR,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_FR },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_FR },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_FR },
         { "4:3",  OPTION_VAL_4_3_FR },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_FR },
         { "left/right", OPTION_VAL_LEFT_RIGHT_FR },
         { "full",       OPTION_VAL_FULL_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_FR },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_FR },
         { "composite",  OPTION_VAL_COMPOSITE_FR },
         { "svideo",     OPTION_VAL_SVIDEO_FR },
         { "rgb",        OPTION_VAL_RGB_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_FR,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_FR },
         { "double field", OPTION_VAL_DOUBLE_FIELD_FR },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_FR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_FR },
         { "manual",   OPTION_VAL_MANUAL_FR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_FR,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_FR,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_FR },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_FR,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_FR },
         { "nuked", OPTION_VAL_NUKED_FR },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_FR,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_FR,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_FR,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_FR },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_FR },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_FR },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_FR },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_FR },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_FR,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_FR },
         { "mono",   OPTION_VAL_MONO_FR },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_FR,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_FR },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_FR },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_FR,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_FR,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_FR,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FR },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FR },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_FR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_FR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_FR },
         { "125%", OPTION_VAL_125_FR },
         { "150%", OPTION_VAL_150_FR },
         { "175%", OPTION_VAL_175_FR },
         { "200%", OPTION_VAL_200_FR },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_FR,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_FR,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_FR,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fr = {
   option_cats_fr,
   option_defs_fr
};

/* RETRO_LANGUAGE_GL */

#define CATEGORY_SYSTEM_LABEL_GL NULL
#define CATEGORY_SYSTEM_INFO_0_GL NULL
#define CATEGORY_VIDEO_LABEL_GL "Vídeo"
#define CATEGORY_VIDEO_INFO_0_GL NULL
#define CATEGORY_AUDIO_LABEL_GL "Son"
#define CATEGORY_AUDIO_INFO_0_GL NULL
#define CATEGORY_INPUT_LABEL_GL "Entrada"
#define CATEGORY_INPUT_INFO_0_GL NULL
#define CATEGORY_HACKS_LABEL_GL "Hacks de emulación"
#define CATEGORY_HACKS_INFO_0_GL NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_GL NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_GL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_GL NULL
#define OPTION_VAL_AUTO_GL NULL
#define OPTION_VAL_SG_1000_GL NULL
#define OPTION_VAL_SG_1000_II_GL NULL
#define OPTION_VAL_MARK_III_GL NULL
#define OPTION_VAL_MASTER_SYSTEM_GL NULL
#define OPTION_VAL_MASTER_SYSTEM_II_GL NULL
#define OPTION_VAL_GAME_GEAR_GL NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_GL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_GL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_GL NULL
#define OPTION_VAL_NTSC_U_GL NULL
#define OPTION_VAL_PAL_GL NULL
#define OPTION_VAL_NTSC_J_GL NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_GL NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_GL NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_GL NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_GL NULL
#define OPTION_VAL_PER_BIOS_GL NULL
#define OPTION_VAL_PER_GAME_GL NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_GL NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_GL NULL
#define OPTION_VAL_SEGA_MEGA_CD_GL NULL
#define OPTION_VAL_MEGASD_GL NULL
#define OPTION_VAL_NONE_GL "Ningún"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_GL NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_GL NULL
#define OPTION_VAL_GAME_GENIE_GL NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_GL NULL
#define OPTION_VAL_SONIC_KNUCKLES_GL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_GL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_GL NULL
#define OPTION_VAL_NTSC_PAR_GL NULL
#define OPTION_VAL_PAL_PAR_GL NULL
#define OPTION_VAL_4_3_GL NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_GL NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_GL NULL
#define OPTION_VAL_TOP_BOTTOM_GL NULL
#define OPTION_VAL_LEFT_RIGHT_GL NULL
#define OPTION_VAL_FULL_GL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_GL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_GL NULL
#define OPTION_VAL_LEFT_BORDER_GL NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_GL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_GL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_GL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_GL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_GL NULL
#define OPTION_VAL_MONOCHROME_GL NULL
#define OPTION_VAL_COMPOSITE_GL NULL
#define OPTION_VAL_SVIDEO_GL NULL
#define OPTION_VAL_RGB_GL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_GL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_GL NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_GL NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_GL NULL
#define OPTION_VAL_SINGLE_FIELD_GL NULL
#define OPTION_VAL_DOUBLE_FIELD_GL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_GL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_GL NULL
#define OPTION_VAL_MANUAL_GL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_GL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_GL "Cando a omisión de fotogramas sexa configurada en 'Manual', este axuste especifíca o umbral de ocupación do búfer de audio (en porcentaxe). Os valores altos reducen o risco de aparición de chasquidos omitindo fotogramas de forma máis frecuente."
#define GENESIS_PLUS_GX_YM2413_LABEL_GL NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_GL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_GL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_GL NULL
#define OPTION_VAL_MAME_GL NULL
#define OPTION_VAL_NUKED_GL NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_GL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_GL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_GL NULL
#define OPTION_VAL_MAME_YM2612_GL NULL
#define OPTION_VAL_MAME_ASIC_YM3438_GL NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_GL NULL
#define OPTION_VAL_NUKED_YM2612_GL NULL
#define OPTION_VAL_NUKED_YM3438_GL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_GL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_GL NULL
#define OPTION_VAL_STEREO_GL NULL
#define OPTION_VAL_MONO_GL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_GL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_GL NULL
#define OPTION_VAL_LOW_PASS_GL NULL
#define OPTION_VAL_EQ_GL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_GL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_GL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_GL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_GL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_GL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_GL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_GL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_GL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_GL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_GL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_GL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_GL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_GL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_GL NULL
#define OPTION_VAL_LIGHTGUN_GL NULL
#define OPTION_VAL_TOUCHSCREEN_GL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_GL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_GL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_GL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_GL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_GL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_GL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_GL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_GL NULL
#define OPTION_VAL_100_GL NULL
#define OPTION_VAL_125_GL NULL
#define OPTION_VAL_150_GL NULL
#define OPTION_VAL_175_GL NULL
#define OPTION_VAL_200_GL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_GL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_GL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_GL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_GL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_GL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_GL NULL

struct retro_core_option_v2_category option_cats_gl[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_GL,
      CATEGORY_SYSTEM_INFO_0_GL
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_GL,
      CATEGORY_VIDEO_INFO_0_GL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_GL,
      CATEGORY_AUDIO_INFO_0_GL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_GL,
      CATEGORY_INPUT_INFO_0_GL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_GL,
      CATEGORY_HACKS_INFO_0_GL
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_GL,
      CATEGORY_CHANNEL_VOLUME_INFO_0_GL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_gl[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_GL               },
         { "sg-1000",              OPTION_VAL_SG_1000_GL            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_GL         },
         { "mark-III",             OPTION_VAL_MARK_III_GL           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_GL      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_GL   },
         { "game gear",            OPTION_VAL_GAME_GEAR_GL          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_GL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_GL   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_GL },
         { "pal",     OPTION_VAL_PAL_GL    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_GL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_GL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_GL,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_GL },
         { "per game", OPTION_VAL_PER_GAME_GL },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_GL,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_GL },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_GL },
         { "megasd",       OPTION_VAL_MEGASD_GL },
         { "none",         OPTION_VAL_NONE_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_GL,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_GL },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_GL },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_GL,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_GL },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_GL },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_GL },
         { "4:3",  OPTION_VAL_4_3_GL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_GL },
         { "left/right", OPTION_VAL_LEFT_RIGHT_GL },
         { "full",       OPTION_VAL_FULL_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_GL },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_GL },
         { "composite",  OPTION_VAL_COMPOSITE_GL },
         { "svideo",     OPTION_VAL_SVIDEO_GL },
         { "rgb",        OPTION_VAL_RGB_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_GL,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_GL },
         { "double field", OPTION_VAL_DOUBLE_FIELD_GL },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_GL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_GL },
         { "manual",   OPTION_VAL_MANUAL_GL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_GL,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_GL,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_GL },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_GL,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_GL },
         { "nuked", OPTION_VAL_NUKED_GL },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_GL,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_GL,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_GL,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_GL },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_GL },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_GL },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_GL },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_GL },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_GL,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_GL },
         { "mono",   OPTION_VAL_MONO_GL },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_GL,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_GL },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_GL },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_GL,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_GL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_GL,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_GL },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_GL },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_GL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_GL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_GL },
         { "125%", OPTION_VAL_125_GL },
         { "150%", OPTION_VAL_150_GL },
         { "175%", OPTION_VAL_175_GL },
         { "200%", OPTION_VAL_200_GL },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_GL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_GL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_GL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_gl = {
   option_cats_gl,
   option_defs_gl
};

/* RETRO_LANGUAGE_HE */

#define CATEGORY_SYSTEM_LABEL_HE NULL
#define CATEGORY_SYSTEM_INFO_0_HE NULL
#define CATEGORY_VIDEO_LABEL_HE "וידאו"
#define CATEGORY_VIDEO_INFO_0_HE NULL
#define CATEGORY_AUDIO_LABEL_HE "שמע"
#define CATEGORY_AUDIO_INFO_0_HE NULL
#define CATEGORY_INPUT_LABEL_HE "קלט"
#define CATEGORY_INPUT_INFO_0_HE NULL
#define CATEGORY_HACKS_LABEL_HE NULL
#define CATEGORY_HACKS_INFO_0_HE NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_HE NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_HE NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_HE NULL
#define OPTION_VAL_AUTO_HE NULL
#define OPTION_VAL_SG_1000_HE NULL
#define OPTION_VAL_SG_1000_II_HE NULL
#define OPTION_VAL_MARK_III_HE NULL
#define OPTION_VAL_MASTER_SYSTEM_HE NULL
#define OPTION_VAL_MASTER_SYSTEM_II_HE NULL
#define OPTION_VAL_GAME_GEAR_HE NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_HE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_HE NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_HE NULL
#define OPTION_VAL_NTSC_U_HE NULL
#define OPTION_VAL_PAL_HE NULL
#define OPTION_VAL_NTSC_J_HE NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_HE NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_HE NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_HE NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_HE NULL
#define OPTION_VAL_PER_BIOS_HE NULL
#define OPTION_VAL_PER_GAME_HE NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_HE NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_HE NULL
#define OPTION_VAL_SEGA_MEGA_CD_HE NULL
#define OPTION_VAL_MEGASD_HE NULL
#define OPTION_VAL_NONE_HE NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_HE NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_HE NULL
#define OPTION_VAL_GAME_GENIE_HE NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_HE NULL
#define OPTION_VAL_SONIC_KNUCKLES_HE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_HE NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_HE NULL
#define OPTION_VAL_NTSC_PAR_HE NULL
#define OPTION_VAL_PAL_PAR_HE NULL
#define OPTION_VAL_4_3_HE NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_HE NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_HE NULL
#define OPTION_VAL_TOP_BOTTOM_HE NULL
#define OPTION_VAL_LEFT_RIGHT_HE NULL
#define OPTION_VAL_FULL_HE NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_HE NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_HE NULL
#define OPTION_VAL_LEFT_BORDER_HE NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_HE NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_HE NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_HE NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_HE NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_HE NULL
#define OPTION_VAL_MONOCHROME_HE NULL
#define OPTION_VAL_COMPOSITE_HE NULL
#define OPTION_VAL_SVIDEO_HE NULL
#define OPTION_VAL_RGB_HE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_HE NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_HE NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_HE NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_HE NULL
#define OPTION_VAL_SINGLE_FIELD_HE NULL
#define OPTION_VAL_DOUBLE_FIELD_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_HE NULL
#define OPTION_VAL_MANUAL_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_HE NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_HE NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_HE NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_HE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_HE NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_HE NULL
#define OPTION_VAL_MAME_HE NULL
#define OPTION_VAL_NUKED_HE NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_HE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_HE NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_HE NULL
#define OPTION_VAL_MAME_YM2612_HE NULL
#define OPTION_VAL_MAME_ASIC_YM3438_HE NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_HE NULL
#define OPTION_VAL_NUKED_YM2612_HE NULL
#define OPTION_VAL_NUKED_YM3438_HE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_HE NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_HE NULL
#define OPTION_VAL_STEREO_HE NULL
#define OPTION_VAL_MONO_HE NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_HE NULL
#define OPTION_VAL_LOW_PASS_HE NULL
#define OPTION_VAL_EQ_HE NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_HE NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_HE NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_HE NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_HE NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_HE NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_HE NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_HE NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_HE NULL
#define OPTION_VAL_LIGHTGUN_HE NULL
#define OPTION_VAL_TOUCHSCREEN_HE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_HE NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_HE NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_HE NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_HE NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_HE NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_HE NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_HE NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_HE NULL
#define OPTION_VAL_100_HE NULL
#define OPTION_VAL_125_HE NULL
#define OPTION_VAL_150_HE NULL
#define OPTION_VAL_175_HE NULL
#define OPTION_VAL_200_HE NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_HE NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_HE NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_HE NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_HE NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_HE NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_HE NULL

struct retro_core_option_v2_category option_cats_he[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_HE,
      CATEGORY_SYSTEM_INFO_0_HE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_HE,
      CATEGORY_VIDEO_INFO_0_HE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_HE,
      CATEGORY_AUDIO_INFO_0_HE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_HE,
      CATEGORY_INPUT_INFO_0_HE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_HE,
      CATEGORY_HACKS_INFO_0_HE
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_HE,
      CATEGORY_CHANNEL_VOLUME_INFO_0_HE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_he[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_HE               },
         { "sg-1000",              OPTION_VAL_SG_1000_HE            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_HE         },
         { "mark-III",             OPTION_VAL_MARK_III_HE           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_HE      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_HE   },
         { "game gear",            OPTION_VAL_GAME_GEAR_HE          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_HE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_HE   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_HE },
         { "pal",     OPTION_VAL_PAL_HE    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_HE },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_HE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_HE,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_HE },
         { "per game", OPTION_VAL_PER_GAME_HE },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_HE,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_HE },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_HE },
         { "megasd",       OPTION_VAL_MEGASD_HE },
         { "none",         OPTION_VAL_NONE_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_HE,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_HE },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_HE },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_HE,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_HE },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_HE },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_HE },
         { "4:3",  OPTION_VAL_4_3_HE },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_HE },
         { "left/right", OPTION_VAL_LEFT_RIGHT_HE },
         { "full",       OPTION_VAL_FULL_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_HE },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_HE },
         { "composite",  OPTION_VAL_COMPOSITE_HE },
         { "svideo",     OPTION_VAL_SVIDEO_HE },
         { "rgb",        OPTION_VAL_RGB_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_HE,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_HE },
         { "double field", OPTION_VAL_DOUBLE_FIELD_HE },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_HE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_HE },
         { "manual",   OPTION_VAL_MANUAL_HE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_HE,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_HE,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_HE },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_HE,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_HE },
         { "nuked", OPTION_VAL_NUKED_HE },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_HE,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_HE,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_HE,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_HE },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_HE },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_HE },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_HE },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_HE },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_HE,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_HE },
         { "mono",   OPTION_VAL_MONO_HE },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_HE,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_HE },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_HE },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_HE,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_HE,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_HE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_HE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_HE },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_HE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_HE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_HE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_HE,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_HE },
         { "125%", OPTION_VAL_125_HE },
         { "150%", OPTION_VAL_150_HE },
         { "175%", OPTION_VAL_175_HE },
         { "200%", OPTION_VAL_200_HE },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_HE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_HE,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_HE,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_HE,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_he = {
   option_cats_he,
   option_defs_he
};

/* RETRO_LANGUAGE_HU */

#define CATEGORY_SYSTEM_LABEL_HU NULL
#define CATEGORY_SYSTEM_INFO_0_HU NULL
#define CATEGORY_VIDEO_LABEL_HU "Videó"
#define CATEGORY_VIDEO_INFO_0_HU NULL
#define CATEGORY_AUDIO_LABEL_HU "Hang"
#define CATEGORY_AUDIO_INFO_0_HU NULL
#define CATEGORY_INPUT_LABEL_HU "Bevitel"
#define CATEGORY_INPUT_INFO_0_HU NULL
#define CATEGORY_HACKS_LABEL_HU NULL
#define CATEGORY_HACKS_INFO_0_HU NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_HU NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_HU NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_HU NULL
#define OPTION_VAL_AUTO_HU NULL
#define OPTION_VAL_SG_1000_HU NULL
#define OPTION_VAL_SG_1000_II_HU NULL
#define OPTION_VAL_MARK_III_HU NULL
#define OPTION_VAL_MASTER_SYSTEM_HU NULL
#define OPTION_VAL_MASTER_SYSTEM_II_HU NULL
#define OPTION_VAL_GAME_GEAR_HU NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_HU NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_HU NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_HU NULL
#define OPTION_VAL_NTSC_U_HU NULL
#define OPTION_VAL_PAL_HU NULL
#define OPTION_VAL_NTSC_J_HU NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_HU NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_HU NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_HU NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_HU NULL
#define OPTION_VAL_PER_BIOS_HU NULL
#define OPTION_VAL_PER_GAME_HU NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_HU NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_HU NULL
#define OPTION_VAL_SEGA_MEGA_CD_HU NULL
#define OPTION_VAL_MEGASD_HU NULL
#define OPTION_VAL_NONE_HU NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_HU NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_HU NULL
#define OPTION_VAL_GAME_GENIE_HU NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_HU NULL
#define OPTION_VAL_SONIC_KNUCKLES_HU NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_HU NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_HU NULL
#define OPTION_VAL_NTSC_PAR_HU NULL
#define OPTION_VAL_PAL_PAR_HU NULL
#define OPTION_VAL_4_3_HU NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_HU NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_HU NULL
#define OPTION_VAL_TOP_BOTTOM_HU NULL
#define OPTION_VAL_LEFT_RIGHT_HU NULL
#define OPTION_VAL_FULL_HU NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_HU NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_HU NULL
#define OPTION_VAL_LEFT_BORDER_HU NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_HU NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_HU NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_HU NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_HU NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_HU NULL
#define OPTION_VAL_MONOCHROME_HU NULL
#define OPTION_VAL_COMPOSITE_HU NULL
#define OPTION_VAL_SVIDEO_HU NULL
#define OPTION_VAL_RGB_HU NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_HU NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_HU NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_HU NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_HU NULL
#define OPTION_VAL_SINGLE_FIELD_HU NULL
#define OPTION_VAL_DOUBLE_FIELD_HU NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_HU NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_HU NULL
#define OPTION_VAL_MANUAL_HU "Kézi"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_HU NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_HU NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_HU NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_HU NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_HU NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_HU NULL
#define OPTION_VAL_MAME_HU NULL
#define OPTION_VAL_NUKED_HU NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_HU NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_HU NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_HU NULL
#define OPTION_VAL_MAME_YM2612_HU NULL
#define OPTION_VAL_MAME_ASIC_YM3438_HU NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_HU NULL
#define OPTION_VAL_NUKED_YM2612_HU NULL
#define OPTION_VAL_NUKED_YM3438_HU NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_HU NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_HU NULL
#define OPTION_VAL_STEREO_HU NULL
#define OPTION_VAL_MONO_HU NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_HU NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_HU NULL
#define OPTION_VAL_LOW_PASS_HU NULL
#define OPTION_VAL_EQ_HU NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_HU NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_HU NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_HU NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_HU NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_HU NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_HU NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_HU NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_HU NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_HU NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_HU NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_HU NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_HU NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_HU NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_HU NULL
#define OPTION_VAL_LIGHTGUN_HU NULL
#define OPTION_VAL_TOUCHSCREEN_HU NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_HU NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_HU NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_HU NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_HU NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_HU NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_HU NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_HU NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_HU NULL
#define OPTION_VAL_100_HU NULL
#define OPTION_VAL_125_HU NULL
#define OPTION_VAL_150_HU NULL
#define OPTION_VAL_175_HU NULL
#define OPTION_VAL_200_HU NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_HU NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_HU NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_HU NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_HU NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_HU NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_HU NULL

struct retro_core_option_v2_category option_cats_hu[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_HU,
      CATEGORY_SYSTEM_INFO_0_HU
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_HU,
      CATEGORY_VIDEO_INFO_0_HU
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_HU,
      CATEGORY_AUDIO_INFO_0_HU
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_HU,
      CATEGORY_INPUT_INFO_0_HU
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_HU,
      CATEGORY_HACKS_INFO_0_HU
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_HU,
      CATEGORY_CHANNEL_VOLUME_INFO_0_HU
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_hu[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_HU,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_HU               },
         { "sg-1000",              OPTION_VAL_SG_1000_HU            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_HU         },
         { "mark-III",             OPTION_VAL_MARK_III_HU           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_HU      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_HU   },
         { "game gear",            OPTION_VAL_GAME_GEAR_HU          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_HU },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_HU,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_HU   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_HU },
         { "pal",     OPTION_VAL_PAL_HU    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_HU },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_HU,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_HU,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_HU },
         { "per game", OPTION_VAL_PER_GAME_HU },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_HU,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_HU },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_HU },
         { "megasd",       OPTION_VAL_MEGASD_HU },
         { "none",         OPTION_VAL_NONE_HU },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_HU,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_HU },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_HU },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_HU },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_HU,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_HU },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_HU },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_HU },
         { "4:3",  OPTION_VAL_4_3_HU },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_HU,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_HU },
         { "left/right", OPTION_VAL_LEFT_RIGHT_HU },
         { "full",       OPTION_VAL_FULL_HU },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_HU,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_HU },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_HU },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_HU,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_HU,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_HU },
         { "composite",  OPTION_VAL_COMPOSITE_HU },
         { "svideo",     OPTION_VAL_SVIDEO_HU },
         { "rgb",        OPTION_VAL_RGB_HU },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_HU,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_HU,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_HU },
         { "double field", OPTION_VAL_DOUBLE_FIELD_HU },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_HU,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_HU },
         { "manual",   OPTION_VAL_MANUAL_HU },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_HU,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_HU,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_HU },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_HU,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_HU },
         { "nuked", OPTION_VAL_NUKED_HU },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_HU,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_HU,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_HU,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_HU },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_HU },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_HU },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_HU },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_HU },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_HU,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_HU },
         { "mono",   OPTION_VAL_MONO_HU },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_HU,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_HU },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_HU },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_HU,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_HU,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_HU,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_HU },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_HU },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_HU,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_HU,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_HU,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_HU,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_HU },
         { "125%", OPTION_VAL_125_HU },
         { "150%", OPTION_VAL_150_HU },
         { "175%", OPTION_VAL_175_HU },
         { "200%", OPTION_VAL_200_HU },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_HU,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_HU,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_HU,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_HU,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_hu = {
   option_cats_hu,
   option_defs_hu
};

/* RETRO_LANGUAGE_ID */

#define CATEGORY_SYSTEM_LABEL_ID NULL
#define CATEGORY_SYSTEM_INFO_0_ID NULL
#define CATEGORY_VIDEO_LABEL_ID NULL
#define CATEGORY_VIDEO_INFO_0_ID NULL
#define CATEGORY_AUDIO_LABEL_ID "Suara"
#define CATEGORY_AUDIO_INFO_0_ID NULL
#define CATEGORY_INPUT_LABEL_ID "Masukan"
#define CATEGORY_INPUT_INFO_0_ID NULL
#define CATEGORY_HACKS_LABEL_ID NULL
#define CATEGORY_HACKS_INFO_0_ID NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_ID NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_ID NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_ID NULL
#define OPTION_VAL_AUTO_ID NULL
#define OPTION_VAL_SG_1000_ID NULL
#define OPTION_VAL_SG_1000_II_ID NULL
#define OPTION_VAL_MARK_III_ID NULL
#define OPTION_VAL_MASTER_SYSTEM_ID NULL
#define OPTION_VAL_MASTER_SYSTEM_II_ID NULL
#define OPTION_VAL_GAME_GEAR_ID NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_ID NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_ID NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_ID NULL
#define OPTION_VAL_NTSC_U_ID NULL
#define OPTION_VAL_PAL_ID NULL
#define OPTION_VAL_NTSC_J_ID NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_ID NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_ID NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_ID NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_ID NULL
#define OPTION_VAL_PER_BIOS_ID NULL
#define OPTION_VAL_PER_GAME_ID NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_ID NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_ID NULL
#define OPTION_VAL_SEGA_MEGA_CD_ID NULL
#define OPTION_VAL_MEGASD_ID NULL
#define OPTION_VAL_NONE_ID NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_ID NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_ID NULL
#define OPTION_VAL_GAME_GENIE_ID NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_ID NULL
#define OPTION_VAL_SONIC_KNUCKLES_ID NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_ID NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_ID NULL
#define OPTION_VAL_NTSC_PAR_ID NULL
#define OPTION_VAL_PAL_PAR_ID NULL
#define OPTION_VAL_4_3_ID NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_ID NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_ID NULL
#define OPTION_VAL_TOP_BOTTOM_ID NULL
#define OPTION_VAL_LEFT_RIGHT_ID NULL
#define OPTION_VAL_FULL_ID NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_ID NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_ID NULL
#define OPTION_VAL_LEFT_BORDER_ID NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_ID NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_ID NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_ID NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_ID NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_ID NULL
#define OPTION_VAL_MONOCHROME_ID NULL
#define OPTION_VAL_COMPOSITE_ID NULL
#define OPTION_VAL_SVIDEO_ID NULL
#define OPTION_VAL_RGB_ID NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_ID NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_ID NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_ID NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_ID NULL
#define OPTION_VAL_SINGLE_FIELD_ID NULL
#define OPTION_VAL_DOUBLE_FIELD_ID NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_ID NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_ID NULL
#define OPTION_VAL_MANUAL_ID NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_ID NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_ID "Saat 'Frameskip' di setel ke 'Manual', tentukan ambang batas hunian buffer audio (persentase) di bawah frame mana yang akan dilewati. Nilai yang lebih tinggi mengurangi risiko keretakan dengan menyebabkan bingkai frame lebih sering dijatuhkan."
#define GENESIS_PLUS_GX_YM2413_LABEL_ID NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_ID NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_ID NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_ID NULL
#define OPTION_VAL_MAME_ID NULL
#define OPTION_VAL_NUKED_ID NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_ID NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_ID NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_ID NULL
#define OPTION_VAL_MAME_YM2612_ID NULL
#define OPTION_VAL_MAME_ASIC_YM3438_ID NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_ID NULL
#define OPTION_VAL_NUKED_YM2612_ID NULL
#define OPTION_VAL_NUKED_YM3438_ID NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_ID NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_ID NULL
#define OPTION_VAL_STEREO_ID NULL
#define OPTION_VAL_MONO_ID NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_ID NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_ID NULL
#define OPTION_VAL_LOW_PASS_ID NULL
#define OPTION_VAL_EQ_ID NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_ID NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_ID NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_ID NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_ID NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_ID NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_ID NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_ID NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_ID NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_ID NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_ID NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_ID NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_ID NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_ID NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_ID NULL
#define OPTION_VAL_LIGHTGUN_ID NULL
#define OPTION_VAL_TOUCHSCREEN_ID NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_ID NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_ID NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_ID NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_ID NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_ID NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_ID NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_ID NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_ID NULL
#define OPTION_VAL_100_ID NULL
#define OPTION_VAL_125_ID NULL
#define OPTION_VAL_150_ID NULL
#define OPTION_VAL_175_ID NULL
#define OPTION_VAL_200_ID NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_ID NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_ID NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_ID NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_ID NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_ID NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_ID NULL

struct retro_core_option_v2_category option_cats_id[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_ID,
      CATEGORY_SYSTEM_INFO_0_ID
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_ID,
      CATEGORY_VIDEO_INFO_0_ID
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_ID,
      CATEGORY_AUDIO_INFO_0_ID
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_ID,
      CATEGORY_INPUT_INFO_0_ID
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_ID,
      CATEGORY_HACKS_INFO_0_ID
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_ID,
      CATEGORY_CHANNEL_VOLUME_INFO_0_ID
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_id[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_ID,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_ID               },
         { "sg-1000",              OPTION_VAL_SG_1000_ID            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_ID         },
         { "mark-III",             OPTION_VAL_MARK_III_ID           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_ID      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_ID   },
         { "game gear",            OPTION_VAL_GAME_GEAR_ID          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_ID },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_ID,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_ID   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_ID },
         { "pal",     OPTION_VAL_PAL_ID    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_ID },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_ID,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_ID,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_ID },
         { "per game", OPTION_VAL_PER_GAME_ID },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_ID,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_ID },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_ID },
         { "megasd",       OPTION_VAL_MEGASD_ID },
         { "none",         OPTION_VAL_NONE_ID },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_ID,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_ID },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_ID },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_ID },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_ID,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_ID },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_ID },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_ID },
         { "4:3",  OPTION_VAL_4_3_ID },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_ID,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_ID },
         { "left/right", OPTION_VAL_LEFT_RIGHT_ID },
         { "full",       OPTION_VAL_FULL_ID },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_ID,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_ID },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_ID },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_ID,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_ID,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_ID },
         { "composite",  OPTION_VAL_COMPOSITE_ID },
         { "svideo",     OPTION_VAL_SVIDEO_ID },
         { "rgb",        OPTION_VAL_RGB_ID },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_ID,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_ID,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_ID },
         { "double field", OPTION_VAL_DOUBLE_FIELD_ID },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_ID,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_ID },
         { "manual",   OPTION_VAL_MANUAL_ID },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_ID,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_ID,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_ID },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_ID,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_ID },
         { "nuked", OPTION_VAL_NUKED_ID },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_ID,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_ID,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_ID,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_ID },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_ID },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_ID },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_ID },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_ID },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_ID,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_ID },
         { "mono",   OPTION_VAL_MONO_ID },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_ID,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_ID },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_ID },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_ID,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_ID,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_ID,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_ID },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_ID },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_ID,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_ID,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_ID,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_ID,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_ID },
         { "125%", OPTION_VAL_125_ID },
         { "150%", OPTION_VAL_150_ID },
         { "175%", OPTION_VAL_175_ID },
         { "200%", OPTION_VAL_200_ID },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_ID,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_ID,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_ID,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_ID,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_id = {
   option_cats_id,
   option_defs_id
};

/* RETRO_LANGUAGE_IT */

#define CATEGORY_SYSTEM_LABEL_IT "Sistema"
#define CATEGORY_SYSTEM_INFO_0_IT "Cambia la selezione hardware di base, regione, BIOS e Sega CD/Mega-CD impostazioni di salvataggio dei file."
#define CATEGORY_VIDEO_LABEL_IT NULL
#define CATEGORY_VIDEO_INFO_0_IT "Cambia le proporzioni, il ritaglio, il filtro video e le impostazioni di salto dei fotogrammi."
#define CATEGORY_AUDIO_LABEL_IT NULL
#define CATEGORY_AUDIO_INFO_0_IT "Cambia le impostazioni del dispositivo audio."
#define CATEGORY_INPUT_LABEL_IT NULL
#define CATEGORY_INPUT_INFO_0_IT "Cambia le impostazioni di input della pistola leggera e/o del mouse."
#define CATEGORY_HACKS_LABEL_IT "Hacks di Emulazione"
#define CATEGORY_HACKS_INFO_0_IT "Cambia le impostazioni di overclocking e di accuratezza dell'emulazione del processore che influenzano le prestazioni e la compatibilità di basso livello."
#define CATEGORY_CHANNEL_VOLUME_LABEL_IT "Impostazioni Avanzate Del Volume Dei Canali"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_IT "Cambia il volume dei singoli canali audio hardware."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_IT "Hardware Di Sistema"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_IT "Esegue il contenuto caricato con una specifica console emulata. 'Auto' selezionerà il sistema più appropriato per il gioco corrente."
#define OPTION_VAL_AUTO_IT "Automatico"
#define OPTION_VAL_SG_1000_IT NULL
#define OPTION_VAL_SG_1000_II_IT NULL
#define OPTION_VAL_MARK_III_IT NULL
#define OPTION_VAL_MASTER_SYSTEM_IT NULL
#define OPTION_VAL_MASTER_SYSTEM_II_IT NULL
#define OPTION_VAL_GAME_GEAR_IT NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_IT NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_IT "Regione Di Sistema"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_IT "Specifica la regione da cui proviene il sistema. Per console diverse dal Game Gear, 'PAL' è 50 hz mentre 'NTSC' è 60 hz. I giochi possono essere più veloci o più lenti del normale se la regione errata è selezionata."
#define OPTION_VAL_NTSC_U_IT NULL
#define OPTION_VAL_PAL_IT NULL
#define OPTION_VAL_NTSC_J_IT NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_IT "ROM Di Avvio Di Sistema"
#define GENESIS_PLUS_GX_BIOS_INFO_0_IT "Usa BIOS/bootloader ufficiale per l'hardware emulato, se presente nella directory di sistema di RetroArch. Visualizza la sequenza di avvio/animazione specifica della console, quindi esegue il contenuto caricato."
#define GENESIS_PLUS_GX_BRAM_LABEL_IT "BRAM Del Sistema Cd"
#define GENESIS_PLUS_GX_BRAM_INFO_0_IT "Quando si esegue il contenuto di Sega CD/Mega-CD, specifica se condividere un singolo file di salvataggio tra tutti i giochi di una regione specifica (Per-BIOS) o creare un file di salvataggio separato per ogni partita (Per-Game). Si noti che il CD Sega / Mega-CD ha una limitata memoria interna, sufficiente solo per una manciata di titoli. Per evitare di esaurire lo spazio, si raccomanda l'impostazione 'Per-Game'."
#define OPTION_VAL_PER_BIOS_IT NULL
#define OPTION_VAL_PER_GAME_IT NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_IT "CD add-on (modalità MD) (Richiede il riavvio)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_IT "Specifica quale componente aggiuntivo usare per la riproduzione di CD audio con i giochi Mega Drive/Genesis supportati."
#define OPTION_VAL_SEGA_MEGA_CD_IT NULL
#define OPTION_VAL_MEGASD_IT NULL
#define OPTION_VAL_NONE_IT "Nessuno"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_IT "Cartuccia Lock-On"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_IT "Lock-On Technology è una funzione Mega Drive/Genesis che ha permesso a un gioco più vecchio di connettersi alla porta pass-through di una cartuccia speciale per un gioco esteso o alterato. Questa opzione specifica il tipo di cartuccia speciale 'lock-on' da emulare. Un file bios corrispondente deve essere presente nella directory di sistema di RetroArch."
#define OPTION_VAL_GAME_GENIE_IT NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_IT NULL
#define OPTION_VAL_SONIC_KNUCKLES_IT NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_IT "Rapporto Dimensioni fornito dal Core"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_IT "Scegli le proporzioni preferite del contenuto. Questo si applicherà solo quando le proporzioni di RetroArch sono impostate su 'Core fornito' nelle impostazioni del video."
#define OPTION_VAL_NTSC_PAR_IT NULL
#define OPTION_VAL_PAL_PAR_IT NULL
#define OPTION_VAL_4_3_IT NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_IT "Bordi"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_IT "Abilita questa opzione per visualizzare le regioni di sovrascrittura in alto/in basso e/o a sinistra/destra dello schermo. Questi sarebbero normalmente nascosti dalla lunetta intorno al bordo di un televisore a definizione standard."
#define OPTION_VAL_TOP_BOTTOM_IT "Alto/Basso"
#define OPTION_VAL_LEFT_RIGHT_IT "Sinistra/Destra"
#define OPTION_VAL_FULL_IT "Pieno"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_IT "Nascondi Bordi Laterali Del Sistema Principale"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_IT "Taglia 8 pixel da entrambi i lati sinistro dello schermo, o entrambi i lati sinistro e destro quando si eseguono i giochi Master System."
#define OPTION_VAL_LEFT_BORDER_IT "Solo Bordo Sinistro"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_IT "Bordi Sinistra E Destra"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_IT "Game Gear Schermo esteso"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_IT "Forza i titoli di Game Gear a funzionare in modalità SMS, con una risoluzione aumentata di 256x192. Può mostrare contenuti aggiuntivi, ma in genere visualizza un bordo di dati di immagine corrotti / indesiderati."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_IT "Filtro Blargg NTSC"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_IT "Applicare un filtro video per imitare vari segnali TV NTSC."
#define OPTION_VAL_MONOCHROME_IT "Monocromatico"
#define OPTION_VAL_COMPOSITE_IT "Composito"
#define OPTION_VAL_SVIDEO_IT NULL
#define OPTION_VAL_RGB_IT NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_IT "Filtro Lcd Ghosting"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_IT "Applicare un filtro immagine \"ghosting\" per imitare le caratteristiche di visualizzazione dei pannelli LCD di Game Gear e Genesis Nomad."
#define GENESIS_PLUS_GX_RENDER_LABEL_IT "Uscita Modalità Interlacciata 2"
#define GENESIS_PLUS_GX_RENDER_INFO_0_IT "La modalità interlacciata 2 permette al Mega Drive/Genesis di produrre un'immagine a doppia altezza (alta risoluzione) 320x448 disegnando linee di scansione alternative ogni fotogramma (questo è usato da Sonic il riccio 2 e Combat Cars modalità multiplayer). 'Double Field' imita l'hardware originale, producendo un'immagine nitida con artefatti sfarfallanti/interlacciati. 'Campo singolo' applica un filtro di deinterlacciamento, che stabilizza l'immagine ma provoca una lieve sfocatura."
#define OPTION_VAL_SINGLE_FIELD_IT "Campo Singolo"
#define OPTION_VAL_DOUBLE_FIELD_IT "Doppio Campo"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_IT "Salta fotogramma"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_IT "Salta i fotogrammi per evitare la sottoesecuzione del buffer audio (crackling). Migliora le prestazioni a scapito della fluidità visiva. 'Auto' salta i quadri quando consigliato dal frontend. 'Manuale' utilizza l'impostazione 'Frameskip Threshold (%)'."
#define OPTION_VAL_MANUAL_IT "Manuale"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_IT "Soglia Frameskip (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_IT "Quando 'Salta fotogramma\" è impostato a 'Manuale', specifica la soglia di occupazione del buffer audio (percentuale) al di sotto della quale i quadri verranno saltati. Valori più elevati riducono il rischio di rompere causando un calo più frequente dei fotogrammi."
#define GENESIS_PLUS_GX_YM2413_LABEL_IT NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_IT "Abilita l'emulazione dell'unità sonora FM utilizzata da alcuni giochi Sega Mark III/Master System per un'uscita audio migliorata."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_IT NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_IT "Selezionare il metodo utilizzato per emulare l'unità sonora FM del Sega Mark III/Master System. L'opzione 'MAME' è veloce e funziona a piena velocità sulla maggior parte dei sistemi. 'Nuked' opzione è ciclo accurato, qualità molto alta e ha requisiti di CPU sostanziali."
#define OPTION_VAL_MAME_IT NULL
#define OPTION_VAL_NUKED_IT NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_IT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_IT "Selezionare il metodo utilizzato per emulare il sintetizzatore FM (generatore di suono principale) del Mega Drive/Genesis. Le opzioni 'MAME' sono veloci e funzionano a piena velocità sulla maggior parte dei sistemi. Le opzioni 'Nuked' sono ciclo accurato, qualità molto alta e hanno requisiti di CPU sostanziali. Il chip YM2612 viene utilizzato dal modello originale 1 Mega Drive/Genesis. Lo YM3438 viene utilizzato nelle successive revisioni di Mega Drive/Genesis."
#define GENESIS_PLUS_GX_YM2612_INFO_1_IT "Selezionare il metodo utilizzato per emulare il sintetizzatore FM (generatore di suono principale) del Mega Drive/Genesis. Il chip YM2612 viene utilizzato dal modello originale 1 Mega Drive/Genesis. Lo YM3438 viene utilizzato nelle successive revisioni di Mega Drive/Genesis."
#define OPTION_VAL_MAME_YM2612_IT NULL
#define OPTION_VAL_MAME_ASIC_YM3438_IT NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_IT "MAME (YM3438 potenziato)"
#define OPTION_VAL_NUKED_YM2612_IT NULL
#define OPTION_VAL_NUKED_YM3438_IT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_IT "Uscita Suono"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_IT "Seleziona riproduzione audio stereo o mono."
#define OPTION_VAL_STEREO_IT NULL
#define OPTION_VAL_MONO_IT NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_IT "Filtro Audio"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_IT "Abilita un filtro audio passa-basso per simulare meglio il suono caratteristico di un Megadrive/Genesis Modello 1."
#define OPTION_VAL_LOW_PASS_IT "Passo-basso"
#define OPTION_VAL_EQ_IT NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_IT "Filtro passo-basso %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_IT "Specificare la frequenza di cut-off del filtro passa-basso audio. Un valore più elevato aumenta la 'forza' percepita del filtro, poiché una gamma più ampia dello spettro ad alta frequenza è attenuata."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_IT "Livello Preamplificatore PSG"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_IT "Imposta il livello del preamplificatore audio del generatore audio programmabile a 4 canali SN76496 emulato trovato nello SG-1000, Sega Mark III, Master System, Game Gear e Mega Drive/Genesis."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_IT "Livello Preamplificatore FM"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_IT "Imposta il livello del preamplificatore audio del sintetizzatore sonoro Mega Drive/Genesis FM emulato o dell'unità sonora Sega Mark III/Master System FM."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_IT "Volume CD-DA"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_IT "Regola il volume di miscelazione dell'uscita di riproduzione audio CD emulato."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_IT "Volume PCM"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_IT "Regolare il volume di miscelazione dell'emulata uscita del generatore di suono Sega CD/Mega-CD RF5C164 PCM."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_IT "EQ Basso"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_IT "Regola la banda a basso raggio dell'equalizzatore audio interno."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_IT "EQ Medio"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_IT "Regola la banda di intervallo medio dell'equalizzatore audio interno."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_IT "EQ Alto"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_IT "Regola la banda di alta gamma dell'equalizzatore audio interno."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_IT "Ingresso Pistola Ottica"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_IT "Usa un ingresso 'Pistola Ottica' o 'Schermo tattile\" controllato dal mouse."
#define OPTION_VAL_LIGHTGUN_IT "Pistola Ottica"
#define OPTION_VAL_TOUCHSCREEN_IT "Schermo tattile"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_IT "Mostra Il Mirino Della Pistola Ottica"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_IT "Mostra i mirini della pistola leggera quando si utilizzano i tipi di dispositivo di ingresso MD Menacer, MD Justifiers e MS Light Phaser."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_IT "Inverti Asse Y Del Mouse"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_IT "Inverte l'asse Y del tipo di dispositivo di ingresso MD Mouse."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_IT "Rimuovi Limite Sprite Per Linea"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_IT "Rimuove il limite hardware originale sprite-per-scanline. Questo riduce lo sfarfallio ma può causare problemi visivi, poiché alcuni giochi sfruttano il limite hardware per generare effetti speciali."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_IT "Velocità CPU"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_IT "Sovrascrivi la CPU emulata. Può ridurre il rallentamento, ma può causare glitch."
#define OPTION_VAL_100_IT NULL
#define OPTION_VAL_125_IT NULL
#define OPTION_VAL_150_IT NULL
#define OPTION_VAL_175_IT NULL
#define OPTION_VAL_200_IT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_IT "Blocchi Di Sistema"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_IT "Emulare i blocchi di sistema che si verificano sull'hardware reale quando si esegue l'accesso illegale agli indirizzi. Questo dovrebbe essere disabilitato solo durante la riproduzione di alcune demo e homebrew che si basano su comportamenti illegali per il corretto funzionamento."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_IT "Errore Indirizzo 68K"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_IT "La CPU principale Mega Drive/Genesis (Motorola 68000) genera un'eccezione di errore di indirizzo (crash) quando si tenta di eseguire l'accesso alla memoria non allineato. Abilitando questo si simulerà questo comportamento. Dovrebbe essere disabilitato solo durante la riproduzione di hack ROM, dal momento che questi sono in genere sviluppati utilizzando emulatori meno accurati e possono fare affidamento su un accesso RAM non valido per il corretto funzionamento."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_IT "Mostra le impostazioni avanzate del volume audio (riapri il menu)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_IT "Abilita la configurazione dei parametri del canale audio a basso livello. NOTA: il menu rapido deve essere attivato perché questa impostazione abbia effetto."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_IT "Volume % del Tono PSG del Canale 0"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_IT "Riduce il volume del tono PSG del canale 0."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_IT "Volume % del Tono PSG del Canale 1"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_IT "Riduce il volume del tono PSG del canale 1."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_IT "Volume % del Tono PSG del Canale 2"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_IT "Riduce il volume del tono PSG del canale 2."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_IT "Volume % del Tono PSG del Canale 3"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_IT "Riduce il volume del tono PSG del canale 3."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_IT "Volume % del Mega Drive/Genesis FM Canale 0"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_IT "Riduce il volume del Mega Drive/Genesis FM Canale 0. Funziona solo con gli emulatori MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_IT "Volume % del Mega Drive/Genesis FM Canale 1"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_IT "Riduce il volume del Mega Drive/Genesis FM Canale 1. Funziona solo con gli emulatori MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_IT "Volume % del Mega Drive/Genesis FM Canale 2"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_IT "Riduce il volume del Mega Drive/Genesis FM Canale 2. Funziona solo con gli emulatori MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_IT "Volume % del Mega Drive/Genesis FM Canale 3"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_IT "Riduce il volume del Mega Drive/Genesis FM Canale 3. Funziona solo con gli emulatori MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_IT "Volume % del Mega Drive/Genesis FM Canale 4"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_IT "Riduce il volume del Mega Drive/Genesis FM Canale 4. Funziona solo con gli emulatori MAME FM."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_IT "Volume % del Mega Drive/Genesis FM Canale 5"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_IT "Riduce il volume del Mega Drive/Genesis FM Canale 5. Funziona solo con gli emulatori MAME FM."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 0"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_IT "Riduce il Volume del Master System FM del Canale 0."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 1"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 1."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 2"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 2."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 3"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 3."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 4"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 4."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 5"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 5."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 6"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 6."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 7"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 7."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_IT "Volume % del Master System FM (YM2413) del Canale 8"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_IT "Riduci il volume del Master System FM Canale 8."

struct retro_core_option_v2_category option_cats_it[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_IT,
      CATEGORY_SYSTEM_INFO_0_IT
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_IT,
      CATEGORY_VIDEO_INFO_0_IT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_IT,
      CATEGORY_AUDIO_INFO_0_IT
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_IT,
      CATEGORY_INPUT_INFO_0_IT
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_IT,
      CATEGORY_HACKS_INFO_0_IT
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_IT,
      CATEGORY_CHANNEL_VOLUME_INFO_0_IT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_it[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_IT,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_IT               },
         { "sg-1000",              OPTION_VAL_SG_1000_IT            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_IT         },
         { "mark-III",             OPTION_VAL_MARK_III_IT           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_IT      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_IT   },
         { "game gear",            OPTION_VAL_GAME_GEAR_IT          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_IT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_IT,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_IT   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_IT },
         { "pal",     OPTION_VAL_PAL_IT    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_IT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_IT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_IT,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_IT },
         { "per game", OPTION_VAL_PER_GAME_IT },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_IT,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_IT },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_IT },
         { "megasd",       OPTION_VAL_MEGASD_IT },
         { "none",         OPTION_VAL_NONE_IT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_IT,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_IT },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_IT },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_IT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_IT,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_IT },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_IT },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_IT },
         { "4:3",  OPTION_VAL_4_3_IT },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_IT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_IT },
         { "left/right", OPTION_VAL_LEFT_RIGHT_IT },
         { "full",       OPTION_VAL_FULL_IT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_IT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_IT },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_IT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_IT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_IT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_IT },
         { "composite",  OPTION_VAL_COMPOSITE_IT },
         { "svideo",     OPTION_VAL_SVIDEO_IT },
         { "rgb",        OPTION_VAL_RGB_IT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_IT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_IT,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_IT },
         { "double field", OPTION_VAL_DOUBLE_FIELD_IT },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_IT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_IT },
         { "manual",   OPTION_VAL_MANUAL_IT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_IT,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_IT,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_IT },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_IT,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_IT },
         { "nuked", OPTION_VAL_NUKED_IT },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_IT,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_IT,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_IT,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_IT },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_IT },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_IT },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_IT },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_IT },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_IT,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_IT },
         { "mono",   OPTION_VAL_MONO_IT },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_IT,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_IT },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_IT },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_IT,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_IT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_IT,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_IT },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_IT },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_IT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_IT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_IT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_IT,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_IT },
         { "125%", OPTION_VAL_125_IT },
         { "150%", OPTION_VAL_150_IT },
         { "175%", OPTION_VAL_175_IT },
         { "200%", OPTION_VAL_200_IT },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_IT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_IT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_IT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_IT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_it = {
   option_cats_it,
   option_defs_it
};

/* RETRO_LANGUAGE_JA */

#define CATEGORY_SYSTEM_LABEL_JA "システム"
#define CATEGORY_SYSTEM_INFO_0_JA "基本ハードウェアの選択、リージョン、BIOS、Sega CD/Mega-CDセーブファイルの設定を変更します。"
#define CATEGORY_VIDEO_LABEL_JA "ビデオのドライバ"
#define CATEGORY_VIDEO_INFO_0_JA "アスペクト比、表示トリミング、ビデオフィルター、フレームスキップの設定を変更します。"
#define CATEGORY_AUDIO_LABEL_JA "オーディオのドライバ"
#define CATEGORY_AUDIO_INFO_0_JA "オーディオデバイスの設定を変更する。"
#define CATEGORY_INPUT_LABEL_JA "入力"
#define CATEGORY_INPUT_INFO_0_JA "ライトガンやマウスの入力設定を変更します。"
#define CATEGORY_HACKS_LABEL_JA "エミュレーションハック"
#define CATEGORY_HACKS_INFO_0_JA "低レベルの性能と互換性に影響を与えるプロセッサのオーバークロックとエミュレーションの精度設定を変更します。"
#define CATEGORY_CHANNEL_VOLUME_LABEL_JA "高度なチャンネル音量設定"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_JA "個々のハードウェアオーディオチャンネルの音量を変更します。"
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_JA "システムハードウェア"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_JA "特定のエミュレートされたコンソールで読み込まれたコンテンツを実行します。「自動」は現在のゲームに最適なシステムを選択します。"
#define OPTION_VAL_AUTO_JA "自動"
#define OPTION_VAL_SG_1000_JA NULL
#define OPTION_VAL_SG_1000_II_JA NULL
#define OPTION_VAL_MARK_III_JA NULL
#define OPTION_VAL_MASTER_SYSTEM_JA NULL
#define OPTION_VAL_MASTER_SYSTEM_II_JA NULL
#define OPTION_VAL_GAME_GEAR_JA "ゲームギア"
#define OPTION_VAL_MEGA_DRIVE_GENESIS_JA NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_JA "システム地域"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_JA NULL
#define OPTION_VAL_NTSC_U_JA NULL
#define OPTION_VAL_PAL_JA NULL
#define OPTION_VAL_NTSC_J_JA NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_JA "システムブートROM"
#define GENESIS_PLUS_GX_BIOS_INFO_0_JA NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_JA "CD システム BRAM"
#define GENESIS_PLUS_GX_BRAM_INFO_0_JA NULL
#define OPTION_VAL_PER_BIOS_JA "BIOS ごと"
#define OPTION_VAL_PER_GAME_JA "ゲームごと"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_JA NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_JA NULL
#define OPTION_VAL_SEGA_MEGA_CD_JA NULL
#define OPTION_VAL_MEGASD_JA NULL
#define OPTION_VAL_NONE_JA "なし"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_JA NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_JA NULL
#define OPTION_VAL_GAME_GENIE_JA NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_JA NULL
#define OPTION_VAL_SONIC_KNUCKLES_JA NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_JA "コア提供アスペクト比"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_JA NULL
#define OPTION_VAL_NTSC_PAR_JA NULL
#define OPTION_VAL_PAL_PAR_JA NULL
#define OPTION_VAL_4_3_JA NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_JA NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_JA NULL
#define OPTION_VAL_TOP_BOTTOM_JA "上/下"
#define OPTION_VAL_LEFT_RIGHT_JA "左/右"
#define OPTION_VAL_FULL_JA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_JA NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_JA NULL
#define OPTION_VAL_LEFT_BORDER_JA NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_JA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_JA NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_JA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_JA NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_JA NULL
#define OPTION_VAL_MONOCHROME_JA "モノクローム"
#define OPTION_VAL_COMPOSITE_JA NULL
#define OPTION_VAL_SVIDEO_JA NULL
#define OPTION_VAL_RGB_JA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_JA NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_JA NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_JA NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_JA NULL
#define OPTION_VAL_SINGLE_FIELD_JA NULL
#define OPTION_VAL_DOUBLE_FIELD_JA NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_JA "フレームスキップ"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_JA "フレームをスキップしてオーディオバッファアンダーラン (音割れ) を回避します。視覚的な滑らかさを犠牲にしてパフォーマンスを向上させます。 「自動」は、フロントエンドにアドバイスされたときにフレームをスキップします。「マニュアル」は、「フレームスキップ閾値 (%)」設定を使用します。"
#define OPTION_VAL_MANUAL_JA "手動"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_JA "フレームスキップ閾値 (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_JA "'フレームスキップ' が '手動' に設定されている場合, フレームがスキップされるオーディオバッファ占有しきい値 (%) を指定します. 値を大きくすると, フレームを頻繁に落とすことでクラッキングが発生するリスクが低下します."
#define GENESIS_PLUS_GX_YM2413_LABEL_JA NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_JA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_JA NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_JA NULL
#define OPTION_VAL_MAME_JA NULL
#define OPTION_VAL_NUKED_JA NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_JA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_JA NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_JA NULL
#define OPTION_VAL_MAME_YM2612_JA NULL
#define OPTION_VAL_MAME_ASIC_YM3438_JA NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_JA NULL
#define OPTION_VAL_NUKED_YM2612_JA NULL
#define OPTION_VAL_NUKED_YM3438_JA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_JA NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_JA NULL
#define OPTION_VAL_STEREO_JA "ステレオ"
#define OPTION_VAL_MONO_JA "モノラル"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_JA "オーディオフィルタ"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_JA NULL
#define OPTION_VAL_LOW_PASS_JA NULL
#define OPTION_VAL_EQ_JA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_JA NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_JA NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_JA "PSG プリアンプレベル"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_JA NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_JA "FMプリアンプレベル"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_JA NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_JA "CD-DA 音量"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_JA "PCM音量"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_JA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_JA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_JA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_JA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_JA NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_JA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_JA NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_JA NULL
#define OPTION_VAL_LIGHTGUN_JA "ライトガン"
#define OPTION_VAL_TOUCHSCREEN_JA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_JA NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_JA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_JA NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_JA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_JA NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_JA NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_JA "CPU速度"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_JA NULL
#define OPTION_VAL_100_JA NULL
#define OPTION_VAL_125_JA NULL
#define OPTION_VAL_150_JA NULL
#define OPTION_VAL_175_JA NULL
#define OPTION_VAL_200_JA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_JA NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_JA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_JA NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_JA NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_JA NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_JA NULL

struct retro_core_option_v2_category option_cats_ja[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_JA,
      CATEGORY_SYSTEM_INFO_0_JA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_JA,
      CATEGORY_VIDEO_INFO_0_JA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_JA,
      CATEGORY_AUDIO_INFO_0_JA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_JA,
      CATEGORY_INPUT_INFO_0_JA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_JA,
      CATEGORY_HACKS_INFO_0_JA
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_JA,
      CATEGORY_CHANNEL_VOLUME_INFO_0_JA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ja[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_JA,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_JA               },
         { "sg-1000",              OPTION_VAL_SG_1000_JA            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_JA         },
         { "mark-III",             OPTION_VAL_MARK_III_JA           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_JA      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_JA   },
         { "game gear",            OPTION_VAL_GAME_GEAR_JA          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_JA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_JA,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_JA   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_JA },
         { "pal",     OPTION_VAL_PAL_JA    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_JA },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_JA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_JA,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_JA },
         { "per game", OPTION_VAL_PER_GAME_JA },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_JA,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_JA },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_JA },
         { "megasd",       OPTION_VAL_MEGASD_JA },
         { "none",         OPTION_VAL_NONE_JA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_JA,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_JA },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_JA },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_JA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_JA,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_JA },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_JA },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_JA },
         { "4:3",  OPTION_VAL_4_3_JA },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_JA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_JA },
         { "left/right", OPTION_VAL_LEFT_RIGHT_JA },
         { "full",       OPTION_VAL_FULL_JA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_JA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_JA },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_JA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_JA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_JA,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_JA },
         { "composite",  OPTION_VAL_COMPOSITE_JA },
         { "svideo",     OPTION_VAL_SVIDEO_JA },
         { "rgb",        OPTION_VAL_RGB_JA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_JA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_JA,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_JA },
         { "double field", OPTION_VAL_DOUBLE_FIELD_JA },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_JA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_JA },
         { "manual",   OPTION_VAL_MANUAL_JA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_JA,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_JA,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_JA },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_JA,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_JA },
         { "nuked", OPTION_VAL_NUKED_JA },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_JA,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_JA,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_JA,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_JA },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_JA },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_JA },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_JA },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_JA },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_JA,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_JA },
         { "mono",   OPTION_VAL_MONO_JA },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_JA,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_JA },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_JA },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_JA,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_JA,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_JA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_JA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_JA },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_JA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_JA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_JA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_JA,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_JA },
         { "125%", OPTION_VAL_125_JA },
         { "150%", OPTION_VAL_150_JA },
         { "175%", OPTION_VAL_175_JA },
         { "200%", OPTION_VAL_200_JA },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_JA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_JA,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_JA,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_JA,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ja = {
   option_cats_ja,
   option_defs_ja
};

/* RETRO_LANGUAGE_KO */

#define CATEGORY_SYSTEM_LABEL_KO "시스템"
#define CATEGORY_SYSTEM_INFO_0_KO "기본 하드웨어, 지역, BIOS, Sega CD/Mega-CD 저장 파일 등의 설정을 변경합니다."
#define CATEGORY_VIDEO_LABEL_KO "비디오"
#define CATEGORY_VIDEO_INFO_0_KO "화면비, 잘라내기, 비디오 필터, 프레임 스킵 등의 설정을 변경합니다."
#define CATEGORY_AUDIO_LABEL_KO "오디오"
#define CATEGORY_AUDIO_INFO_0_KO "오디오 장치 설정을 변경합니다."
#define CATEGORY_INPUT_LABEL_KO "입력"
#define CATEGORY_INPUT_INFO_0_KO "라이트 건 및 마우스 설정을 변경합니다."
#define CATEGORY_HACKS_LABEL_KO "에뮬레이션 핵"
#define CATEGORY_HACKS_INFO_0_KO "성능과 호환성에 영향을 끼치는 프로세서 오버클러킹 및 에뮬레이션 정확도 설정 등을 변경합니다."
#define CATEGORY_CHANNEL_VOLUME_LABEL_KO "고급 채널 볼륨 설정"
#define CATEGORY_CHANNEL_VOLUME_INFO_0_KO "개별 하드웨어 오디오 채널의 볼륨을 변경합니다."
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_KO "시스템 하드웨어"
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_KO "불러온 컨텐츠를 실행할 콘솔을 선택합니다. '자동'으로 설정하면 게임에 가장 적절한 시스템을 자동으로 선택합니다."
#define OPTION_VAL_AUTO_KO "자동"
#define OPTION_VAL_SG_1000_KO NULL
#define OPTION_VAL_SG_1000_II_KO NULL
#define OPTION_VAL_MARK_III_KO NULL
#define OPTION_VAL_MASTER_SYSTEM_KO NULL
#define OPTION_VAL_MASTER_SYSTEM_II_KO NULL
#define OPTION_VAL_GAME_GEAR_KO NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_KO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_KO "시스템 지역"
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_KO "시스템의 지역을 선택합니다. Game Gear를 제외한 다른 콘솔들에게 'PAL'은 50 Hz, 'NTSC'는 60 Hz입니다. 잘못된 지역을 선택할 경우 게임이 정상 속도보다 빠르거나 느리게 실행될 수 있습니다."
#define OPTION_VAL_NTSC_U_KO NULL
#define OPTION_VAL_PAL_KO NULL
#define OPTION_VAL_NTSC_J_KO NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_KO "시스템 부트 롬"
#define GENESIS_PLUS_GX_BIOS_INFO_0_KO "하드웨어의 공식 BIOS/부트로더를 사용합니다. 해당되는 파일이 RetroArch의 시스템 디렉토리에 존재해야 합니다. 콘솔 특유의 시작 시퀀스/애니메이션을 표시하고 컨텐츠를 실행합니다."
#define GENESIS_PLUS_GX_BRAM_LABEL_KO "CD 시스템 BRAM"
#define GENESIS_PLUS_GX_BRAM_INFO_0_KO "Sega CD/Mega-CD 컨텐츠를 실행할 때, 특정 지역의 모든 게임 간에 단일 세이브 파일을 사용할지(BIOS별), 각 게임마다 별도의 세이브 파일을 사용할지(게임별)를 선택합니다. Sega CD/Mega-CD의 내부 저장소는 아주 작아 게임 몇 개의 데이터만 저장할 수 있으므로, 용량 부족 방지를 위해 '게임별' 설정을 사용할 것을 권장합니다."
#define OPTION_VAL_PER_BIOS_KO "BIOS별"
#define OPTION_VAL_PER_GAME_KO "게임별"
#define GENESIS_PLUS_GX_ADD_ON_LABEL_KO "CD 애드온 (MD 모드) (재시작 필요)"
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_KO "지원되는 Mega Drive/Genesis 게임의 CD 오디오 재생을 위해 사용할 애드온을 선택합니다."
#define OPTION_VAL_SEGA_MEGA_CD_KO NULL
#define OPTION_VAL_MEGASD_KO NULL
#define OPTION_VAL_NONE_KO "없음"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_KO "카트리지 록온"
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_KO "록온 기술은 특별한 카트리지의 패스스루 포트에 다른 게임을 연결해 추가적인 게임플레이를 구현하는 Mega Drive/Genesis의 기능입니다. 이 옵션은 어떤 '락온' 카트리지를 사용할지 설정합니다. 해당되는 BIOS 파일이 RetroArch의 시스템 디렉토리에 존재해야 합니다."
#define OPTION_VAL_GAME_GENIE_KO NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_KO NULL
#define OPTION_VAL_SONIC_KNUCKLES_KO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_KO "코어 제공 화면비"
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_KO "선호하는 컨텐츠 화면비를 선택합니다. RetroArch의 비디오 설정에서 화면비가 'Core provided'로 설정되어 있어야 적용됩니다."
#define OPTION_VAL_NTSC_PAR_KO NULL
#define OPTION_VAL_PAL_PAR_KO NULL
#define OPTION_VAL_4_3_KO NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_KO "테두리"
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_KO "이 옵션을 활성화하면 화면의 위/아래 또는 좌/우 오버스캔 지역을 표시합니다. 이 지역은 일반적으로 텔레비전의 베젤에 가려져 표시되지 않습니다."
#define OPTION_VAL_TOP_BOTTOM_KO "위/아래"
#define OPTION_VAL_LEFT_RIGHT_KO "좌/우"
#define OPTION_VAL_FULL_KO "모두"
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_KO "Master System 테두리 숨기기"
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_KO "Master System 게임을 실행할 때 화면을 왼쪽 또는 왼쪽과 오른쪽에서 8픽셀씩 잘라냅니다."
#define OPTION_VAL_LEFT_BORDER_KO "왼쪽만"
#define OPTION_VAL_LEFT_RIGHT_BORDERS_KO "왼쪽 및 오른쪽"
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_KO "Game Gear 화면 확장"
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_KO "Game Gear 게임을 강제로 256x192의 확장된 해상도를 가지는 SMS 모드로 실행합니다. 더 많은 컨텐츠를 보여줄 수도 있지만, 일반적으로 망가진 이미지 데이터로 이루어진 테두리가 표시됩니다."
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_KO "Blargg NTSC 필터"
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_KO "다양한 NTSC TV 신호를 흉내내는 비디오 필터를 적용합니다."
#define OPTION_VAL_MONOCHROME_KO "흑백"
#define OPTION_VAL_COMPOSITE_KO "컴포지트"
#define OPTION_VAL_SVIDEO_KO "S-비디오"
#define OPTION_VAL_RGB_KO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_KO "LCD 고스팅 필터"
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_KO "Game Gear 또는 Genesis Nomad의 LCD 패널에서 나타나는 이미지 '고스팅' 현상을 흉내내는 비디오 필터를 적용합니다."
#define GENESIS_PLUS_GX_RENDER_LABEL_KO "인터레이스 모드 2 출력"
#define GENESIS_PLUS_GX_RENDER_INFO_0_KO "인터레이스 모드 2는 Mega Drive/Genesis가 매 프레임마다 다른 스캔라인을 사용하여 기존 해상도의 2배인 320x448의 고해상도를 사용할 수 있게 합니다. 이 기술은 Sonic the Hedgehog 2와 Combat Cars의 멀티플레이어 모드에 사용되었습니다. '이중 필드'는 원본 하드웨어의 동작을 따라하여 날카롭지만 깜빡이며 지저분한 이미지를 표시합니다. '단일 필드'는 디인터레이싱 필터를 적용하여 안정적이지만 다소 부드러운 이미지를 표시합니다."
#define OPTION_VAL_SINGLE_FIELD_KO "단일 필드"
#define OPTION_VAL_DOUBLE_FIELD_KO "이중 필드"
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_KO "프레임 스킵"
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_KO "오디오 버퍼 언더런(소리깨짐) 을 줄이기 위해 프레임 건너뛰기를 합니다. 시각적인 부드러움을 포기하는 대신 성능이 향상됩니다. '자동'은 프론트엔드의 추천값으로 실행되고 '사용자 설정'은 '프레임 스킵 임계값(%)' 설정을 이용해 실행됩니다."
#define OPTION_VAL_MANUAL_KO "사용자 설정"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_KO "프레임 스킵 임계값 (%)"
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_KO "'프레임 스킵'이 '사용자 설정'일 경우 건너뛸 프레임에 대한 오디오 버퍼 점유 임계점(퍼센트)을 설정하게됩니다. 값이 높을수록 프레임은 떨어지고 그 대신 소리 깨짐 현상은 줄어들게 됩니다."
#define GENESIS_PLUS_GX_YM2413_LABEL_KO NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_KO "세가 Mark III/Master System에 사용된 FM 사운드 유닛의 에뮬레이션을 활성화하여 오디오 출력을 향상시킵니다."
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_KO "Master System FM (YM2413) 코어"
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_KO "세가 Mark III/Master System의 FM 사운드 유닛을 에뮬레이트할 방식을 선택합니다. 'MAME' 옵션은 빠르고 거의 모든 시스템에서 풀 스피드로 구동됩니다. 'Nuked' 옵션은 사이클 수준 정확도를 가지며, 매우 높은 품질을 제공하지만 강력한 CPU를 필요로 합니다."
#define OPTION_VAL_MAME_KO NULL
#define OPTION_VAL_NUKED_KO NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_KO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_KO "Mega Drive/Genesis의 FM 신시사이저(주 사운드 생성기)를 에뮬레이트할 방식을 선택합니다. 'MAME' 옵션은 빠르고 거의 모든 시스템에서 풀 스피드로 구동됩니다. 'Nuked' 옵션은 사이클 수준 정확도를 가지며, 매우 높은 품질을 제공하지만 강력한 CPU를 필요로 합니다. YM2612 칩은 원조 모델 1 Mega Drive/Genesis에서 사용된 칩이며 YM3438은 후기 Mega Drive/Genesis 리비전에서 사용된 칩입니다."
#define GENESIS_PLUS_GX_YM2612_INFO_1_KO "Mega Drive/Genesis의 FM 신시사이저(주 사운드 생성기)를 에뮬레이트할 방식을 선택합니다. YM2612 칩은 원조 모델 1 Mega Drive/Genesis에서 사용된 칩이며 YM3438은 후기 Mega Drive/Genesis 리비전에서 사용된 칩입니다."
#define OPTION_VAL_MAME_YM2612_KO NULL
#define OPTION_VAL_MAME_ASIC_YM3438_KO NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_KO "MAME (개선된 YM3438)"
#define OPTION_VAL_NUKED_YM2612_KO NULL
#define OPTION_VAL_NUKED_YM3438_KO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_KO "소리 출력"
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_KO "스테레오/모노 소리 재생을 선택합니다."
#define OPTION_VAL_STEREO_KO "스테레오"
#define OPTION_VAL_MONO_KO "모노"
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_KO "오디오 필터"
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_KO "로우패스 오디오 필터를 사용하여 모델 1 Mega Drive/Genesis의 소리 특징을 더욱 정확히 구현합니다."
#define OPTION_VAL_LOW_PASS_KO "로우패스"
#define OPTION_VAL_EQ_KO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_KO "로우패스 필터 %"
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_KO "오디오 로우패스 필터의 컷오프 주파수를 지정합니다. 높은 값은 더 넓은 범위의 고주파음을 차단하여 필터의 '강도'를 높입니다."
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_KO "PSG 프리앰프 수준"
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_KO "SG-1000, Sega Mark III, Master System, Game Gear, Mega Drive/Genesis에서 사용되는 SN76496 4채널 PSG의 에뮬레이션의 프리앰프 수준을 설정합니다."
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_KO "FM 프리앰프 수준"
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_KO "Mega Drive/Genesis FM 신시사이저 및 Sega Mark III/Master System FM 사운드 유닛의 에뮬레이션의 프리앰프 수준을 설정합니다."
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_KO "CD-DA 음량"
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_KO "에뮬레이트된 CD 오디오 출력의 믹싱 볼륨을 조절합니다."
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_KO "PCM 볼륨"
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_KO "에뮬레이트된 Sega CD/Mega-CD RF5C164 PCM 사운드 발생기 출력의 믹싱 볼륨을 조절합니다."
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_KO "EQ 저음"
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_KO "내장 오디오 이퀄라이저의 저음 영역을 조정합니다."
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_KO "EQ 중음"
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_KO "내장 오디오 이퀄라이저의 중음 영역을 조정합니다."
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_KO "EQ 고음"
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_KO "내장 오디오 이퀄라이저의 고음 영역을 조정합니다."
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_KO "라이트 건 입력"
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_KO "마우스로 조종되는 '라이트 건' 또는 '터치스크린' 입력을 사용합니다."
#define OPTION_VAL_LIGHTGUN_KO "라이트 건"
#define OPTION_VAL_TOUCHSCREEN_KO "터치스크린"
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_KO "라이트 건 조준선 표시"
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_KO "MD Menacer, MD Justifiers, MS Light Phaser 등의 입력 장치를 사용할 때 라이트 건 조준선을 표시합니다."
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_KO "마우스 Y축 반전"
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_KO "MD Mouse 등의 입력 장치를 사용할 때 Y축 입력을 반전시킵니다."
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_KO "스캔라인 당 스프라이트 제한 제거"
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_KO "원본 하드웨어에 존재하는 스캔라인 당 스프라이트 제한을 제거합니다. 깜빡임을 줄여주지만 이러한 제한을 활용해 특별한 효과를 만들어내는 게임에서는 그래픽 오류가 일어날 수 있습니다."
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_KO "CPU 속도"
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_KO "에뮬레이트되는 CPU를 오버클럭합니다. 느려지는 현상을 줄일 수 있지만 버그가 발생할 수 있습니다."
#define OPTION_VAL_100_KO NULL
#define OPTION_VAL_125_KO NULL
#define OPTION_VAL_150_KO NULL
#define OPTION_VAL_175_KO NULL
#define OPTION_VAL_200_KO NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_KO "시스템 중단"
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_KO "실제 하드웨어에서 잘못된 주소에 접근 시 발생하는 시스템 중단을 구현합니다. 이러한 미정의 행동을 올바르게 활용하는 일부 데모 또는 홈브루를 구동할 때만 비활성화되어야 합니다."
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_KO "68K 주소 오류"
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_KO "Mega Drive/Genesis의 주 CPU(Motorola 68000)는 정렬되지 않은 메모리 접근을 수행할 경우 주소 오류 예외(크래시)를 발생시킵니다. 이 옵션을 활성화하면 이 동작이 구현됩니다. 부정확한 에뮬레이터에서 개발되어 잘못된 메모리 접근을 활용하는 일부 ROM 핵을 구동할 때만 비활성화되어야 합니다."
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_KO "고급 오디오 볼륨 설정 표시 (메뉴 다시 열기 필요)"
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_KO "저수준 오디오 채널 변수 설정을 활성화합니다. 주의: 이 설정은 빠른 메뉴를 껐다 켜야 반영됩니다."
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_KO "PSG 소리 채널 0 볼륨 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_KO "PSG 소리 채널 0의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_KO "PSG 소리 채널 1 볼륨 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_KO "PSG 소리 채널 1의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_KO "PSG 소리 채널 2 볼륨 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_KO "PSG 소리 채널 2의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_KO "PSG 노이즈 채널 3 볼륨 %"
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_KO "PSG 노이즈 채널 3의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_KO "Mega Drive/Genesis FM 채널 0 볼륨 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_KO "Mega Drive/Genesis FM 채널 0의 볼륨을 감소시킵니다. MAME FM 에뮬레이터에만 적용됩니다."
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_KO "Mega Drive/Genesis FM 채널 1 볼륨 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_KO "Mega Drive/Genesis FM 채널 1의 볼륨을 감소시킵니다. MAME FM 에뮬레이터에만 적용됩니다."
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_KO "Mega Drive/Genesis FM 채널 2 볼륨 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_KO "Mega Drive/Genesis FM 채널 2의 볼륨을 감소시킵니다. MAME FM 에뮬레이터에만 적용됩니다."
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_KO "Mega Drive/Genesis FM 채널 3 볼륨 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_KO "Mega Drive/Genesis FM 채널 3의 볼륨을 감소시킵니다. MAME FM 에뮬레이터에만 적용됩니다."
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_KO "Mega Drive/Genesis FM 채널 4 볼륨 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_KO "Mega Drive/Genesis FM 채널 4의 볼륨을 감소시킵니다. MAME FM 에뮬레이터에만 적용됩니다."
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_KO "Mega Drive/Genesis FM 채널 5 볼륨 %"
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_KO "Mega Drive/Genesis FM 채널 5의 볼륨을 감소시킵니다. MAME FM 에뮬레이터에만 적용됩니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 0 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_KO "Master System FM 채널 0의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 1 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_KO "Master System FM 채널 1의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 2 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_KO "Master System FM 채널 2의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 3 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_KO "Master System FM 채널 3의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 4 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_KO "Master System FM 채널 4의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 5 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_KO "Master System FM 채널 5의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 6 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_KO "Master System FM 채널 6의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 7 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_KO "Master System FM 채널 7의 볼륨을 감소시킵니다."
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_KO "Master System FM (YM2413) 채널 8 볼륨 %"
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_KO "Master System FM 채널 8의 볼륨을 감소시킵니다."

struct retro_core_option_v2_category option_cats_ko[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_KO,
      CATEGORY_SYSTEM_INFO_0_KO
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_KO,
      CATEGORY_VIDEO_INFO_0_KO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_KO,
      CATEGORY_AUDIO_INFO_0_KO
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_KO,
      CATEGORY_INPUT_INFO_0_KO
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_KO,
      CATEGORY_HACKS_INFO_0_KO
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_KO,
      CATEGORY_CHANNEL_VOLUME_INFO_0_KO
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ko[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_KO,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_KO               },
         { "sg-1000",              OPTION_VAL_SG_1000_KO            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_KO         },
         { "mark-III",             OPTION_VAL_MARK_III_KO           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_KO      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_KO   },
         { "game gear",            OPTION_VAL_GAME_GEAR_KO          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_KO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_KO,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_KO   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_KO },
         { "pal",     OPTION_VAL_PAL_KO    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_KO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_KO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_KO,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_KO },
         { "per game", OPTION_VAL_PER_GAME_KO },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_KO,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_KO },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_KO },
         { "megasd",       OPTION_VAL_MEGASD_KO },
         { "none",         OPTION_VAL_NONE_KO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_KO,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_KO },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_KO },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_KO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_KO,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_KO },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_KO },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_KO },
         { "4:3",  OPTION_VAL_4_3_KO },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_KO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_KO },
         { "left/right", OPTION_VAL_LEFT_RIGHT_KO },
         { "full",       OPTION_VAL_FULL_KO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_KO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_KO },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_KO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_KO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_KO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_KO },
         { "composite",  OPTION_VAL_COMPOSITE_KO },
         { "svideo",     OPTION_VAL_SVIDEO_KO },
         { "rgb",        OPTION_VAL_RGB_KO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_KO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_KO,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_KO },
         { "double field", OPTION_VAL_DOUBLE_FIELD_KO },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_KO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_KO },
         { "manual",   OPTION_VAL_MANUAL_KO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_KO,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_KO,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_KO },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_KO,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_KO },
         { "nuked", OPTION_VAL_NUKED_KO },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_KO,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_KO,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_KO,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_KO },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_KO },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_KO },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_KO },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_KO },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_KO,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_KO },
         { "mono",   OPTION_VAL_MONO_KO },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_KO,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_KO },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_KO },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_KO,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_KO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_KO,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_KO },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_KO },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_KO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_KO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_KO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_KO,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_KO },
         { "125%", OPTION_VAL_125_KO },
         { "150%", OPTION_VAL_150_KO },
         { "175%", OPTION_VAL_175_KO },
         { "200%", OPTION_VAL_200_KO },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_KO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_KO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_KO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_KO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ko = {
   option_cats_ko,
   option_defs_ko
};

/* RETRO_LANGUAGE_MT */

#define CATEGORY_SYSTEM_LABEL_MT NULL
#define CATEGORY_SYSTEM_INFO_0_MT NULL
#define CATEGORY_VIDEO_LABEL_MT NULL
#define CATEGORY_VIDEO_INFO_0_MT NULL
#define CATEGORY_AUDIO_LABEL_MT NULL
#define CATEGORY_AUDIO_INFO_0_MT NULL
#define CATEGORY_INPUT_LABEL_MT NULL
#define CATEGORY_INPUT_INFO_0_MT NULL
#define CATEGORY_HACKS_LABEL_MT NULL
#define CATEGORY_HACKS_INFO_0_MT NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_MT NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_MT NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_MT NULL
#define OPTION_VAL_AUTO_MT NULL
#define OPTION_VAL_SG_1000_MT NULL
#define OPTION_VAL_SG_1000_II_MT NULL
#define OPTION_VAL_MARK_III_MT NULL
#define OPTION_VAL_MASTER_SYSTEM_MT NULL
#define OPTION_VAL_MASTER_SYSTEM_II_MT NULL
#define OPTION_VAL_GAME_GEAR_MT NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_MT NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_MT NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_MT NULL
#define OPTION_VAL_NTSC_U_MT NULL
#define OPTION_VAL_PAL_MT NULL
#define OPTION_VAL_NTSC_J_MT NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_MT NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_MT NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_MT NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_MT NULL
#define OPTION_VAL_PER_BIOS_MT NULL
#define OPTION_VAL_PER_GAME_MT NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_MT NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_MT NULL
#define OPTION_VAL_SEGA_MEGA_CD_MT NULL
#define OPTION_VAL_MEGASD_MT NULL
#define OPTION_VAL_NONE_MT NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_MT NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_MT NULL
#define OPTION_VAL_GAME_GENIE_MT NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_MT NULL
#define OPTION_VAL_SONIC_KNUCKLES_MT NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_MT NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_MT NULL
#define OPTION_VAL_NTSC_PAR_MT NULL
#define OPTION_VAL_PAL_PAR_MT NULL
#define OPTION_VAL_4_3_MT NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_MT NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_MT NULL
#define OPTION_VAL_TOP_BOTTOM_MT NULL
#define OPTION_VAL_LEFT_RIGHT_MT NULL
#define OPTION_VAL_FULL_MT NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_MT NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_MT NULL
#define OPTION_VAL_LEFT_BORDER_MT NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_MT NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_MT NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_MT NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_MT NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_MT NULL
#define OPTION_VAL_MONOCHROME_MT NULL
#define OPTION_VAL_COMPOSITE_MT NULL
#define OPTION_VAL_SVIDEO_MT NULL
#define OPTION_VAL_RGB_MT NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_MT NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_MT NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_MT NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_MT NULL
#define OPTION_VAL_SINGLE_FIELD_MT NULL
#define OPTION_VAL_DOUBLE_FIELD_MT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_MT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_MT NULL
#define OPTION_VAL_MANUAL_MT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_MT NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_MT NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_MT NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_MT NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_MT NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_MT NULL
#define OPTION_VAL_MAME_MT NULL
#define OPTION_VAL_NUKED_MT NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_MT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_MT NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_MT NULL
#define OPTION_VAL_MAME_YM2612_MT NULL
#define OPTION_VAL_MAME_ASIC_YM3438_MT NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_MT NULL
#define OPTION_VAL_NUKED_YM2612_MT NULL
#define OPTION_VAL_NUKED_YM3438_MT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_MT NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_MT NULL
#define OPTION_VAL_STEREO_MT NULL
#define OPTION_VAL_MONO_MT NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_MT NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_MT NULL
#define OPTION_VAL_LOW_PASS_MT NULL
#define OPTION_VAL_EQ_MT NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_MT NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_MT NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_MT NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_MT NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_MT NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_MT NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_MT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_MT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_MT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_MT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_MT NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_MT NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_MT NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_MT NULL
#define OPTION_VAL_LIGHTGUN_MT NULL
#define OPTION_VAL_TOUCHSCREEN_MT NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_MT NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_MT NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_MT NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_MT NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_MT NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_MT NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_MT NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_MT NULL
#define OPTION_VAL_100_MT NULL
#define OPTION_VAL_125_MT NULL
#define OPTION_VAL_150_MT NULL
#define OPTION_VAL_175_MT NULL
#define OPTION_VAL_200_MT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_MT NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_MT NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_MT NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_MT NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_MT NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_MT NULL

struct retro_core_option_v2_category option_cats_mt[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_MT,
      CATEGORY_SYSTEM_INFO_0_MT
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_MT,
      CATEGORY_VIDEO_INFO_0_MT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_MT,
      CATEGORY_AUDIO_INFO_0_MT
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_MT,
      CATEGORY_INPUT_INFO_0_MT
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_MT,
      CATEGORY_HACKS_INFO_0_MT
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_MT,
      CATEGORY_CHANNEL_VOLUME_INFO_0_MT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_mt[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_MT,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_MT               },
         { "sg-1000",              OPTION_VAL_SG_1000_MT            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_MT         },
         { "mark-III",             OPTION_VAL_MARK_III_MT           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_MT      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_MT   },
         { "game gear",            OPTION_VAL_GAME_GEAR_MT          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_MT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_MT,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_MT   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_MT },
         { "pal",     OPTION_VAL_PAL_MT    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_MT },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_MT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_MT,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_MT },
         { "per game", OPTION_VAL_PER_GAME_MT },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_MT,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_MT },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_MT },
         { "megasd",       OPTION_VAL_MEGASD_MT },
         { "none",         OPTION_VAL_NONE_MT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_MT,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_MT },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_MT },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_MT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_MT,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_MT },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_MT },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_MT },
         { "4:3",  OPTION_VAL_4_3_MT },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_MT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_MT },
         { "left/right", OPTION_VAL_LEFT_RIGHT_MT },
         { "full",       OPTION_VAL_FULL_MT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_MT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_MT },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_MT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_MT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_MT,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_MT },
         { "composite",  OPTION_VAL_COMPOSITE_MT },
         { "svideo",     OPTION_VAL_SVIDEO_MT },
         { "rgb",        OPTION_VAL_RGB_MT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_MT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_MT,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_MT },
         { "double field", OPTION_VAL_DOUBLE_FIELD_MT },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_MT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_MT },
         { "manual",   OPTION_VAL_MANUAL_MT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_MT,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_MT,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_MT },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_MT,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_MT },
         { "nuked", OPTION_VAL_NUKED_MT },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_MT,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_MT,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_MT,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_MT },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_MT },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_MT },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_MT },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_MT },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_MT,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_MT },
         { "mono",   OPTION_VAL_MONO_MT },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_MT,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_MT },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_MT },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_MT,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_MT,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_MT,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_MT },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_MT },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_MT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_MT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_MT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_MT,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_MT },
         { "125%", OPTION_VAL_125_MT },
         { "150%", OPTION_VAL_150_MT },
         { "175%", OPTION_VAL_175_MT },
         { "200%", OPTION_VAL_200_MT },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_MT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_MT,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_MT,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_MT,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_mt = {
   option_cats_mt,
   option_defs_mt
};

/* RETRO_LANGUAGE_NL */

#define CATEGORY_SYSTEM_LABEL_NL "Systeem"
#define CATEGORY_SYSTEM_INFO_0_NL NULL
#define CATEGORY_VIDEO_LABEL_NL NULL
#define CATEGORY_VIDEO_INFO_0_NL NULL
#define CATEGORY_AUDIO_LABEL_NL "Geluid"
#define CATEGORY_AUDIO_INFO_0_NL NULL
#define CATEGORY_INPUT_LABEL_NL "Invoer"
#define CATEGORY_INPUT_INFO_0_NL NULL
#define CATEGORY_HACKS_LABEL_NL NULL
#define CATEGORY_HACKS_INFO_0_NL NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_NL NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_NL NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_NL NULL
#define OPTION_VAL_AUTO_NL "Automatisch"
#define OPTION_VAL_SG_1000_NL NULL
#define OPTION_VAL_SG_1000_II_NL NULL
#define OPTION_VAL_MARK_III_NL NULL
#define OPTION_VAL_MASTER_SYSTEM_NL NULL
#define OPTION_VAL_MASTER_SYSTEM_II_NL NULL
#define OPTION_VAL_GAME_GEAR_NL NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_NL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_NL NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_NL NULL
#define OPTION_VAL_NTSC_U_NL NULL
#define OPTION_VAL_PAL_NL NULL
#define OPTION_VAL_NTSC_J_NL NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_NL NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_NL NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_NL NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_NL NULL
#define OPTION_VAL_PER_BIOS_NL NULL
#define OPTION_VAL_PER_GAME_NL NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_NL NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_NL NULL
#define OPTION_VAL_SEGA_MEGA_CD_NL NULL
#define OPTION_VAL_MEGASD_NL NULL
#define OPTION_VAL_NONE_NL "Geen"
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_NL NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_NL NULL
#define OPTION_VAL_GAME_GENIE_NL NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_NL NULL
#define OPTION_VAL_SONIC_KNUCKLES_NL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_NL NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_NL NULL
#define OPTION_VAL_NTSC_PAR_NL NULL
#define OPTION_VAL_PAL_PAR_NL NULL
#define OPTION_VAL_4_3_NL NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_NL NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_NL NULL
#define OPTION_VAL_TOP_BOTTOM_NL NULL
#define OPTION_VAL_LEFT_RIGHT_NL NULL
#define OPTION_VAL_FULL_NL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_NL NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_NL NULL
#define OPTION_VAL_LEFT_BORDER_NL NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_NL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_NL NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_NL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_NL NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_NL NULL
#define OPTION_VAL_MONOCHROME_NL NULL
#define OPTION_VAL_COMPOSITE_NL NULL
#define OPTION_VAL_SVIDEO_NL NULL
#define OPTION_VAL_RGB_NL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_NL NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_NL NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_NL NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_NL NULL
#define OPTION_VAL_SINGLE_FIELD_NL NULL
#define OPTION_VAL_DOUBLE_FIELD_NL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_NL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_NL NULL
#define OPTION_VAL_MANUAL_NL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_NL NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_NL NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_NL NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_NL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_NL NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_NL NULL
#define OPTION_VAL_MAME_NL NULL
#define OPTION_VAL_NUKED_NL NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_NL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_NL NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_NL NULL
#define OPTION_VAL_MAME_YM2612_NL NULL
#define OPTION_VAL_MAME_ASIC_YM3438_NL NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_NL NULL
#define OPTION_VAL_NUKED_YM2612_NL NULL
#define OPTION_VAL_NUKED_YM3438_NL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_NL NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_NL NULL
#define OPTION_VAL_STEREO_NL NULL
#define OPTION_VAL_MONO_NL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_NL NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_NL NULL
#define OPTION_VAL_LOW_PASS_NL NULL
#define OPTION_VAL_EQ_NL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_NL NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_NL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_NL NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_NL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_NL NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_NL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_NL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_NL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_NL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_NL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_NL NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_NL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_NL NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_NL NULL
#define OPTION_VAL_LIGHTGUN_NL NULL
#define OPTION_VAL_TOUCHSCREEN_NL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_NL NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_NL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_NL NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_NL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_NL NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_NL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_NL NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_NL NULL
#define OPTION_VAL_100_NL NULL
#define OPTION_VAL_125_NL NULL
#define OPTION_VAL_150_NL NULL
#define OPTION_VAL_175_NL NULL
#define OPTION_VAL_200_NL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_NL NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_NL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_NL NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_NL NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_NL NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_NL NULL

struct retro_core_option_v2_category option_cats_nl[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_NL,
      CATEGORY_SYSTEM_INFO_0_NL
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_NL,
      CATEGORY_VIDEO_INFO_0_NL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_NL,
      CATEGORY_AUDIO_INFO_0_NL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_NL,
      CATEGORY_INPUT_INFO_0_NL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_NL,
      CATEGORY_HACKS_INFO_0_NL
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_NL,
      CATEGORY_CHANNEL_VOLUME_INFO_0_NL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_nl[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_NL,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_NL               },
         { "sg-1000",              OPTION_VAL_SG_1000_NL            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_NL         },
         { "mark-III",             OPTION_VAL_MARK_III_NL           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_NL      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_NL   },
         { "game gear",            OPTION_VAL_GAME_GEAR_NL          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_NL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_NL,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_NL   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_NL },
         { "pal",     OPTION_VAL_PAL_NL    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_NL },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_NL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_NL,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_NL },
         { "per game", OPTION_VAL_PER_GAME_NL },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_NL,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_NL },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_NL },
         { "megasd",       OPTION_VAL_MEGASD_NL },
         { "none",         OPTION_VAL_NONE_NL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_NL,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_NL },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_NL },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_NL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_NL,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_NL },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_NL },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_NL },
         { "4:3",  OPTION_VAL_4_3_NL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_NL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_NL },
         { "left/right", OPTION_VAL_LEFT_RIGHT_NL },
         { "full",       OPTION_VAL_FULL_NL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_NL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_NL },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_NL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_NL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_NL,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_NL },
         { "composite",  OPTION_VAL_COMPOSITE_NL },
         { "svideo",     OPTION_VAL_SVIDEO_NL },
         { "rgb",        OPTION_VAL_RGB_NL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_NL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_NL,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_NL },
         { "double field", OPTION_VAL_DOUBLE_FIELD_NL },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_NL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_NL },
         { "manual",   OPTION_VAL_MANUAL_NL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_NL,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_NL,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_NL },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_NL,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_NL },
         { "nuked", OPTION_VAL_NUKED_NL },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_NL,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_NL,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_NL,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_NL },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_NL },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_NL },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_NL },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_NL },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_NL,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_NL },
         { "mono",   OPTION_VAL_MONO_NL },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_NL,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_NL },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_NL },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_NL,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_NL,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_NL,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_NL },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_NL },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_NL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_NL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_NL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_NL,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_NL },
         { "125%", OPTION_VAL_125_NL },
         { "150%", OPTION_VAL_150_NL },
         { "175%", OPTION_VAL_175_NL },
         { "200%", OPTION_VAL_200_NL },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_NL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_NL,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_NL,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_NL,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_nl = {
   option_cats_nl,
   option_defs_nl
};

/* RETRO_LANGUAGE_NO */

#define CATEGORY_SYSTEM_LABEL_NO NULL
#define CATEGORY_SYSTEM_INFO_0_NO NULL
#define CATEGORY_VIDEO_LABEL_NO NULL
#define CATEGORY_VIDEO_INFO_0_NO NULL
#define CATEGORY_AUDIO_LABEL_NO "Lyd"
#define CATEGORY_AUDIO_INFO_0_NO NULL
#define CATEGORY_INPUT_LABEL_NO "Inndata"
#define CATEGORY_INPUT_INFO_0_NO NULL
#define CATEGORY_HACKS_LABEL_NO NULL
#define CATEGORY_HACKS_INFO_0_NO NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_NO NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_NO NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_NO NULL
#define OPTION_VAL_AUTO_NO NULL
#define OPTION_VAL_SG_1000_NO NULL
#define OPTION_VAL_SG_1000_II_NO NULL
#define OPTION_VAL_MARK_III_NO NULL
#define OPTION_VAL_MASTER_SYSTEM_NO NULL
#define OPTION_VAL_MASTER_SYSTEM_II_NO NULL
#define OPTION_VAL_GAME_GEAR_NO NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_NO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_NO NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_NO NULL
#define OPTION_VAL_NTSC_U_NO NULL
#define OPTION_VAL_PAL_NO NULL
#define OPTION_VAL_NTSC_J_NO NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_NO NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_NO NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_NO NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_NO NULL
#define OPTION_VAL_PER_BIOS_NO NULL
#define OPTION_VAL_PER_GAME_NO NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_NO NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_NO NULL
#define OPTION_VAL_SEGA_MEGA_CD_NO NULL
#define OPTION_VAL_MEGASD_NO NULL
#define OPTION_VAL_NONE_NO NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_NO NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_NO NULL
#define OPTION_VAL_GAME_GENIE_NO NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_NO NULL
#define OPTION_VAL_SONIC_KNUCKLES_NO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_NO NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_NO NULL
#define OPTION_VAL_NTSC_PAR_NO NULL
#define OPTION_VAL_PAL_PAR_NO NULL
#define OPTION_VAL_4_3_NO NULL
#define GENESIS_PLUS_GX_OVERSCAN_LABEL_NO NULL
#define GENESIS_PLUS_GX_OVERSCAN_INFO_0_NO NULL
#define OPTION_VAL_TOP_BOTTOM_NO NULL
#define OPTION_VAL_LEFT_RIGHT_NO NULL
#define OPTION_VAL_FULL_NO NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_LABEL_NO NULL
#define GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_NO NULL
#define OPTION_VAL_LEFT_BORDER_NO NULL
#define OPTION_VAL_LEFT_RIGHT_BORDERS_NO NULL
#define GENESIS_PLUS_GX_GG_EXTRA_LABEL_NO NULL
#define GENESIS_PLUS_GX_GG_EXTRA_INFO_0_NO NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_NO NULL
#define GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_NO NULL
#define OPTION_VAL_MONOCHROME_NO NULL
#define OPTION_VAL_COMPOSITE_NO NULL
#define OPTION_VAL_SVIDEO_NO NULL
#define OPTION_VAL_RGB_NO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_LABEL_NO NULL
#define GENESIS_PLUS_GX_LCD_FILTER_INFO_0_NO NULL
#define GENESIS_PLUS_GX_RENDER_LABEL_NO NULL
#define GENESIS_PLUS_GX_RENDER_INFO_0_NO NULL
#define OPTION_VAL_SINGLE_FIELD_NO NULL
#define OPTION_VAL_DOUBLE_FIELD_NO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_LABEL_NO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_INFO_0_NO NULL
#define OPTION_VAL_MANUAL_NO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_NO NULL
#define GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_NO NULL
#define GENESIS_PLUS_GX_YM2413_LABEL_NO NULL
#define GENESIS_PLUS_GX_YM2413_INFO_0_NO NULL
#define GENESIS_PLUS_GX_YM2413_CORE_LABEL_NO NULL
#define GENESIS_PLUS_GX_YM2413_CORE_INFO_0_NO NULL
#define OPTION_VAL_MAME_NO NULL
#define OPTION_VAL_NUKED_NO NULL
#define GENESIS_PLUS_GX_YM2612_LABEL_NO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_0_NO NULL
#define GENESIS_PLUS_GX_YM2612_INFO_1_NO NULL
#define OPTION_VAL_MAME_YM2612_NO NULL
#define OPTION_VAL_MAME_ASIC_YM3438_NO NULL
#define OPTION_VAL_MAME_ENHANCED_YM3438_NO NULL
#define OPTION_VAL_NUKED_YM2612_NO NULL
#define OPTION_VAL_NUKED_YM3438_NO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_NO NULL
#define GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_NO NULL
#define OPTION_VAL_STEREO_NO NULL
#define OPTION_VAL_MONO_NO NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_NO NULL
#define GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_NO NULL
#define OPTION_VAL_LOW_PASS_NO NULL
#define OPTION_VAL_EQ_NO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_NO NULL
#define GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_NO NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_LABEL_NO NULL
#define GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_NO NULL
#define GENESIS_PLUS_GX_FM_PREAMP_LABEL_NO NULL
#define GENESIS_PLUS_GX_FM_PREAMP_INFO_0_NO NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_NO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_NO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_NO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_NO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_NO NULL
#define GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_NO NULL
#define GENESIS_PLUS_GX_GUN_INPUT_LABEL_NO NULL
#define GENESIS_PLUS_GX_GUN_INPUT_INFO_0_NO NULL
#define OPTION_VAL_LIGHTGUN_NO NULL
#define OPTION_VAL_TOUCHSCREEN_NO NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_LABEL_NO NULL
#define GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_NO NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_NO NULL
#define GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_NO NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_NO NULL
#define GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_NO NULL
#define GENESIS_PLUS_GX_OVERCLOCK_LABEL_NO NULL
#define GENESIS_PLUS_GX_OVERCLOCK_INFO_0_NO NULL
#define OPTION_VAL_100_NO NULL
#define OPTION_VAL_125_NO NULL
#define OPTION_VAL_150_NO NULL
#define OPTION_VAL_175_NO NULL
#define OPTION_VAL_200_NO NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_LABEL_NO NULL
#define GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_NO NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_LABEL_NO NULL
#define GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_NO NULL
#define GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_NO NULL
#define GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_NO NULL

struct retro_core_option_v2_category option_cats_no[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_NO,
      CATEGORY_SYSTEM_INFO_0_NO
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_NO,
      CATEGORY_VIDEO_INFO_0_NO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_NO,
      CATEGORY_AUDIO_INFO_0_NO
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_NO,
      CATEGORY_INPUT_INFO_0_NO
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_NO,
      CATEGORY_HACKS_INFO_0_NO
   },
   {
      "channel_volume",
      CATEGORY_CHANNEL_VOLUME_LABEL_NO,
      CATEGORY_CHANNEL_VOLUME_INFO_0_NO
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_no[] = {
   {
      "genesis_plus_gx_system_hw",
      GENESIS_PLUS_GX_SYSTEM_HW_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_NO,
      NULL,
      "system",
      {
         { "auto",                 OPTION_VAL_AUTO_NO               },
         { "sg-1000",              OPTION_VAL_SG_1000_NO            },
         { "sg-1000 II",           OPTION_VAL_SG_1000_II_NO         },
         { "mark-III",             OPTION_VAL_MARK_III_NO           },
         { "master system",        OPTION_VAL_MASTER_SYSTEM_NO      },
         { "master system II",     OPTION_VAL_MASTER_SYSTEM_II_NO   },
         { "game gear",            OPTION_VAL_GAME_GEAR_NO          },
         { "mega drive / genesis", OPTION_VAL_MEGA_DRIVE_GENESIS_NO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_region_detect",
      GENESIS_PLUS_GX_REGION_DETECT_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_REGION_DETECT_INFO_0_NO,
      NULL,
      "system",
      {
         { "auto",    OPTION_VAL_AUTO_NO   },
         { "ntsc-u",  OPTION_VAL_NTSC_U_NO },
         { "pal",     OPTION_VAL_PAL_NO    },
         { "ntsc-j",  OPTION_VAL_NTSC_J_NO },
         { NULL, NULL },
      },
      "auto"
   },
   {
      "genesis_plus_gx_bios",
      GENESIS_PLUS_GX_BIOS_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_BIOS_INFO_0_NO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_bram",
      GENESIS_PLUS_GX_BRAM_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_BRAM_INFO_0_NO,
      NULL,
      "system",
      {
         { "per bios", OPTION_VAL_PER_BIOS_NO },
         { "per game", OPTION_VAL_PER_GAME_NO },
         { NULL, NULL },
      },
      "per bios"
   },
   {
      "genesis_plus_gx_add_on",
      GENESIS_PLUS_GX_ADD_ON_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_ADD_ON_INFO_0_NO,
      NULL,
      "system",
      {
         { "auto",         OPTION_VAL_AUTO_NO },
         { "sega/mega cd", OPTION_VAL_SEGA_MEGA_CD_NO },
         { "megasd",       OPTION_VAL_MEGASD_NO },
         { "none",         OPTION_VAL_NONE_NO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lock_on",
      GENESIS_PLUS_GX_LOCK_ON_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_LOCK_ON_INFO_0_NO,
      NULL,
      "system",
      {
         { "disabled",            NULL },
         { "game genie",          OPTION_VAL_GAME_GENIE_NO },
         { "action replay (pro)", OPTION_VAL_ACTION_REPLAY_PRO_NO },
         { "sonic & knuckles",    OPTION_VAL_SONIC_KNUCKLES_NO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_aspect_ratio",
      GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_NO,
      NULL,
      "video",
      {
         { "auto",     OPTION_VAL_AUTO_NO },
         { "NTSC PAR", OPTION_VAL_NTSC_PAR_NO },
         { "PAL PAR",  OPTION_VAL_PAL_PAR_NO },
         { "4:3",  OPTION_VAL_4_3_NO },
      },
      "auto"
   },
   {
      "genesis_plus_gx_overscan",
      GENESIS_PLUS_GX_OVERSCAN_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_OVERSCAN_INFO_0_NO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "top/bottom", OPTION_VAL_TOP_BOTTOM_NO },
         { "left/right", OPTION_VAL_LEFT_RIGHT_NO },
         { "full",       OPTION_VAL_FULL_NO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_left_border",
      GENESIS_PLUS_GX_LEFT_BORDER_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_LEFT_BORDER_INFO_0_NO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "left border", OPTION_VAL_LEFT_BORDER_NO },
         { "left & right borders", OPTION_VAL_LEFT_RIGHT_BORDERS_NO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_gg_extra",
      GENESIS_PLUS_GX_GG_EXTRA_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_GG_EXTRA_INFO_0_NO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_blargg_ntsc_filter",
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_BLARGG_NTSC_FILTER_INFO_0_NO,
      NULL,
      "video",
      {
         { "disabled",   NULL },
         { "monochrome", OPTION_VAL_MONOCHROME_NO },
         { "composite",  OPTION_VAL_COMPOSITE_NO },
         { "svideo",     OPTION_VAL_SVIDEO_NO },
         { "rgb",        OPTION_VAL_RGB_NO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lcd_filter",
      GENESIS_PLUS_GX_LCD_FILTER_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_LCD_FILTER_INFO_0_NO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_render",
      GENESIS_PLUS_GX_RENDER_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_RENDER_INFO_0_NO,
      NULL,
      "video",
      {
         { "single field", OPTION_VAL_SINGLE_FIELD_NO },
         { "double field", OPTION_VAL_DOUBLE_FIELD_NO },
         { NULL, NULL },
      },
      "single field"
   },
   {
      "genesis_plus_gx_frameskip",
      GENESIS_PLUS_GX_FRAMESKIP_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_INFO_0_NO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "auto",     OPTION_VAL_AUTO_NO },
         { "manual",   OPTION_VAL_MANUAL_NO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_frameskip_threshold",
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_FRAMESKIP_THRESHOLD_INFO_0_NO,
      NULL,
      "video",
      {
         { "15", NULL },
         { "18", NULL },
         { "21", NULL },
         { "24", NULL },
         { "27", NULL },
         { "30", NULL },
         { "33", NULL },
         { "36", NULL },
         { "39", NULL },
         { "42", NULL },
         { "45", NULL },
         { "48", NULL },
         { "51", NULL },
         { "54", NULL },
         { "57", NULL },
         { "60", NULL },
         { NULL, NULL },
      },
      "33"
   },
   {
      "genesis_plus_gx_ym2413",
      GENESIS_PLUS_GX_YM2413_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_YM2413_INFO_0_NO,
      NULL,
      "audio",
      {
         { "auto",     OPTION_VAL_AUTO_NO },
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "auto"
   },
#ifdef HAVE_OPLL_CORE
   {
      "genesis_plus_gx_ym2413_core",
      GENESIS_PLUS_GX_YM2413_CORE_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_YM2413_CORE_INFO_0_NO,
      NULL,
      "audio",
      {
         { "mame",  OPTION_VAL_MAME_NO },
         { "nuked", OPTION_VAL_NUKED_NO },
         { NULL, NULL },
      },
      "mame"
   },
#endif
   {
      "genesis_plus_gx_ym2612",
      GENESIS_PLUS_GX_YM2612_LABEL_NO,
      NULL,
#ifdef HAVE_YM3438_CORE
      GENESIS_PLUS_GX_YM2612_INFO_0_NO,
#else
      GENESIS_PLUS_GX_YM2612_INFO_1_NO,
#endif
      NULL,
      "audio",
      {
         { "mame (ym2612)",          OPTION_VAL_MAME_YM2612_NO },
         { "mame (asic ym3438)",     OPTION_VAL_MAME_ASIC_YM3438_NO },
         { "mame (enhanced ym3438)", OPTION_VAL_MAME_ENHANCED_YM3438_NO },
#ifdef HAVE_YM3438_CORE
         { "nuked (ym2612)",         OPTION_VAL_NUKED_YM2612_NO },
         { "nuked (ym3438)",         OPTION_VAL_NUKED_YM3438_NO },
#endif
         { NULL, NULL },
      },
      "mame (ym2612)"
   },
   {
      "genesis_plus_gx_sound_output",
      GENESIS_PLUS_GX_SOUND_OUTPUT_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SOUND_OUTPUT_INFO_0_NO,
      NULL,
      "audio",
      {
         { "stereo", OPTION_VAL_STEREO_NO },
         { "mono",   OPTION_VAL_MONO_NO },
         { NULL, NULL },
      },
      "stereo"
   },
   {
      "genesis_plus_gx_audio_filter",
      GENESIS_PLUS_GX_AUDIO_FILTER_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_FILTER_INFO_0_NO,
      NULL,
      "audio",
      {
         { "disabled", NULL },
         { "low-pass", OPTION_VAL_LOW_PASS_NO },
#if HAVE_EQ
         { "EQ",       OPTION_VAL_EQ_NO },
#endif
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_lowpass_range",
      GENESIS_PLUS_GX_LOWPASS_RANGE_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_LOWPASS_RANGE_INFO_0_NO,
      NULL,
      "audio",
      {
         { "5",  NULL },
         { "10", NULL },
         { "15", NULL },
         { "20", NULL },
         { "25", NULL },
         { "30", NULL },
         { "35", NULL },
         { "40", NULL },
         { "45", NULL },
         { "50", NULL },
         { "55", NULL },
         { "60", NULL },
         { "65", NULL },
         { "70", NULL },
         { "75", NULL },
         { "80", NULL },
         { "85", NULL },
         { "90", NULL },
         { "95", NULL },
         { NULL, NULL },
      },
      "60"
   },
   {
      "genesis_plus_gx_psg_preamp",
      GENESIS_PLUS_GX_PSG_PREAMP_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_PSG_PREAMP_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "genesis_plus_gx_fm_preamp",
      GENESIS_PLUS_GX_FM_PREAMP_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_FM_PREAMP_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { "105", NULL },
         { "110", NULL },
         { "115", NULL },
         { "120", NULL },
         { "125", NULL },
         { "130", NULL },
         { "135", NULL },
         { "140", NULL },
         { "145", NULL },
         { "150", NULL },
         { "155", NULL },
         { "160", NULL },
         { "165", NULL },
         { "170", NULL },
         { "175", NULL },
         { "180", NULL },
         { "185", NULL },
         { "190", NULL },
         { "195", NULL },
         { "200", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_cdda_volume",
      GENESIS_PLUS_GX_CDDA_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_CDDA_VOLUME_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_pcm_volume",
      GENESIS_PLUS_GX_PCM_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_PCM_VOLUME_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#ifdef HAVE_EQ
   {
      "genesis_plus_gx_audio_eq_low",
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_LOW_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_mid",
      GENESIS_PLUS_GX_AUDIO_EQ_MID_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_MID_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_audio_eq_high",
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_AUDIO_EQ_HIGH_INFO_0_NO,
      NULL,
      "audio",
      {
         { "0",   NULL },
         { "5",   NULL },
         { "10",  NULL },
         { "15",  NULL },
         { "20",  NULL },
         { "25",  NULL },
         { "30",  NULL },
         { "35",  NULL },
         { "40",  NULL },
         { "45",  NULL },
         { "50",  NULL },
         { "55",  NULL },
         { "60",  NULL },
         { "65",  NULL },
         { "70",  NULL },
         { "75",  NULL },
         { "80",  NULL },
         { "85",  NULL },
         { "90",  NULL },
         { "95",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   {
      "genesis_plus_gx_gun_input",
      GENESIS_PLUS_GX_GUN_INPUT_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_GUN_INPUT_INFO_0_NO,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_NO },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_NO },
         { NULL, NULL },
      },
      "lightgun"
   },
   {
      "genesis_plus_gx_gun_cursor",
      GENESIS_PLUS_GX_GUN_CURSOR_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_GUN_CURSOR_INFO_0_NO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_invert_mouse",
      GENESIS_PLUS_GX_INVERT_MOUSE_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_INVERT_MOUSE_INFO_0_NO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      "genesis_plus_gx_no_sprite_limit",
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_NO_SPRITE_LIMIT_INFO_0_NO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef HAVE_OVERCLOCK
   {
      "genesis_plus_gx_overclock",
      GENESIS_PLUS_GX_OVERCLOCK_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_OVERCLOCK_INFO_0_NO,
      NULL,
      "hacks",
      {
         { "100%", OPTION_VAL_100_NO },
         { "125%", OPTION_VAL_125_NO },
         { "150%", OPTION_VAL_150_NO },
         { "175%", OPTION_VAL_175_NO },
         { "200%", OPTION_VAL_200_NO },
         { NULL, NULL },
      },
      "100%"
   },
#endif
   {
      "genesis_plus_gx_force_dtack",
      GENESIS_PLUS_GX_FORCE_DTACK_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_FORCE_DTACK_INFO_0_NO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      "genesis_plus_gx_addr_error",
      GENESIS_PLUS_GX_ADDR_ERROR_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_ADDR_ERROR_INFO_0_NO,
      NULL,
      "hacks",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#ifdef USE_PER_SOUND_CHANNELS_CONFIG
   {
      "genesis_plus_gx_show_advanced_audio_settings",
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SHOW_ADVANCED_AUDIO_SETTINGS_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      "genesis_plus_gx_psg_channel_0_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_0_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_1_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_1_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_2_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_2_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_psg_channel_3_volume",
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_PSG_CHANNEL_3_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_0_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_0_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_1_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_1_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_2_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_2_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_3_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_3_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_4_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_4_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_md_channel_5_volume",
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_MD_CHANNEL_5_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_0_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_0_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_1_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_1_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_2_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_2_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_3_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_3_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_4_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_4_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_5_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_5_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_6_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_6_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_7_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_7_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "genesis_plus_gx_sms_fm_channel_8_volume",
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_LABEL_NO,
      NULL,
      GENESIS_PLUS_GX_SMS_FM_CHANNEL_8_VOLUME_INFO_0_NO,
      NULL,
      "channel_volume",
      {
         { "0",   NULL },
         { "10",  NULL },
         { "20",  NULL },
         { "30",  NULL },
         { "40",  NULL },
         { "50",  NULL },
         { "60",  NULL },
         { "70",  NULL },
         { "80",  NULL },
         { "90",  NULL },
         { "100", NULL },
         { NULL, NULL },
      },
      "100"
   },
#endif
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_no = {
   option_cats_no,
   option_defs_no
};

/* RETRO_LANGUAGE_OC */

#define CATEGORY_SYSTEM_LABEL_OC NULL
#define CATEGORY_SYSTEM_INFO_0_OC NULL
#define CATEGORY_VIDEO_LABEL_OC "Vidèo"
#define CATEGORY_VIDEO_INFO_0_OC NULL
#define CATEGORY_AUDIO_LABEL_OC NULL
#define CATEGORY_AUDIO_INFO_0_OC NULL
#define CATEGORY_INPUT_LABEL_OC NULL
#define CATEGORY_INPUT_INFO_0_OC NULL
#define CATEGORY_HACKS_LABEL_OC NULL
#define CATEGORY_HACKS_INFO_0_OC NULL
#define CATEGORY_CHANNEL_VOLUME_LABEL_OC NULL
#define CATEGORY_CHANNEL_VOLUME_INFO_0_OC NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_LABEL_OC NULL
#define GENESIS_PLUS_GX_SYSTEM_HW_INFO_0_OC NULL
#define OPTION_VAL_AUTO_OC NULL
#define OPTION_VAL_SG_1000_OC NULL
#define OPTION_VAL_SG_1000_II_OC NULL
#define OPTION_VAL_MARK_III_OC NULL
#define OPTION_VAL_MASTER_SYSTEM_OC NULL
#define OPTION_VAL_MASTER_SYSTEM_II_OC NULL
#define OPTION_VAL_GAME_GEAR_OC NULL
#define OPTION_VAL_MEGA_DRIVE_GENESIS_OC NULL
#define GENESIS_PLUS_GX_REGION_DETECT_LABEL_OC NULL
#define GENESIS_PLUS_GX_REGION_DETECT_INFO_0_OC NULL
#define OPTION_VAL_NTSC_U_OC NULL
#define OPTION_VAL_PAL_OC NULL
#define OPTION_VAL_NTSC_J_OC NULL
#define GENESIS_PLUS_GX_BIOS_LABEL_OC NULL
#define GENESIS_PLUS_GX_BIOS_INFO_0_OC NULL
#define GENESIS_PLUS_GX_BRAM_LABEL_OC NULL
#define GENESIS_PLUS_GX_BRAM_INFO_0_OC NULL
#define OPTION_VAL_PER_BIOS_OC NULL
#define OPTION_VAL_PER_GAME_OC NULL
#define GENESIS_PLUS_GX_ADD_ON_LABEL_OC NULL
#define GENESIS_PLUS_GX_ADD_ON_INFO_0_OC NULL
#define OPTION_VAL_SEGA_MEGA_CD_OC NULL
#define OPTION_VAL_MEGASD_OC NULL
#define OPTION_VAL_NONE_OC NULL
#define GENESIS_PLUS_GX_LOCK_ON_LABEL_OC NULL
#define GENESIS_PLUS_GX_LOCK_ON_INFO_0_OC NULL
#define OPTION_VAL_GAME_GENIE_OC NULL
#define OPTION_VAL_ACTION_REPLAY_PRO_OC NULL
#define OPTION_VAL_SONIC_KNUCKLES_OC NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_LABEL_OC NULL
#define GENESIS_PLUS_GX_ASPECT_RATIO_INFO_0_OC NULL
#define OPTION_VAL_NT