/*****************************************************************************
** $Source: /cygdrive/d/Private/_SVNROOT/bluemsx/blueMSX/Src/Language/LanguageChineseTraditional.h,v $
**
** $Revision: 1.52 $
**
** $Date: 2009-04-04 20:57:19 $
**
** More info: http://www.bluemsx.com
**
** Copyright (C) 2003-2006 Daniel Vik
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
******************************************************************************
*/
#ifndef LANGUAGE_CHINESE_TRADITIONAL_H
#define LANGUAGE_CHINESE_TRADITIONAL_H

#include "LanguageStrings.h"
 
void langInitChineseTraditional(LanguageStrings* ls) 
{
    //----------------------
    // Language lines
    //----------------------

    ls->langCatalan             = "Catalan";
    ls->langChineseSimplified   = " (²)";
    ls->langChineseTraditional  = " (c)";
    ls->langDutch               = "";
    ls->langEnglish             = "^";
    ls->langFinnish             = "";
    ls->langFrench              = "k";
    ls->langGerman              = "w";
    ls->langItalian             = "qjQ";
    ls->langJapanese            = "";
    ls->langKorean              = "";
    ls->langPolish              = "i";
    ls->langPortuguese          = "";
    ls->langRussian             = "Russian";            // v2.8
    ls->langSpanish             = "Z";
    ls->langSwedish             = "";


    //----------------------
    // Generic lines
    //----------------------

    ls->textDevice              = "˸m:";
    ls->textFilename            = "ɮצW:";
    ls->textFile                = "ɮ";
    ls->textNone                = "L";
    ls->textUnknown             = "";                            


    //----------------------
    // Warning and Error lines
    //----------------------

    ls->warningTitle            = "blueMSX - ĵi";
    ls->warningDiscardChanges   = "zTwnܧܡH";
    ls->warningOverwriteFile    = "zTwnмgɮ:"; 
    ls->errorTitle              = "blueMSX - ~";
    ls->errorEnterFullscreen    = "LkiJùҦC           \n";
    ls->errorDirectXFailed      = "Lkإ DirectX C           \nNϥ GDIC\nˬdTeC";
    ls->errorNoRomInZip         = "Lkb zip YɮפX .rom ɮסC";
    ls->errorNoDskInZip         = "Lkb zip YɮפX .dsk ɮסC";
    ls->errorNoCasInZip         = "Lkb zip YɮפX .cas ɮסC";
    ls->errorNoHelp             = "Lk blueMSX ɮסC";
    ls->errorStartEmu           = "LkҰ MSX C";
    ls->errorPortableReadonly   = "i⦡˸mŪݩ";        


    //----------------------
    // File related lines
    //----------------------

    ls->fileRom                 = "ROM M";
    ls->fileAll                 = "Ҧɮ";
    ls->fileCpuState            = "CPU A";
    ls->fileVideoCapture        = "^T"; 
    ls->fileDisk                = "ϺЬM";
    ls->fileCas                 = "ϱaM";
    ls->fileAvi                 = "ŵT";    


    //----------------------
    // Menu related lines
    //----------------------

    ls->menuNoRecentFiles       = "- S̪ɮ -";
    ls->menuInsert              = "J";
    ls->menuEject               = "hX";

    ls->menuCartGameReader      = "CŪ";                        
    ls->menuCartIde             = "IDE";                                
    ls->menuCartBeerIde         = "Beer";                               
    ls->menuCartGIde            = "GIDE";                               
    ls->menuCartSunriseIde      = "Sunrise";                              
    ls->menuCartScsi            = "SCSI";                // New in 2.7
    ls->menuCartMegaSCSI        = "MEGA-SCSI";           // New in 2.7
    ls->menuCartWaveSCSI        = "WAVE-SCSI";           // New in 2.7
    ls->menuCartGoudaSCSI       = "Gouda SCSI";          // New in 2.7
    ls->menuJoyrexPsg           = "Joyrex PSG dX"; // New in 2.9
    ls->menuCartSCCPlus         = "SCC + dX";
    ls->menuCartSCC             = "SCC dX";
    ls->menuCartFMPac           = "FM-PAC dX";
    ls->menuCartPac             = "PAC dX";
    ls->menuCartHBI55           = "SONY HBI-55 dX";
    ls->menuCartInsertSpecial   = "JSɮ";                     
    ls->menuCartMegaRam         = "MegaRAM";                            
    ls->menuCartExternalRam     = "~ RAM";
    ls->menuCartEseRam          = "Ese-RAM";             // New in 2.7
    ls->menuCartEseSCC          = "Ese-SCC";             // New in 2.7
    ls->menuCartMegaFlashRom    = "Mega Flash ROM";      // New in 2.7

    ls->menuDiskInsertNew       = "JsϺЬM";              
    ls->menuDiskInsertCdrom     = "Insert CD-Rom";       // New in 2.7
    ls->menuDiskDirInsert       = "Jؿ";
    ls->menuDiskAutoStart       = "J᭫m";
    ls->menuCartAutoReset       = "J/᭫m";
    
    ls->menuCasRewindAfterInsert = "Jja";
    ls->menuCasUseReadOnly       = "ϥκϱaMɰŪ";
    ls->lmenuCasSaveAs           = "tsϱaMɬ...";
    ls->menuCasSetPosition      = "]wm";
    ls->menuCasRewind           = "ja";

    ls->menuVideoLoad           = "J...";             
    ls->menuVideoPlay           = "W^";   
    ls->menuVideoRecord         = "s";              
    ls->menuVideoRecording      = "bs";           
    ls->menuVideoRecAppend      = "s ([)";     
    ls->menuVideoStop           = "";                
    ls->menuVideoRender         = "VTɮ";   

    ls->menuPrnFormfeed         = "";

    ls->menuZoomNormal          = "@jp";
    ls->menuZoomDouble          = "⭿jp";
    ls->menuZoomFullscreen      = "ù";
    
    ls->menuPropsEmulation      = "";
    ls->menuPropsVideo          = "T";
    ls->menuPropsSound          = "";
    ls->menuPropsControls       = "";
    ls->menuPropsEffects        = "Effects";               // New in 2.9
    ls->menuPropsSettings        = "]w";
    ls->menuPropsFile           = "ɮ";
    ls->menuPropsDisk           = "Disks";               // New in 2.7
    ls->menuPropsLanguage       = "y";
    ls->menuPropsPorts          = "s";
    
    ls->menuVideoSource         = "TXӷ";                   
    ls->menuVideoSourceDefault  = "STXӷsu";      
    ls->menuVideoChipAutodetect = "۰ʰT";
    ls->menuVideoInSource       = "TJӷ";                    
    ls->menuVideoInBitmap       = "I}";                        
    
    ls->menuEthInterface        = "Ethernet"; 

    ls->menuHelpHelp            = "DD";
    ls->menuHelpAbout           = " blueMSX";

    ls->menuFileCart            = "dX";
    ls->menuFileDisk            = "Ϻо";
    ls->menuFileCas             = "ϱa";
    ls->menuFilePrn             = "L";
    ls->menuFileLoadState       = "J CPU A";
    ls->menuFileSaveState       = "xs CPU A";
    ls->menuFileQLoadState      = "ֳtJA";
    ls->menuFileQSaveState      = "ֳtxsA";
    ls->menuFileCaptureAudio    = "^T";
    ls->menuFileCaptureVideo    = "^T"; 
    ls->menuFileScreenShot      = "xsù";
    ls->menuFileExit            = "";

    ls->menuFileHarddisk        = "wо";                          
    ls->menuFileHarddiskNoPesent= "Swо";             
    ls->menuFileHarddiskRemoveAll= "Eject All Harddisk";    // New in 2.7

    ls->menuRunRun              = "";
    ls->menuRunPause            = "Ȱ";
    ls->menuRunStop             = "";
    ls->menuRunSoftReset        = "n魫m";
    ls->menuRunHardReset        = "w魫m";
    ls->menuRunCleanReset       = "@뭫m";

    ls->menuToolsMachine        = "ؽs边";
    ls->menuToolsShortcuts      = "ֳts边";
    ls->menuToolsCtrlEditor     = " / Ls边"; 
    ls->menuToolsMixer          = "VX";
    ls->menuToolsDebugger       = "u";               
    ls->menuToolsTrainer        = "Vm";                
    ls->menuToolsTraceLogger    = "lܰO";           

    ls->menuFile                = "ɮ";
    ls->menuRun                 = "";
    ls->menuWindow              = "";
    ls->menuOptions             = "ﶵ";
    ls->menuTools               = "u";
    ls->menuHelp                = "";


    //----------------------
    // Dialog related lines
    //----------------------

    ls->dlgOK                   = "Tw";
    ls->dlgOpen                 = "}";
    ls->dlgCancel               = "";
    ls->dlgSave                 = "xs";
    ls->dlgSaveAs               = "tss...";
    ls->dlgRun                  = "";
    ls->dlgClose                = "";
    
    ls->dlgLoadRom              = "blueMSX - ܥdXMɸJ";
    ls->dlgLoadDsk              = "blueMSX - ܺϺЬMɸJ";
    ls->dlgLoadCas              = "blueMSX - ܺϱaMɸJ";
    ls->dlgLoadRomDskCas        = "blueMSX - ܥdXBϺЩκϱaMɸJ";
    ls->dlgLoadRomDesc          = "пܭnJdXM:";
    ls->dlgLoadDskDesc          = "пܭnJϺЬM:";
    ls->dlgLoadCasDesc          = "пܭnJϱaM:";
    ls->dlgLoadRomDskCasDesc    = "пܭnJdXBϺЩκϱaM:";
    ls->dlgLoadState            = "J CPU A";
    ls->dlgLoadVideoCapture     = "J^T";      
    ls->dlgSaveState            = "xs CPU A";
    ls->dlgSaveCassette          = "blueMSX - xsϱaM";
    ls->dlgSaveVideoClipAs      = "xsTŬ...";      
    ls->dlgAmountCompleted      = "ͧ:";          
    ls->dlgInsertRom1           = "Цb 1 J ROM dX";
    ls->dlgInsertRom2           = "Цb 2 J ROM dX";
    ls->dlgInsertDiskA          = "ЦbϺо A JϺЬM";
    ls->dlgInsertDiskB          = "ЦbϺо B JϺЬM";
    ls->dlgInsertHarddisk       = "Jwо";                   
    ls->dlgInsertCas            = "дJϱaϱa";
    ls->dlgRomType              = "ROM :";
    ls->dlgDiskSize             = "ϺФjp:";             

    ls->dlgTapeTitle            = "blueMSX - ϱam";
    ls->dlgTapeFrameText        = "ϱam";
    ls->dlgTapeCurrentPos       = "ثem";
    ls->dlgTapeTotalTime        = "`ɶ";
    ls->dlgTapeSetPosText        = "ϱam:";
    ls->dlgTapeCustom            = "ܦۭqɮ";
    ls->dlgTabPosition           = "m";
    ls->dlgTabType               = "";
    ls->dlgTabFilename           = "ɮצW";
    ls->dlgZipReset             = "J᭫m";

    ls->dlgAboutTitle           = "blueMSX - ";

    ls->dlgLangLangText         = "п blueMSX nϥΪy";
    ls->dlgLangLangTitle        = "blueMSX - y";

    ls->dlgAboutAbout           = "\r\n====";
    ls->dlgAboutVersion         = ":";
    ls->dlgAboutBuildNumber     = "ի:";
    ls->dlgAboutBuildDate       = ":";
    ls->dlgAboutCreat           = " Daniel Vik Ч@";
    ls->dlgAboutDevel           = "}o\r\n========";
    ls->dlgAboutThanks          = "SOP\r\n============";       // New in 2.7 (retranslate, see english)
    ls->dlgAboutLisence         = "vĳ\r\n"
                                  "======\r\n\r\n"
                                  "oӳn̾ڥثeAӴѡASTηtܪOC "
                                  "b󱡪pUAϥγoӳnҳyl`ݭnϥΪ̦ۤvӾA "
                                  "@̤Ӿ󪺳dC\r\n\r\n"
                                  "гX www.bluemsx.com ohӸ`C";

    ls->dlgSavePreview          = "ܹw";
    ls->dlgSaveDate             = "xsɶ:";

    ls->dlgRenderVideoCapture   = "blueMSX - bV^T...";  


    //----------------------
    // Properties related lines
    //----------------------

    ls->propTitle               = "blueMSX - e";
    ls->propEmulation           = "";
    ls->propVideo               = "T";
    ls->propSound               = "";
    ls->propControls            = "";
    ls->propPerformance         = "į";
    ls->propEffects             = "Effects";             // New in 2.9
    ls->propSettings             = "]w";
    ls->propFile                = "ɮ";
    ls->propDisk                = "Disks";              // New in 2.7
    ls->propPorts               = "s";
    
    ls->propEmuGeneralGB        = "@ ";
    ls->propEmuFamilyText       = "MSX :";
    ls->propEmuMemoryGB         = "O ";
    ls->propEmuRamSizeText      = "RAM jp:";
    ls->propEmuVramSizeText     = "VRAM jp:";
    ls->propEmuSpeedGB          = "t ";
    ls->propEmuSpeedText        = "t:";
    ls->propEmuFrontSwitchGB     = "Panasonic } ";
    ls->propEmuFrontSwitch       = " eݶ}";
    ls->propEmuNoSpriteLimits   = " Disable Sprites Limitation";  // New in 2.9
    ls->propEnableMsxKeyboardQuirk = " Emulate MSX keyboard quirk";  // New in 2.9
    ls->propEmuFdcTiming        = " γnϺоp";
    ls->propEmuReversePlay      = " Enable reverse playback"; // New in 2.8.3
    ls->propEmuPauseSwitch      = " Ȱ}";
    ls->propEmuAudioSwitch       = " MSX ĥd}";
    ls->propVideoFreqText       = "TWv:";
    ls->propVideoFreqAuto       = "۰";
    ls->propSndOversampleText   = "W:";
    ls->propSndYkInGB           = "YK-01/YK-10/YK-20 J ";                
    ls->propSndMidiInGB         = "MIDI J ";
    ls->propSndMidiOutGB        = "MIDI X ";
    ls->propSndMidiChannel      = "MIDI nD:";                      
    ls->propSndMidiAll          = "";                                

    ls->propMonMonGB            = "ʵ ";
    ls->propMonTypeText         = "ʵ:";
    ls->propMonEmuText          = "ʵ:";
    ls->propVideoTypeText       = "T:";
    ls->propWindowSizeText      = "jp:";
    ls->propMonHorizStretch      = " Ԧ";
    ls->propMonVertStretch       = " Ԧ";
    ls->propMonDeInterlace      = " he\\";
    ls->propBlendFrames         = " VXs򪺵e";           
    ls->propMonBrightness       = "G:";
    ls->propMonContrast         = ":";
    ls->propMonSaturation       = "X:";
    ls->propMonGamma            = "ɺ:";
    ls->propMonScanlines        = " ˽u:";
    ls->propMonColorGhosting    = " RF ܾ:";
    ls->propMonEffectsGB        = "ĪG ";

    ls->propPerfVideoDrvGB      = "TXʵ{ ";
    ls->propPerfVideoDispDrvText= "Xʵ{:";
    ls->propPerfFrameSkipText   = "e沤L:";
    ls->propPerfAudioDrvGB      = "TXʵ{ ";
    ls->propPerfAudioDrvText    = "Xʵ{:";
    ls->propPerfAudioBufSzText  = "ĽwİϤjp:";
    ls->propPerfEmuGB           = " ";
    ls->propPerfSyncModeText    = "PBҦ:";
    ls->propFullscreenResText   = "ùѪR:";

    ls->propSndChipEmuGB        = "Ĵ ";
    ls->propSndMsxMusic         = " MSX ";
    ls->propSndMsxAudio         = " MSX ";
    ls->propSndMoonsound        = " MoonSound";
    ls->propSndMt32ToGm         = "  MT-32 ־@ MIDI ˸m";

    ls->propPortsLptGB          = "æCs ";
    ls->propPortsComGB          = "ǦCs ";
    ls->propPortsLptText        = "s:";
    ls->propPortsCom1Text       = "s 1:";
    ls->propPortsNone           = "L";
    ls->propPortsSimplCovox     = "SiMPL / Covox Ʀഫ";
    ls->propPortsFile           = "CLɮ";
    ls->propPortsComFile        = "ǰeɮ";
    ls->propPortsOpenLogFile    = "}ҰO";
    ls->propPortsEmulateMsxPrn  = ":";

    ls->propSetFileHistoryGB     = "ɮװO ";
    ls->propSetFileHistorySize   = "ɮװOؼ:";
    ls->propSetFileHistoryClear  = "MO";
    ls->propFileTypes            = " U blueMSX pɮ (.rom, .dsk, .cas, .sta)";
    ls->propWindowsEnvGB         = "Windows  "; 
    ls->propSetScreenSaver       = "  blueMSX ɰοùO@";
    ls->propDisableWinKeys       = " ϥ MSX ɦ۰ʰ Windows Bk\\"; 
    ls->propPriorityBoost        = "  blueMSX uv";
    ls->propScreenshotPng        = " ϥΥi⦡ϧ (.png) ù";  
    ls->propEjectMediaOnExit    = " Eject media when blueMSX exits";        // New in 2.8
    ls->propClearHistory         = "zO_TwnMɮװOH";
    ls->propOpenRomGB            = "} ROM ܤ ";
    ls->propDefaultRomType       = "w] ROM :";
    ls->propGuessRomType         = " ROM ";

    ls->propSettDefSlotGB       = "즲 ";
    ls->propSettDefSlots        = "J ROM :";
    ls->propSettDefSlot         = " ";
    ls->propSettDefDrives       = "JϤ:";
    ls->propSettDefDrive        = " Ϻо";

    ls->propThemeGB             = "GDD ";
    ls->propTheme               = "GDD:";

    ls->propCdromGB             = "CD-ROM ";         // New in 2.7
    ls->propCdromMethod         = "Access Method:";  // New in 2.7
    ls->propCdromMethodNone     = "None";            // New in 2.7
    ls->propCdromMethodIoctl    = "IOCTL";           // New in 2.7
    ls->propCdromMethodAspi     = "ASPI";            // New in 2.7
    ls->propCdromDrive          = "Drive:";          // New in 2.7

    ls->propD3DParametersGB         = "Parameters ";                // New in 2.9
    ls->propD3DAspectRatioText      = "Aspect ratio";               // New in 2.9
    ls->propD3DLinearFilteringText  = " Linear filtering";          // New in 2.9
    ls->propD3DForceHighResText     = " Force high resolution";     // New in 2.9
    ls->propD3DExtendBorderColorText    = " Extend border color";   // New in 2.9

    ls->propD3DCroppingGB               = "Cropping ";              // New in 2.9
    ls->propD3DCroppingTypeText         = "Cropping type:";         // New in 2.9
    ls->propD3DCroppingLeftText         = "Left:";                  // New in 2.9
    ls->propD3DCroppingRightText        = "Right:";                 // New in 2.9
    ls->propD3DCroppingTopText          = "Top:";                   // New in 2.9
    ls->propD3DCroppingBottomText       = "Bottom:";                // New in 2.9


    //----------------------
    // Dropdown related lines
    //----------------------

    ls->enumVideoMonColor       = "m";
    ls->enumVideoMonGrey        = "¥";
    ls->enumVideoMonGreen       = "";
    ls->enumVideoMonAmber       = "";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "L";
    ls->enumVideoEmuYc          = "Y/C ^ (UQ)";
    ls->enumVideoEmuMonitor     = "ʵ";
    ls->enumVideoEmuYcBlur      = "T Y/C ^ (UQ)";
    ls->enumVideoEmuComp        = "ƦX (ҽk)";
    ls->enumVideoEmuCompBlur    = "TƦX (ҽk)";
    ls->enumVideoEmuScale2x     = "⭿Y";
    ls->enumVideoEmuHq2x        = "⭿~";

    ls->enumVideoSize1x         = "з - 320x200";
    ls->enumVideoSize2x         = "⭿ - 640x400";
    ls->enumVideoSizeFullscreen = "ù";

    ls->enumVideoDrvDirectDrawHW = "DirectDraw w[t"; 
    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";
    ls->enumVideoDrvD3D         = "Direct3D";

    ls->enumVideoFrameskip0     = "L";
    ls->enumVideoFrameskip1     = "1 e";
    ls->enumVideoFrameskip2     = "2 ӵe";
    ls->enumVideoFrameskip3     = "3 ӵe";
    ls->enumVideoFrameskip4     = "4 ӵe";
    ls->enumVideoFrameskip5     = "5 ӵe";

    ls->enumD3DARAuto           = "Auto";           // New in 2.9
    ls->enumD3DARStretch        = "Stretch";        // New in 2.9
    ls->enumD3DARPAL            = "PAL";            // New in 2.9
    ls->enumD3DARNTSC           = "NTSC";           // New in 2.9
    ls->enumD3DAR11             = "1:1";            // New in 2.9

    ls->enumD3DCropNone         = "None";           // New in 2.9
    ls->enumD3DCropMSX1         = "MSX1";           // New in 2.9
    ls->enumD3DCropMSX1Plus8    = "MSX1+8";         // New in 2.9
    ls->enumD3DCropMSX2         = "MSX2";           // New in 2.9
    ls->enumD3DCropMSX2Plus8    = "MSX2+8";         // New in 2.9
    ls->enumD3DCropCustom       = "Custom";         // New in 2.9

    ls->enumSoundDrvNone        = "S";
    ls->enumSoundDrvWMM         = "WMM Xʵ{";
    ls->enumSoundDrvDirectX     = "DirectX Xʵ{";

    ls->enumEmuSync1ms          = "PB MSX sz";
    ls->enumEmuSyncAuto         = "۰ (ֳt)";
    ls->enumEmuSyncNone         = "L";
    ls->enumEmuSyncVblank       = "PB PC ť";
    ls->enumEmuAsyncVblank      = "DPB PC ť";             

    ls->enumControlsJoyNone     = "L";
    ls->enumControlsJoyMouse    = "ƹ";
    ls->enumControlsJoyTetris2Dongle = "Xù 2 Ҳ";
    ls->enumControlsJoyTMagicKeyDongle = "MagicKey Dongle";             
    ls->enumControlsJoy2Button = "2 sn";                   
    ls->enumControlsJoyGunstick  = "Gun Stick uj";                         
    ls->enumControlsJoyAsciiLaser="ASCII Plus-X ׵̹pguj";      
    ls->enumControlsArkanoidPad  ="Arkanoid Pad";                   // New in 2.7.1
    ls->enumControlsJoyColeco = "ColecoVision n";                

    ls->enumDiskMsx35Dbl9Sect    = "MSX 3.5\" , 9 Ӻϰ";     
    ls->enumDiskMsx35Dbl8Sect    = "MSX 3.5\" , 8 Ӻϰ";     
    ls->enumDiskMsx35Sgl9Sect    = "MSX 3.5\" 歱, 9 Ӻϰ";     
    ls->enumDiskMsx35Sgl8Sect    = "MSX 3.5\" 歱, 8 Ӻϰ";     
    ls->enumDiskSvi525Dbl        = "SVI-328 5.25\" ";           
    ls->enumDiskSvi525Sgl        = "SVI-328 5.25\" 歱"; 
    ls->enumDiskSf3Sgl           = "Sega SF-7000 3\"  歱";               


    //----------------------
    // Configuration related lines
    //----------------------

    ls->confTitle                = "blueMSX - زպAs边";
    ls->confConfigText           = "]w";
    ls->confSlotLayout           = "Ѱtm";
    ls->confMemory               = "O";
    ls->confChipEmulation        = "";
    ls->confChipExtras          = "B~";

    ls->confOpenRom             = "} ROM M";
    ls->confSaveTitle            = "blueMSX - xs]w";
    ls->confSaveText             = "zTwnмgس]w:";
    ls->confSaveAsTitle         = "ts]w...";
    ls->confSaveAsMachineName    = "ئW:";
    ls->confDiscardTitle         = "blueMSX - ]w";
    ls->confExitSaveTitle        = "blueMSX - }]ws边";
    ls->confExitSaveText         = "zTwnثe]wܧܡH";

    ls->confSlotLayoutGB         = "ѥ ";
    ls->confSlotExtSlotGB        = "~ ";
    ls->confBoardGB             = "DO ";
    ls->confBoardText           = "DO:";
    ls->confSlotPrimary          = "Dn";
    ls->confSlotExpanded         = "wXi (|Ӥl)";

    ls->confSlotCart             = "dX";
    ls->confSlot                = "";
    ls->confSubslot             = "l";

    ls->confMemAdd               = "[J...";
    ls->confMemEdit              = "s...";
    ls->confMemRemove            = "";
    ls->confMemSlot              = "";
    ls->confMemAddresss          = "}";
    ls->confMemType              = "";
    ls->confMemRomImage          = "ROM M";
    
    ls->confChipVideoGB          = "T ";
    ls->confChipVideoChip        = "T:";
    ls->confChipVideoRam         = "T RAM:";
    ls->confChipSoundGB          = " ";
    ls->confChipPsgStereoText    = " PSG n";

    ls->confCmosGB                = "CMOS ";
    ls->confCmosEnable            = " ҥ CMOS";
    ls->confCmosBattery           = " ϥΥRqq";

    ls->confCpuFreqGB            = "CPU Wv ";
    ls->confZ80FreqText          = "Z80 Wv:";
    ls->confR800FreqText         = "R800 Wv:";
    ls->confFdcGB                = "nϺб ";
    ls->confCFdcNumDrivesText    = "ϺоN:";

    ls->confEditMemTitle         = "blueMSX - s";
    ls->confEditMemGB            = "Ӹ` ";
    ls->confEditMemType          = ":";
    ls->confEditMemFile          = "ɮ:";
    ls->confEditMemAddress       = "}";
    ls->confEditMemSize          = "jp";
    ls->confEditMemSlot          = "";


    //----------------------
    // Shortcut lines
    //----------------------

    ls->shortcutKey             = "ֳt";
    ls->shortcutDescription     = "|";

    ls->shortcutSaveConfig      = "blueMSX - xs]w";
    ls->shortcutOverwriteConfig = "zTwnмgֳt]w:";
    ls->shortcutExitConfig      = "blueMSX - }ֳts边";
    ls->shortcutDiscardConfig   = "zTwnثe]wܧܡH";
    ls->shortcutSaveConfigAs    = "blueMSX - tsֳt]w...";
    ls->shortcutConfigName      = "]wW:";
    ls->shortcutNewProfile      = "< s]w >";
    ls->shortcutConfigTitle     = "blueMSX - ֳts边";
    ls->shortcutAssign          = "";
    ls->shortcutPressText       = "ЫUֳt:";
    ls->shortcutScheme          = "tm:";
    ls->shortcutCartInsert1     = "JdX 1";
    ls->shortcutCartRemove1     = "dX 1";
    ls->shortcutCartInsert2     = "JdX 2";
    ls->shortcutCartRemove2     = "dX 2";
    ls->shortcutSpecialMenu1    = "ܥdX 1 B~ ROM ";
    ls->shortcutSpecialMenu2    = "ܥdX 2 B~ ROM ";
    ls->shortcutCartAutoReset   = "dXJ᭫m";
    ls->shortcutDiskInsertA     = "JϤ A";
    ls->shortcutDiskDirInsertA  = "Jؿ@Ϥ A";
    ls->shortcutDiskRemoveA     = "hXϤ A";
    ls->shortcutDiskChangeA     = "ֳtܧϤ A";
    ls->shortcutDiskAutoResetA  = "Ϥ A J᭫m";
    ls->shortcutDiskInsertB     = "JϤ B";
    ls->shortcutDiskDirInsertB  = "Jؿ@Ϥ B";
    ls->shortcutDiskRemoveB     = "hXϤ B";
    ls->shortcutCasInsert       = "Jϱa";
    ls->shortcutCasEject        = "hXϱa";
    ls->shortcutCasAutorewind   = "Nϱa۰ʰjaA";
    ls->shortcutCasReadOnly     = "NϱaŪA";
    ls->shortcutCasSetPosition  = "]wϱam";
    ls->shortcutCasRewind       = "ϱaja";
    ls->shortcutCasSave         = "xsϱaM";
    ls->shortcutPrnFormFeed     = "L";
    ls->shortcutCpuStateLoad    = "J CPU A";
    ls->shortcutCpuStateSave    = "xs CPU A";
    ls->shortcutCpuStateQload   = "ֳtJ CPU A";
    ls->shortcutCpuStateQsave   = "ֳtxs CPU A";
    ls->shortcutAudioCapture    = "}l/T^";
    ls->shortcutScreenshotOrig  = "ù (l)";
    ls->shortcutScreenshotSmall = "Loù (p)";
    ls->shortcutScreenshotLarge = "Loù (j)";
    ls->shortcutQuit            = " blueMSX";
    ls->shortcutRunPause        = "/Ȱ";
    ls->shortcutStop            = "";
    ls->shortcutResetHard       = "w魫m";
    ls->shortcutResetSoft       = "n魫m";
    ls->shortcutResetClean      = "@뭫m";
    ls->shortcutSizeSmall       = "]wpjp";
    ls->shortcutSizeNormal      = "]wзǵjp";
    ls->shortcutSizeFullscreen  = "]wù";
    ls->shortcutSizeMinimized   = "̤pƵ";
    ls->shortcutToggleFullscren = "ù";
    ls->shortcutVolumeIncrease  = "Wjq";
    ls->shortcutVolumeDecrease  = "pq";
    ls->shortcutVolumeMute      = "Rq";
    ls->shortcutVolumeStereo    = "歵/n";
    ls->shortcutSwitchMsxAudio  = " MSX Ķ}";
    ls->shortcutSwitchFront     = " Panasonic eݶ}";
    ls->shortcutSwitchPause     = "Ȱ}";
    ls->shortcutToggleMouseLock = "ƹw";
    ls->shortcutEmuSpeedMax     = "̰t";
    ls->shortcutEmuPlayReverse  = "Rewind emulation";                     // New in 2.8.3
    ls->shortcutEmuSpeedToggle  = "̰t";
    ls->shortcutEmuSpeedNormal  = "зǼt";
    ls->shortcutEmuSpeedInc     = "W[t";
    ls->shortcutEmuSpeedDec     = "Ct";
    ls->shortcutThemeSwitch     = "GDD";
    ls->shortcutShowEmuProp     = "ܼe";
    ls->shortcutShowVideoProp   = "ܵTe";
    ls->shortcutShowAudioProp   = "ܭTe";
    ls->shortcutShowCtrlProp    = "ܱe";
    ls->shortcutShowEffectsProp = "Show Effects Properties";     // New in 2.9
    ls->shortcutShowSettProp    = "ܳ]we";
    ls->shortcutShowPorts       = "ܳs𤺮e";
    ls->shortcutShowLanguage    = "ܻyܤ";
    ls->shortcutShowMachines    = "ܾؽs边";
    ls->shortcutShowShortcuts   = "ܧֳts边";
    ls->shortcutShowKeyboard    = "Ls边";
    ls->shortcutShowMixer       = "ܲVX";
    ls->shortcutShowDebugger    = "ܰu";
    ls->shortcutShowTrainer     = "ܭקﾹ";
    ls->shortcutShowHelp        = "ܻܤ";
    ls->shortcutShowAbout       = "ܤ";
    ls->shortcutShowFiles       = "ɮפe";
    ls->shortcutToggleSpriteEnable = "/ëeϼh";
    ls->shortcutToggleFdcTiming = "ҥ/γnϺоp";
    ls->shortcutToggleNoSpriteLimits = "Toggle Sprites Limitation";                 // New in 2.9
    ls->shortcutEnableMsxKeyboardQuirk = "Emulate MSX Keyboard Quirk";              // New in 2.9
    ls->shortcutToggleCpuTrace  = "ҥ/ CPU l";
    ls->shortcutVideoLoad       = "J...";             
    ls->shortcutVideoPlay       = "W^";   
    ls->shortcutVideoRecord     = "s";              
    ls->shortcutVideoStop       = "";                
    ls->shortcutVideoRender     = "VTɮ";   


    //----------------------
    // Keyboard config lines
    //----------------------

    ls->keyconfigSelectedKey    = ":";
    ls->keyconfigMappedTo       = ":";
    ls->keyconfigMappingScheme  = "tm:";

    
    //----------------------
    // Rom type lines
    //----------------------

    ls->romTypeStandard         = "Standard";
    ls->romTypeZenima80         = "Zemina 80 in 1";
    ls->romTypeZenima90         = "Zemina 90 in 1";
    ls->romTypeZenima126        = "Zemina 126 in 1";
    ls->romTypeSccMirrored      = "SCC mirrored";
    ls->romTypeSccExtended      = "SCC extended";
    ls->romTypeKonamiGeneric    = "Konami Generic";
    ls->romTypeMirrored         = "Mirrored ROM";
    ls->romTypeNormal           = "Normal ROM";
    ls->romTypeDiskPatch        = "Normal + Disk Patch";
    ls->romTypeCasPatch         = "Normal + Cassette Patch";
    ls->romTypeTc8566afFdc      = "TC8566AF Disk Controller";
    ls->romTypeTc8566afTrFdc    = "TC8566AF Turbo-R Disk Controller";
    ls->romTypeMicrosolFdc      = "Microsol Disk Controller";
    ls->romTypeNationalFdc      = "National Disk Controller";
    ls->romTypePhilipsFdc       = "Philips Disk Controller";
    ls->romTypeSvi707Fdc        = "SVI-707 Disk Controller";
    ls->romTypeSvi738Fdc        = "SVI-738 Disk Controller";
    ls->romTypeMappedRam        = "Mapped RAM";
    ls->romTypeMirroredRam1k    = "1kB Mirrored RAM";
    ls->romTypeMirroredRam2k    = "2kB Mirrored RAM";
    ls->romTypeNormalRam        = "Normal RAM";
    ls->romTypeTurborPause      = "Turbo-R Pause";
    ls->romTypeF4deviceNormal   = "F4 Device Normal";
    ls->romTypeF4deviceInvert   = "F4 Device Inverted";
    ls->romTypeTurborTimer      = "Turbo-R Timer";
    ls->romTypeNormal4000       = "Normal 4000h";
    ls->romTypeNormalC000       = "Normal C000h";
    ls->romTypeExtRam           = "External RAM";
    ls->romTypeExtRam16         = "16kB External RAM";
    ls->romTypeExtRam32         = "32kB External RAM";
    ls->romTypeExtRam48         = "48kB External RAM";
    ls->romTypeExtRam64         = "64kB External RAM";
    ls->romTypeExtRam512        = "512kB External RAM";
    ls->romTypeExtRam1mb        = "1MB External RAM";
    ls->romTypeExtRam2mb        = "2MB External RAM";
    ls->romTypeExtRam4mb        = "4MB External RAM";
    ls->romTypeSvi328Cart       = "SVI-328 Cartridge";
    ls->romTypeSvi328Fdc        = "SVI-328 Disk Controller";
    ls->romTypeSvi328Prn        = "SVI-328 Printer";
    ls->romTypeSvi328Uart       = "SVI-328 Serial Port";
    ls->romTypeSvi328col80      = "SVI-328 80 Column Card";
    ls->romTypeSvi727col80      = "SVI-727 80 Column Card";
    ls->romTypeColecoCart       = "Coleco Cartridge";
    ls->romTypeSg1000Cart       = "SG-1000 Cartridge";
    ls->romTypeSc3000Cart       = "SC-3000 Cartridge";
    ls->romTypeMsxPrinter       = "MSX Printer";
    ls->romTypeTurborPcm        = "Turbo-R PCM Chip";
    ls->romTypeNms8280Digitiz   = "Philips NMS-8280 Digitizer";
    ls->romTypeHbiV1Digitiz     = "Sony HBI-V1 Digitizer";
    
    
    //----------------------
    // Debug type lines
    // Note: Only needs translation if debugger is translated
    //----------------------

    ls->dbgMemVisible           = "iO";
    ls->dbgMemRamNormal         = "з";
    ls->dbgMemRamMapped         = "";
    ls->dbgMemYmf278            = "YMF278  RAM";
    ls->dbgMemAy8950            = "AY8950  RAM";
    ls->dbgMemScc               = "O";

    ls->dbgCallstack            = "Is|";

    ls->dbgRegs                 = "Ȧs";
    ls->dbgRegsCpu              = "CPU Ȧs";
    ls->dbgRegsYmf262           = "YMF262 Ȧs";
    ls->dbgRegsYmf278           = "YMF278 Ȧs";
    ls->dbgRegsAy8950           = "AY8950 Ȧs";
    ls->dbgRegsYm2413           = "YM2413 Ȧs";

    ls->dbgDevRamMapper         = "RAM ";
    ls->dbgDevRam               = "RAM";
    ls->dbgDevF4Device          = "F4 ˸m";
    ls->dbgDevKorean80          = "Korean 80";
    ls->dbgDevKorean90          = "Korean 90";
    ls->dbgDevKorean128         = "Korean 128";
    ls->dbgDevFdcMicrosol       = "Microsol FDC";
    ls->dbgDevPrinter           = "L";
    ls->dbgDevSviFdc            = "SVI FDC";
    ls->dbgDevSviPrn            = "SVI L";
    ls->dbgDevSvi80Col          = "SVI 80 ";
    ls->dbgDevRtc               = "RTC";
    ls->dbgDevTrPause           = "TR Ȱ";


    //----------------------
    // Debug type lines
    // Note: Can only be translated to european languages
    //----------------------

    ls->aboutScrollThanksTo     = "Special thanks to: ";
    ls->aboutScrollAndYou       = "and YOU !!!!";
};

#endif
